/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDRectangularPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel leftLabel;
    private JSpinner leftSpinner;
    private JLabel rightLabel;
    private JSpinner rightSpinner;
    private JLabel bottomLabel;
    private JSpinner bottomSpinner;
    private JLabel topLabel;
    private JSpinner topSpinner;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JDRectangular[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDRectangularPanel(JDRectangular[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel posPanel = new JPanel(null);
        posPanel.setBorder(JDUtils.createTitleBorder("Positioning"));
        posPanel.setBounds(5, 5, 370, 85);
        this.leftLabel = new JLabel("Left");
        this.leftLabel.setFont(JDUtils.labelFont);
        this.leftLabel.setForeground(JDUtils.labelColor);
        this.leftLabel.setBounds(10, 20, 100, 25);
        posPanel.add(this.leftLabel);
        this.leftSpinner = new JSpinner();
        this.leftSpinner.addChangeListener(this);
        this.leftSpinner.setBounds(115, 20, 60, 25);
        posPanel.add(this.leftSpinner);
        this.rightLabel = new JLabel("Right");
        this.rightLabel.setFont(JDUtils.labelFont);
        this.rightLabel.setForeground(JDUtils.labelColor);
        this.rightLabel.setBounds(195, 20, 100, 25);
        posPanel.add(this.rightLabel);
        this.rightSpinner = new JSpinner();
        this.rightSpinner.addChangeListener(this);
        this.rightSpinner.setBounds(295, 20, 60, 25);
        posPanel.add(this.rightSpinner);
        this.topLabel = new JLabel("Top");
        this.topLabel.setFont(JDUtils.labelFont);
        this.topLabel.setForeground(JDUtils.labelColor);
        this.topLabel.setBounds(10, 50, 100, 25);
        posPanel.add(this.topLabel);
        this.topSpinner = new JSpinner();
        this.topSpinner.addChangeListener(this);
        this.topSpinner.setBounds(115, 50, 60, 25);
        posPanel.add(this.topSpinner);
        this.bottomLabel = new JLabel("Bottom");
        this.bottomLabel.setFont(JDUtils.labelFont);
        this.bottomLabel.setForeground(JDUtils.labelColor);
        this.bottomLabel.setBounds(195, 50, 100, 25);
        posPanel.add(this.bottomLabel);
        this.bottomSpinner = new JSpinner();
        this.bottomSpinner.addChangeListener(this);
        this.bottomSpinner.setBounds(295, 50, 60, 25);
        posPanel.add(this.bottomSpinner);
        this.add(posPanel);
        JPanel dimPanel = new JPanel(null);
        dimPanel.setBorder(JDUtils.createTitleBorder("Dimension"));
        dimPanel.setBounds(5, 90, 370, 55);
        this.widthLabel = new JLabel("Width");
        this.widthLabel.setFont(JDUtils.labelFont);
        this.widthLabel.setForeground(JDUtils.labelColor);
        this.widthLabel.setBounds(10, 20, 100, 25);
        dimPanel.add(this.widthLabel);
        this.widthSpinner = new JSpinner();
        this.widthSpinner.addChangeListener(this);
        this.widthSpinner.setBounds(115, 20, 60, 25);
        dimPanel.add(this.widthSpinner);
        this.heightLabel = new JLabel("Height");
        this.heightLabel.setFont(JDUtils.labelFont);
        this.heightLabel.setForeground(JDUtils.labelColor);
        this.heightLabel.setBounds(195, 20, 100, 25);
        dimPanel.add(this.heightLabel);
        this.heightSpinner = new JSpinner();
        this.heightSpinner.addChangeListener(this);
        this.heightSpinner.setBounds(295, 20, 60, 25);
        dimPanel.add(this.heightSpinner);
        this.add(dimPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDRectangular[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            SpinnerNumberModel nullModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.leftSpinner.setModel(nullModel);
        } else {
            JDRectangular p = objs[0];
            Integer min = -4096;
            Integer max = 4096;
            Integer step = 1;
            this.leftSpinner.setModel(new SpinnerNumberModel(new Integer(p.getLeft()), min, max, step));
            this.rightSpinner.setModel(new SpinnerNumberModel(new Integer(p.getRight()), min, max, step));
            this.topSpinner.setModel(new SpinnerNumberModel(new Integer(p.getTop()), min, max, step));
            this.bottomSpinner.setModel(new SpinnerNumberModel(new Integer(p.getBottom()), min, max, step));
            this.widthSpinner.setModel(new SpinnerNumberModel(new Integer(p.getWidth()), min, max, step));
            this.heightSpinner.setModel(new SpinnerNumberModel(new Integer(p.getHeight()), min, max, step));
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.leftSpinner) {
            Integer v = (Integer)this.leftSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setLeft(v);
            }
            this.invoker.setNeedToSave(true, "Change left");
        } else if (src == this.rightSpinner) {
            Integer v = (Integer)this.rightSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setRight(v);
            }
            this.invoker.setNeedToSave(true, "Change right");
        } else if (src == this.topSpinner) {
            Integer v = (Integer)this.topSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setTop(v);
            }
            this.invoker.setNeedToSave(true, "Change top");
        } else if (src == this.bottomSpinner) {
            Integer v = (Integer)this.bottomSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setBottom(v);
            }
            this.invoker.setNeedToSave(true, "Change bottom");
        } else if (src == this.widthSpinner) {
            Integer v = (Integer)this.widthSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setWidth(v);
            }
            this.invoker.setNeedToSave(true, "Change width");
        } else if (src == this.heightSpinner) {
            Integer v = (Integer)this.heightSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setHeight(v);
            }
            this.invoker.setNeedToSave(true, "Change height");
        }
        this.updatePanel(this.allObjects);
        this.repaintObjects();
    }
}

