/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public abstract class JDRectangular
extends JDObject {
    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        if (this.fillStyle != 0) {
            Paint p = GraphicsUtils.createPatternForFilling(this);
            if (p != null) {
                g2.setPaint(p);
            }
            g.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
        }
        if (this.lineWidth > 0) {
            g.setColor(this.foreground);
            BasicStroke bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (bs != null) {
                Stroke old = g2.getStroke();
                g2.setStroke(bs);
                g.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                g2.setStroke(old);
            } else {
                g.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        this.paintShadows(g);
    }

    @Override
    int getSummitMotion(int id) {
        switch (id) {
            case 0: 
            case 2: 
            case 4: 
            case 6: {
                return 3;
            }
            case 1: 
            case 5: {
                return 2;
            }
        }
        return 1;
    }

    public void setLeft(int x) {
        int nw = this.getWidth() + this.getLeft() - x;
        this.summit[0].x = x;
        this.summit[6].x = x;
        this.summit[2].x = x + nw;
        this.summit[4].x = x + nw;
        this.centerSummit();
        this.updateShape();
    }

    public int getLeft() {
        return (int)Math.min(this.summit[2].x, this.summit[0].x);
    }

    public void setTop(int y) {
        int nh = this.getHeight() + this.getTop() - y;
        this.summit[0].y = y;
        this.summit[2].y = y;
        this.summit[4].y = y + nh;
        this.summit[6].y = y + nh;
        this.centerSummit();
        this.updateShape();
    }

    public int getTop() {
        return (int)Math.min(this.summit[0].y, this.summit[4].y);
    }

    public void setRight(int x) {
        int nw = this.getWidth() + x - this.getRight();
        this.summit[2].x = x;
        this.summit[4].x = x;
        this.summit[0].x = x - nw;
        this.summit[6].x = x - nw;
        this.centerSummit();
        this.updateShape();
    }

    public int getRight() {
        return (int)Math.max(this.summit[0].x, this.summit[2].x);
    }

    public void setBottom(int y) {
        int nh = this.getHeight() + y - this.getBottom();
        this.summit[0].y = y - nh;
        this.summit[2].y = y - nh;
        this.summit[4].y = y;
        this.summit[6].y = y;
        this.centerSummit();
        this.updateShape();
    }

    public int getBottom() {
        return (int)Math.max(this.summit[0].y, this.summit[4].y);
    }

    public void setWidth(int w) {
        int x = this.getLeft();
        this.summit[0].x = x;
        this.summit[6].x = x;
        this.summit[2].x = x + w;
        this.summit[4].x = x + w;
        this.centerSummit();
        this.updateShape();
    }

    public int getWidth() {
        return (int)Math.abs(this.summit[2].x - this.summit[0].x);
    }

    public void setHeight(int h) {
        int y = this.getTop();
        this.summit[0].y = y;
        this.summit[2].y = y;
        this.summit[4].y = y + h;
        this.summit[6].y = y + h;
        this.centerSummit();
        this.updateShape();
    }

    public int getHeight() {
        return (int)Math.abs(this.summit[4].y - this.summit[0].y);
    }

    @Override
    public void moveSummit(int id, double x, double y) {
        switch (id) {
            case 0: {
                if (Math.abs(this.summit[2].x - x) > 0.5) {
                    this.summit[0].x = x;
                    this.summit[6].x = x;
                }
                if (!(Math.abs(this.summit[4].y - y) > 0.5)) break;
                this.summit[0].y = y;
                this.summit[2].y = y;
                break;
            }
            case 1: {
                if (!(Math.abs(this.summit[4].y - y) > 0.5)) break;
                this.summit[0].y = y;
                this.summit[2].y = y;
                break;
            }
            case 2: {
                if (Math.abs(this.summit[0].x - x) > 0.5) {
                    this.summit[2].x = x;
                    this.summit[4].x = x;
                }
                if (!(Math.abs(this.summit[4].y - y) > 0.5)) break;
                this.summit[0].y = y;
                this.summit[2].y = y;
                break;
            }
            case 3: {
                if (!(Math.abs(this.summit[0].x - x) > 0.5)) break;
                this.summit[2].x = x;
                this.summit[4].x = x;
                break;
            }
            case 4: {
                if (Math.abs(this.summit[0].x - x) > 0.5) {
                    this.summit[2].x = x;
                    this.summit[4].x = x;
                }
                if (!(Math.abs(this.summit[0].y - y) > 0.5)) break;
                this.summit[4].y = y;
                this.summit[6].y = y;
                break;
            }
            case 5: {
                if (!(Math.abs(this.summit[0].y - y) > 0.5)) break;
                this.summit[4].y = y;
                this.summit[6].y = y;
                break;
            }
            case 6: {
                if (Math.abs(this.summit[2].x - x) > 0.5) {
                    this.summit[0].x = x;
                    this.summit[6].x = x;
                }
                if (!(Math.abs(this.summit[0].y - y) > 0.5)) break;
                this.summit[4].y = y;
                this.summit[6].y = y;
                break;
            }
            case 7: {
                if (!(Math.abs(this.summit[2].x - x) > 0.5)) break;
                this.summit[0].x = x;
                this.summit[6].x = x;
            }
        }
        this.centerSummit();
        this.updateShape();
    }

    void centerSummit() {
        this.summit[1].x = (this.summit[0].x + this.summit[2].x) / 2.0;
        this.summit[1].y = (this.summit[0].y + this.summit[2].y) / 2.0;
        this.summit[3].x = (this.summit[2].x + this.summit[4].x) / 2.0;
        this.summit[3].y = (this.summit[2].y + this.summit[4].y) / 2.0;
        this.summit[5].x = (this.summit[6].x + this.summit[4].x) / 2.0;
        this.summit[5].y = (this.summit[6].y + this.summit[4].y) / 2.0;
        this.summit[7].x = (this.summit[0].x + this.summit[6].x) / 2.0;
        this.summit[7].y = (this.summit[0].y + this.summit[6].y) / 2.0;
    }

    @Override
    void recordSummit(StringBuffer to_write, StringBuffer decal) {
        to_write.append(decal).append("summit:");
        to_write.append(this.roundDouble(this.summit[0].x)).append(",").append(this.roundDouble(this.summit[0].y)).append(",");
        to_write.append(this.roundDouble(this.summit[4].x)).append(",").append(this.roundDouble(this.summit[4].y)).append("\n");
    }

    @Override
    public void rotate90(double x, double y) {
        Point2D.Double d1 = this.summit[0];
        Point2D.Double d2 = this.summit[1];
        for (int i = 2; i < 8; ++i) {
            this.summit[i - 2] = this.summit[i];
        }
        this.summit[6] = d1;
        this.summit[7] = d2;
        super.rotate90(x, y);
    }
}

