/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDRectangle
extends JDRectangular
implements JDPolyConvert {
    public JDRectangle(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(x, y));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.updateShape();
    }

    JDRectangle(JDRectangle e, int x, int y) {
        this.cloneObject(e, x, y);
        this.updateShape();
    }

    JDRectangle(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    JDRectangle(JLXObject jlxObj) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.updateShape();
    }

    JDRectangle(LXObject lxObj) {
        this.initDefault();
        this.loadObject(lxObj);
        double x = lxObj.boundRect.getX();
        double y = lxObj.boundRect.getY();
        double w = lxObj.boundRect.getWidth();
        double h = lxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.updateShape();
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDRectangle(this, x, y);
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(x, y);
        }
        int x1 = this.boundRect.x;
        int x2 = this.boundRect.x + this.boundRect.width;
        int y1 = this.boundRect.y;
        int y2 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(x, y, x1, y1, x2, y1) || this.isPointOnLine(x, y, x2, y1, x2, y2) || this.isPointOnLine(x, y, x2, y2, x1, y2) || this.isPointOnLine(x, y, x1, y2, x1, y1);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        this.ptsx[0] = (int)(this.summit[0].x + 0.5);
        this.ptsy[0] = (int)(this.summit[0].y + 0.5);
        this.ptsx[1] = (int)(this.summit[2].x + 0.5);
        this.ptsy[1] = (int)(this.summit[2].y + 0.5);
        this.ptsx[2] = (int)(this.summit[4].x + 0.5);
        this.ptsy[2] = (int)(this.summit[4].y + 0.5);
        this.ptsx[3] = (int)(this.summit[6].x + 0.5);
        this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline ret = this.buildDefaultPolyline();
        ret.setClosed(true);
        ret.updateShape();
        return ret;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        this.recordObjectHeader(to_write, level);
        this.closeObjectHeader(to_write, level);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(6);
        this.fillUndoPattern(u);
        return u;
    }

    JDRectangle(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }
}

