/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class JDLibraryViewer
extends JFrame
implements ActionListener,
JDrawEditorListener {
    JDrawEditor libViewer;
    JDrawEditor invoker;
    JPanel controlPanel;
    JButton copyButton;
    JButton closeButton;
    JMenuItem copyMenuItem;
    JMenuItem exitMenuItem;

    public JDLibraryViewer(String libName, JDrawEditor invoker) {
        this.initComponents(libName, invoker, true);
    }

    public JDLibraryViewer(String libName, JDrawEditor invoker, boolean lPanel) {
        this.initComponents(libName, invoker, lPanel);
    }

    public void initComponents(String libName, JDrawEditor invoker, boolean lPanel) {
        this.invoker = invoker;
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.libViewer = new JDrawEditor(4);
        try {
            this.libViewer.loadFile(libName);
        }
        catch (IOException e) {
            System.out.println("Cannot load library:\n" + e.getMessage());
        }
        this.libViewer.computePreferredSize();
        this.libViewer.setBorder(BorderFactory.createEtchedBorder());
        pane.add((Component)this.libViewer, "Center");
        if (lPanel) {
            this.controlPanel = new JPanel();
            this.copyButton = new JButton("Copy");
            this.copyButton.setFont(ATKConstant.labelFont);
            this.copyButton.setMnemonic(67);
            this.copyButton.addActionListener(this);
            this.closeButton = new JButton("Close");
            this.closeButton.setFont(ATKConstant.labelFont);
            this.closeButton.setMnemonic(76);
            this.closeButton.addActionListener(this);
            this.controlPanel.add(this.copyButton);
            this.controlPanel.add(this.closeButton);
            pane.add((Component)this.controlPanel, "South");
        }
        this.copyMenuItem = new JMenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.exitMenuItem = new JMenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        this.libViewer.addToMenu(this.copyMenuItem);
        this.libViewer.addToMenu(this.exitMenuItem);
        this.libViewer.addEditorListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.closeButton || src == this.exitMenuItem) {
            this.setVisible(false);
        } else if ((src == this.copyButton || src == this.copyMenuItem) && this.invoker != null) {
            this.invoker.addObjectToClipboard(this.libViewer.getSelectedObjects());
        }
    }

    @Override
    public void selectionChanged() {
        if (this.libViewer.getSelectionLength() > 0) {
            this.invoker.addObjectToClipboard(this.libViewer.getSelectedObjects());
            this.invoker.create(7);
        }
    }

    @Override
    public void sizeChanged() {
    }

    @Override
    public void clipboardChanged() {
    }

    @Override
    public void valueChanged() {
    }

    @Override
    public void creationDone() {
    }

    public static void main(String[] args) {
        JDLibraryViewer libView = new JDLibraryViewer("Z:/segfs/blcdas/appli/vacuum/xvacuum/LOOX_files/Lib_Xvacuum.g", null);
        libView.setTitle("ESRF Vacuum Library");
        libView.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(libView);
        libView.setVisible(true);
    }
}

