/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDClipboard;
import fr.esrf.tangoatk.widget.util.jdraw.JDCreationMenu;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroupEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditorListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

class JDGroupEditorView
extends JComponent
implements JDrawEditorListener,
ActionListener {
    JDGroup theGroup;
    JDrawEditor invoker;
    JDGroupEditor theEditor;
    JScrollPane theEditorView;
    Rectangle oldRect;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenuItem exitMenuItem;
    JDCreationMenu creationMenu;
    JMenu editMenu;
    JMenuItem editCutMenuItem;
    JMenuItem editCopyMenuItem;
    JMenuItem editPasteMenuItem;
    JMenuItem editDeleteMenuItem;
    JMenuItem editSelectAllMenuItem;
    JMenuItem editSelectNoneMenuItem;
    JMenu viewsMenu;
    JMenuItem viewsOptionMenuItem;
    JMenuItem viewsGroupEditMenuItem;
    JMenu toolsMenu;
    JMenuItem toolsHMirrorMenuItem;
    JMenuItem toolsVMirrorMenuItem;
    JMenuItem toolsAligntopMenuItem;
    JMenuItem toolsAlignleftMenuItem;
    JMenuItem toolsAlignbottomMenuItem;
    JMenuItem toolsAlignrightMenuItem;
    JMenuItem toolsRaiseMenuItem;
    JMenuItem toolsLowerMenuItem;
    JMenuItem toolsFrontMenuItem;
    JMenuItem toolsBackMenuItem;
    JMenuItem toolsConvertPolyMenuItem;
    JCheckBoxMenuItem toolsGridVisible;
    JCheckBoxMenuItem toolsAlignToGrid;
    JMenuItem toolsGridSettings;
    JMenuItem toolsFitToGraph;

    public JDGroupEditorView(JDGroup g, JDrawEditor jc) {
        int margin = 20;
        this.theGroup = g;
        this.invoker = jc;
        this.oldRect = g.getRepaintRect();
        this.setLayout(new BorderLayout());
        this.theEditor = new JDGroupEditor();
        Rectangle r = g.getBoundRect();
        this.theEditor.addEditorListener(this);
        int gSize = jc.getGridSize();
        this.theEditor.setTranslation(this.round(-r.x + margin, gSize), this.round(-r.y + margin, gSize));
        this.theEditor.setPreferredSize(new Dimension(r.width + 2 * margin, r.height + 2 * margin));
        this.theEditor.setRootPaths(jc.getRootPaths());
        for (int i = 0; i < g.getChildrenNumber(); ++i) {
            this.theEditor.addObject(g.getChildAt(i));
        }
        this.theEditorView = new JScrollPane(this.theEditor);
        this.add((Component)this.theEditorView, "Center");
        this.theEditor.setZoomFactor(this.invoker.getZoomFactor());
        this.creationMenu = new JDCreationMenu();
        this.creationMenu.setEditor(this.theEditor);
        this.add((Component)this.creationMenu.getToolbar(), "West");
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('E');
        menuBar.add(fileMenu);
        this.exitMenuItem = new JMenuItem("Close");
        this.exitMenuItem.addActionListener(this);
        fileMenu.add(this.exitMenuItem);
        this.editCutMenuItem = new JMenuItem("Cut");
        this.editCutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.editCutMenuItem.addActionListener(this);
        this.editCopyMenuItem = new JMenuItem("Copy");
        this.editCopyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.editCopyMenuItem.addActionListener(this);
        this.editPasteMenuItem = new JMenuItem("Paste");
        this.editPasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.editPasteMenuItem.addActionListener(this);
        this.editDeleteMenuItem = new JMenuItem("Delete");
        this.editDeleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.editDeleteMenuItem.addActionListener(this);
        this.editSelectAllMenuItem = new JMenuItem("Select all");
        this.editSelectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.editSelectAllMenuItem.addActionListener(this);
        this.editSelectNoneMenuItem = new JMenuItem("Select none");
        this.editSelectNoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.editSelectNoneMenuItem.addActionListener(this);
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('E');
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editCutMenuItem);
        this.editMenu.add(this.editCopyMenuItem);
        this.editMenu.add(this.editPasteMenuItem);
        this.editMenu.add(this.editDeleteMenuItem);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(this.editSelectAllMenuItem);
        this.editMenu.add(this.editSelectNoneMenuItem);
        menuBar.add(this.editMenu);
        menuBar.add(this.creationMenu.getMenu());
        this.viewsOptionMenuItem = new JMenuItem("Object properties...");
        this.viewsOptionMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.viewsOptionMenuItem.addActionListener(this);
        this.viewsGroupEditMenuItem = new JMenuItem("Group editor...");
        this.viewsGroupEditMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.viewsGroupEditMenuItem.addActionListener(this);
        this.viewsMenu = new JMenu("Views");
        this.viewsMenu.setMnemonic('V');
        this.viewsMenu.add(this.viewsOptionMenuItem);
        this.viewsMenu.add(this.viewsGroupEditMenuItem);
        menuBar.add(this.viewsMenu);
        this.toolsHMirrorMenuItem = new JMenuItem("Horizontal mirror");
        this.toolsHMirrorMenuItem.addActionListener(this);
        this.toolsVMirrorMenuItem = new JMenuItem("Vertical mirror");
        this.toolsVMirrorMenuItem.addActionListener(this);
        this.toolsAligntopMenuItem = new JMenuItem("Align top");
        this.toolsAligntopMenuItem.addActionListener(this);
        this.toolsAlignleftMenuItem = new JMenuItem("Align left");
        this.toolsAlignleftMenuItem.addActionListener(this);
        this.toolsAlignbottomMenuItem = new JMenuItem("Align bottom");
        this.toolsAlignbottomMenuItem.addActionListener(this);
        this.toolsAlignrightMenuItem = new JMenuItem("Align right");
        this.toolsAlignrightMenuItem.addActionListener(this);
        this.toolsConvertPolyMenuItem = new JMenuItem("Convert to Polyline");
        this.toolsConvertPolyMenuItem.addActionListener(this);
        this.toolsRaiseMenuItem = new JMenuItem("Raise");
        this.toolsRaiseMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 3));
        this.toolsRaiseMenuItem.addActionListener(this);
        this.toolsLowerMenuItem = new JMenuItem("Lower");
        this.toolsLowerMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        this.toolsLowerMenuItem.addActionListener(this);
        this.toolsFrontMenuItem = new JMenuItem("Bring to front");
        this.toolsFrontMenuItem.addActionListener(this);
        this.toolsBackMenuItem = new JMenuItem("Send to back");
        this.toolsBackMenuItem.addActionListener(this);
        this.toolsAlignToGrid = new JCheckBoxMenuItem("Align to grid");
        this.toolsAlignToGrid.setAccelerator(KeyStroke.getKeyStroke(65, 3));
        this.toolsAlignToGrid.setSelected(false);
        this.toolsAlignToGrid.addActionListener(this);
        this.toolsGridVisible = new JCheckBoxMenuItem("Show grid");
        this.toolsGridVisible.setSelected(false);
        this.toolsGridVisible.addActionListener(this);
        this.toolsGridSettings = new JMenuItem("Grid settings...");
        this.toolsGridSettings.addActionListener(this);
        this.toolsFitToGraph = new JMenuItem("Fit view to graph");
        this.toolsFitToGraph.addActionListener(this);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.add(this.toolsHMirrorMenuItem);
        this.toolsMenu.add(this.toolsVMirrorMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAligntopMenuItem);
        this.toolsMenu.add(this.toolsAlignleftMenuItem);
        this.toolsMenu.add(this.toolsAlignbottomMenuItem);
        this.toolsMenu.add(this.toolsAlignrightMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsRaiseMenuItem);
        this.toolsMenu.add(this.toolsLowerMenuItem);
        this.toolsMenu.add(this.toolsFrontMenuItem);
        this.toolsMenu.add(this.toolsBackMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsConvertPolyMenuItem);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsAlignToGrid);
        this.toolsMenu.add(this.toolsGridVisible);
        this.toolsMenu.add(this.toolsGridSettings);
        this.toolsMenu.add(new JSeparator());
        this.toolsMenu.add(this.toolsFitToGraph);
        menuBar.add(this.toolsMenu);
        this.add((Component)menuBar, "North");
        this.selectionChanged();
        this.valueChanged();
        JDClipboard.getInstance().addChangeListener(this);
        JDClipboard.getInstance().check();
    }

    private int round(int value, int prec) {
        return value / prec * prec;
    }

    @Override
    public void creationDone() {
    }

    @Override
    public void selectionChanged() {
        int sz = this.theEditor.getSelectionLength();
        this.editCutMenuItem.setEnabled(sz > 0);
        this.editCopyMenuItem.setEnabled(sz > 0);
        this.editPasteMenuItem.setEnabled(JDClipboard.getInstance().size() > 0);
        this.editDeleteMenuItem.setEnabled(sz > 0);
        this.editSelectAllMenuItem.setEnabled(sz < this.theEditor.getObjectNumber());
        this.editSelectNoneMenuItem.setEnabled(sz > 0);
        this.viewsGroupEditMenuItem.setEnabled(this.theEditor.canEditGroup());
        this.viewsOptionMenuItem.setEnabled(sz > 0);
        this.toolsHMirrorMenuItem.setEnabled(sz > 0);
        this.toolsVMirrorMenuItem.setEnabled(sz > 0);
        this.toolsAlignleftMenuItem.setEnabled(sz > 1);
        this.toolsAligntopMenuItem.setEnabled(sz > 1);
        this.toolsAlignrightMenuItem.setEnabled(sz > 1);
        this.toolsAlignbottomMenuItem.setEnabled(sz > 1);
        this.toolsConvertPolyMenuItem.setEnabled(this.theEditor.canConvertToPolyline());
        this.toolsRaiseMenuItem.setEnabled(sz == 1);
        this.toolsLowerMenuItem.setEnabled(sz == 1);
        this.toolsFrontMenuItem.setEnabled(sz >= 1);
        this.toolsBackMenuItem.setEnabled(sz >= 1);
        this.toolsAlignToGrid.setSelected(this.theEditor.isAlignToGrid());
        this.toolsGridVisible.setSelected(this.theEditor.isGridVisible());
    }

    @Override
    public void clipboardChanged() {
        int sz = JDClipboard.getInstance().size();
        this.editPasteMenuItem.setEnabled(sz > 0);
    }

    @Override
    public void valueChanged() {
        this.rebuildGroup();
    }

    @Override
    public void sizeChanged() {
        this.theEditorView.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.editCutMenuItem) {
            this.theEditor.cutSelection();
        } else if (src == this.editCopyMenuItem) {
            this.theEditor.copySelection();
        } else if (src == this.editPasteMenuItem) {
            this.theEditor.pasteClipboard(30, 30, false);
        } else if (src == this.editDeleteMenuItem) {
            this.theEditor.deleteSelection();
        } else if (src == this.editSelectAllMenuItem) {
            this.theEditor.selectAll();
        } else if (src == this.editSelectNoneMenuItem) {
            this.theEditor.unselectAll();
        } else if (src == this.exitMenuItem) {
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        } else if (src == this.viewsOptionMenuItem) {
            this.theEditor.showPropertyWindow();
        } else if (src == this.viewsGroupEditMenuItem) {
            this.theEditor.showGroupEditorWindow();
        } else if (src == this.toolsConvertPolyMenuItem) {
            this.theEditor.convertToPolyline();
        } else if (src == this.toolsRaiseMenuItem) {
            this.theEditor.raiseObject();
        } else if (src == this.toolsLowerMenuItem) {
            this.theEditor.lowerObject();
        } else if (src == this.toolsFrontMenuItem) {
            this.theEditor.frontSelection();
        } else if (src == this.toolsBackMenuItem) {
            this.theEditor.backSelection();
        } else if (src == this.toolsAlignToGrid) {
            this.theEditor.setAlignToGrid(this.toolsAlignToGrid.isSelected());
        } else if (src == this.toolsGridVisible) {
            this.theEditor.setGridVisible(this.toolsGridVisible.isSelected());
        } else if (src == this.toolsGridSettings) {
            String newSize = JOptionPane.showInputDialog("Enter Grid Size", (Object)new Integer(this.theEditor.getGridSize()));
            if (newSize != null) {
                try {
                    int sz = Integer.parseInt(newSize);
                    this.theEditor.setGridSize(sz);
                }
                catch (NumberFormatException e2) {
                    JOptionPane.showMessageDialog(this, "Wrong integer value\n" + e2.getMessage());
                }
            }
        } else if (src == this.toolsFitToGraph) {
            this.theEditor.computePreferredSize();
        } else if (src == this.toolsHMirrorMenuItem) {
            this.theEditor.scaleSelection(-1.0, 1.0);
        } else if (src == this.toolsVMirrorMenuItem) {
            this.theEditor.scaleSelection(1.0, -1.0);
        } else if (src == this.toolsAligntopMenuItem) {
            this.theEditor.aligntopSelection();
        } else if (src == this.toolsAlignleftMenuItem) {
            this.theEditor.alignleftSelection();
        } else if (src == this.toolsAlignbottomMenuItem) {
            this.theEditor.alignbottomSelection();
        } else if (src == this.toolsAlignrightMenuItem) {
            this.theEditor.alignrightSelection();
        }
    }

    private void rebuildGroup() {
        this.theGroup.setChildrenList(this.theEditor.getObjects());
        Rectangle r = this.theGroup.getRepaintRect();
        this.invoker.repaint(this.oldRect.union(r));
        this.invoker.fireValueChanged();
        this.oldRect = r;
        JDUtils.modified = true;
    }
}

