/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

class JDGlobalPanel
extends JPanel
implements ActionListener {
    private JLabel backgroundLabel;
    private JButton backgroundButton;
    private JButton dismissBtn;
    private JCheckBox autoResizeLabelCheck;
    private JCheckBox resizeLabelFontCheck;
    private JCheckBox resizeLabelTextCheck;
    JDrawEditor invoker;

    public JDGlobalPanel(JDrawEditor jc) {
        this.invoker = jc;
        this.setForeground(JDUtils.labelColor);
        this.setFont(JDUtils.labelFont);
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(270, 220));
        JPanel colorPanel = new JPanel(null);
        colorPanel.setBorder(JDUtils.createTitleBorder("Global settings"));
        colorPanel.setBounds(5, 5, 270, 95);
        this.backgroundLabel = JDUtils.createLabel("Background");
        this.backgroundLabel.setBounds(10, 20, 180, 24);
        colorPanel.add(this.backgroundLabel);
        this.backgroundButton = new JButton("");
        this.backgroundButton.setMargin(new Insets(0, 0, 0, 0));
        this.backgroundButton.setBackground(this.invoker.getBackground());
        this.backgroundButton.setForeground(Color.BLACK);
        this.backgroundButton.addActionListener(this);
        this.backgroundButton.setBounds(200, 20, 60, 24);
        colorPanel.add(this.backgroundButton);
        this.autoResizeLabelCheck = new JCheckBox("Resize drawing when panel size change");
        this.autoResizeLabelCheck.setFont(JDUtils.labelFont);
        this.autoResizeLabelCheck.setForeground(JDUtils.labelColor);
        this.autoResizeLabelCheck.setBounds(10, 50, 250, 25);
        this.autoResizeLabelCheck.setSelected(this.invoker.autoZoomAsked);
        colorPanel.add(this.autoResizeLabelCheck);
        this.add(colorPanel);
        JPanel editorPanel = new JPanel(null);
        editorPanel.setBorder(JDUtils.createTitleBorder("Editor settings"));
        editorPanel.setBounds(5, 105, 270, 85);
        this.resizeLabelFontCheck = new JCheckBox("Resize label when changing font");
        this.resizeLabelFontCheck.setFont(JDUtils.labelFont);
        this.resizeLabelFontCheck.setForeground(JDUtils.labelColor);
        this.resizeLabelFontCheck.setBounds(10, 20, 250, 25);
        this.resizeLabelFontCheck.setSelected(this.invoker.resizeLabelOnFontChange);
        editorPanel.add(this.resizeLabelFontCheck);
        this.resizeLabelTextCheck = new JCheckBox("Resize label when changing text");
        this.resizeLabelTextCheck.setFont(JDUtils.labelFont);
        this.resizeLabelTextCheck.setForeground(JDUtils.labelColor);
        this.resizeLabelTextCheck.setBounds(10, 50, 250, 25);
        this.resizeLabelTextCheck.setSelected(this.invoker.resizeLabelOnTextChange);
        editorPanel.add(this.resizeLabelTextCheck);
        this.add(editorPanel);
        this.dismissBtn = new JButton("Dismiss");
        this.dismissBtn.setMargin(new Insets(0, 0, 0, 0));
        this.dismissBtn.setFont(JDUtils.labelFont);
        this.dismissBtn.addActionListener(this);
        this.dismissBtn.setBounds(192, 195, 80, 24);
        this.add(this.dismissBtn);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.backgroundButton) {
            Color c = JColorChooser.showDialog(this, "Choose background color", this.invoker.getBackground());
            if (c != null) {
                this.invoker.setBackground(c);
                this.backgroundButton.setBackground(c);
            }
        } else if (src == this.dismissBtn) {
            this.invoker.resizeLabelOnFontChange = this.resizeLabelFontCheck.isSelected();
            this.invoker.resizeLabelOnTextChange = this.resizeLabelTextCheck.isSelected();
            this.invoker.autoZoomAsked = this.autoResizeLabelCheck.isSelected();
            ATKGraphicsUtils.getWindowForComponent(this).setVisible(false);
        }
    }
}

