/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDEllipsePanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JLabel startLabel;
    private JSpinner startSpinner;
    private JLabel extentLabel;
    private JSpinner extentSpinner;
    private JLabel stepLabel;
    private JSpinner stepSpinner;
    private JLabel arcTypeLabel;
    private JComboBox arcTypeCombo;
    private JDEllipse[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDEllipsePanel(JDEllipse[] p, JDrawEditor jc) {
        this.invoker = jc;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel polyPanel = new JPanel(null);
        polyPanel.setBorder(JDUtils.createTitleBorder("Ellipse"));
        polyPanel.setBounds(5, 5, 370, 120);
        this.startLabel = new JLabel("Angle start");
        this.startLabel.setFont(JDUtils.labelFont);
        this.startLabel.setForeground(JDUtils.labelColor);
        this.startLabel.setBounds(10, 20, 100, 25);
        polyPanel.add(this.startLabel);
        this.startSpinner = new JSpinner();
        this.startSpinner.addChangeListener(this);
        this.startSpinner.setBounds(115, 20, 60, 25);
        polyPanel.add(this.startSpinner);
        this.extentLabel = new JLabel("Angle extent");
        this.extentLabel.setFont(JDUtils.labelFont);
        this.extentLabel.setForeground(JDUtils.labelColor);
        this.extentLabel.setBounds(190, 20, 100, 25);
        polyPanel.add(this.extentLabel);
        this.extentSpinner = new JSpinner();
        this.extentSpinner.addChangeListener(this);
        this.extentSpinner.setBounds(295, 20, 60, 25);
        polyPanel.add(this.extentSpinner);
        this.stepLabel = new JLabel("Interpolation step");
        this.stepLabel.setFont(JDUtils.labelFont);
        this.stepLabel.setForeground(JDUtils.labelColor);
        this.stepLabel.setBounds(10, 50, 100, 25);
        polyPanel.add(this.stepLabel);
        this.stepSpinner = new JSpinner();
        this.stepSpinner.addChangeListener(this);
        this.stepSpinner.setBounds(115, 50, 60, 25);
        polyPanel.add(this.stepSpinner);
        this.arcTypeLabel = JDUtils.createLabel("Arc Type");
        this.arcTypeLabel.setBounds(10, 80, 90, 20);
        polyPanel.add(this.arcTypeLabel);
        this.arcTypeCombo = new JComboBox();
        this.arcTypeCombo.setFont(JDUtils.labelFont);
        this.arcTypeCombo.addItem("Open");
        this.arcTypeCombo.addItem("Closed");
        this.arcTypeCombo.addItem("Pie");
        this.arcTypeCombo.addActionListener(this);
        this.arcTypeCombo.setBounds(115, 80, 60, 25);
        polyPanel.add(this.arcTypeCombo);
        this.add(polyPanel);
        this.updatePanel(p);
    }

    public void updatePanel(JDEllipse[] objs) {
        this.allObjects = objs;
        this.isUpdating = true;
        if (objs == null || objs.length <= 0) {
            SpinnerNumberModel nullModel = new SpinnerNumberModel(0, 0, 0, 0);
            this.startSpinner.setModel(nullModel);
            this.extentSpinner.setModel(nullModel);
            this.stepSpinner.setModel(nullModel);
            this.arcTypeCombo.setSelectedIndex(-1);
        } else {
            JDEllipse p = objs[0];
            Integer value = new Integer(p.getAngleStart());
            Integer min = new Integer(-360);
            Integer max = new Integer(360);
            Integer step = new Integer(1);
            SpinnerNumberModel spModel = new SpinnerNumberModel(value, min, max, step);
            this.startSpinner.setModel(spModel);
            value = new Integer(p.getAngleExtent());
            min = new Integer(0);
            max = new Integer(360);
            step = new Integer(1);
            spModel = new SpinnerNumberModel(value, min, max, step);
            this.extentSpinner.setModel(spModel);
            value = new Integer(p.getStep());
            min = new Integer(1);
            max = new Integer(256);
            step = new Integer(1);
            spModel = new SpinnerNumberModel(value, min, max, step);
            this.stepSpinner.setModel(spModel);
            this.arcTypeCombo.setSelectedIndex(p.getArcType());
        }
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle newRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            newRect = newRect.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(newRect.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.arcTypeCombo) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setArcType(this.arcTypeCombo.getSelectedIndex());
            }
            this.invoker.setNeedToSave(true, "Change arc type");
        }
        this.repaintObjects();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object src = e.getSource();
        if (src == this.stepSpinner) {
            Integer v = (Integer)this.stepSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setStep(v);
            }
            this.invoker.setNeedToSave(true, "Change arc step");
        } else if (src == this.startSpinner) {
            Integer v = (Integer)this.startSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAngleStart(v);
            }
            this.invoker.setNeedToSave(true, "Change arc angle");
        } else if (src == this.extentSpinner) {
            Integer v = (Integer)this.extentSpinner.getValue();
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setAngleExtent(v);
            }
            this.invoker.setNeedToSave(true, "Change arc angle");
        }
        this.repaintObjects();
    }
}

