/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDEllipse
extends JDRectangular
implements JDPolyConvert {
    public static final int ARC_OPEN = 0;
    public static final int ARC_CLOSED = 1;
    public static final int ARC_PIE = 2;
    static final int stepDefault = 36;
    static final int angleStartDefault = 0;
    static final int angleExtentDefault = 360;
    static final int arcTypeDefault = 0;
    int step;
    int arcType;
    int angleStart;
    int angleExtent;
    int sAngleStart;
    private boolean useOval = false;
    private double x1;
    private double y1;
    private double width;
    private double height;

    public JDEllipse(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(x, y));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.updateShape();
    }

    JDEllipse(JDEllipse e, int x, int y) {
        this.cloneObject(e, x, y);
        this.step = e.step;
        this.arcType = e.arcType;
        this.angleStart = e.angleStart;
        this.angleExtent = e.angleExtent;
        this.updateShape();
    }

    JDEllipse(JLXObject jlxObj, int a, int b, int atype) {
        this.initDefault();
        this.loadObject(jlxObj);
        double x = jlxObj.boundRect.getX();
        double y = jlxObj.boundRect.getY();
        double w = jlxObj.boundRect.getWidth();
        double h = jlxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.step = 36;
        this.angleStart = a;
        this.angleExtent = b;
        this.arcType = this.fillStyle == 0 ? 0 : (atype == 1 ? 1 : 2);
        this.updateShape();
    }

    JDEllipse(LXObject lxObj, int a, int b, int atype) {
        this.initDefault();
        this.loadObject(lxObj);
        double x = lxObj.boundRect.getX();
        double y = lxObj.boundRect.getY();
        double w = lxObj.boundRect.getWidth();
        double h = lxObj.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(x + w / 2.0, y + h / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[1].x = x + w / 2.0;
        this.summit[1].y = y;
        this.summit[2].x = x + w;
        this.summit[2].y = y;
        this.summit[3].x = x + w;
        this.summit[3].y = y + h / 2.0;
        this.summit[4].x = x + w;
        this.summit[4].y = y + h;
        this.summit[5].x = x + w / 2.0;
        this.summit[5].y = y + h;
        this.summit[6].x = x;
        this.summit[6].y = y + h;
        this.summit[7].x = x;
        this.summit[7].y = y + h / 2.0;
        this.step = 36;
        this.angleStart = a;
        this.angleExtent = b;
        this.arcType = this.fillStyle == 0 ? 0 : (atype == 1 ? 1 : 2);
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 36;
        this.arcType = 0;
        this.angleStart = 0;
        this.angleExtent = 360;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDEllipse(this, x, y);
    }

    @Override
    public boolean isInsideObject(int x, int y) {
        if (!super.isInsideObject(x, y)) {
            return false;
        }
        boolean found = false;
        int i = 0;
        if (this.fillStyle != 0) {
            Polygon p = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            found = p.contains(x, y);
        } else {
            while (i < this.ptsx.length - 1 && !found) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[i + 1], this.ptsy[i + 1]);
                if (found) continue;
                ++i;
            }
            if (!found) {
                found = this.isPointOnLine(x, y, this.ptsx[i], this.ptsy[i], this.ptsx[0], this.ptsy[0]);
            }
        }
        return found;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.makePolygon();
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline ret = this.buildDefaultPolyline();
        ret.setClosed(this.isClosed());
        ret.updateShape();
        return ret;
    }

    boolean isClosed() {
        return this.angleExtent == 360 || this.arcType != 0;
    }

    @Override
    public void rotate90(double x, double y) {
        this.angleStart += 90;
        this.angleStart %= 360;
        super.rotate90(x, y);
    }

    @Override
    public void restoreTransform() {
        this.angleStart = this.sAngleStart;
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        this.sAngleStart = this.angleStart;
        super.saveTransform();
    }

    @Override
    void computeBoundRect() {
        double maxx = -65536.0;
        double maxy = -65536.0;
        double minx = 65536.0;
        double miny = 65536.0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (this.summit[i].x < minx) {
                minx = this.summit[i].x;
            }
            if (this.summit[i].x > maxx) {
                maxx = this.summit[i].x;
            }
            if (this.summit[i].y < miny) {
                miny = this.summit[i].y;
            }
            if (!(this.summit[i].y > maxy)) continue;
            maxy = this.summit[i].y;
        }
        this.x1 = minx;
        this.y1 = miny;
        this.width = maxx - minx;
        this.height = maxy - miny;
        this.boundRect.setRect((int)minx, (int)miny, (int)(maxx - minx) + 1, (int)(maxy - miny) + 1);
    }

    JDEllipse(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("step")) {
                this.step = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("angle_start")) {
                this.angleStart = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("angle_extent")) {
                this.angleExtent = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("arc_type")) {
                this.arcType = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.step != 36) {
            to_write.append(decal).append("step:").append(this.step).append("\n");
        }
        if (this.angleStart != 0) {
            to_write.append(decal).append("angle_start:").append(this.angleStart).append("\n");
        }
        if (this.angleExtent != 360) {
            to_write.append(decal).append("angle_extent:").append(this.angleExtent).append("\n");
        }
        if (this.arcType != 0) {
            to_write.append(decal).append("arc_type:").append(this.arcType).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(1);
        this.fillUndoPattern(u);
        u.step = this.step;
        u.arcType = this.arcType;
        u.angleStart = this.angleStart;
        u.angleExtent = this.angleExtent;
        return u;
    }

    JDEllipse(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.step = e.step;
        this.arcType = e.arcType;
        this.angleStart = e.angleStart;
        this.angleExtent = e.angleExtent;
        this.updateShape();
    }

    public void setStep(int s) {
        this.step = s;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setArcType(int type) {
        this.arcType = type;
        this.updateShape();
    }

    public int getArcType() {
        return this.arcType;
    }

    public void setAngleStart(int a) {
        this.angleStart = a;
        this.updateShape();
    }

    public int getAngleStart() {
        return this.angleStart;
    }

    public void setAngleExtent(int a) {
        this.angleExtent = a;
        this.updateShape();
    }

    public int getAngleExtent() {
        return this.angleExtent;
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        Paint p;
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        if (this.fillStyle != 0 && this.isClosed() && (p = GraphicsUtils.createPatternForFilling(this)) != null) {
            g2.setPaint(p);
            if (this.useOval) {
                g.fillOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)(this.width + 1.0), (int)(this.height + 1.0));
            } else {
                g.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        if (this.lineWidth > 0) {
            g.setColor(this.foreground);
            BasicStroke bs = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            Stroke old = null;
            if (bs != null) {
                old = g2.getStroke();
                g2.setStroke(bs);
            }
            if (this.isClosed()) {
                if (this.useOval) {
                    g.drawOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)this.width, (int)this.height);
                } else {
                    g.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                }
            } else {
                g.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
            }
            if (bs != null) {
                g2.setStroke(old);
            }
        }
        this.paintShadows(g);
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }

    private void makePolygon() {
        double w = this.width / 2.0;
        double h = this.height / 2.0;
        double xc = this.x1 + w;
        double yc = this.y1 + h;
        w -= 0.5;
        h -= 0.5;
        int nbp = this.arcType == 2 && this.angleExtent != 360 ? this.step + 1 : this.step;
        this.ptsx = new int[nbp];
        this.ptsy = new int[nbp];
        double r = (double)this.angleExtent / 180.0 * Math.PI / (double)this.step;
        double r0 = (double)this.angleStart / 180.0 * Math.PI;
        for (int i = 0; i < this.step; ++i) {
            double x = w * Math.cos(r0 + r * (double)i);
            double y = h * Math.sin(r0 + r * (double)i);
            this.ptsx[i] = (int)(xc + x);
            this.ptsy[i] = (int)(yc + y);
        }
        if (this.arcType == 2 && this.angleExtent != 360) {
            this.ptsx[i] = (int)xc;
            this.ptsy[i] = (int)yc;
        }
        this.useOval = this.angleExtent == 360 && this.step == 36;
    }
}

