/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.jdraw.JDEntityNode;
import fr.esrf.tangoatk.widget.util.jdraw.JDNode;
import fr.esrf.tangoatk.widget.util.jdraw.RootNode;
import fr.esrf.tangoatk.widget.util.jdraw.TestPanel;
import fr.esrf.tangoatk.widget.util.jdraw.TreeNodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class JDDeviceTree
extends JPanel
implements DragGestureListener,
DragSourceListener {
    public static final int NODE_ATTRIBUTE = 1;
    public static final int NODE_COMMAND = 2;
    static Database db;
    JTree tree;
    JScrollPane treeView;
    DefaultTreeModel treeModel;

    public JDDeviceTree() {
        try {
            db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage(null, "Database", e);
            return;
        }
        this.setLayout(new BorderLayout());
        this.createTree();
        this.add((Component)this.treeView, "Center");
    }

    private void createTree() {
        this.treeModel = new DefaultTreeModel(new RootNode());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.tree);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.tree, 2, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        JTree tree = (JTree)dragGestureEvent.getComponent();
        TreePath path = tree.getSelectionPath();
        if (path != null) {
            JDNode selectedNode = (JDNode)path.getLastPathComponent();
            DefaultMutableTreeNode selection = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (selectedNode.isLeaf()) {
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, (JDEntityNode)selectedNode, this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
        context.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = 200;
        return d;
    }

    public static void main(String[] args) {
        JDDeviceTree df = new JDDeviceTree();
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        TestPanel tp = new TestPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)df, "Center");
        p.add((Component)tp, "East");
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }
}

