/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDAxis
extends JDRectangular {
    public static final int HORIZONTAL_AXIS = 0;
    public static final int VERTICAL_AXIS = 1;
    public static final int LEFT_LABEL = 0;
    public static final int RIGHT_LABEL = 1;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    private static int orientationDefault = 1;
    private static boolean tickCenteredDefault = false;
    private static int tickLengthDefault = 4;
    private static int labelPosDefault = 0;
    private static int scaleDefault = 0;
    private static int formatDefault = 0;
    private static double minDefault = 0.0;
    private static double maxDefault = 100.0;
    private static boolean invertedDefault = true;
    private static int tickSpacingDefault = 10;
    private Font theFont;
    private int orientation;
    private boolean tickCentered;
    private boolean inverted;
    private int tickLength;
    private int labelPos;
    private int scale;
    private int format;
    private int tickSpacing;
    private double min;
    private double max;
    private int fAscent;
    protected JLAxis theAxis;

    public JDAxis(String objectName, int x, int y, int w, int h) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = objectName;
        this.createSummit();
        this.computeSummitCoordinates(x, y, w, h);
        this.buildAxis();
        this.updateShape();
        this.centerOrigin();
    }

    JDAxis(JDAxis e, int x, int y) {
        this.cloneObject(e, x, y);
        this.theFont = new Font(e.theFont.getName(), e.theFont.getStyle(), e.theFont.getSize());
        this.orientation = e.orientation;
        this.tickCentered = e.tickCentered;
        this.tickLength = e.tickLength;
        this.tickSpacing = e.tickSpacing;
        this.labelPos = e.labelPos;
        this.scale = e.scale;
        this.min = e.min;
        this.max = e.max;
        this.format = e.format;
        this.inverted = e.inverted;
        this.buildAxis();
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.lineWidth = 0;
        this.theFont = JDLabel.fontDefault;
        this.orientation = orientationDefault;
        this.tickCentered = tickCenteredDefault;
        this.tickLength = tickLengthDefault;
        this.labelPos = labelPosDefault;
        this.min = minDefault;
        this.max = maxDefault;
        this.scale = scaleDefault;
        this.format = formatDefault;
        this.inverted = invertedDefault;
        this.tickSpacing = tickSpacingDefault;
    }

    @Override
    public JDObject copy(int x, int y) {
        return new JDAxis(this, x, y);
    }

    @Override
    public void paint(JDrawEditor parent, Graphics g) {
        if (!this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.prepareRendering(g2);
        super.paint(parent, g);
        int tr = 0;
        boolean clipNeeded = false;
        Shape oldClip = null;
        Color backColor = Color.BLACK;
        if (parent != null) {
            backColor = parent.getBackground();
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.orientation == 1) {
            this.theAxis.measureAxis(frc, 0, this.boundRect.height - 1);
            int tickLgth = this.theAxis.getTickLength();
            if (tickLgth < 0) {
                tickLgth = 0;
            }
            boolean bl = clipNeeded = this.boundRect.width <= this.theAxis.getThickness() + tickLgth;
            if (clipNeeded) {
                oldClip = g.getClip();
                g.setClip(this.boundRect.x, this.boundRect.y - this.fAscent, this.boundRect.width, this.boundRect.height + 2 * this.fAscent);
            }
            if (this.labelPos == 0) {
                tr = this.boundRect.width - this.theAxis.getThickness() - 1;
            }
            if (tr < 0) {
                tr = 0;
            }
            this.theAxis.paintAxisDirect(g, frc, this.boundRect.x + tr, this.boundRect.y, backColor, 0, 0);
        } else {
            this.theAxis.measureAxis(frc, this.boundRect.width - 1, 0);
            int tickLgth = this.theAxis.getTickLength();
            if (tickLgth < 0) {
                tickLgth = 0;
            }
            boolean bl = clipNeeded = this.boundRect.height <= this.theAxis.getThickness() + tickLgth;
            if (clipNeeded) {
                oldClip = g.getClip();
                int fo = this.theAxis.getFontOverWidth();
                g.setClip(this.boundRect.x - fo, this.boundRect.y, this.boundRect.width + 2 * fo, this.boundRect.height);
            }
            this.theAxis.paintAxisDirect(g, frc, this.boundRect.x, this.boundRect.y, backColor, 0, 0);
        }
        if (clipNeeded) {
            g.setClip(oldClip);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle r = super.getRepaintRect();
        int tick = this.theAxis.getTickLength();
        if (tick < 0) {
            tick = 0;
        }
        int fo = this.theAxis.getFontOverWidth();
        if (this.orientation == 1) {
            r.x -= tick;
            r.width += 2 * tick;
            r.y -= this.fAscent;
            r.height += 2 * this.fAscent;
        } else {
            r.y -= tick;
            r.height += 2 * tick;
            r.x -= fo;
            r.width += 2 * fo;
        }
        return r;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)(this.summit[0].x + 0.5);
                this.ptsy[0] = (int)(this.summit[0].y + 0.5);
                this.ptsx[1] = (int)(this.summit[2].x + 0.5);
                this.ptsy[1] = (int)(this.summit[2].y + 0.5);
                this.ptsx[2] = (int)(this.summit[4].x + 0.5);
                this.ptsy[2] = (int)(this.summit[4].y + 0.5);
                this.ptsx[3] = (int)(this.summit[6].x + 0.5);
                this.ptsy[3] = (int)(this.summit[6].y + 0.5);
            } else {
                this.ptsx[0] = (int)(this.summit[6].x + 0.5);
                this.ptsy[0] = (int)(this.summit[6].y + 0.5);
                this.ptsx[1] = (int)(this.summit[4].x + 0.5);
                this.ptsy[1] = (int)(this.summit[4].y + 0.5);
                this.ptsx[2] = (int)(this.summit[2].x + 0.5);
                this.ptsy[2] = (int)(this.summit[2].y + 0.5);
                this.ptsx[3] = (int)(this.summit[0].x + 0.5);
                this.ptsy[3] = (int)(this.summit[0].y + 0.5);
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)(this.summit[2].x + 0.5);
            this.ptsy[0] = (int)(this.summit[2].y + 0.5);
            this.ptsx[1] = (int)(this.summit[0].x + 0.5);
            this.ptsy[1] = (int)(this.summit[0].y + 0.5);
            this.ptsx[2] = (int)(this.summit[6].x + 0.5);
            this.ptsy[2] = (int)(this.summit[6].y + 0.5);
            this.ptsx[3] = (int)(this.summit[4].x + 0.5);
            this.ptsy[3] = (int)(this.summit[4].y + 0.5);
        } else {
            this.ptsx[0] = (int)(this.summit[4].x + 0.5);
            this.ptsy[0] = (int)(this.summit[4].y + 0.5);
            this.ptsx[1] = (int)(this.summit[6].x + 0.5);
            this.ptsy[1] = (int)(this.summit[6].y + 0.5);
            this.ptsx[2] = (int)(this.summit[0].x + 0.5);
            this.ptsy[2] = (int)(this.summit[0].y + 0.5);
            this.ptsx[3] = (int)(this.summit[2].x + 0.5);
            this.ptsy[3] = (int)(this.summit[2].y + 0.5);
        }
        if (this.theAxis != null) {
            if (this.orientation == 1) {
                if (this.labelPos == 0) {
                    this.theAxis.setOrientation(6);
                } else {
                    this.theAxis.setOrientation(5);
                }
                if (this.tickCentered) {
                    this.theAxis.setPosition(7);
                }
            } else {
                this.theAxis.setOrientation(1);
                if (this.tickCentered) {
                    this.theAxis.setPosition(4);
                }
            }
            this.theAxis.setTickSpacing(this.tickSpacing);
            this.theAxis.setTickLength(-this.tickLength);
            this.theAxis.setScale(this.scale);
            this.theAxis.setFont(this.theFont);
            this.fAscent = (int)(ATKGraphicsUtils.getLineMetrics("0", this.theFont).getAscent() + 0.5f);
            this.theAxis.setAxisColor(this.foreground);
            this.theAxis.setMinimum(this.min);
            this.theAxis.setMaximum(this.max);
            this.theAxis.setLabelFormat(this.format);
            this.theAxis.setInverted(this.inverted);
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    @Override
    public void setForeground(Color f) {
        super.setForeground(f);
        this.updateShape();
    }

    public void setFont(Font f) {
        this.theFont = f;
        this.updateShape();
    }

    public Font getFont() {
        return this.theFont;
    }

    public void setTickCentered(boolean center) {
        this.tickCentered = center;
        this.updateShape();
    }

    public boolean isTickCentered() {
        return this.tickCentered;
    }

    public void setTickWidth(int width) {
        this.tickLength = width;
        this.updateShape();
    }

    public int getTickWidth() {
        return this.tickLength;
    }

    public void setTickSpacing(int spacing) {
        this.tickSpacing = spacing;
        this.updateShape();
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setMax(double m) {
        this.max = m;
        this.updateShape();
    }

    public void setMin(double m) {
        this.min = m;
        this.updateShape();
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public void setLabelPos(int pos) {
        this.labelPos = pos;
        this.updateShape();
    }

    public int getLabelPos() {
        return this.labelPos;
    }

    public void setOrientation(int o) {
        this.orientation = o;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setScale(int s) {
        this.scale = s;
        this.updateShape();
    }

    public int getScale() {
        return this.scale;
    }

    public void setFormat(int f) {
        this.format = f;
        this.updateShape();
    }

    public int getFormat() {
        return this.format;
    }

    public void setInverted(boolean i) {
        this.inverted = i;
        this.updateShape();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    void recordObject(StringBuffer to_write, int level) {
        StringBuffer decal = this.recordObjectHeader(to_write, level);
        if (this.theFont.getName() != JDLabel.fontDefault.getName() || this.theFont.getStyle() != JDLabel.fontDefault.getStyle() || this.theFont.getSize() != JDLabel.fontDefault.getSize()) {
            to_write.append(decal).append("font:\"");
            to_write.append(this.theFont.getName()).append("\",");
            to_write.append(this.theFont.getStyle()).append(",");
            to_write.append(this.theFont.getSize()).append("\n");
        }
        if (this.tickCentered != tickCenteredDefault) {
            to_write.append(decal).append("tickCentered:").append(this.tickCentered).append("\n");
        }
        if (this.inverted != invertedDefault) {
            to_write.append(decal).append("inverted:").append(this.inverted).append("\n");
        }
        if (this.tickSpacing != tickSpacingDefault) {
            to_write.append(decal).append("tickSpacing:").append(this.tickSpacing).append("\n");
        }
        if (this.tickLength != tickLengthDefault) {
            to_write.append(decal).append("tickLength:").append(this.tickLength).append("\n");
        }
        if (this.max != maxDefault) {
            to_write.append(decal).append("max:").append(this.max).append("\n");
        }
        if (this.min != minDefault) {
            to_write.append(decal).append("min:").append(this.min).append("\n");
        }
        if (this.labelPos != labelPosDefault) {
            to_write.append(decal).append("labelPos:").append(this.labelPos).append("\n");
        }
        if (this.orientation != orientationDefault) {
            to_write.append(decal).append("orientation:").append(this.orientation).append("\n");
        }
        if (this.scale != scaleDefault) {
            to_write.append(decal).append("scale:").append(this.scale).append("\n");
        }
        if (this.format != formatDefault) {
            to_write.append(decal).append("format:").append(this.format).append("\n");
        }
        this.closeObjectHeader(to_write, level);
    }

    JDAxis(JDFileLoader f) throws IOException {
        this.initDefault();
        f.startBlock();
        this.summit = f.parseRectangularSummitArray();
        while (!f.isEndBlock()) {
            String propName = f.parseProperyName();
            if (propName.equals("font")) {
                this.theFont = f.parseFont();
                continue;
            }
            if (propName.equals("tickCentered")) {
                this.tickCentered = f.parseBoolean();
                continue;
            }
            if (propName.equals("inverted")) {
                this.inverted = f.parseBoolean();
                continue;
            }
            if (propName.equals("tickLength")) {
                this.tickLength = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("tickSpacing")) {
                this.tickSpacing = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("labelPos")) {
                this.labelPos = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("orientation")) {
                this.orientation = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("scale")) {
                this.scale = (int)f.parseDouble();
                continue;
            }
            if (propName.equals("min")) {
                this.min = f.parseDouble();
                continue;
            }
            if (propName.equals("max")) {
                this.max = f.parseDouble();
                continue;
            }
            if (propName.equals("format")) {
                this.format = (int)f.parseDouble();
                continue;
            }
            this.loadDefaultPropery(f, propName);
        }
        f.endBlock();
        this.buildAxis();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern u = new UndoPattern(11);
        this.fillUndoPattern(u);
        u.fName = this.theFont.getName();
        u.fStyle = this.theFont.getStyle();
        u.fSize = this.theFont.getSize();
        u.tickCentered = this.tickCentered;
        u.arrowWidth = this.tickLength;
        u.cornerWidth = this.tickSpacing;
        u.vAlignment = this.labelPos;
        u.arrowMode = this.orientation;
        u.arcType = this.scale;
        u.min = this.min;
        u.max = this.max;
        u.axis = this.theAxis;
        u.angleExtent = this.format;
        u.isClosed = this.inverted;
        return u;
    }

    JDAxis(UndoPattern e) {
        this.initDefault();
        this.applyUndoPattern(e);
        this.theFont = new Font(e.fName, e.fStyle, e.fSize);
        this.tickCentered = e.tickCentered;
        this.tickLength = e.arrowWidth;
        this.tickSpacing = e.cornerWidth;
        this.labelPos = e.vAlignment;
        this.orientation = e.arrowMode;
        this.scale = e.arcType;
        this.min = e.min;
        this.max = e.max;
        this.format = e.angleExtent;
        this.theAxis = e.axis;
        this.inverted = e.isClosed;
        this.updateShape();
    }

    private void computeSummitCoordinates(int x, int y, int width, int height) {
        this.summit[0].x = x;
        this.summit[0].y = y;
        this.summit[2].x = x + width;
        this.summit[2].y = y;
        this.summit[4].x = x + width;
        this.summit[4].y = y + height;
        this.summit[6].x = x;
        this.summit[6].y = y + height;
        this.centerSummit();
    }

    private void buildAxis() {
        this.theAxis = this.orientation == 1 ? new JLAxis(null, 6) : new JLAxis(null, 1);
        this.theAxis.setAutoScale(false);
        this.theAxis.setAnnotation(2);
    }
}

