/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;

public class FileFinder {
    private String rootDir;
    private String extension;
    private int maxFiles;
    private int counter;
    private String[] fileList;
    private boolean recursive;

    public FileFinder(String rd, String xt, int mx) {
        this.rootDir = rd;
        this.extension = xt;
        this.maxFiles = mx;
        this.fileList = new String[this.maxFiles];
        this.counter = 0;
    }

    public String[] getList(boolean rc) {
        this.recursive = rc;
        FileFilter fileFilter1 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().startsWith(".");
            }
        };
        FilenameFilter fileFilter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lib");
            }
        };
        File dir = new File(this.rootDir);
        File[] files = dir.listFiles(fileFilter1);
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length && this.counter < this.maxFiles; ++i) {
            if (files[i].isDirectory() && this.recursive) {
                FileFinder subdir = new FileFinder(this.rootDir + "/" + files[i].getName(), this.extension, this.maxFiles - this.counter);
                String[] sublist = subdir.getList(true);
                for (int j = 0; j < sublist.length; ++j) {
                    this.fileList[this.counter] = files[i].getName() + "/" + sublist[j];
                    ++this.counter;
                }
                continue;
            }
            if (!files[i].getName().endsWith(".lib")) continue;
            this.fileList[this.counter] = files[i].getName();
            ++this.counter;
        }
        String[] returnList = new String[this.counter];
        for (int i = 0; i < this.counter; ++i) {
            returnList[i] = this.fileList[i];
            System.out.println("File found: " + returnList[i]);
        }
        return returnList;
    }
}

