/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock.examples;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetEditorFrame;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.NetUtils;
import fr.esrf.tangoatk.widget.util.interlock.examples.ItlkNetEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class ItlkEditor
extends NetEditorFrame {
    ItlkNetEditor itlkEditor;
    JMenuItem traceMode;
    JMenuItem editMode;
    JButton bubbleBtn;
    JButton permitBtn;
    JButton joinBtn;
    JButton vccBtn;
    JButton groundBtn;

    public ItlkEditor() {
        this.setAppTitle("Interlock Simulator Editor");
        this.itlkEditor = new ItlkNetEditor(this);
        this.setEditor(this.itlkEditor);
        this.traceMode = NetUtils.createMenuItem("Trace mode", 0, 0, this);
        this.editMode = NetUtils.createMenuItem("Edit mode", 0, 0, this);
        this.getOptionMenu().add((Component)this.traceMode, 0);
        this.getOptionMenu().add((Component)this.editMode, 1);
        this.getOptionMenu().add((Component)new JSeparator(), 2);
        JToolBar tb = this.getToolbar();
        tb.remove(this.getToobarButton(1));
        String rPth = "/fr/esrf/tangoatk/widget/util/interlock/gif/";
        this.bubbleBtn = this.createIconButton(rPth, "bubble", "Create an interlock object (physical switch)", this);
        tb.add((Component)this.bubbleBtn, 0);
        this.permitBtn = this.createIconButton(rPth, "permit", "Create a permit object (logical sensor)", this);
        tb.add((Component)this.permitBtn, 1);
        this.joinBtn = this.createIconButton(rPth, "join", "Create a join object (intersection point)", this);
        tb.add((Component)this.joinBtn, 2);
        this.vccBtn = this.createIconButton(rPth, "start", "Create a VCC object", this);
        tb.add((Component)this.vccBtn, 3);
        this.groundBtn = this.createIconButton(rPth, "end", "Create a Ground object", this);
        tb.add((Component)this.groundBtn, 4);
    }

    @Override
    public void objectClicked(NetEditor src, NetObject obj, MouseEvent e) {
        this.itlkEditor.swapItlkState(obj);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.bubbleBtn) {
            this.itlkEditor.setCreateMode(1, 1);
            this.getHelpLabel().setText("Interlock creation: Left click to create a interlock object, right click to cancel.");
        } else if (src == this.permitBtn) {
            this.itlkEditor.setCreateMode(1, 2);
            this.getHelpLabel().setText("Sensor creation: Left click to create a sensor object, right click to cancel.");
        } else if (src == this.joinBtn) {
            this.itlkEditor.setCreateMode(1, 5);
            this.getHelpLabel().setText("Join creation: Left click to create a join object, right click to cancel.");
        } else if (src == this.vccBtn) {
            this.itlkEditor.setCreateMode(1, 3);
            this.getHelpLabel().setText("VCC creation: Left click to create a VCC object, right click to cancel.");
        } else if (src == this.groundBtn) {
            this.itlkEditor.setCreateMode(1, 4);
            this.getHelpLabel().setText("Ground creation: Left click to create a ground object, right click to cancel.");
        } else if (src == this.traceMode) {
            this.itlkEditor.setEditable(false);
        } else if (src == this.editMode) {
            this.itlkEditor.setEditable(true);
        } else {
            super.actionPerformed(e);
        }
    }

    public static void main(String[] args) {
        ItlkEditor iE = new ItlkEditor();
        iE.pack();
        iE.setVisible(true);
    }
}

