/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.shape.Computer1;
import fr.esrf.tangoatk.widget.util.interlock.shape.Device1;
import fr.esrf.tangoatk.widget.util.interlock.shape.Device2;
import fr.esrf.tangoatk.widget.util.interlock.shape.Device3;
import fr.esrf.tangoatk.widget.util.interlock.shape.NetDevice1;
import fr.esrf.tangoatk.widget.util.interlock.shape.NetDevice2;
import fr.esrf.tangoatk.widget.util.interlock.shape.NetDevice3;
import fr.esrf.tangoatk.widget.util.interlock.shape.Printer1;
import fr.esrf.tangoatk.widget.util.interlock.shape.Printer2;
import fr.esrf.tangoatk.widget.util.interlock.shape.Printer3;
import fr.esrf.tangoatk.widget.util.interlock.shape.Server1;
import fr.esrf.tangoatk.widget.util.interlock.shape.Server2;
import fr.esrf.tangoatk.widget.util.interlock.shape.Storage1;
import fr.esrf.tangoatk.widget.util.interlock.shape.Storage2;
import fr.esrf.tangoatk.widget.util.interlock.shape.Storage3;
import fr.esrf.tangoatk.widget.util.interlock.shape.Storage4;
import fr.esrf.tangoatk.widget.util.interlock.shape.Storage5;
import fr.esrf.tangoatk.widget.util.interlock.shape.XTerm;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;

public class NetShape {
    public static final int SHAPE_CIRCLE = 0;
    public static final int SHAPE_SQUARE = 1;
    public static final int SHAPE_HEXAGON = 2;
    public static final int SHAPE_VCC = 3;
    public static final int SHAPE_GROUND = 4;
    public static final int SHAPE_DOT = 5;
    public static final int SHAPE_COMPUTER1 = 6;
    public static final int SHAPE_DEVICE1 = 7;
    public static final int SHAPE_DEVICE2 = 8;
    public static final int SHAPE_DEVICE3 = 9;
    public static final int SHAPE_NETDEVICE1 = 10;
    public static final int SHAPE_NETDEVICE2 = 11;
    public static final int SHAPE_NETDEVICE3 = 12;
    public static final int SHAPE_PRINTER1 = 13;
    public static final int SHAPE_PRINTER2 = 14;
    public static final int SHAPE_PRINTER3 = 15;
    public static final int SHAPE_SERVER1 = 16;
    public static final int SHAPE_SERVER2 = 17;
    public static final int SHAPE_STORAGE1 = 18;
    public static final int SHAPE_STORAGE2 = 19;
    public static final int SHAPE_STORAGE3 = 20;
    public static final int SHAPE_STORAGE4 = 21;
    public static final int SHAPE_STORAGE5 = 22;
    public static final int SHAPE_XTERM = 23;
    static Color selColor = new Color(160, 160, 80);
    private static int[] xHexagonI = new int[8];
    private static int[] yHexagonI = new int[8];
    private static Polygon hexagonPoly = new Polygon();

    static void paintShape(Graphics2D g, int shape, boolean isSelected, Color color, int x, int y, int bSize) {
        if (bSize == 0) {
            return;
        }
        switch (shape) {
            case 0: {
                NetShape.setFillColor(g, color, isSelected);
                g.fillOval(x - bSize - 2, y - bSize - 2, bSize * 2 + 5, bSize * 2 + 5);
                g.setColor(Color.black);
                g.drawOval(x - bSize - 2, y - bSize - 2, bSize * 2 + 4, bSize * 2 + 4);
                break;
            }
            case 1: {
                NetShape.setFillColor(g, color, isSelected);
                g.fillRect(x - bSize - 5, y - bSize - 4, bSize * 2 + 10, bSize * 2 + 8);
                g.setColor(Color.black);
                g.drawRect(x - bSize - 5, y - bSize - 4, bSize * 2 + 10, bSize * 2 + 8);
                break;
            }
            case 2: {
                NetShape.placeHexagon(bSize, x, y);
                NetShape.setFillColor(g, color, isSelected);
                g.fillPolygon(hexagonPoly);
                g.setColor(Color.black);
                g.drawPolygon(hexagonPoly);
                break;
            }
            case 3: {
                NetShape.setFillColor(g, Color.GREEN, isSelected);
                g.fillRect(x - 10, y - 2, 20, 4);
                NetShape.setFillColor(g, Color.BLACK, isSelected);
                g.fillRect(x - 3, y - 3, 6, 6);
                break;
            }
            case 4: {
                NetShape.setFillColor(g, Color.BLACK, isSelected);
                g.drawLine(x - 10, y, x + 10, y);
                for (int i = -10; i <= 10; i += 4) {
                    g.drawLine(x + i, y, x + (i - 4), y + 5);
                }
                g.fillRect(x - 3, y - 3, 6, 6);
                break;
            }
            case 5: {
                NetShape.setFillColor(g, Color.BLACK, isSelected);
                g.fillRect(x - 3, y - 3, 6, 6);
                break;
            }
            case 6: {
                Computer1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 7: {
                Device1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 8: {
                Device2.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 9: {
                Device3.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 10: {
                NetDevice1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 11: {
                NetDevice2.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 12: {
                NetDevice3.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 13: {
                Printer1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 14: {
                Printer2.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 15: {
                Printer3.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 16: {
                Server1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 17: {
                Server2.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 18: {
                Storage1.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 19: {
                Storage2.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 20: {
                Storage3.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 21: {
                Storage4.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 22: {
                Storage5.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
                break;
            }
            case 23: {
                XTerm.paint(g, isSelected ? selColor : color, x, y, (double)bSize / 10.0);
            }
        }
    }

    static void setBoundRect(int shape, int x, int y, int bSize, Rectangle bound) {
        switch (shape) {
            case 0: 
            case 1: 
            case 2: {
                bound.setRect(x - bSize - 2, y - bSize - 2, bSize * 2 + 4, bSize * 2 + 4);
                break;
            }
            case 3: {
                bound.setRect(x - 10, y - 4, 20.0, 8.0);
                break;
            }
            case 4: {
                bound.setRect(x - 10, y - 4, 20.0, 8.0);
                break;
            }
            case 5: {
                bound.setRect(x - 5, y - 5, 10.0, 10.0);
                break;
            }
            case 6: {
                Computer1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 7: {
                Device1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 8: {
                Device2.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 9: {
                Device3.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 10: {
                NetDevice1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 11: {
                NetDevice2.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 12: {
                NetDevice3.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 13: {
                Printer1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 14: {
                Printer2.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 15: {
                Printer3.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 16: {
                Server1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 17: {
                Server2.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 18: {
                Storage1.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 19: {
                Storage2.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 20: {
                Storage3.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 21: {
                Storage4.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 22: {
                Storage5.setBoundRect(x, y, (double)bSize / 10.0, bound);
                break;
            }
            case 23: {
                XTerm.setBoundRect(x, y, (double)bSize / 10.0, bound);
            }
        }
    }

    private static void placeHexagon(int bSize, int x, int y) {
        double size = bSize + 2;
        NetShape.xHexagonI[0] = x - (int)size;
        NetShape.xHexagonI[1] = x - (int)(size * 0.38 + 0.5);
        NetShape.xHexagonI[2] = x + (int)(size * 0.38 + 0.5);
        NetShape.xHexagonI[3] = x + (int)size;
        NetShape.xHexagonI[4] = x + (int)size;
        NetShape.xHexagonI[5] = x + (int)(size * 0.38 + 0.5);
        NetShape.xHexagonI[6] = x - (int)(size * 0.38 + 0.5);
        NetShape.xHexagonI[7] = x - (int)size;
        NetShape.yHexagonI[0] = y - (int)(size * 0.38 + 0.5);
        NetShape.yHexagonI[1] = y - (int)size;
        NetShape.yHexagonI[2] = y - (int)size;
        NetShape.yHexagonI[3] = y - (int)(size * 0.38 + 0.5);
        NetShape.yHexagonI[4] = y + (int)(size * 0.38 + 0.5);
        NetShape.yHexagonI[5] = y + (int)size;
        NetShape.yHexagonI[6] = y + (int)size;
        NetShape.yHexagonI[7] = y + (int)(size * 0.38 + 0.5);
        NetShape.hexagonPoly.xpoints = xHexagonI;
        NetShape.hexagonPoly.ypoints = yHexagonI;
        NetShape.hexagonPoly.npoints = 8;
        hexagonPoly.invalidate();
    }

    private static void setFillColor(Graphics2D g, Color defaultColor, boolean selected) {
        if (selected) {
            g.setColor(selColor);
        } else {
            g.setColor(defaultColor);
        }
    }
}

