/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetEditor;
import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class NetFileLoader {
    private static final int NUMBER = 1;
    private static final int STRING = 2;
    private static final int COMA = 3;
    private static final int COLON = 4;
    private static final int OPENBRACE = 5;
    private static final int CLOSEBRACE = 6;
    private static final int OPENBRACKET = 7;
    private static final int CLOSEBRACKET = 8;
    private static final int BUBBLE_KW = 9;
    private static final int TEXT_KW = 10;
    private static final int LABEL_KW = 11;
    private static final int CHILDREN_KW = 12;
    private static final int LABELOFFSET_KW = 13;
    private static final int JUSTIFY_KW = 14;
    private static final int EXTENSIONS_KW = 15;
    private static final int SIZE_KW = 16;
    private static final int SHAPE_KW = 17;
    private static final int EDSHAPE_KW = 18;
    private static final int FONT_KW = 19;
    private static final int NETFILE_KW = 20;
    private static final int GLOBALPARAM_KW = 21;
    private static final int LABELFONT_KW = 22;
    private static final int SMALLFONT_KW = 23;
    private static final int USEAAFONT_KW = 24;
    private static final int DRAWARROW_KW = 25;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", ",", ":", "{", "}", "(", ")", "Bubble", "Text", "label", "children", "label_offset", "justify", "extensions", "size", "shape", "editable_shape", "font", "NetFile", "GlobalParam", "label_font", "small_font", "use_aa_font", "draw_arrow"};
    private FileReader f;
    private String fileName;
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char NextChar;
    private boolean firstWarning;
    private int objIdx;
    private String word;
    private Font smallFont = NetEditor.defaultSmallFont;
    private Font labelFont = NetEditor.defaultLabelFont;
    private boolean useAAFont = false;
    private boolean drawArrow = true;

    public NetFileLoader(FileReader file, String fileName) throws IOException {
        this.CrtLine = 1;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        this.firstWarning = true;
        this.fileName = fileName;
        this.f = file;
    }

    public NetFileLoader(FileReader file, String fileName, int startLine) throws IOException {
        this.CrtLine = startLine;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        this.firstWarning = true;
        this.fileName = fileName;
        this.f = file;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.NextChar;
        this.NextChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws IOException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ':' || this.CurrentChar == '{' || this.CurrentChar == '}' || this.CurrentChar == ',' || this.CurrentChar == '(' || this.CurrentChar == ')') {
            ret_word.append(this.CurrentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.CurrentChar == '\"') {
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
                ret_word.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            this.read_char();
            return ret_word.toString();
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != '{' && this.CurrentChar != '}' && this.CurrentChar != ',' && this.CurrentChar != ':' && this.CurrentChar != '(' && this.CurrentChar != ')') {
            ret_word.append(this.CurrentChar);
            this.read_char();
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    private int class_lex(String word) {
        int i = 3;
        boolean found = false;
        if (word == null) {
            return 0;
        }
        if (word.length() == 0) {
            return 2;
        }
        while (i < this.lexical_word.length && !found) {
            found = word.equalsIgnoreCase(this.lexical_word[i]);
            if (found) continue;
            ++i;
        }
        if (found) {
            return i;
        }
        char c = word.charAt(0);
        if (c >= '0' && c <= '9' || c == '-') {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int lt, int le) throws IOException {
        if (lt != le) {
            throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[le] + "' expected");
        }
    }

    private void jump_lexem(int l) throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), l);
        this.word = this.read_word();
    }

    private int parseInteger() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        int ret = 0;
        try {
            ret = Integer.parseInt(this.word);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word();
        return ret;
    }

    private String parseParamString() throws IOException {
        String ret = this.word;
        int lex = this.class_lex(this.word);
        if (lex != 2 && lex != 1 && lex < 9) {
            throw new IOException("Error at line " + this.StartLine + ", '" + this.lexical_word[1] + "' or '" + this.lexical_word[2] + "' expected");
        }
        this.word = this.read_word();
        return ret;
    }

    private int[] parseIntegerList() throws IOException {
        boolean eol = false;
        Vector<Integer> tmpResult = new Vector<Integer>();
        do {
            tmpResult.add(new Integer(this.parseInteger()));
            boolean bl = eol = this.class_lex(this.word) != 3;
            if (eol) continue;
            this.word = this.read_word();
        } while (!eol);
        int[] result = new int[tmpResult.size()];
        for (int i = 0; i < tmpResult.size(); ++i) {
            result[i] = (Integer)tmpResult.get(i);
        }
        return result;
    }

    private String[] parseStringList() throws IOException {
        boolean eol = false;
        Vector<String> tmpResult = new Vector<String>();
        do {
            tmpResult.add(this.parseParamString());
            boolean bl = eol = this.class_lex(this.word) != 3;
            if (eol) continue;
            this.word = this.read_word();
        } while (!eol);
        String[] result = new String[tmpResult.size()];
        for (int i = 0; i < tmpResult.size(); ++i) {
            result[i] = (String)tmpResult.get(i);
        }
        return result;
    }

    private Font parseFont() throws IOException {
        String fntName = this.word;
        this.word = this.read_word();
        this.jump_lexem(3);
        int fntType = this.parseInteger();
        this.jump_lexem(3);
        int fntSize = this.parseInteger();
        return new Font(fntName, fntType, fntSize);
    }

    private void parseObjectExtension(NetObject o) throws IOException {
        int lex = this.class_lex(this.word);
        Vector<String> extN = new Vector<String>();
        Vector<String> extV = new Vector<String>();
        while (this.word != null && lex != 6) {
            extN.add(this.parseParamString());
            this.jump_lexem(4);
            extV.add(this.parseParamString());
            lex = this.class_lex(this.word);
        }
        int sz = extN.size();
        if (sz > 0) {
            int i;
            String[] strs = new String[sz];
            for (i = 0; i < sz; ++i) {
                strs[i] = (String)extN.get(i);
            }
            o.setExtensionList(strs);
            for (i = 0; i < sz; ++i) {
                o.setExtendedParam(i, (String)extV.get(i));
            }
        }
    }

    private void parseObjectParam(NetObject o) throws IOException {
        int lex = this.class_lex(this.word);
        while (this.word != null && lex != 6) {
            switch (lex) {
                case 11: {
                    this.jump_lexem(11);
                    this.jump_lexem(4);
                    o.setLabel(this.parseStringList());
                    break;
                }
                case 13: {
                    this.jump_lexem(13);
                    this.jump_lexem(4);
                    int[] off = this.parseIntegerList();
                    if (off.length != 2) {
                        throw new IOException("Error at line " + this.StartLine + ", 2 values expected for label_offset");
                    }
                    o.labelOffset.x = off[0];
                    o.labelOffset.y = off[1];
                    break;
                }
                case 14: {
                    this.jump_lexem(14);
                    this.jump_lexem(4);
                    o.justify = this.parseInteger();
                    break;
                }
                case 16: {
                    this.jump_lexem(16);
                    this.jump_lexem(4);
                    o.bSize = this.parseInteger();
                    break;
                }
                case 17: {
                    this.jump_lexem(17);
                    this.jump_lexem(4);
                    o.shape = this.parseInteger();
                    break;
                }
                case 18: {
                    this.jump_lexem(18);
                    this.jump_lexem(4);
                    o.editableShape = this.parseInteger() == 1;
                    break;
                }
                case 19: {
                    this.jump_lexem(19);
                    this.jump_lexem(4);
                    o.setTextFont(this.parseFont());
                    break;
                }
                case 12: {
                    this.jump_lexem(12);
                    this.jump_lexem(4);
                    o.setChildrenIdList(this.parseIntegerList());
                    break;
                }
                case 15: {
                    this.jump_lexem(15);
                    this.jump_lexem(5);
                    this.parseObjectExtension(o);
                    this.jump_lexem(6);
                    break;
                }
                default: {
                    if (lex == 6) break;
                    this.warningMessage("Warning: Unknown param name '" + this.word + "' at line " + this.CrtLine + "... Ignoring.");
                    this.jump_lexem(2);
                    this.jump_lexem(4);
                    this.parseStringList();
                }
            }
            lex = this.class_lex(this.word);
        }
    }

    private NetObject parseObject(int type) throws IOException {
        int maxI = 0;
        int maxO = 0;
        this.word = this.read_word();
        int uType = this.parseInteger();
        this.jump_lexem(7);
        int x = this.parseInteger();
        this.jump_lexem(3);
        int y = this.parseInteger();
        this.jump_lexem(8);
        if (type == 1) {
            maxI = this.parseInteger();
            this.jump_lexem(3);
            maxO = this.parseInteger();
        }
        NetObject ret = new NetObject(type, uType, maxI, maxO, x, y);
        ret.setIndex(this.objIdx);
        ++this.objIdx;
        this.jump_lexem(5);
        this.parseObjectParam(ret);
        this.jump_lexem(6);
        return ret;
    }

    private void parseGlobalParam() throws IOException {
        this.jump_lexem(21);
        this.jump_lexem(5);
        int lex = this.class_lex(this.word);
        while (this.word != null && lex != 6) {
            switch (lex) {
                case 22: {
                    this.jump_lexem(22);
                    this.jump_lexem(4);
                    this.labelFont = this.parseFont();
                    break;
                }
                case 23: {
                    this.jump_lexem(23);
                    this.jump_lexem(4);
                    this.smallFont = this.parseFont();
                    break;
                }
                case 24: {
                    this.jump_lexem(24);
                    this.jump_lexem(4);
                    this.useAAFont = this.parseInteger() == 1;
                    break;
                }
                case 25: {
                    this.jump_lexem(25);
                    this.jump_lexem(4);
                    this.drawArrow = this.parseInteger() == 1;
                    break;
                }
                default: {
                    if (lex == 6) break;
                    this.warningMessage("Warning: Unknown global param name '" + this.word + "' at line " + this.CrtLine + "... Ignoring.");
                    this.jump_lexem(2);
                    this.jump_lexem(4);
                    this.parseStringList();
                }
            }
            lex = this.class_lex(this.word);
        }
        this.jump_lexem(6);
    }

    public Vector parseNetFile() throws IOException {
        boolean eof = false;
        Vector<NetObject> objects = new Vector<NetObject>();
        this.objIdx = 0;
        this.word = this.read_word();
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        int lex = this.class_lex(this.word);
        if (lex != 20) {
            throw new IOException("Invalid net file header !");
        }
        this.word = this.read_word();
        this.jump_lexem(2);
        this.jump_lexem(5);
        if (this.class_lex(this.word) == 21) {
            this.parseGlobalParam();
        }
        lex = this.class_lex(this.word);
        while (!eof) {
            switch (lex) {
                case 9: {
                    objects.add(this.parseObject(1));
                    break;
                }
                case 10: {
                    objects.add(this.parseObject(2));
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new IOException("Invalid keyword at line " + this.StartLine);
                }
            }
            lex = this.class_lex(this.word);
            eof = this.word == null || lex == 6;
        }
        if (this.word == null) {
            throw new IOException("Unexpected end of file.");
        }
        this.CHECK_LEX(this.class_lex(this.word), 6);
        for (int i = 0; i < objects.size(); ++i) {
            NetObject o = (NetObject)objects.get(i);
            int[] childIds = o.getChildrenIdList();
            if (childIds == null) continue;
            for (int j = 0; j < childIds.length; ++j) {
                NetObject dst = this.findFromIndex(objects, childIds[j]);
                if (dst == null) {
                    throw new IOException("Invalid index '" + childIds[j] + "' in children list of object #" + o.getIndex());
                }
                o.addChild(dst);
            }
        }
        return objects;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public boolean getUseAAFont() {
        return this.useAAFont;
    }

    public boolean getDrawArrow() {
        return this.drawArrow;
    }

    private void warningMessage(String message) {
        if (this.firstWarning) {
            System.out.println("Warning while parsing: " + this.fileName);
            this.firstWarning = false;
        }
        System.out.println(message);
    }

    private NetObject findFromIndex(Vector objs, int idx) {
        int i = 0;
        int sz = objs.size();
        boolean found = false;
        NetObject o = null;
        while (i < sz && !found) {
            o = (NetObject)objs.get(i);
            found = o.getIndex() == idx;
            if (found) continue;
            ++i;
        }
        if (found) {
            return o;
        }
        return null;
    }
}

