/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

class PossibleNamesLister
extends JDialog
implements MouseListener {
    protected JLabel lastSelected = null;
    protected JLabel destination = null;
    protected JLabel[] names = null;
    protected JPanel mainPanel = new JPanel();
    protected JScrollPane scroller = null;
    protected int prefWidth = 0;
    protected int prefHeight = 0;
    static final Color selectionColor = new Color(255, 160, 200);
    static final Color mouseOverColor = new Color(200, 180, 255);
    static final Border labelBorder = new LineBorder(Color.BLACK, 1);
    static final Border selectionBorder = new LineBorder(selectionColor, 1);
    static final int maxWidth = 400;
    static final int maxHeight = 400;

    public PossibleNamesLister(String[] nameList, JDialog parent) {
        super(parent, "Choose variable:", true);
        this.mainPanel.setLayout(null);
        if (nameList != null) {
            int i;
            this.names = new JLabel[nameList.length];
            for (i = 0; i < nameList.length; ++i) {
                this.names[i] = nameList[i] != null ? new JLabel(new String(nameList[i])) : new JLabel("");
                this.names[i].setBorder(labelBorder);
                if (this.names[i].getPreferredSize().width > this.prefWidth) {
                    this.prefWidth = this.names[i].getPreferredSize().width;
                }
                this.prefHeight += 25;
            }
            for (i = 0; i < this.names.length; ++i) {
                this.names[i].setBounds(0, 25 * i, this.prefWidth, 25);
                this.mainPanel.add(this.names[i]);
                this.names[i].addMouseListener(this);
            }
            this.mainPanel.setPreferredSize(new Dimension(this.prefWidth, this.prefHeight));
        }
        this.scroller = new JScrollPane(this.mainPanel);
        this.setContentPane(this.scroller);
        this.mainPanel.setBackground(Color.WHITE);
        this.scroller.setBackground(Color.WHITE);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.initBounds();
        this.setResizable(false);
    }

    public void initBounds() {
        int width = this.prefWidth + 30 < 400 ? this.prefWidth + 30 : 400;
        int height = this.prefHeight + 30 < 400 ? this.prefHeight + 30 : 400;
        int x = this.getParent().getX() - (this.prefWidth + 50);
        int y = this.getParent().getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(x, y, width, height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (this.lastSelected != null) {
                this.lastSelected.setBorder(labelBorder);
                this.lastSelected.setOpaque(false);
                this.lastSelected.setBackground(Color.WHITE);
                this.lastSelected.repaint();
            }
            this.setVisible(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ((JLabel)e.getSource()).setBackground(mouseOverColor);
        ((JLabel)e.getSource()).setOpaque(true);
        ((JLabel)e.getSource()).repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ((JLabel)e.getSource()).setOpaque(false);
        ((JLabel)e.getSource()).setBackground(Color.WHITE);
        ((JLabel)e.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.lastSelected != null && this.lastSelected != (JLabel)e.getSource()) {
            this.lastSelected.setBorder(labelBorder);
            this.lastSelected.setOpaque(false);
            this.lastSelected.setBackground(Color.WHITE);
            this.lastSelected.repaint();
        }
        ((JLabel)e.getSource()).setBackground(selectionColor);
        ((JLabel)e.getSource()).setBorder(selectionBorder);
        ((JLabel)e.getSource()).setOpaque(true);
        ((JLabel)e.getSource()).repaint();
        this.lastSelected = (JLabel)e.getSource();
        if (this.destination != null) {
            this.destination.setText(((JLabel)e.getSource()).getText());
            this.destination.setToolTipText(((JLabel)e.getSource()).getText());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void dispose() {
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = null;
            }
            this.names = null;
        }
        this.lastSelected = null;
    }

    public JLabel getDestination() {
        return this.destination;
    }

    public void setDestination(JLabel destination) {
        this.destination = destination;
    }
}

