/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import org.nfunk.jep.JEP;

public class ExpressionParser {
    protected JLDataView[] dv;
    protected DataList[] dl;
    protected int anno;
    protected int precision = 0;
    protected JEP parser;
    protected String expression;
    protected boolean x = false;

    public ExpressionParser(int nb, String expr) {
        this.dv = new JLDataView[nb];
        this.dl = new DataList[nb];
        this.parser = new JEP();
        this.parser.addStandardConstants();
        this.parser.addStandardFunctions();
        this.expression = expr;
    }

    public void setPrecision(int milliseconds) {
        this.precision = milliseconds;
    }

    public void add(int id, JLDataView v) {
        this.dv[id] = v;
        this.dl[id] = v.getData();
    }

    protected double getMinTime() {
        double r = Double.MAX_VALUE;
        for (int i = 0; i < this.dl.length; ++i) {
            if (this.dl[i] == null || !(this.dl[i].x < r)) continue;
            r = this.dl[i].x;
        }
        return r;
    }

    protected void initialize() {
        if (this.x) {
            this.parser.addVariable("x", Double.NaN);
        } else {
            for (int i = 0; i < this.dv.length; ++i) {
                this.parser.addVariable("x" + (i + 1), Double.NaN);
            }
        }
    }

    protected double[] getNextValues() {
        double t0 = this.getMinTime();
        if (t0 == Double.MAX_VALUE) {
            return null;
        }
        double[] result = new double[2];
        result[0] = t0;
        if (this.x) {
            if (this.dl[0] != null && this.dl[0].x >= t0 - (double)this.precision && this.dl[0].x <= t0 + (double)this.precision) {
                this.parser.removeVariable("x");
                this.parser.addVariable("x", this.dl[0].y);
                this.dl[0] = this.dl[0].next;
            }
        } else {
            for (int i = 0; i < this.dl.length; ++i) {
                if (this.dl[i] == null || !(this.dl[i].x >= t0 - (double)this.precision) || !(this.dl[i].x <= t0 + (double)this.precision)) continue;
                this.parser.removeVariable("x" + (i + 1));
                this.parser.addVariable("x" + (i + 1), this.dl[i].y);
                this.dl[i] = this.dl[i].next;
            }
        }
        this.parser.parseExpression(this.expression);
        result[1] = this.parser.getValue();
        return result;
    }

    public JLDataView buildDataView(JLDataView initDv) {
        this.initialize();
        JLDataView dataView = initDv;
        if (initDv == null) {
            dataView = new JLDataView();
            dataView.setName(this.expression);
        }
        double[] nextValues = this.getNextValues();
        while (nextValues != null) {
            dataView.add(nextValues[0], nextValues[1]);
            nextValues = this.getNextValues();
        }
        return dataView;
    }

    public void clean() {
        if (this.dv != null) {
            for (int i = 0; i < this.dv.length; ++i) {
                this.dv[i] = null;
                this.dl[i] = null;
            }
            this.dv = null;
            this.dl = null;
        }
        this.parser = null;
        this.expression = null;
    }

    public boolean isX() {
        return this.x;
    }

    public void setX(boolean x) {
        this.x = x;
    }
}

