/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.examples;

import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChartExample4
extends JFrame
implements IJLChartListener {
    final JLDataView yData;

    public ChartExample4() {
        final JLChart chart = new JLChart();
        int nbValue = 50;
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setHeader("Spectrum Monitoring");
        chart.setJLChartListener(this);
        chart.getY1Axis().setName("dB");
        chart.getY1Axis().setAutoScale(true);
        chart.getXAxis().setAutoScale(true);
        chart.getXAxis().setName("Frequency (Hz)");
        chart.getXAxis().setAnnotation(2);
        this.yData = new JLDataView();
        this.yData.setName("Amplitude");
        this.yData.setUnit("dB");
        this.yData.setColor(new Color(200, 0, 0));
        this.yData.setLineWidth(2);
        chart.getY1Axis().addDataView(this.yData);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    ChartExample4.this.yData.reset();
                    for (int i = 0; i < 50; ++i) {
                        double v = Math.PI * 2 * ((double)i / 20.0);
                        ChartExample4.this.yData.add((double)i * 50.0, Math.abs(Math.sin(v) * Math.exp(-((double)i) / 10.0) * (1.0 + Math.random() / 5.0)));
                    }
                    chart.repaint();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Graph options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)chart, "Center");
        this.getContentPane().add((Component)bot, "South");
        this.setSize(640, 480);
        this.setTitle("Chart Example 4");
        this.setVisible(true);
    }

    @Override
    public String[] clickOnChart(JLChartEvent e) {
        String[] ret = new String[]{"Frequency= " + e.getTransformedXValue() + " Hz", "Amplitude= " + e.getTransformedYValue() + " " + this.yData.getUnit()};
        return ret;
    }

    public static void main(String[] args) {
        ChartExample4 f = new ChartExample4();
    }
}

