/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.examples;

import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChartExample1
extends JFrame {
    public ChartExample1() {
        final JLChart chart = new JLChart();
        JLDataView[] v = new JLDataView[32];
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setHeader("BarChart");
        chart.setLabelVisible(false);
        chart.getY1Axis().setName("uSv");
        chart.getY1Axis().setAutoScale(true);
        chart.getY1Axis().setGridVisible(true);
        chart.getY1Axis().setSubGridVisible(false);
        chart.getXAxis().setAutoScale(false);
        chart.getXAxis().setMinimum(0.0);
        chart.getXAxis().setMaximum(33.0);
        chart.getXAxis().setAnnotation(2);
        chart.getXAxis().setName("Cells");
        chart.getXAxis().setGridVisible(false);
        chart.getXAxis().setSubGridVisible(false);
        JLDataView alarm = new JLDataView();
        alarm.setName("Alarm level");
        alarm.setUnit("uSv");
        alarm.setColor(Color.orange);
        alarm.setLineWidth(2);
        alarm.add(-1.0, 25.0);
        alarm.add(35.0, 25.0);
        chart.getY1Axis().addDataView(alarm);
        JLDataView fault = new JLDataView();
        fault.setName("Fault level");
        fault.setUnit("uSv");
        fault.setColor(Color.red);
        fault.setLineWidth(2);
        fault.add(-1.0, 45.0);
        fault.add(35.0, 45.0);
        chart.getY1Axis().addDataView(fault);
        for (int i = 0; i < 32; ++i) {
            v[i] = new JLDataView();
            v[i].setName("Cell " + Integer.toString(i + 1));
            v[i].setUnit("uSv");
            v[i].setColor(Color.black);
            v[i].setLineWidth(1);
            v[i].setBarWidth(16);
            v[i].setFillStyle(1);
            v[i].setViewType(1);
            double val = Math.random() * 50.0;
            v[i].add(i + 1, val);
            if (val > 45.0) {
                v[i].setFillColor(Color.red);
            } else if (val > 25.0) {
                v[i].setFillColor(Color.orange);
            } else {
                v[i].setFillColor(Color.green);
            }
            chart.getY1Axis().addDataView(v[i]);
        }
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Graph options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)chart, "Center");
        this.getContentPane().add((Component)bot, "South");
        this.setSize(640, 480);
        this.setTitle("Chart Example 1");
        this.setVisible(true);
    }

    public static void main(String[] args) {
        ChartExample1 f = new ChartExample1();
    }
}

