/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.ColorItem;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JLDataView
implements Serializable {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_DOT = 1;
    public static final int MARKER_BOX = 2;
    public static final int MARKER_TRIANGLE = 3;
    public static final int MARKER_DIAMOND = 4;
    public static final int MARKER_STAR = 5;
    public static final int MARKER_VERT_LINE = 6;
    public static final int MARKER_HORIZ_LINE = 7;
    public static final int MARKER_CROSS = 8;
    public static final int MARKER_CIRCLE = 9;
    public static final int MARKER_SQUARE = 10;
    public static final int STYLE_SOLID = 0;
    public static final int STYLE_DOT = 1;
    public static final int STYLE_DASH = 2;
    public static final int STYLE_LONG_DASH = 3;
    public static final int STYLE_DASH_DOT = 4;
    public static final int TYPE_LINE = 0;
    public static final int TYPE_BAR = 1;
    public static final int METHOD_FILL_FROM_TOP = 0;
    public static final int METHOD_FILL_FROM_ZERO = 1;
    public static final int METHOD_FILL_FROM_BOTTOM = 2;
    public static final int FILL_STYLE_NONE = 0;
    public static final int FILL_STYLE_SOLID = 1;
    public static final int FILL_STYLE_LARGE_RIGHT_HATCH = 2;
    public static final int FILL_STYLE_LARGE_LEFT_HATCH = 3;
    public static final int FILL_STYLE_LARGE_CROSS_HATCH = 4;
    public static final int FILL_STYLE_SMALL_RIGHT_HATCH = 5;
    public static final int FILL_STYLE_SMALL_LEFT_HATCH = 6;
    public static final int FILL_STYLE_SMALL_CROSS_HATCH = 7;
    public static final int FILL_STYLE_DOT_PATTERN_1 = 8;
    public static final int FILL_STYLE_DOT_PATTERN_2 = 9;
    public static final int FILL_STYLE_DOT_PATTERN_3 = 10;
    public static final double NAN_FOR_NULL = Double.longBitsToDouble(9218868487374504191L);
    public static final double NAN_FOR_POSITIVE_INFINITY = Double.longBitsToDouble(-1217159371947777L);
    public static final double NAN_FOR_NEGATIVE_INFINITY = Double.longBitsToDouble(-4503599626605057L);
    public static final int INTERPOLATE_NONE = 0;
    public static final int INTERPOLATE_LINEAR = 1;
    public static final int INTERPOLATE_COSINE = 2;
    public static final int INTERPOLATE_CUBIC = 3;
    public static final int INTERPOLATE_HERMITE = 4;
    public static final int SMOOTH_NONE = 0;
    public static final int SMOOTH_FLAT = 1;
    public static final int SMOOTH_TRIANGULAR = 2;
    public static final int SMOOTH_GAUSSIAN = 3;
    public static final int SMOOTH_EXT_NONE = 0;
    public static final int SMOOTH_EXT_FLAT = 1;
    public static final int SMOOTH_EXT_LINEAR = 2;
    public static final int MATH_NONE = 0;
    public static final int MATH_DERIVATIVE = 1;
    public static final int MATH_INTEGRAL = 2;
    public static final int MATH_FFT_MODULUS = 3;
    public static final int MATH_FFT_PHASE = 4;
    private JLAxis parentAxis = null;
    private Vector<ColorItem> barFillColor;
    private Color lineColor;
    private Color fillColor;
    private Color markerColor;
    private int lineStyle = 0;
    private int lineWidth = 1;
    private int markerType = 0;
    private int markerSize = 6;
    private int barWidth = 10;
    private int fillStyle = 0;
    private int fillMethod = 2;
    private int type = 0;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private double A2 = 0.0;
    private DataList theData = null;
    private DataList theFilteredData = null;
    private int dataLength = 0;
    private int filteredDataLength;
    private DataList theDataEnd = null;
    private DataList theFilteredDataEnd;
    private double max = -1.7976931348623157E308;
    private double min;
    private double maxXValue = -1.7976931348623157E308;
    private double minXValue;
    private String name = "";
    private String unit = "";
    private boolean clickable = true;
    private boolean labelVisible = true;
    private String userFormat = null;
    private Color labelColor = Color.BLACK;
    private int interpMethod = 0;
    private int interpStep = 10;
    private double interpTension = 0.0;
    private double interpBias = 0.0;
    private int smoothMethod = 0;
    private double[] smoothCoefs = null;
    private int smoothNeighbor = 3;
    private double smoothSigma = 0.5;
    private int smoothExtrapolation = 2;
    private int mathFunction = 0;
    private boolean drawOnNaN = false;
    private Vector<ChangeListener> listeners = null;
    private double samplingFreq = Double.NaN;
    private boolean removeAverage = false;
    protected boolean xDataSorted = true;

    public static String getHelpString() {
        return "-- Dataview settings --\n  Parameter name is preceded by the dataview name.\n\nlinecolor:r,g,b  Curve color\nlinewidth:width  Curve width\nlinestyle:style  Line style (0 Solid,1 Dot, 2 Dash, 3 Long Dash,...)\nfillcolor:r,g,b  Curve fill color\nfillmethod:m   Bar filling method (0 Top,1 Zero,2 Bottom)\nfillstyle:style  Curve filling style (0 No fill,1 Solid,...)\nviewtype:type   Type of plot (0 Line, 1 Bar)\nbarwidth:width   Bar width in pixel (0 autoscale)\nmarkercolor:r,g,b   Marker color\nmarkersize:size   Marker size\nmarkerstyle:style  Marker style (0 No marker,1 Dot,2 Box,...)\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nlabelvisible:true or false   Displays legend of this view\nclickable:true or false  Shows tooltip on mouse click\n";
    }

    public JLDataView() {
        this.barFillColor = new Vector();
        this.lineColor = Color.red;
        this.fillColor = Color.lightGray;
        this.markerColor = Color.red;
        this.min = Double.MAX_VALUE;
        this.minXValue = Double.MAX_VALUE;
    }

    public void setViewType(int s) {
        this.type = s;
        this.fireStateChange();
    }

    public int getViewType() {
        return this.type;
    }

    public void setFillStyle(int b) {
        this.fillStyle = b;
        this.fireStateChange();
    }

    public int getFillStyle() {
        return this.fillStyle;
    }

    public void setFillMethod(int m) {
        this.fillMethod = m;
        this.fireStateChange();
    }

    public int getFillMethod() {
        return this.fillMethod;
    }

    public void setFillColor(Color c) {
        this.fillColor = c;
        this.fireStateChange();
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setBarFillColorAt(int idx, Color fillColor) {
        ColorItem ci;
        boolean found = false;
        int i = 0;
        while (!found && i < this.barFillColor.size()) {
            ci = this.barFillColor.get(i);
            found = ci.idx == idx;
            if (found) continue;
            ++i;
        }
        if (found) {
            this.barFillColor.get((int)i).idx = idx;
            this.barFillColor.get((int)i).fillColor = fillColor;
        } else {
            ci = new ColorItem(idx, fillColor);
            this.barFillColor.add(ci);
        }
    }

    public Color getBarFillColorAt(int idx) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.barFillColor.size()) {
            ColorItem ci = this.barFillColor.get(i);
            found = ci.idx == idx;
            if (found) continue;
            ++i;
        }
        if (found) {
            return this.barFillColor.get((int)i).fillColor;
        }
        return null;
    }

    public void setBarFillColors(Vector<ColorItem> bfColors) {
        this.barFillColor = bfColors;
    }

    public Vector<ColorItem> getBarFillColors() {
        return this.barFillColor;
    }

    public void setColor(Color c) {
        this.lineColor = c;
        this.fireStateChange();
    }

    public Color getColor() {
        return this.lineColor;
    }

    public boolean isFill() {
        return this.fillStyle != 0;
    }

    public void setFill(boolean b) {
        if (!b) {
            this.setFillStyle(0);
        } else {
            this.setFillStyle(1);
        }
    }

    public void setClickable(boolean b) {
        this.clickable = b;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setLabelVisible(boolean b) {
        this.labelVisible = b;
        this.fireStateChange();
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
        this.fireStateChange();
    }

    public void setInterpolationMethod(int method) {
        this.interpMethod = method;
        this.commitChange();
        this.fireStateChange();
    }

    public int getInterpolationMethod() {
        return this.interpMethod;
    }

    public void setInterpolationStep(int step) {
        if (step < 2) {
            step = 2;
        }
        this.interpStep = step;
        this.updateFilters();
        this.fireStateChange();
    }

    public int getInterpolationStep() {
        return this.interpStep;
    }

    public void setHermiteTension(double tension) {
        if (tension < -1.0) {
            tension = -1.0;
        }
        if (tension > 1.0) {
            tension = 1.0;
        }
        this.interpTension = tension;
        this.updateFilters();
        this.fireStateChange();
    }

    public double getHermiteTension() {
        return this.interpTension;
    }

    public void setHermiteBias(double bias) {
        this.interpBias = bias;
        this.updateFilters();
        this.fireStateChange();
    }

    public double getHermiteBias() {
        return this.interpBias;
    }

    public void setSmoothingMethod(int method) {
        this.smoothMethod = method;
        this.updateSmoothCoefs();
        this.commitChange();
        this.fireStateChange();
    }

    public int getSmoothingMethod() {
        return this.smoothMethod;
    }

    public void setSmoothingNeighbors(int n) {
        this.smoothNeighbor = n / 2 * 2 + 1;
        if (this.smoothNeighbor < 3) {
            this.smoothNeighbor = 3;
        }
        this.updateSmoothCoefs();
        this.updateFilters();
        this.fireStateChange();
    }

    public int getSmoothingNeighbors() {
        return this.smoothNeighbor - 1;
    }

    public void setSmoothingGaussSigma(double sigma) {
        this.smoothSigma = sigma;
        this.updateSmoothCoefs();
        this.commitChange();
        this.fireStateChange();
    }

    public double getSmoothingGaussSigma() {
        return this.smoothSigma;
    }

    public void setSmoothingExtrapolation(int extMode) {
        this.smoothExtrapolation = extMode;
        this.updateFilters();
        this.fireStateChange();
    }

    public int getSmoothingExtrapolation() {
        return this.smoothExtrapolation;
    }

    public void setMathFunction(int function) {
        this.mathFunction = function;
        this.updateFilters();
        if (function == 0) {
            this.computeDataBounds();
        }
        this.fireStateChange();
    }

    public int getMathFunction() {
        return this.mathFunction;
    }

    public void setBarWidth(int w) {
        this.barWidth = w;
        this.fireStateChange();
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setMarkerColor(Color c) {
        this.markerColor = c;
        this.fireStateChange();
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public void setStyle(int c) {
        this.lineStyle = c;
        this.fireStateChange();
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int c) {
        this.markerSize = c;
        this.fireStateChange();
    }

    public int getStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int c) {
        this.lineWidth = c;
        this.fireStateChange();
    }

    public void setName(String s) {
        this.name = s;
        this.fireStateChange();
    }

    public String getName() {
        return this.name;
    }

    public void setUnit(String s) {
        this.unit = s;
        this.fireStateChange();
    }

    public String getUnit() {
        return this.unit;
    }

    public String getExtendedName() {
        String t = "";
        if (this.hasTransform()) {
            String r = this.name + " [";
            if (this.A0 != 0.0) {
                r = r + Double.toString(this.A0);
                t = " + ";
            }
            if (this.A1 != 0.0) {
                r = r + t + Double.toString(this.A1) + "*y";
                t = " + ";
            }
            if (this.A2 != 0.0) {
                r = r + t + Double.toString(this.A2) + "*y^2";
            }
            r = r + "]";
            return r;
        }
        return this.name;
    }

    public int getMarker() {
        return this.markerType;
    }

    public void setMarker(int m) {
        this.markerType = m;
        this.fireStateChange();
    }

    public void setDrawOnNaN(boolean drawOnNaN) {
        this.drawOnNaN = drawOnNaN;
    }

    public boolean isDrawOnNaN() {
        return this.drawOnNaN;
    }

    public double getA0() {
        return this.A0;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public void setA0(double d) {
        this.A0 = d;
        this.fireStateChange();
    }

    public void setA1(double d) {
        this.A1 = d;
        this.fireStateChange();
    }

    public void setA2(double d) {
        this.A2 = d;
        this.fireStateChange();
    }

    public boolean hasTransform() {
        return this.A0 != 0.0 || this.A1 != 1.0 || this.A2 != 0.0;
    }

    public boolean hasFilter() {
        return this.interpMethod != 0 || this.smoothMethod != 0 || this.mathFunction != 0;
    }

    public void setAxis(JLAxis a) {
        this.parentAxis = a;
    }

    public JLAxis getAxis() {
        return this.parentAxis;
    }

    public double getMinimum() {
        return this.min;
    }

    public double getMaximum() {
        return this.max;
    }

    public double getMinTime() {
        if (this.hasFilter()) {
            return this.minXValue;
        }
        if (this.theData != null) {
            return this.theData.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMinXValue() {
        if (this.isXDataSorted()) {
            return this.getMinTime();
        }
        return this.minXValue;
    }

    public double getPositiveMinXValue() {
        double mi = Double.MAX_VALUE;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.x > 0.0 && e.x < mi) {
                mi = e.x;
            }
            e = e.next;
        }
        return mi;
    }

    public double getPositiveMinTime() {
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        boolean found = false;
        while (e != null && !found) {
            found = e.x > 0.0;
            if (found) continue;
            e = e.next;
        }
        if (e != null) {
            return e.x;
        }
        return Double.MAX_VALUE;
    }

    public double getMaxXValue() {
        if (this.isXDataSorted()) {
            return this.getMaxTime();
        }
        return this.maxXValue;
    }

    public double getMaxTime() {
        if (this.hasFilter()) {
            return this.maxXValue;
        }
        if (this.theDataEnd != null) {
            return this.theDataEnd.x;
        }
        return -1.7976931348623157E308;
    }

    public int getDataLength() {
        if (this.hasFilter()) {
            return this.filteredDataLength;
        }
        return this.dataLength;
    }

    public DataList getData() {
        if (this.hasFilter()) {
            return this.theFilteredData;
        }
        return this.theData;
    }

    public void commitChange() {
        if (this.hasFilter()) {
            this.updateFilters();
        } else {
            this.computeDataBounds();
        }
    }

    public void add(double x, double y) {
        this.add(x, y, true);
    }

    public synchronized void add(double x, double y, boolean updateFilter) {
        if (Double.isInfinite(y)) {
            y = y > 0.0 ? NAN_FOR_POSITIVE_INFINITY : NAN_FOR_NEGATIVE_INFINITY;
        }
        DataList newData = new DataList(x, y);
        this.theDataEnd = this.theData == null ? (this.theData = newData) : (this.theDataEnd.next = newData);
        if (y < this.min) {
            this.min = y;
        }
        if (y > this.max) {
            this.max = y;
        }
        if (x < this.minXValue) {
            this.minXValue = x;
        }
        if (x > this.maxXValue) {
            this.maxXValue = x;
        }
        ++this.dataLength;
        if (updateFilter) {
            this.updateFilters();
        }
    }

    public void setData(double[] x, double[] y) {
        if (x.length != y.length) {
            System.out.println("Warning: Cannot set data, x vector and y vector have not the same length");
            return;
        }
        this.reset();
        for (int i = 0; i < x.length; ++i) {
            this.add(x[i], y[i], false);
        }
        this.updateFilters();
    }

    public void setUnorderedData(double[] x, double[] y) {
        if (x.length != y.length) {
            System.out.println("Warning: Cannot set data, x vector and y vector have not the same length");
            return;
        }
        double[] xOrd = new double[x.length];
        double[] yOrd = new double[y.length];
        System.arraycopy(x, 0, xOrd, 0, x.length);
        System.arraycopy(y, 0, yOrd, 0, y.length);
        JLDataView.mergeSort(xOrd, yOrd);
        this.setData(xOrd, yOrd);
    }

    public void add(Point2D.Double p) {
        this.add(p.x, p.y);
    }

    public synchronized int garbagePointTime(double garbageLimit) {
        boolean need_to_recompute_max = false;
        boolean need_to_recompute_min = false;
        boolean need_to_recompute_max_x_value = false;
        boolean need_to_recompute_min_x_value = false;
        boolean found = false;
        int nbr = 0;
        if (this.theData != null) {
            while (this.theData != null && !found) {
                found = this.theData.x > this.maxXValue - garbageLimit - 3000.0;
                if (found) continue;
                need_to_recompute_max = need_to_recompute_max || this.theData.y == this.max;
                need_to_recompute_min = need_to_recompute_min || this.theData.y == this.min;
                need_to_recompute_max_x_value = need_to_recompute_max_x_value || this.theData.x == this.maxXValue;
                need_to_recompute_min_x_value = need_to_recompute_min_x_value || this.theData.x == this.minXValue;
                DataList old = this.theData;
                this.theData = this.theData.next;
                old.next = null;
                old = null;
                --this.dataLength;
                ++nbr;
            }
        }
        if (this.theData == null) {
            this.reset();
        } else if (this.hasFilter()) {
            this.updateFilters();
        } else {
            need_to_recompute_min_x_value = need_to_recompute_min_x_value && !this.isXDataSorted();
            boolean bl = need_to_recompute_max_x_value = need_to_recompute_max_x_value && !this.isXDataSorted();
            if (need_to_recompute_max) {
                if (need_to_recompute_min || need_to_recompute_min_x_value || need_to_recompute_max_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMax();
                }
            } else if (need_to_recompute_min) {
                if (need_to_recompute_min_x_value || need_to_recompute_max_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMin();
                }
            } else if (need_to_recompute_max_x_value) {
                if (need_to_recompute_min_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMaxXValue();
                }
            } else if (need_to_recompute_min_x_value) {
                this.computeMinXValue();
            }
        }
        return nbr;
    }

    public synchronized void garbagePointLimit(int garbageLimit) {
        boolean need_to_recompute_max = false;
        boolean need_to_recompute_min = false;
        boolean need_to_recompute_max_x_value = false;
        boolean need_to_recompute_min_x_value = false;
        int nb = this.dataLength - garbageLimit;
        for (int i = 0; i < nb; ++i) {
            need_to_recompute_max = need_to_recompute_max || this.theData.y == this.max;
            need_to_recompute_min = need_to_recompute_min || this.theData.y == this.min;
            need_to_recompute_max_x_value = need_to_recompute_max_x_value || this.theData.x == this.maxXValue;
            need_to_recompute_min_x_value = need_to_recompute_min_x_value || this.theData.x == this.minXValue;
            DataList old = this.theData;
            this.theData = this.theData.next;
            old.next = null;
            --this.dataLength;
        }
        if (this.hasFilter()) {
            this.updateFilters();
        } else {
            need_to_recompute_min_x_value = need_to_recompute_min_x_value && !this.isXDataSorted();
            boolean bl = need_to_recompute_max_x_value = need_to_recompute_max_x_value && !this.isXDataSorted();
            if (need_to_recompute_max) {
                if (need_to_recompute_min || need_to_recompute_min_x_value || need_to_recompute_max_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMax();
                }
            } else if (need_to_recompute_min) {
                if (need_to_recompute_min_x_value || need_to_recompute_max_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMin();
                }
            } else if (need_to_recompute_max_x_value) {
                if (need_to_recompute_min_x_value) {
                    this.computeDataBounds();
                } else {
                    this.computeMaxXValue();
                }
            } else if (need_to_recompute_min_x_value) {
                this.computeMinXValue();
            }
        }
    }

    private void computeMin() {
        this.min = Double.MAX_VALUE;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.y < this.min) {
                this.min = e.y;
            }
            e = e.next;
        }
    }

    private void computeMax() {
        this.max = -1.7976931348623157E308;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.y > this.max) {
                this.max = e.y;
            }
            e = e.next;
        }
    }

    private void computeMinXValue() {
        this.minXValue = Double.MAX_VALUE;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.x < this.minXValue) {
                this.minXValue = e.x;
            }
            e = e.next;
        }
    }

    private void computeMaxXValue() {
        this.maxXValue = -1.7976931348623157E308;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.x > this.maxXValue) {
                this.maxXValue = e.x;
            }
            e = e.next;
        }
    }

    public void computeDataBounds() {
        this.minXValue = Double.MAX_VALUE;
        this.maxXValue = -1.7976931348623157E308;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.x < this.minXValue) {
                this.minXValue = e.x;
            }
            if (e.x > this.maxXValue) {
                this.maxXValue = e.x;
            }
            if (e.y < this.min) {
                this.min = e.y;
            }
            if (e.y > this.max) {
                this.max = e.y;
            }
            e = e.next;
        }
    }

    public double[] computeTransformedMinMax() {
        double[] ret = new double[2];
        double mi = Double.MAX_VALUE;
        double ma = -1.7976931348623157E308;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            double v = this.A0 + this.A1 * e.y + this.A2 * e.y * e.y;
            if (v < mi) {
                mi = v;
            }
            if (v > ma) {
                ma = v;
            }
            e = e.next;
        }
        if (mi == Double.MAX_VALUE) {
            mi = 0.0;
        }
        if (ma == -1.7976931348623157E308) {
            ma = 99.0;
        }
        ret[0] = mi;
        ret[1] = ma;
        return ret;
    }

    public double computePositiveMin() {
        double mi = Double.MAX_VALUE;
        DataList e = this.theData;
        if (this.hasFilter()) {
            e = this.theFilteredData;
        }
        while (e != null) {
            if (e.y > 0.0 && e.y < mi) {
                mi = e.y;
            }
            e = e.next;
        }
        return mi;
    }

    public double getTransformedValue(double x) {
        return this.A0 + this.A1 * x + this.A2 * x * x;
    }

    public DataList getLastValue() {
        if (!this.hasFilter()) {
            return this.theDataEnd;
        }
        return this.theFilteredDataEnd;
    }

    public DataList getLastValueRaw() {
        return this.theDataEnd;
    }

    public synchronized void reset() {
        this.theData = null;
        this.theDataEnd = null;
        this.dataLength = 0;
        this.barFillColor.clear();
        this.updateFilters();
        this.computeDataBounds();
    }

    public void applyConfiguration(String prefix, CfFileReader f) {
        Vector<String> p = f.getParam(prefix + "_linecolor");
        if (p != null) {
            this.setColor(OFormat.getColor(p));
        }
        if ((p = f.getParam(prefix + "_linewidth")) != null) {
            this.setLineWidth(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_linestyle")) != null) {
            this.setStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_fillcolor")) != null) {
            this.setFillColor(OFormat.getColor(p));
        }
        if ((p = f.getParam(prefix + "_fillmethod")) != null) {
            this.setFillMethod(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_fillstyle")) != null) {
            this.setFillStyle(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_viewtype")) != null) {
            this.setViewType(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_barwidth")) != null) {
            this.setBarWidth(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_markercolor")) != null) {
            this.setMarkerColor(OFormat.getColor(p));
        }
        if ((p = f.getParam(prefix + "_markersize")) != null) {
            this.setMarkerSize(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_markerstyle")) != null) {
            this.setMarker(OFormat.getInt(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_A0")) != null) {
            this.setA0(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_A1")) != null) {
            this.setA1(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_A2")) != null) {
            this.setA2(OFormat.getDouble(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_labelvisible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_clickable")) != null) {
            this.setClickable(OFormat.getBoolean(p.get(0).toString()));
        }
        if ((p = f.getParam(prefix + "_labelColor")) != null) {
            this.setLabelColor(OFormat.getColor(p));
        }
    }

    public String getConfiguration(String prefix) {
        String to_write = "";
        to_write = to_write + prefix + "_linecolor:" + OFormat.color(this.getColor()) + "\n";
        to_write = to_write + prefix + "_linewidth:" + this.getLineWidth() + "\n";
        to_write = to_write + prefix + "_linestyle:" + this.getStyle() + "\n";
        to_write = to_write + prefix + "_fillcolor:" + OFormat.color(this.getFillColor()) + "\n";
        to_write = to_write + prefix + "_fillmethod:" + this.getFillMethod() + "\n";
        to_write = to_write + prefix + "_fillstyle:" + this.getFillStyle() + "\n";
        to_write = to_write + prefix + "_viewtype:" + this.getViewType() + "\n";
        to_write = to_write + prefix + "_barwidth:" + this.getBarWidth() + "\n";
        to_write = to_write + prefix + "_markercolor:" + OFormat.color(this.getMarkerColor()) + "\n";
        to_write = to_write + prefix + "_markersize:" + this.getMarkerSize() + "\n";
        to_write = to_write + prefix + "_markerstyle:" + this.getMarker() + "\n";
        to_write = to_write + prefix + "_A0:" + this.getA0() + "\n";
        to_write = to_write + prefix + "_A1:" + this.getA1() + "\n";
        to_write = to_write + prefix + "_A2:" + this.getA2() + "\n";
        to_write = to_write + prefix + "_labelvisible:" + this.isLabelVisible() + "\n";
        to_write = to_write + prefix + "_clickable:" + this.isClickable() + "\n";
        to_write = to_write + prefix + "_labelColor:" + OFormat.color(this.getLabelColor()) + "\n";
        return to_write;
    }

    public double getYValueByIndex(int idx) {
        if (idx < 0 || idx >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList e = this.theData;
        for (int i = 0; e != null && i < idx; ++i) {
            e = e.next;
        }
        if (e != null) {
            return e.y;
        }
        return Double.NaN;
    }

    public double getXValueByIndex(int idx) {
        if (idx < 0 || idx >= this.getDataLength()) {
            return Double.NaN;
        }
        DataList e = this.theData;
        for (int i = 0; e != null && i < idx; ++i) {
            e = e.next;
        }
        if (e != null) {
            return e.x;
        }
        return Double.NaN;
    }

    public void setUserFormat(String format) {
        if (format != null && format.length() > 0) {
            this.userFormat = format;
        } else {
            StringBuffer errorBuffer = new StringBuffer();
            errorBuffer.append("JLDataView.setUserFormat(String format): ");
            errorBuffer.append(format);
            errorBuffer.append(" is not a valid format !");
            System.err.println(errorBuffer.toString());
            errorBuffer = null;
            this.userFormat = null;
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void clearChangeListener() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    private void fireStateChange() {
        if (this.listeners != null) {
            ChangeEvent evt = new ChangeEvent(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).stateChanged(evt);
            }
        }
    }

    public String getUserFormat() {
        return this.userFormat;
    }

    public String formatValue(double v) {
        if (Double.isNaN(v)) {
            long l = Double.doubleToRawLongBits(v);
            if (l == Double.doubleToRawLongBits(NAN_FOR_NULL)) {
                return "null";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_NEGATIVE_INFINITY)) {
                return "-Infinity";
            }
            if (l == Double.doubleToRawLongBits(NAN_FOR_POSITIVE_INFINITY)) {
                return "+Infinity";
            }
            return "NaN";
        }
        if (this.userFormat != null) {
            return ATKFormat.format(this.userFormat, v);
        }
        if (this.parentAxis == null) {
            return Double.toString(v);
        }
        return this.parentAxis.formatValue(v, 0.0);
    }

    public boolean isXDataSorted() {
        return this.xDataSorted;
    }

    public void setXDataSorted(boolean dataSorted) {
        if (this.xDataSorted && !dataSorted) {
            this.computeDataBounds();
        }
        this.xDataSorted = dataSorted;
    }

    public synchronized double[] getSortedTimes() {
        double[] time = new double[this.dataLength];
        DataList currentData = this.theData;
        int i = 0;
        while (i < this.dataLength) {
            time[i] = currentData.x;
            currentData = currentData.next;
        }
        JLDataView.mergeSort(time, null);
        return time;
    }

    public synchronized double[] getSortedValues() {
        double[] value = new double[this.dataLength];
        DataList currentData = this.theData;
        int i = 0;
        while (i < this.dataLength) {
            value[i] = currentData.y;
            currentData = currentData.next;
        }
        JLDataView.mergeSort(value, null);
        return value;
    }

    public synchronized double[][] getDataSortedByTimes() {
        double[][] result = new double[2][this.dataLength];
        double[] time = new double[this.dataLength];
        double[] value = new double[this.dataLength];
        DataList currentData = this.theData;
        int i = 0;
        while (i < this.dataLength) {
            time[i] = currentData.x;
            value[i] = currentData.y;
            currentData = currentData.next;
        }
        JLDataView.mergeSort(time, value);
        result[0] = time;
        result[1] = value;
        return result;
    }

    public synchronized double[][] getDataSortedByValues() {
        double[][] result = new double[2][this.dataLength];
        double[] time = new double[this.dataLength];
        double[] value = new double[this.dataLength];
        DataList currentData = this.theData;
        int i = 0;
        while (i < this.dataLength) {
            time[i] = currentData.x;
            value[i] = currentData.y;
            currentData = currentData.next;
        }
        JLDataView.mergeSort(value, time);
        result[0] = time;
        result[1] = value;
        return result;
    }

    public void removeFromAxis() {
        JLAxis v = this.getAxis();
        if (v != null) {
            v.removeDataView(this);
        }
    }

    public static void mergeSort(double[] array, double[] associated) {
        int length = array.length;
        if (length > 0) {
            JLDataView.mergeSort(array, associated, 0, length - 1);
        }
    }

    private static void mergeSort(double[] array, double[] associated, int start, int end) {
        if (start != end) {
            int middle = (end + start) / 2;
            JLDataView.mergeSort(array, associated, start, middle);
            JLDataView.mergeSort(array, associated, middle + 1, end);
            JLDataView.merge(array, associated, start, middle, end);
        }
    }

    private static void merge(double[] array, double[] associated, int start1, int end1, int end2) {
        int deb2 = end1 + 1;
        double[] tempArray = new double[end1 - start1 + 1];
        double[] tempAsso = associated == null ? null : new double[end1 - start1 + 1];
        for (int i = start1; i <= end1; ++i) {
            tempArray[i - start1] = array[i];
            if (associated == null) continue;
            tempAsso[i - start1] = associated[i];
        }
        int index1 = start1;
        int index2 = deb2;
        for (int i = start1; i <= end2 && index1 != deb2; ++i) {
            if (index2 == end2 + 1) {
                array[i] = tempArray[index1 - start1];
                if (associated != null) {
                    associated[i] = tempAsso[index1 - start1];
                }
                ++index1;
                continue;
            }
            if (tempArray[index1 - start1] < array[index2]) {
                array[i] = tempArray[index1 - start1];
                if (associated != null) {
                    associated[i] = tempAsso[index1 - start1];
                }
                ++index1;
                continue;
            }
            array[i] = array[index2];
            if (associated != null) {
                associated[i] = associated[index2];
            }
            ++index2;
        }
    }

    private Point2D.Double[] getSource(DataList src, int nbExtra, boolean interpNan) {
        DataList f = src;
        Vector<Point2D.Double> pts = new Vector<Point2D.Double>();
        Point2D.Double lastValue = new Point2D.Double(Double.NaN, Double.NaN);
        Point2D.Double nextValue = new Point2D.Double(Double.NaN, Double.NaN);
        while (f != null) {
            if (!Double.isNaN(f.y)) {
                pts.add(new Point2D.Double(f.x, f.y));
            } else if (interpNan && !Double.isNaN(lastValue.y)) {
                if (f.next != null && !Double.isNaN(f.next.y)) {
                    nextValue.x = f.next.x;
                    nextValue.y = f.next.y;
                    pts.add(this.LinearInterpolate(lastValue, nextValue, 0.5));
                } else {
                    pts.add(new Point2D.Double(f.x, lastValue.y));
                }
            }
            lastValue.x = f.x;
            lastValue.y = f.y;
            f = f.next;
        }
        Point2D.Double[] ret = new Point2D.Double[pts.size() + 2 * nbExtra];
        for (int i = 0; i < pts.size(); ++i) {
            ret[i + nbExtra] = (Point2D.Double)pts.get(i);
        }
        return ret;
    }

    private void mathop() {
        if (this.mathFunction == 0) {
            return;
        }
        Point2D.Double[] source = this.interpMethod == 0 ? this.getSource(this.theData, 0, false) : this.getSource(this.theFilteredData, 0, false);
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        switch (this.mathFunction) {
            case 1: {
                for (int i = 0; i < source.length - 1; ++i) {
                    double d = (source[i + 1].y - source[i].y) / (source[i + 1].x - source[i].x);
                    this.addInt(source[i].x, d);
                }
                break;
            }
            case 2: {
                double sum = 0.0;
                this.addInt(source[0].x, sum);
                for (int i = 0; i < source.length - 1; ++i) {
                    this.addInt(source[i + 1].x, sum += (source[i + 1].y + source[i].y) / 2.0 * (source[i + 1].x - source[i].x));
                }
                break;
            }
            case 3: {
                this.doFFT(source, 0);
                break;
            }
            case 4: {
                this.doFFT(source, 1);
            }
        }
    }

    private int reverse(int idx, int p) {
        int rev = 0;
        for (int i = 0; i < p; ++i) {
            rev = rev << 1 | idx & 1;
            idx >>= 1;
        }
        return rev;
    }

    public void setRemoveAverage(boolean remove) {
        this.removeAverage = remove;
    }

    public boolean getRemoveAverage() {
        return this.removeAverage;
    }

    public void setSamplingFrequency(double f) {
        this.samplingFreq = f;
    }

    public double getSamplingFrequency() {
        return this.samplingFreq;
    }

    private void doFFT(Point2D.Double[] in, int mode) {
        int idx;
        int i;
        int nbSample = in.length;
        if (nbSample < 2) {
            return;
        }
        int p = 0;
        p = (nbSample & nbSample - 1) == 0 ? -1 : 0;
        while (nbSample != 0) {
            nbSample >>= 1;
            ++p;
        }
        nbSample = 1 << p;
        double avg = 0.0;
        double avgr = 0.0;
        for (i = 0; i < in.length; ++i) {
            avg += in[i].y;
        }
        avg /= (double)in.length;
        if (this.removeAverage) {
            avgr = avg;
        }
        double[] real = new double[nbSample];
        double[] imag = new double[nbSample];
        for (i = 0; i < in.length; ++i) {
            idx = this.reverse(i, p);
            real[idx] = in[i].y - avgr;
            imag[idx] = 0.0;
        }
        while (i < nbSample) {
            idx = this.reverse(i, p);
            real[idx] = avg - avgr;
            imag[idx] = 0.0;
            ++i;
        }
        double fs = Double.isNaN(this.samplingFreq) ? 1.0 / (in[1].x - in[0].x) : this.samplingFreq;
        int blockEnd = 1;
        for (int blockSize = 2; blockSize <= nbSample; blockSize <<= 1) {
            double deltaAngle = Math.PI * 2 / (double)blockSize;
            double sm2 = Math.sin(-2.0 * deltaAngle);
            double sm1 = Math.sin(-deltaAngle);
            double cm2 = Math.cos(-2.0 * deltaAngle);
            double cm1 = Math.cos(-deltaAngle);
            double w = 2.0 * cm1;
            for (i = 0; i < nbSample; i += blockSize) {
                double ar2 = cm2;
                double ar1 = cm1;
                double ai2 = sm2;
                double ai1 = sm1;
                int j = i;
                for (int n = 0; n < blockEnd; ++n) {
                    double ar0 = w * ar1 - ar2;
                    ar2 = ar1;
                    ar1 = ar0;
                    double ai0 = w * ai1 - ai2;
                    ai2 = ai1;
                    ai1 = ai0;
                    int k = j + blockEnd;
                    double tr = ar0 * real[k] - ai0 * imag[k];
                    double ti = ar0 * imag[k] + ai0 * real[k];
                    real[k] = real[j] - tr;
                    imag[k] = imag[j] - ti;
                    int n2 = j;
                    real[n2] = real[n2] + tr;
                    int n3 = j++;
                    imag[n3] = imag[n3] + ti;
                }
            }
            blockEnd = blockSize;
        }
        double nS = nbSample;
        switch (mode) {
            case 0: {
                for (i = 0; i < nbSample / 2; ++i) {
                    double n = Math.sqrt(real[i] * real[i] + imag[i] * imag[i]);
                    this.addInt((double)i * fs / nS, n / nS);
                }
                break;
            }
            case 1: {
                for (i = 0; i < nbSample; ++i) {
                    double arg = Math.atan2(imag[i], real[i]);
                    this.addInt((double)i * fs / nS, arg);
                }
                break;
            }
        }
    }

    public void updateFilters() {
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        if (this.hasFilter()) {
            this.interpolate();
            this.mathop();
            this.convolution();
            this.computeDataBounds();
        }
    }

    private void updateSmoothCoefs() {
        int i;
        if (this.smoothMethod == 0) {
            this.smoothCoefs = null;
            return;
        }
        this.smoothCoefs = new double[this.smoothNeighbor];
        int nb = this.smoothNeighbor / 2;
        switch (this.smoothMethod) {
            case 1: {
                for (int i2 = 0; i2 < this.smoothNeighbor; ++i2) {
                    this.smoothCoefs[i2] = 1.0;
                }
                break;
            }
            case 2: {
                int i3;
                double l = 1.0 / ((double)nb + 1.0);
                for (i3 = 0; i3 < nb; ++i3) {
                    this.smoothCoefs[i3] = (double)(i3 - nb) * l + 1.0;
                }
                for (i3 = 1; i3 <= nb; ++i3) {
                    this.smoothCoefs[i3 + nb] = (double)(-i3) * l + 1.0;
                }
                this.smoothCoefs[nb] = 1.0;
                break;
            }
            case 3: {
                double A = 1.0 / (2.0 * Math.sqrt(Math.PI) * this.smoothSigma);
                double B = 1.0 / (2.0 * this.smoothSigma * this.smoothSigma);
                for (int i4 = 0; i4 < this.smoothNeighbor; ++i4) {
                    double x = i4 - nb;
                    this.smoothCoefs[i4] = A * Math.exp(-x * x * B);
                }
                break;
            }
        }
        double sum = 0.0;
        for (i = 0; i < this.smoothNeighbor; ++i) {
            sum += this.smoothCoefs[i];
        }
        for (i = 0; i < this.smoothNeighbor; ++i) {
            this.smoothCoefs[i] = this.smoothCoefs[i] / sum;
        }
    }

    private void convolution() {
        int i;
        int nbE;
        if (this.smoothMethod == 0) {
            return;
        }
        int nbG = this.smoothCoefs.length / 2;
        switch (this.smoothExtrapolation) {
            case 0: {
                nbE = 0;
                break;
            }
            default: {
                nbE = nbG;
            }
        }
        Point2D.Double[] source = this.interpMethod == 0 && this.mathFunction == 0 ? this.getSource(this.theData, nbE, true) : this.getSource(this.theFilteredData, nbE, true);
        int nbF = source.length - 2 * nbG;
        int start = nbG;
        int end = nbF + nbG - 1;
        if (nbF == nbE || start > end) {
            return;
        }
        switch (this.smoothExtrapolation) {
            case 2: {
                int maxPts = 3;
                Point2D.Double vect = new Point2D.Double();
                int nb = 0;
                vect.x = 0.0;
                vect.y = 0.0;
                for (i = start; i < maxPts + start && i < nbF + start - 1; ++i) {
                    vect.x += source[i].x - source[i + 1].x;
                    vect.y += source[i].y - source[i + 1].y;
                    ++nb;
                }
                if (nb == 0) {
                    vect.x = source[start].x - (double)nbE;
                    vect.y = source[start].y;
                } else {
                    vect.x = vect.x / (double)nb * (double)nbE + source[start].x;
                    vect.y = vect.y / (double)nb * (double)nbE + source[start].y;
                }
                for (i = 0; i < nbE; ++i) {
                    source[i] = this.LinearInterpolate(vect, source[start], (double)i / (double)nbE);
                }
                nb = 0;
                vect.x = 0.0;
                vect.y = 0.0;
                for (i = end - maxPts; i < end; ++i) {
                    if (i < start) continue;
                    vect.x += source[i + 1].x - source[i].x;
                    vect.y += source[i + 1].y - source[i].y;
                    ++nb;
                }
                if (nb == 0) {
                    vect.x = source[end].x + (double)nbE;
                    vect.y = source[end].y;
                } else {
                    vect.x = vect.x / (double)nb * (double)nbE + source[end].x;
                    vect.y = vect.y / (double)nb * (double)nbE + source[end].y;
                }
                for (i = 1; i <= nbE; ++i) {
                    source[end + i] = this.LinearInterpolate(source[end], vect, (double)i / (double)nbE);
                }
                break;
            }
            case 1: {
                for (i = 0; i < nbE; ++i) {
                    source[i] = new Point2D.Double(source[start].x - (double)nbE + (double)i, source[start].y);
                    source[i + end + 1] = new Point2D.Double(source[end].x + (double)i + 1.0, source[end].y);
                }
                break;
            }
        }
        this.theFilteredData = null;
        this.theFilteredDataEnd = null;
        this.filteredDataLength = 0;
        for (i = start; i <= end; ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.smoothCoefs.length; ++j) {
                sum += this.smoothCoefs[j] * source[i + j - nbG].y;
            }
            this.addInt(source[i].x, sum);
        }
    }

    private void addInt(Point2D.Double p) {
        this.addInt(p.x, p.y);
    }

    private void addInt(double x, double y) {
        DataList newData = new DataList(x, y);
        if (this.theFilteredData == null) {
            this.theFilteredData = newData;
        } else {
            this.theFilteredDataEnd.next = newData;
        }
        this.theFilteredDataEnd = newData;
        ++this.filteredDataLength;
    }

    private Point2D.Double[] getSegments(DataList l) {
        int nb = 0;
        DataList head = l;
        while (l != null && !Double.isNaN(l.y)) {
            ++nb;
            l = l.next;
        }
        l = head;
        Point2D.Double[] ret = new Point2D.Double[nb];
        for (int i = 0; i < nb; ++i) {
            ret[i] = new Point2D.Double(l.x, l.y);
            l = l.next;
        }
        return ret;
    }

    private Point2D.Double LinearInterpolate(Point2D.Double p1, Point2D.Double p2, double t) {
        return new Point2D.Double(p1.x + (p2.x - p1.x) * t, p1.y + (p2.y - p1.y) * t);
    }

    private Point2D.Double CosineInterpolate(Point2D.Double p1, Point2D.Double p2, double t) {
        double t2 = (1.0 - Math.cos(t * Math.PI)) / 2.0;
        return new Point2D.Double(p1.x + (p2.x - p1.x) * t, p1.y * (1.0 - t2) + p2.y * t2);
    }

    private Point2D.Double CubicInterpolate(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double ay3 = p3.y - p2.y - p0.y + p1.y;
        double ay2 = p0.y - p1.y - ay3;
        double ay1 = p2.y - p0.y;
        double ay0 = p1.y;
        return new Point2D.Double(p1.x + (p2.x - p1.x) * t, ay3 * t3 + ay2 * t2 + ay1 * t + ay0);
    }

    private Point2D.Double HermiteInterpolate(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double mu, double tension, double bias) {
        double t = (1.0 - tension) / 2.0;
        double mu2 = mu * mu;
        double mu3 = mu2 * mu;
        double a0 = 2.0 * mu3 - 3.0 * mu2 + 1.0;
        double a1 = mu3 - 2.0 * mu2 + mu;
        double a2 = mu3 - mu2;
        double a3 = -2.0 * mu3 + 3.0 * mu2;
        double xm0 = (p1.x - p0.x) * (1.0 + bias) * t;
        double xm1 = (p2.x - p1.x) * (1.0 + bias) * t;
        double ym0 = (p1.y - p0.y) * (1.0 + bias) * t;
        double ym1 = (p2.y - p1.y) * (1.0 + bias) * t;
        return new Point2D.Double(a0 * p1.x + a1 * (xm0 += (p2.x - p1.x) * (1.0 - bias) * t) + a2 * (xm1 += (p3.x - p2.x) * (1.0 - bias) * t) + a3 * p2.x, a0 * p1.y + a1 * (ym0 += (p2.y - p1.y) * (1.0 - bias) * t) + a2 * (ym1 += (p3.y - p2.y) * (1.0 - bias) * t) + a3 * p2.y);
    }

    private void interpolate() {
        if (this.interpMethod == 0) {
            return;
        }
        double dt = 1.0 / (double)this.interpStep;
        DataList l = this.theData;
        while (l != null) {
            int i;
            Point2D.Double[] pts = this.getSegments(l);
            int nbPts = pts.length;
            int method = this.interpMethod;
            if (nbPts == 0) {
                method = 0;
                this.addInt(new Point2D.Double(l.x, l.y));
                l = l.next;
            } else if (nbPts == 1) {
                method = 0;
                this.addInt(pts[0]);
            } else if (nbPts == 2) {
                method = 1;
            }
            switch (method) {
                case 1: {
                    double t;
                    int j;
                    for (i = 0; i < nbPts - 2; ++i) {
                        for (j = 0; j < this.interpStep; ++j) {
                            t = (double)j * dt;
                            this.addInt(this.LinearInterpolate(pts[i], pts[i + 1], t));
                        }
                    }
                    for (j = 0; j <= this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.LinearInterpolate(pts[i], pts[i + 1], t));
                    }
                    break;
                }
                case 2: {
                    double t;
                    int j;
                    for (i = 0; i < nbPts - 2; ++i) {
                        for (j = 0; j < this.interpStep; ++j) {
                            t = (double)j * dt;
                            this.addInt(this.CosineInterpolate(pts[i], pts[i + 1], t));
                        }
                    }
                    for (j = 0; j <= this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.LinearInterpolate(pts[i], pts[i + 1], t));
                    }
                    break;
                }
                case 3: {
                    double t;
                    int j;
                    Point2D.Double fP = new Point2D.Double(2.0 * pts[0].x - pts[1].x, 2.0 * pts[0].y - pts[1].y);
                    for (j = 0; j < this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.CubicInterpolate(fP, pts[0], pts[1], pts[2], t));
                    }
                    for (i = 1; i < nbPts - 2; ++i) {
                        for (j = 0; j < this.interpStep; ++j) {
                            t = (double)j * dt;
                            this.addInt(this.CubicInterpolate(pts[i - 1], pts[i], pts[i + 1], pts[i + 2], t));
                        }
                    }
                    Point2D.Double lP = new Point2D.Double(2.0 * pts[i + 1].x - pts[i].x, 2.0 * pts[i + 1].y - pts[i].y);
                    for (j = 0; j <= this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.CubicInterpolate(pts[i - 1], pts[i], pts[i + 1], lP, t));
                    }
                    break;
                }
                case 4: {
                    double t;
                    int j;
                    Point2D.Double fP = new Point2D.Double(2.0 * pts[0].x - pts[1].x, 2.0 * pts[0].y - pts[1].y);
                    for (j = 0; j < this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.HermiteInterpolate(fP, pts[0], pts[1], pts[2], t, this.interpTension, this.interpBias));
                    }
                    for (i = 1; i < nbPts - 2; ++i) {
                        for (j = 0; j < this.interpStep; ++j) {
                            t = (double)j * dt;
                            this.addInt(this.HermiteInterpolate(pts[i - 1], pts[i], pts[i + 1], pts[i + 2], t, this.interpTension, this.interpBias));
                        }
                    }
                    Point2D.Double lP = new Point2D.Double(2.0 * pts[i + 1].x - pts[i].x, 2.0 * pts[i + 1].y - pts[i].y);
                    for (j = 0; j <= this.interpStep; ++j) {
                        t = (double)j * dt;
                        this.addInt(this.HermiteInterpolate(pts[i - 1], pts[i], pts[i + 1], lP, t, this.interpTension, this.interpBias));
                    }
                    break;
                }
            }
            for (i = 0; i < nbPts; ++i) {
                l = l.next;
            }
        }
    }
}

