/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.LabelRect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class AdvancedJLChart
extends JLChart {
    public static final int MENU_DATALOAD = 6;
    public static final int MENU_RESET = 7;
    protected JPopupMenu dataViewMenu;
    protected JMenuItem removeDataViewMenuItem;
    protected JMenuItem dataViewOptionItem;
    protected JMenuItem loadFileMenuItem = new JMenuItem("Load data File");
    protected JMenuItem resetMenuItem;

    public AdvancedJLChart() {
        this.loadFileMenuItem.addActionListener(this);
        this.resetMenuItem = new JMenuItem("Reset Chart");
        this.resetMenuItem.addActionListener(this);
        this.chartMenu.add(this.loadFileMenuItem);
        this.chartMenu.add(this.resetMenuItem);
    }

    @Override
    public void removeMenuItem(int menu) {
        switch (menu) {
            case 6: {
                this.chartMenu.remove(this.loadFileMenuItem);
                break;
            }
            case 7: {
                this.chartMenu.remove(this.resetMenuItem);
                break;
            }
            default: {
                super.removeMenuItem(menu);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.loadFileMenuItem) {
            File f;
            JFileChooser chooser = new JFileChooser(this.lastDataFileLocation);
            chooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
            chooser.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0 && (f = chooser.getSelectedFile()) != null) {
                this.loadDataFile(f.getAbsolutePath());
                this.lastDataFileLocation = f.getParentFile().getAbsolutePath();
            }
        } else if (evt.getSource() == this.resetMenuItem) {
            this.reset();
            this.repaint();
        } else {
            super.actionPerformed(evt);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean displayDataViewMenu = false;
        if (e.getButton() == 3) {
            for (int i = 0; i < this.labelRect.size(); ++i) {
                LabelRect r = (LabelRect)this.labelRect.get(i);
                if (!r.rect.contains(e.getX(), e.getY())) continue;
                displayDataViewMenu = this.prepareDataViewMenu(r.view);
                break;
            }
        }
        if (displayDataViewMenu) {
            this.dataViewMenu.show(this, e.getX(), e.getY());
        } else {
            super.mousePressed(e);
        }
    }

    protected boolean prepareDataViewMenu(JLDataView dataView) {
        int j;
        if (this.dataViewMenu == null) {
            this.dataViewMenu = new JPopupMenu();
            this.removeDataViewMenuItem = new JMenuItem("Remove");
            this.dataViewOptionItem = new JMenuItem("Options");
            this.dataViewMenu.add(this.removeDataViewMenuItem);
            this.dataViewMenu.add(this.dataViewOptionItem);
        }
        final JLDataView theView = dataView;
        this.removeDataViewMenuItem.setText("Remove : " + dataView.getName());
        ActionListener[] listeners = this.removeDataViewMenuItem.getActionListeners();
        for (j = 0; j < listeners.length; ++j) {
            this.removeDataViewMenuItem.removeActionListener(listeners[j]);
        }
        this.removeDataViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedJLChart.this.removeDataView(theView);
                AdvancedJLChart.this.repaint();
            }
        });
        this.dataViewOptionItem.setText("Options : " + dataView.getName());
        listeners = this.dataViewOptionItem.getActionListeners();
        for (j = 0; j < listeners.length; ++j) {
            this.dataViewOptionItem.removeActionListener(listeners[j]);
        }
        this.dataViewOptionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedJLChart.this.showDataOptionDialog(theView);
            }
        });
        return true;
    }

    public static void main(String[] args) {
        String fileName;
        JFrame f = new JFrame();
        final AdvancedJLChart chart = new AdvancedJLChart();
        chart.setHeaderFont(new Font("Times", 1, 18));
        chart.setLabelFont(new Font("Times", 1, 12));
        chart.setHeader("Test DataView");
        if (args.length > 0) {
            fileName = args[0];
        } else {
            JFileChooser chooser = new JFileChooser(".");
            chooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = null;
                    String s = f.getName();
                    int i = s.lastIndexOf(46);
                    if (i > 0 && i < s.length() - 1) {
                        extension = s.substring(i + 1).toLowerCase();
                    }
                    return extension != null && extension.equals("txt");
                }

                @Override
                public String getDescription() {
                    return "text files ";
                }
            });
            chooser.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                File file = chooser.getSelectedFile();
                fileName = file.getAbsolutePath();
            } else {
                fileName = "";
                System.exit(0);
            }
        }
        chart.reset(false);
        chart.loadDataFile(fileName);
        JPanel bot = new JPanel();
        bot.setLayout(new FlowLayout());
        JButton b = new JButton("Exit");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        bot.add(b);
        JButton c = new JButton("Options");
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                chart.showOptionDialog();
            }
        });
        bot.add(c);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)chart, "Center");
        f.getContentPane().add((Component)bot, "South");
        f.setSize(400, 300);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

