/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.IWheelSwitchListener;
import fr.esrf.tangoatk.widget.util.JArrowButton;
import fr.esrf.tangoatk.widget.util.WheelSwitchEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

public class WheelSwitch
extends JComponent {
    private static Font defaultFont = new Font("Lucida Bright", 0, 16);
    private static Color defaultBackground = new Color(200, 200, 200);
    private static Color defaultSelectionColor = new Color(156, 154, 206);
    private int off_x;
    private int off_y;
    private int intNumber;
    private int fracNumber;
    private int expNumber;
    private double value;
    private double maxValue;
    private double minValue;
    private Dimension dz;
    private boolean editMode;
    private String editValue;
    private EventListenerList listenerList;
    private String format = "%5.2f";
    private boolean editable;
    private char decimalSeparator = (char)46;
    private double minimumIncrement = 0.0;
    private JArrowButton[] buttons_up;
    private JArrowButton[] buttons_down;
    private int nbButton = 0;
    private int selButton = 0;
    private Color buttonBackground;
    private Color selectionColor;
    private Color textBackground;
    private String valueFormatted = null;
    private int totalWidth;
    private int totalHeight;

    public WheelSwitch() {
        this(true);
    }

    public WheelSwitch(boolean editable) {
        this.setLayout(null);
        this.setForeground(Color.black);
        this.setBackground(defaultBackground);
        this.setBorder(null);
        this.setFont(defaultFont);
        this.buttonBackground = this.getBackground();
        this.textBackground = null;
        this.selectionColor = defaultSelectionColor;
        this.setOpaque(true);
        this.editable = editable;
        this.setPrecision(3, 2, 0);
        this.value = 0.0;
        this.editMode = false;
        this.editValue = "";
        this.listenerList = new EventListenerList();
        if (editable) {
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    WheelSwitch.this.processKey(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WheelSwitch.this.grabFocus();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    WheelSwitch.this.updateButtonFocus();
                    WheelSwitch.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    WheelSwitch.this.updateButtonFocus();
                    WheelSwitch.this.repaint();
                }
            });
        }
    }

    public void setMinimumIncrement(double inc) {
        this.minimumIncrement = inc;
    }

    public double getMinimumIncrement() {
        return this.minimumIncrement;
    }

    public void setTextBackground(Color c) {
        this.textBackground = c;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets borderSize = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
        this.computeDigitSize();
        int w = this.expNumber > 0 ? this.dz.width * (this.intNumber + this.fracNumber + this.expNumber + 4) : (this.fracNumber > 0 ? this.dz.width * (this.intNumber + this.fracNumber + 2) : this.dz.width * (this.intNumber + this.fracNumber + 1));
        int h = this.editable ? this.dz.width * 2 + this.dz.height : this.dz.height;
        return new Dimension(w + borderSize.right + borderSize.left, h + borderSize.top + borderSize.bottom);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setValue(double v) {
        double dval1 = 0.0;
        double dval2 = 0.0;
        this.value = v;
        if (!Double.isNaN(v) && !Double.isInfinite(v)) {
            if (this.format.indexOf(101) > 0) {
                dval1 = this.getFloatPart();
                dval2 = this.getExpPart();
            } else {
                dval1 = this.value;
            }
            double newValue = this.near(dval1) * Math.pow(10.0, dval2);
            Double tempDouble = new Double(Double.NaN);
            try {
                if (this.isGoodFormat()) {
                    String valFormated = ATKFormat.format(this.format, newValue);
                    tempDouble = !this.isHexFormat(this.format) ? Double.valueOf(valFormated) : Double.valueOf(Integer.parseInt(valFormated, 16));
                } else {
                    tempDouble = new Double(newValue);
                }
            }
            catch (Exception e) {
                tempDouble = new Double(Double.NaN);
            }
            this.value = !tempDouble.equals(new Double(Double.NaN)) ? tempDouble : newValue;
        }
        this.updateButtonVisibility();
        this.repaint();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.dz = null;
        this.computeDigitSize();
        if (this.isVisible()) {
            this.placeComponents(this.getSize());
        }
    }

    public boolean isGoodFormat() {
        if (this.format.indexOf("%") == 0 && this.format.lastIndexOf("%") == this.format.indexOf("%")) {
            if (this.format.indexOf(".") == -1) {
                try {
                    int x = Integer.parseInt(this.format.substring(1, this.format.length() - 1));
                    return x > 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.format.indexOf(".") == this.format.lastIndexOf(".")) {
                if (this.format.toLowerCase().indexOf("f") == this.format.length() - 1 && this.format.toLowerCase().indexOf("f") > 0 || this.format.toLowerCase().indexOf("e") == this.format.length() - 1 && this.format.toLowerCase().indexOf("e") > 0) {
                    try {
                        int x = Integer.parseInt(this.format.substring(1, this.format.indexOf(".")));
                        int y = Integer.parseInt(this.format.substring(this.format.indexOf(".") + 1, this.format.length() - 1));
                        return x > y && x > 0 && y >= 0;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public Dimension getDigitSize() {
        return this.dz;
    }

    public void setButtonColor(Color c) {
        if (!this.editable) {
            return;
        }
        this.buttonBackground = c;
        for (int i = 0; i < this.nbButton; ++i) {
            this.buttons_up[i].setBackground(this.buttonBackground);
            this.buttons_down[i].setBackground(this.buttonBackground);
        }
    }

    public Color getButtonColor() {
        return this.buttonBackground;
    }

    public void setSelButtonColor(Color c) {
        this.selectionColor = c;
    }

    public Color getSelButtonColor() {
        return this.selectionColor;
    }

    public void setMaxValue(double max) {
        if (this.format.indexOf(101) == -1) {
            this.maxValue = max;
            this.updateButtonVisibility();
        }
    }

    @Override
    public void setEnabled(boolean arg0) {
        int i;
        super.setEnabled(arg0);
        if (this.buttons_up == null || this.buttons_down == null) {
            return;
        }
        for (i = 0; i < this.buttons_up.length; ++i) {
            this.buttons_up[i].setEnabled(arg0);
        }
        for (i = 0; i < this.buttons_down.length; ++i) {
            this.buttons_down[i].setEnabled(arg0);
        }
    }

    public void setMinValue(double min) {
        if (this.format.indexOf(101) == -1) {
            this.minValue = min;
            this.updateButtonVisibility();
        }
    }

    public void setFormat(String aformat) {
        this.setFormat(aformat, null);
    }

    public void setFormat(String aformat, String attName) {
        String oldFormat = this.format;
        double oldValue = this.value;
        String errStr = attName == null ? "WheelSwitch: Invalid format \"" + aformat + "\"" : "WheelSwitch: Invalid format \"" + aformat + "\" for " + attName;
        errStr = errStr + ": use %x.yf, %x.yF, %x.ye, %x.yE, %xd or %xD or %xX";
        int pIdx = aformat.indexOf("%");
        if (pIdx < 0) {
            System.out.println(errStr);
            System.out.println("==> WheelSwitch: format used instead: " + this.format);
            return;
        }
        if ((aformat = aformat.substring(pIdx, aformat.length())).equalsIgnoreCase("%d")) {
            aformat = "%5d";
        }
        if (aformat.equals("%x")) {
            aformat = "%4x";
        }
        if (aformat.equals("%X")) {
            aformat = "%4X";
        }
        this.format = aformat;
        if (!this.isGoodFormat()) {
            System.out.println(errStr);
            this.format = oldFormat;
            System.out.println("==> WheelSwitch: format used instead: " + this.format);
            return;
        }
        if (!this.isHexFormat(this.format)) {
            this.format = this.format.toLowerCase();
        }
        String f = this.format.replace('.', '_');
        f = f.replace('%', '0');
        f = f.substring(0, f.length() - 1);
        String[] s = f.split("_");
        try {
            if (s.length == 2) {
                int a = Integer.parseInt(s[0]);
                int b = Integer.parseInt(s[1]);
                if (this.format.indexOf(101) != -1) {
                    String temp = ATKFormat.format(this.format, this.value);
                    if (temp != null) {
                        this.reformat(temp, a - b, b);
                    } else {
                        System.out.println(errStr);
                        this.format = oldFormat;
                        this.value = oldValue;
                    }
                } else {
                    this.setPrecision(a - b, b, 0);
                }
            } else if (s.length == 1) {
                int a = Integer.parseInt(s[0]);
                this.setPrecision(a, 0, 0);
            }
        }
        catch (NumberFormatException n) {
            System.out.println(errStr);
            this.format = oldFormat;
            this.value = oldValue;
        }
    }

    private void reformat(String valFormated, int integerPart, int decimalPart) {
        String valueFormated = valFormated.toLowerCase();
        int e = valueFormated.indexOf(101);
        int plus = valueFormated.lastIndexOf(43);
        int moins = valueFormated.lastIndexOf(45);
        if (plus > e) {
            e = plus;
        } else if (moins > e) {
            e = moins;
        }
        valueFormated = valueFormated.substring(e + 1, valueFormated.length());
        this.setPrecision(integerPart, decimalPart, valueFormated.length());
    }

    public synchronized void setPrecision(int inb, int fnb, int enb) {
        int i;
        int nb = this.nbButton;
        this.nbButton = 0;
        if (this.editable) {
            for (i = 0; i < nb; ++i) {
                this.remove(this.buttons_up[i]);
                this.remove(this.buttons_down[i]);
                this.buttons_up[i] = null;
                this.buttons_down[i] = null;
            }
        }
        this.intNumber = inb;
        if (this.intNumber < 1) {
            this.intNumber = 1;
        }
        this.fracNumber = fnb;
        if (this.fracNumber < 0) {
            this.fracNumber = 0;
        }
        this.expNumber = enb;
        if (this.expNumber < 0) {
            this.expNumber = 0;
        }
        nb = this.intNumber + this.fracNumber + this.expNumber;
        if (this.editable) {
            this.buttons_up = new JArrowButton[nb];
            this.buttons_down = new JArrowButton[nb];
        }
        if (this.expNumber == 0) {
            if (!this.isHexFormat(this.format)) {
                this.maxValue = Math.pow(10.0, this.intNumber);
                this.minValue = -Math.pow(10.0, this.intNumber);
            } else {
                this.maxValue = Math.pow(16.0, this.intNumber);
                this.minValue = -Math.pow(16.0, this.intNumber);
            }
        } else {
            this.maxValue = Double.MAX_VALUE;
            this.minValue = -1.7976931348623157E308;
        }
        for (i = 0; i < nb && this.editable; ++i) {
            this.buttons_up[i] = new JArrowButton();
            this.add(this.buttons_up[i]);
            this.buttons_up[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    WheelSwitch.this.clickUp(evt);
                }
            });
            this.buttons_down[i] = new JArrowButton();
            this.add(this.buttons_down[i]);
            this.buttons_down[i].setOrientation(JArrowButton.DOWN);
            this.buttons_down[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    WheelSwitch.this.clickDown(evt);
                }
            });
        }
        double dval1 = 0.0;
        double dval2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            dval1 = this.getFloatPart();
            dval2 = this.getExpPart();
        } else {
            dval1 = this.value;
        }
        this.setValue(this.near(dval1) * Math.pow(10.0, dval2));
        this.nbButton = nb;
        this.selButton = nb - 1;
        if (this.isVisible()) {
            this.placeComponents(this.getSize());
        }
        this.updateButtonFocus();
        this.repaint();
    }

    private boolean hasBorder() {
        return this.getBorder() != null;
    }

    private void clickUp(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        int i = 0;
        boolean found = false;
        this.grabFocus();
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return;
        }
        while (i < this.nbButton && !found) {
            found = evt.getSource() == this.buttons_up[i];
            if (found) continue;
            ++i;
        }
        if (!this.editMode && found) {
            this.increaseValue(i);
            this.selButton = i;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    private void clickDown(MouseEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        int i = 0;
        boolean found = false;
        this.grabFocus();
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return;
        }
        while (i < this.nbButton && !found) {
            found = evt.getSource() == this.buttons_down[i];
            if (found) continue;
            ++i;
        }
        if (!this.editMode && found) {
            this.decreaseValue(i);
            this.selButton = i;
            this.updateButtonFocus();
            this.repaint();
        }
    }

    private void computeDigitSize() {
        int max_width = 0;
        int max_height = 0;
        if (this.dz == null) {
            String[] charSet = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "E", "+", "-", " ", "A", "B", "C", "D", "E", "F"};
            for (int i = 0; i < charSet.length; ++i) {
                Dimension b = ATKGraphicsUtils.measureString(charSet[i], this.getFont());
                int w = b.width + 1;
                if (w <= max_width) continue;
                max_width = w;
            }
            max_height = (int)ATKGraphicsUtils.getLineMetrics("0123456789E+- ABCDEF", this.getFont()).getAscent() + 1;
            this.dz = new Dimension(max_width, max_height);
        }
    }

    private double near(double d) {
        double r = Math.pow(10.0, this.fracNumber);
        return Math.rint(d * r) / r;
    }

    private void computeValueFormatted() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            this.valueFormatted = "";
            return;
        }
        this.valueFormatted = this.isGoodFormat() ? (this.isHexFormat(this.format) ? (this.value < 0.0 ? "-" + ATKFormat.format(this.format, -this.value) : ATKFormat.format(this.format, this.value)) : ATKFormat.format(this.format, this.value)) : Double.toString(this.value);
        if (!this.isHexFormat(this.format)) {
            this.valueFormatted = this.valueFormatted.toLowerCase();
        }
        this.valueFormatted = this.valueFormatted.replaceAll("\\-", "");
        this.valueFormatted = this.valueFormatted.replaceAll("\\+", "");
        this.valueFormatted = this.valueFormatted.replaceAll(" ", "");
    }

    private char getDigit(int pos) {
        int idx;
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return '-';
        }
        String intPart = "";
        intPart = this.format.indexOf(100) != -1 || this.isHexFormat(this.format) ? this.valueFormatted : ((idx = this.valueFormatted.indexOf(this.decimalSeparator)) >= 0 ? this.valueFormatted.substring(0, idx) : this.valueFormatted);
        if (pos < this.intNumber) {
            if (intPart.length() < this.intNumber) {
                if (pos < this.intNumber - intPart.length()) {
                    return ' ';
                }
                return intPart.charAt(pos + intPart.length() - this.intNumber);
            }
            if (intPart.length() == this.intNumber) {
                return intPart.charAt(pos);
            }
            int over = intPart.length() - this.intNumber;
            return intPart.charAt(pos + over);
        }
        if (pos < this.intNumber + this.fracNumber) {
            return this.valueFormatted.charAt(pos + 1 + intPart.length() - this.intNumber);
        }
        int e = this.valueFormatted.indexOf(101);
        return this.valueFormatted.charAt(pos + e + 1 - this.intNumber - this.fracNumber);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setPaintMode();
        this.computeDigitSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        g.setFont(this.getFont());
        if (this.editMode) {
            g.setColor(this.getForeground());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            Rectangle2D b = fm.getStringBounds(this.editValue, g);
            int xpos = (w - (int)b.getWidth()) / 2;
            g.drawString(this.editValue, xpos, this.off_y + this.dz.width + this.dz.height - 2);
        } else {
            if (this.textBackground != null) {
                g.setColor(this.textBackground);
                g.fillRect(this.off_x + 1, this.off_y + 1, this.totalWidth - 2, this.totalHeight - 2);
            }
            if (this.isEnabled()) {
                g.setColor(this.getForeground());
            } else {
                g.setColor(this.getBackground().darker());
            }
            int ypos = this.editable ? this.off_y + this.dz.width + this.dz.height - 2 : this.off_y + this.dz.height - 2;
            if (this.value < 0.0) {
                g.drawString("-", this.off_x, ypos);
            }
            if (this.fracNumber > 0) {
                g.drawString(".", this.off_x + (this.intNumber + 1) * this.dz.width + 2, ypos);
            }
            if (this.expNumber > 0) {
                g.drawString("E", this.off_x + (this.intNumber + this.fracNumber + 2) * this.dz.width + 2, ypos);
                String ePart = "" + this.getExpPart();
                String s = ePart.substring(0, 1);
                if (!"-".equals(s)) {
                    s = "+";
                }
                g.drawString(s, this.off_x + (this.intNumber + this.fracNumber + 3) * this.dz.width + 2, ypos);
            }
            this.computeValueFormatted();
            char[] CH = new char[1];
            for (int i = 0; i < this.nbButton; ++i) {
                int xpos = i < this.intNumber ? this.off_x + (i + 1) * this.dz.width : (i < this.intNumber + this.fracNumber ? this.off_x + (i + 2) * this.dz.width : this.off_x + (i + 4) * this.dz.width);
                CH[0] = this.getDigit(i);
                g.drawString(new String(CH), xpos, ypos);
            }
        }
        if (this.hasFocus() && this.editable) {
            Insets b = this.hasBorder() ? this.getInsets() : new Insets(1, 1, 1, 1);
            g.setColor(defaultSelectionColor);
            g.drawLine(b.left + 1, b.top + 1, w - b.right - 1, b.top + 1);
            g.drawLine(w - b.right - 1, b.top + 1, w - b.right - 1, h - b.bottom - 1);
            g.drawLine(w - b.right - 1, h - b.bottom - 1, b.left + 1, h - b.bottom - 1);
            g.drawLine(b.left + 1, h - b.bottom - 1, b.left + 1, b.top + 1);
        }
    }

    public void addWheelSwitchListener(IWheelSwitchListener l) {
        this.listenerList.add(IWheelSwitchListener.class, l);
    }

    public void removeWheelSwitchListener(IWheelSwitchListener l) {
        this.listenerList.remove(IWheelSwitchListener.class, l);
    }

    private Double getExpPart() {
        int e = this.format.indexOf(101);
        if (e == -1) {
            return null;
        }
        String displayVal = ATKFormat.format(this.format, this.value);
        if (!Double.isNaN(this.value) && !Double.isInfinite(this.value) && displayVal != null) {
            displayVal = displayVal.toLowerCase();
            return Double.valueOf(displayVal.substring(displayVal.indexOf(101) + 1));
        }
        return null;
    }

    private Double getFloatPart() {
        int e = this.format.indexOf(101);
        if (e == -1) {
            return new Double(this.value);
        }
        String displayVal = ATKFormat.format(this.format, this.value);
        if (!Double.isNaN(this.value) && !Double.isInfinite(this.value) && displayVal != null) {
            displayVal = displayVal.toLowerCase();
            return Double.valueOf(displayVal.substring(0, displayVal.indexOf(101)));
        }
        return null;
    }

    private void fireValueChange() {
        IWheelSwitchListener[] list = (IWheelSwitchListener[])this.listenerList.getListeners(IWheelSwitchListener.class);
        WheelSwitchEvent w = new WheelSwitchEvent(this, this.value);
        for (int i = 0; i < list.length; ++i) {
            list[i].valueChange(w);
        }
    }

    private void updateButtonFocus() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.editable) {
            return;
        }
        for (int i = 0; i < this.nbButton; ++i) {
            if (i == this.selButton && this.hasFocus()) {
                this.buttons_up[i].setBackground(this.selectionColor);
                this.buttons_down[i].setBackground(this.selectionColor);
                continue;
            }
            this.buttons_up[i].setBackground(this.buttonBackground);
            this.buttons_down[i].setBackground(this.buttonBackground);
        }
    }

    private void increaseValue(int idx) {
        double dval1 = 0.0;
        double dval2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            dval1 = this.getFloatPart();
            dval2 = this.getExpPart();
        } else {
            dval1 = this.value;
        }
        if (idx < this.intNumber + this.fracNumber) {
            dval1 = this.incValue(dval1, idx, this.intNumber);
        } else {
            int idx2 = idx - this.intNumber - this.fracNumber;
            dval2 = this.incValue(dval2, idx2, this.expNumber);
        }
        double newValue = this.near(dval1) * Math.pow(10.0, dval2);
        if (!Double.isNaN(newValue) && !Double.isInfinite(newValue)) {
            double curValue = this.getValue();
            double delta = Math.abs(curValue - newValue);
            if (delta < this.minimumIncrement) {
                newValue = curValue + this.minimumIncrement;
            }
            if (newValue <= this.maxValue && newValue >= this.minValue) {
                this.setValue(newValue);
                if (this.format.indexOf(101) > 0) {
                    this.reformat(ATKFormat.format(this.format, this.value), this.intNumber, this.fracNumber);
                }
            }
            this.fireValueChange();
        }
        this.updateButtonVisibility();
    }

    private double incValue(double val, int idx, int ref) {
        double newValue = !this.isHexFormat(this.format) ? val + Math.pow(10.0, ref - idx - 1) : val + Math.pow(16.0, ref - idx - 1);
        return newValue;
    }

    private double decValue(double val, int idx, int ref) {
        double newValue = !this.isHexFormat(this.format) ? val - Math.pow(10.0, ref - idx - 1) : val - Math.pow(16.0, ref - idx - 1);
        return newValue;
    }

    private void decreaseValue(int idx) {
        double dval1 = 0.0;
        double dval2 = 0.0;
        if (this.format.indexOf(101) > 0) {
            dval1 = this.getFloatPart();
            dval2 = this.getExpPart();
        } else {
            dval1 = this.value;
        }
        if (idx < this.intNumber + this.fracNumber) {
            dval1 = this.decValue(dval1, idx, this.intNumber);
        } else {
            int idx2 = idx - (this.intNumber + this.fracNumber);
            dval2 = this.decValue(dval2, idx2, this.expNumber);
        }
        double newValue = this.near(dval1) * Math.pow(10.0, dval2);
        if (!Double.isNaN(newValue) && !Double.isInfinite(newValue)) {
            double curValue = this.getValue();
            double delta = Math.abs(curValue - newValue);
            if (delta < this.minimumIncrement) {
                newValue = curValue - this.minimumIncrement;
            }
            if (newValue <= this.maxValue && newValue >= this.minValue) {
                this.setValue(newValue);
                if (this.format.indexOf(101) > 0) {
                    this.reformat(ATKFormat.format(this.format, this.value), this.intNumber, this.fracNumber);
                }
            }
            this.fireValueChange();
        }
        this.updateButtonVisibility();
    }

    private void processKey(KeyEvent e) {
        char c = e.getKeyChar();
        c = Character.toUpperCase(c);
        int code = e.getKeyCode();
        if (!this.editMode && this.nbButton > 0) {
            switch (code) {
                case 39: {
                    ++this.selButton;
                    if (this.selButton >= this.nbButton) {
                        this.selButton = this.nbButton - 1;
                    }
                    this.updateButtonFocus();
                    this.repaint();
                    break;
                }
                case 37: {
                    --this.selButton;
                    if (this.selButton < 0) {
                        this.selButton = 0;
                    }
                    this.updateButtonFocus();
                    this.repaint();
                    break;
                }
                case 38: {
                    this.increaseValue(this.selButton);
                    this.repaint();
                    break;
                }
                case 40: {
                    this.decreaseValue(this.selButton);
                    this.repaint();
                }
            }
        }
        if (c >= '0' && c <= '9' || c == this.decimalSeparator || c == '-' || this.isHexFormat(this.format) && c >= 'A' && c <= 'F') {
            this.editValue = this.editValue + c;
            this.editMode = true;
            this.repaint();
        }
        if (!(c != 'e' && c != 'E' || this.editValue.toLowerCase().indexOf(101) != -1 || "".equals(this.editValue))) {
            this.editValue = this.editValue + c;
            this.editMode = true;
            this.repaint();
        }
        if (code == 12 || code == 3 || code == 27) {
            this.editValue = "";
            this.editMode = false;
            this.repaint();
        }
        if (this.editMode && this.editValue.length() > 0 && (code == 8 || code == 127)) {
            this.editValue = this.editValue.substring(0, this.editValue.length() - 1);
            this.repaint();
        }
        if (code == 10) {
            if (this.editMode) {
                try {
                    double newValue = this.isHexFormat(this.format) ? (double)Integer.parseInt(this.editValue, 16) : Double.parseDouble(this.editValue);
                    if (newValue <= this.maxValue && newValue >= this.minValue) {
                        this.value = newValue;
                        this.updateButtonVisibility();
                        this.fireValueChange();
                        this.editValue = "";
                        this.editMode = false;
                        this.repaint();
                    } else {
                        String mesg = "Warning, value is out of the range [" + this.minValue + "," + this.maxValue + "]\nCancel editing ?";
                        int r = JOptionPane.showConfirmDialog(this, mesg, "[WheelSwitch error]", 0);
                        if (r == 0) {
                            this.editValue = "";
                            this.editMode = false;
                            this.repaint();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.fireValueChange();
                this.repaint();
            }
        }
    }

    private void updateButtonVisibility() {
        if (this.editable && this.format.indexOf(101) == -1) {
            for (int i = 0; i < this.nbButton; ++i) {
                double val = this.incValue(this.value, i, this.intNumber);
                this.buttons_up[i].setVisible(val <= this.maxValue);
                val = this.decValue(this.value, i, this.intNumber);
                this.buttons_down[i].setVisible(val >= this.minValue);
            }
        }
    }

    private boolean isHexFormat(String f) {
        return f.indexOf(120) != -1 || f.indexOf(88) != -1;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        this.placeComponents(new Dimension(w, h));
        super.setBounds(x, y, w, h);
    }

    private synchronized void placeComponents(Dimension sz) {
        this.computeDigitSize();
        this.totalWidth = this.expNumber > 0 ? this.dz.width * (this.nbButton + 4) : (this.fracNumber > 0 ? this.dz.width * (this.nbButton + 2) : this.dz.width * (this.nbButton + 1));
        this.totalHeight = this.editable ? this.dz.height + 2 * this.dz.width : this.dz.height;
        this.off_x = (sz.width - this.totalWidth) / 2;
        this.off_y = (sz.height - this.totalHeight) / 2;
        for (int i = 0; i < this.nbButton && this.editable; ++i) {
            int xpos = i < this.intNumber ? this.off_x + (i + 1) * this.dz.width + 1 : (i < this.intNumber + this.fracNumber ? this.off_x + (i + 2) * this.dz.width + 1 : this.off_x + (i + 4) * this.dz.width + 1);
            this.buttons_up[i].setBounds(xpos, this.off_y + 2, this.dz.width - 2, this.dz.width - 2);
            int h = this.dz.width + this.dz.height + this.off_y;
            this.buttons_down[i].setBounds(xpos, h, this.dz.width - 2, this.dz.width - 2);
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        WheelSwitch ws1 = new WheelSwitch();
        WheelSwitch ws2 = new WheelSwitch();
        WheelSwitch ws3 = new WheelSwitch();
        WheelSwitch ws4 = new WheelSwitch();
        WheelSwitch ws5 = new WheelSwitch();
        WheelSwitch ws6 = new WheelSwitch();
        WheelSwitch ws7 = new WheelSwitch();
        ws1.setFormat("%4.3e");
        ws1.setButtonColor(Color.RED);
        ws1.setValue(-42.9995);
        ws1.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws1:" + e.getValue());
            }
        });
        ws2.setFormat("%6.2f");
        ws2.setMinimumIncrement(0.05);
        ws2.setButtonColor(Color.GREEN);
        ws2.setValue(-12.5);
        ws2.setMaxValue(75.0);
        ws2.setMinValue(-25.0);
        ws2.setFont(new Font("Dialog", 1, 50));
        ws2.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws2:" + e.getValue());
            }
        });
        ws3.setFormat("%6d");
        ws3.setButtonColor(Color.BLUE);
        ws3.setValue(48.0);
        ws3.setFont(new Font("Lucida Bright", 1, 30));
        ws3.setBorder(BorderFactory.createEtchedBorder());
        ws3.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws3:" + e.getValue());
            }
        });
        ws4.setFormat("0x%08X");
        ws4.setButtonColor(new Color(100, 200, 160));
        ws4.setValue(40995.0);
        ws4.setFont(new Font("Lucida Bright", 1, 12));
        ws4.setBorder(BorderFactory.createEtchedBorder());
        ws4.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws4:" + e.getValue());
            }
        });
        ws5.setFormat("%5.2e");
        ws5.setButtonColor(new Color(100, 0, 0));
        ws5.setValue(Double.NaN);
        ws5.setFont(new Font("Dialog", 0, 16));
        ws5.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws5:" + e.getValue());
            }
        });
        ws6.setFormat("%5.2f");
        ws6.setButtonColor(new Color(0, 100, 0));
        ws6.setValue(Double.NaN);
        ws6.setFont(new Font("Dialog", 0, 16));
        ws6.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws6:" + e.getValue());
            }
        });
        ws7.setFormat("%5d");
        ws7.setButtonColor(new Color(0, 0, 100));
        ws7.setValue(Double.NaN);
        ws7.setFont(new Font("Dialog", 0, 16));
        ws7.addWheelSwitchListener(new IWheelSwitchListener(){

            @Override
            public void valueChange(WheelSwitchEvent e) {
                System.out.println("Value changed ws7:" + e.getValue());
            }
        });
        JButton b = new JButton("OK");
        b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().setBackground(Color.white);
        f.getContentPane().setLayout(new FlowLayout());
        f.getContentPane().add(ws1);
        f.getContentPane().add(ws2);
        f.getContentPane().add(ws3);
        f.getContentPane().add(ws4);
        f.getContentPane().add(ws5);
        f.getContentPane().add(ws6);
        f.getContentPane().add(ws7);
        f.getContentPane().add(b);
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

