/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class UIManagerHelper {
    public static void setFont(String thingyName, JComponent thingy) {
        Font f = UIManager.getFont(thingyName + ".Font");
        if (f == null) {
            return;
        }
        thingy.setFont(f);
    }

    public static void setForeground(String thingyName, JComponent thingy) {
        Color c = UIManager.getColor(thingyName + ".Foreground");
        if (c == null) {
            return;
        }
        thingy.setForeground(c);
    }

    public static void setBackground(String thingyName, JComponent thingy) {
        Color c = UIManager.getColor(thingyName + ".Background");
        if (c == null) {
            return;
        }
        thingy.setBackground(c);
    }

    public static void setSize(String thingyName, JComponent thingy) {
        Dimension d = UIManager.getDimension(thingyName + ".Size");
        if (d == null) {
            return;
        }
        thingy.setPreferredSize(d);
    }

    public static void setAll(String thingyName, JComponent thingy) {
        UIManagerHelper.setSize(thingyName, thingy);
        UIManagerHelper.setFont(thingyName, thingy);
        UIManagerHelper.setForeground(thingyName, thingy);
        UIManagerHelper.setBackground(thingyName, thingy);
    }

    public static Dimension getRequiredSize(FontMetrics fm, int characters) {
        int advance = fm.getMaxAdvance();
        if (advance != -1) {
            Dimension dim = new Dimension(advance * characters, fm.getHeight());
            return dim;
        }
        int[] widths = fm.getWidths();
        int max = 0;
        for (int i = 0; i < widths.length; ++i) {
            if (widths[i] < max) continue;
            max = widths[i];
        }
        Dimension dim = new Dimension(max * characters, fm.getHeight());
        return dim;
    }
}

