/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class ThreeStateSwitch
extends JComponent
implements MouseListener {
    public static final int UNKNOWN_STATE = 0;
    public static final int ON_STATE = 1;
    public static final int OFF_STATE = 2;
    ImageIcon on_state;
    ImageIcon off_state;
    ImageIcon unknown_state;
    Dimension iconSize;
    Dimension titleSize;
    int currentState;
    String title;
    Font titleFont;
    EventListenerList listenerList;

    public ThreeStateSwitch() {
        this.initComponents();
    }

    public ThreeStateSwitch(String title, Font tFont) {
        this.initComponents();
        if (tFont != null) {
            this.titleFont = tFont;
        }
        this.setTitle(title);
    }

    public void setTitle(String s) {
        this.title = s;
        this.computeTitleSize();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void setFont(Font f) {
        if (f != null) {
            this.titleFont = f;
            this.computeTitleSize();
        }
    }

    @Override
    public Font getFont() {
        return this.titleFont;
    }

    public void setIcons(ImageIcon on, ImageIcon off, ImageIcon unknown) {
        this.on_state = on;
        this.off_state = off;
        this.unknown_state = unknown;
        this.iconSize = new Dimension(this.on_state.getIconWidth(), this.on_state.getIconHeight());
        this.computeTitleSize();
    }

    public void setState(int s) {
        this.currentState = s;
        this.repaint();
    }

    public int getState() {
        return this.currentState;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            switch (this.currentState) {
                case 1: {
                    this.currentState = 2;
                    this.fireStateChange("OFF");
                    this.repaint();
                    break;
                }
                case 2: {
                    this.currentState = 1;
                    this.fireStateChange("ON");
                    this.repaint();
                    break;
                }
                default: {
                    this.fireStateChange("UNKNOWN");
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        if (this.title != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setFont(this.titleFont);
            FontRenderContext frc = g2.getFontRenderContext();
            int fa = (int)Math.ceil(g.getFont().getLineMetrics("ABC", frc).getAscent());
            g.setColor(this.getForeground());
            g.drawString(this.title, (d.width - (this.titleSize.width - 6)) / 2, fa + 2);
        }
        int xOrg = (d.width - this.iconSize.width) / 2;
        int yOrg = (d.height - (this.iconSize.height - this.titleSize.height)) / 2;
        switch (this.currentState) {
            case 1: {
                g.drawImage(this.on_state.getImage(), xOrg, yOrg, null);
                break;
            }
            case 2: {
                g.drawImage(this.off_state.getImage(), xOrg, yOrg, null);
                break;
            }
            default: {
                g.drawImage(this.unknown_state.getImage(), xOrg, yOrg, null);
            }
        }
        this.paintBorder(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(Math.max(this.iconSize.width, this.titleSize.width), this.iconSize.height + this.titleSize.height);
    }

    private void computeTitleSize() {
        if (this.title == null) {
            this.titleSize = new Dimension(0, 0);
            return;
        }
        Dimension d = ATKGraphicsUtils.measureString(this.title, this.titleFont);
        d.width += 6;
        d.height += 4;
        this.titleSize = d;
    }

    private void initComponents() {
        this.setOpaque(true);
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(206, 206, 206));
        this.setForeground(Color.BLACK);
        this.on_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_on.gif"));
        this.off_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_off.gif"));
        this.unknown_state = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/switch_unknown.gif"));
        this.iconSize = new Dimension(this.on_state.getIconWidth(), this.on_state.getIconHeight());
        this.currentState = 1;
        this.title = null;
        this.titleSize = new Dimension(0, 0);
        this.titleFont = new Font("Dialog", 1, 12);
        this.listenerList = new EventListenerList();
        this.addMouseListener(this);
    }

    private void fireStateChange(String state) {
        ActionListener[] list = (ActionListener[])this.listenerList.getListeners(ActionListener.class);
        ActionEvent w = new ActionEvent(this, 1001, state);
        for (int i = 0; i < list.length; ++i) {
            list[i].actionPerformed(w);
        }
    }
}

