/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;

class SplashPanel
extends JComponent
implements MouseListener {
    protected static final String defaultImgLocation = "/fr/esrf/tangoatk/widget/util/splash.jpg";
    protected static final int foregroundDefault = -3355444;
    private JSmoothLabel title;
    private JSmoothLabel message;
    private JSmoothLabel copyright;
    private JSmoothProgressBar progress = null;
    private BufferedImage ddBuffer;
    private boolean firstUpdate = true;
    private Dimension imgSize;
    private ImageIcon img;
    private Color textForeground;
    private JButton exitButton;

    public SplashPanel() {
        this(null, null, null);
    }

    public SplashPanel(ImageIcon icon, Color textForeground, JSmoothProgressBar bar) {
        this.img = icon == null ? new ImageIcon(SplashPanel.class.getResource(defaultImgLocation)) : icon;
        this.textForeground = textForeground == null ? new Color(-3355444) : textForeground;
        if (bar != null) {
            this.progress = bar;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.imgSize = new Dimension(this.img.getIconWidth(), this.img.getIconHeight());
        this.setLayout(null);
        this.setDoubleBuffered(false);
        this.title = new JSmoothLabel();
        this.title.setFont(new Font("Dialog", 1, 18));
        this.title.setForeground(this.textForeground);
        this.title.setText("");
        this.title.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.title.setOpaque(false);
        this.title.setDoubleBuffered(false);
        this.message = new JSmoothLabel();
        this.message.setFont(new Font("Dialog", 1, 12));
        this.message.setForeground(this.textForeground);
        this.message.setText("Initializing...");
        this.message.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.message.setOpaque(false);
        this.message.setDoubleBuffered(false);
        this.copyright = new JSmoothLabel();
        this.copyright.setFont(new Font("Dialog", 0, 10));
        this.copyright.setForeground(this.textForeground);
        this.copyright.setText("(c) ESRF 2002");
        this.copyright.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
        this.copyright.setOpaque(false);
        this.copyright.setDoubleBuffered(false);
        if (this.progress == null) {
            this.progress = new JSmoothProgressBar();
            this.progress.setStringPainted(true);
        }
        this.progress.setDoubleBuffered(false);
        this.exitButton = new JButton("x");
        this.exitButton.setFont(new Font("Dialog", 0, 10));
        this.exitButton.setMargin(new Insets(0, 0, 0, 0));
        this.exitButton.setDoubleBuffered(false);
        this.setPreferredSize(this.imgSize);
        this.setMinimumSize(this.imgSize);
        this.setMaximumSize(this.imgSize);
        this.title.setSize(this.imgSize.width - 10, 23);
        this.message.setSize(this.imgSize.width - 10, 18);
        this.progress.setSize(this.imgSize.width - 10, 21);
        this.copyright.setSize(this.imgSize.width - 10, 15);
        this.exitButton.setSize(15, 15);
        this.ddBuffer = new BufferedImage(this.imgSize.width, this.imgSize.height, 1);
        Graphics g = this.ddBuffer.getGraphics();
        this.paintBackground(g, 0, 0, this.imgSize.width, this.imgSize.height);
        this.paintComponent(g, this.message, 5, this.imgSize.height - 30);
        this.paintComponent(g, this.progress, 5, this.imgSize.height - 55);
        this.paintComponent(g, this.copyright, 5, this.imgSize.height - 75);
        this.paintComponent(g, this.title, 5, this.imgSize.height - 95);
        this.paintComponent(g, this.exitButton, this.imgSize.width - 20, 5);
        g.dispose();
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x > this.imgSize.width - 20 && x < this.imgSize.width - 5 && y > 5 && y < 20) {
            Runtime.getRuntime().halt(0);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void paintComponent(Graphics g, Component c, int x, int y) {
        g.translate(x, y);
        c.paint(g);
        g.translate(-x, -y);
    }

    private void paintBackground(Graphics g, int x, int y, int w, int h) {
        g.drawImage(this.img.getImage(), x, y, x + w, y + h, x, y, x + w, y + h, null);
    }

    private void repaintComponent(Component c, int x, int y) {
        Graphics g = this.ddBuffer.getGraphics();
        this.paintBackground(g, x, y, c.getSize().width, c.getSize().height);
        this.paintComponent(g, c, x, y);
        g.dispose();
        g = this.getGraphics();
        if (g != null) {
            if (this.firstUpdate) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                g.drawImage(this.ddBuffer, 0, 0, null);
                this.firstUpdate = false;
            } else {
                g.drawImage(this.ddBuffer, x, y, x + c.getSize().width, y + c.getSize().height, x, y, x + c.getSize().width, y + c.getSize().height, null);
            }
            g.dispose();
        }
    }

    void setTitle(String s) {
        this.title.setText(s);
        this.repaintComponent(this.title, 5, this.imgSize.height - 95);
    }

    String getTitle() {
        return this.title.getText();
    }

    void setProgress(int p) {
        if (this.progress.getValue() != p) {
            this.progress.setValue(p);
            this.repaintComponent(this.progress, 5, this.imgSize.height - 55);
        }
    }

    JSmoothProgressBar getProgress() {
        return this.progress;
    }

    void setMessage(String s) {
        this.message.setText(s);
        this.repaintComponent(this.message, 5, this.imgSize.height - 30);
    }

    String getMessage() {
        return this.message.getText();
    }

    void setCopyright(String s) {
        this.copyright.setText(s);
        this.repaintComponent(this.copyright, 5, this.imgSize.height - 75);
    }

    String getCopyright() {
        return this.copyright.getText();
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.ddBuffer, 0, 0, null);
    }
}

