/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class RestrictedFolderJFileChooser
extends JFileChooser {
    private String initFolder = null;
    private String[] autorizedFolders = null;
    private String[] autorizedCanonicalFolders = null;

    public RestrictedFolderJFileChooser(String folder) {
        super(".");
        this.initFolder = folder;
        if (this.initFolder != null) {
            this.setCurrentDirectory(new File(this.initFolder));
            this.addAutorizedFolder(this.initFolder);
        }
    }

    public void addAutorizedFolder(String folder) {
        if (folder == null) {
            return;
        }
        if (folder.length() <= 0) {
            return;
        }
        if (this.autorizedFolders == null) {
            this.autorizedFolders = new String[1];
            this.autorizedFolders[0] = folder;
        } else {
            int lgth = this.autorizedFolders.length;
            String[] afs = new String[lgth + 1];
            System.arraycopy(this.autorizedFolders, 0, afs, 0, lgth);
            afs[lgth] = folder;
            this.autorizedFolders = afs;
        }
        this.updateAutorizedCanonicalFolders();
    }

    private void updateAutorizedCanonicalFolders() {
        this.autorizedCanonicalFolders = new String[this.autorizedFolders.length];
        for (int i = 0; i < this.autorizedFolders.length; ++i) {
            this.autorizedCanonicalFolders[i] = this.getCanonicalFolder(this.autorizedFolders[i]);
        }
    }

    private String getCanonicalFolder(String folder) {
        File fileDir = new File(folder);
        String folderCanonicalPath = null;
        try {
            folderCanonicalPath = fileDir.getCanonicalPath();
        }
        catch (IOException ioex) {
            folderCanonicalPath = new String(folder);
        }
        return folderCanonicalPath;
    }

    public File showDialog(Component parent, String approveButtonText, String acceptedFolder) {
        String msg;
        boolean wellLocated;
        File selectedFile = null;
        String selectedFilePath = null;
        this.setCurrentDirectory(new File(this.initFolder));
        int dialReturn = super.showDialog(parent, approveButtonText);
        if (dialReturn != 0) {
            return null;
        }
        selectedFile = this.getSelectedFile();
        try {
            selectedFilePath = selectedFile.getCanonicalPath();
        }
        catch (IOException ioex) {
            JOptionPane.showMessageDialog(parent, "Failed to get the canonical path of the selected file.\n\n" + ioex + "\n\n\n", approveButtonText + " aborted.\n", 0);
            return null;
        }
        if (acceptedFolder == null) {
            wellLocated = this.isInAutorizedFolders(selectedFilePath);
            msg = this.getAutorizedFolderHint();
        } else {
            wellLocated = this.isInSpecifiedFolder(selectedFilePath, acceptedFolder);
            msg = "The file should be located inside " + acceptedFolder + " \n ";
        }
        if (!wellLocated) {
            JOptionPane.showMessageDialog(parent, "The selected file is not inside the authorized root folder(s)\n\n" + msg, approveButtonText + " aborted.\n", 0);
            return null;
        }
        return selectedFile;
    }

    private boolean isInSpecifiedFolder(String fPath, String folder) {
        File fileDir = new File(folder);
        String folderCanonicalPath = null;
        try {
            folderCanonicalPath = fileDir.getCanonicalPath();
        }
        catch (IOException ioex) {
            folderCanonicalPath = new String(folder);
        }
        return fPath.startsWith(folderCanonicalPath);
    }

    private boolean isInAutorizedFolders(String fPath) {
        if (this.autorizedCanonicalFolders == null) {
            return true;
        }
        if (this.autorizedCanonicalFolders.length <= 0) {
            return true;
        }
        for (int i = 0; i < this.autorizedCanonicalFolders.length; ++i) {
            if (!fPath.startsWith(this.autorizedCanonicalFolders[i])) continue;
            return true;
        }
        return false;
    }

    private String getAutorizedFolderHint() {
        if (this.autorizedFolders == null) {
            return "";
        }
        if (this.autorizedFolders.length <= 0) {
            return "";
        }
        String folderHint = "The file should be located inside one the following folders : \n ";
        for (int i = 0; i < this.autorizedFolders.length; ++i) {
            folderHint = folderHint + "     " + this.autorizedFolders[i] + "\n";
        }
        return folderHint;
    }
}

