/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.FileContentViewer;
import fr.esrf.tangoatk.widget.util.SwingUtils;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class PreviewFileChooser
extends JFileChooser {
    private String rootDirectory = null;
    private boolean contentVisible = false;
    private FileContentViewer fcv = new FileContentViewer(400, 250);
    private JTable fileChoosertable = null;
    private Dimension increaseDimension = new Dimension(220, 70);

    public PreviewFileChooser() {
        ActionMap am = this.getActionMap();
        Action details = am.get("viewTypeDetails");
        details.actionPerformed(null);
        this.fileChoosertable = SwingUtils.getDescendantsOfType(JTable.class, this).get(0);
        this.sortByDate();
        this.validate();
        this.increaseSize();
    }

    public PreviewFileChooser(String dirPath) {
        super(dirPath);
        this.rootDirectory = dirPath;
        ActionMap am = this.getActionMap();
        Action details = am.get("viewTypeDetails");
        details.actionPerformed(null);
        this.fileChoosertable = SwingUtils.getDescendantsOfType(JTable.class, this).get(0);
        this.sortByDate();
        this.validate();
        this.increaseSize();
    }

    void sortByDate() {
        if (this.fileChoosertable == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewFileChooser.this.fileChoosertable.getRowSorter().toggleSortOrder(2);
                PreviewFileChooser.this.fileChoosertable.getRowSorter().toggleSortOrder(2);
            }
        });
    }

    public void increaseDimension(int w, int h) {
        this.increaseDimension = new Dimension(w, h);
        this.increaseSize();
    }

    private void increaseSize() {
        if (this.increaseDimension == null) {
            return;
        }
        Dimension psize = this.getPreferredSize();
        psize.width += this.increaseDimension.width;
        psize.height += this.increaseDimension.height;
        this.setPreferredSize(psize);
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String dirPath) {
        File dir = new File(dirPath);
        super.setCurrentDirectory(dir);
        this.rootDirectory = dirPath;
    }

    public boolean isContentVisible() {
        return this.contentVisible;
    }

    public void setContentVisible(boolean cv) {
        if (cv == this.isContentVisible()) {
            return;
        }
        if (this.isContentVisible()) {
            this.removePropertyChangeListener(this.fcv);
            this.setAccessory(null);
        } else {
            this.addPropertyChangeListener(this.fcv);
            this.setAccessory(this.fcv);
        }
        this.validate();
        this.increaseSize();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jf = new JFrame();
                jf.setVisible(true);
                PreviewFileChooser pjfc = new PreviewFileChooser("/users/poncet");
                pjfc.setContentVisible(true);
                int returnDial = pjfc.showDialog(jf.getRootPane(), "Load");
                if (returnDial == 1) {
                    return;
                }
                File selectedFile = pjfc.getSelectedFile();
                if (selectedFile == null) {
                    return;
                }
                if (!selectedFile.exists()) {
                    JOptionPane.showMessageDialog(jf.getRootPane(), "The selected file does not exist.\n\n", "Load file aborted.\n", 0);
                    return;
                }
                System.out.println("File to load : " + selectedFile.getName());
            }
        });
    }
}

