/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.widget.util.EntityNode;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Node;
import fr.esrf.tangoatk.widget.util.SpectrumItemNode;

class MemberNode
extends Node {
    private String domain;
    private String family;
    private String member;

    MemberNode(int mode, String domain, String family, String member) {
        this.mode = mode;
        this.domain = domain;
        this.family = family;
        this.member = member;
    }

    @Override
    void populateNode() throws DevFailed {
        if (!this.isLeaf()) {
            String devName = this.domain + "/" + this.family + "/" + this.member;
            try {
                Device ds = DeviceFactory.getInstance().getDevice(devName);
                switch (this.mode) {
                    case 1: {
                        String[] attList = ds.get_attribute_list();
                        for (int i = 0; i < attList.length; ++i) {
                            this.add(new EntityNode(this.mode, attList[i]));
                        }
                        break;
                    }
                    case 3: {
                        AttributeInfo[] ai = ds.get_attribute_info();
                        for (int i = 0; i < ai.length; ++i) {
                            if (ai[i].data_format.value() != 0) continue;
                            this.add(new EntityNode(this.mode, ai[i].name));
                        }
                        ai = null;
                        break;
                    }
                    case 5: {
                        AttributeInfo[] aib = ds.get_attribute_info();
                        for (int i = 0; i < aib.length; ++i) {
                            if (aib[i].data_format.value() != 0 || aib[i].data_type != 1) continue;
                            this.add(new EntityNode(this.mode, aib[i].name));
                        }
                        aib = null;
                        break;
                    }
                    case 4: {
                        AttributeInfo[] ain = ds.get_attribute_info();
                        for (int i = 0; i < ain.length; ++i) {
                            if (ain[i].data_format.value() != 0) continue;
                            switch (ain[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    this.add(new EntityNode(this.mode, ain[i].name));
                                }
                            }
                        }
                        ain = null;
                        break;
                    }
                    case 7: {
                        AttributeInfo[] aisp = ds.get_attribute_info();
                        for (int i = 0; i < aisp.length; ++i) {
                            if (aisp[i].data_format.value() != 1) continue;
                            switch (aisp[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    this.add(new EntityNode(this.mode, aisp[i].name));
                                }
                            }
                        }
                        Object ain = null;
                        break;
                    }
                    case 6: {
                        AttributeInfo[] ais = ds.get_attribute_info();
                        for (int i = 0; i < ais.length; ++i) {
                            if (ais[i].data_format.value() != 0 || ais[i].data_type != 8) continue;
                            this.add(new EntityNode(this.mode, ais[i].name));
                        }
                        ais = null;
                        break;
                    }
                    case 2: {
                        CommandInfo[] cmdList = ds.command_list_query();
                        for (int i = 0; i < cmdList.length; ++i) {
                            this.add(new EntityNode(this.mode, cmdList[i].cmd_name));
                        }
                        break;
                    }
                    case 8: {
                        AttributeInfo[] ainb = ds.get_attribute_info();
                        for (int i = 0; i < ainb.length; ++i) {
                            if (ainb[i].data_format.value() == 0 && ainb[i].data_type == 1) {
                                this.add(new EntityNode(this.mode, ainb[i].name));
                            }
                            if (ainb[i].data_format.value() != 0) continue;
                            switch (ainb[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    this.add(new EntityNode(this.mode, ainb[i].name));
                                }
                            }
                        }
                        ainb = null;
                        break;
                    }
                    case 9: {
                        AttributeInfo[] ainbs = ds.get_attribute_info();
                        for (int i = 0; i < ainbs.length; ++i) {
                            if (ainbs[i].data_format.value() == 0) {
                                switch (ainbs[i].data_type) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 21: 
                                    case 22: 
                                    case 23: 
                                    case 24: {
                                        this.add(new EntityNode(this.mode, ainbs[i].name));
                                    }
                                }
                            }
                            if (ainbs[i].data_format.value() != 1) continue;
                            switch (ainbs[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    int maxx = ainbs[i].max_dim_x;
                                    if (maxx > 1024) {
                                        maxx = 1024;
                                    }
                                    this.add(new SpectrumItemNode(this.mode, ainbs[i].name, maxx));
                                }
                            }
                        }
                        ainbs = null;
                        break;
                    }
                    case 10: {
                        AttributeInfo[] ainbss = ds.get_attribute_info();
                        for (int i = 0; i < ainbss.length; ++i) {
                            if (ainbss[i].data_format.value() == 0) {
                                switch (ainbss[i].data_type) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 19: 
                                    case 21: 
                                    case 22: 
                                    case 23: 
                                    case 24: {
                                        this.add(new EntityNode(this.mode, ainbss[i].name));
                                    }
                                }
                            }
                            if (ainbss[i].data_format.value() != 1) continue;
                            switch (ainbss[i].data_type) {
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    int maxx = ainbss[i].max_dim_x;
                                    if (maxx > 1024) {
                                        maxx = 1024;
                                    }
                                    this.add(new SpectrumItemNode(this.mode, ainbss[i].name, maxx));
                                }
                            }
                        }
                        ainbss = null;
                    }
                }
            }
            catch (ConnectionException e) {
                ErrorPane.showErrorMessage(null, devName, e);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        return this.mode == 0;
    }

    @Override
    public String toString() {
        return this.member;
    }
}

