/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.AdvancedImagePlus;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.MaskUndoableEdit;
import fr.esrf.tangoatk.widget.util.RoiDefaultUndoableEdit;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.Toolbar;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.LineBorder;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class JImageJ
extends JPanel
implements ActionListener {
    protected BufferedImage theImage = null;
    protected Insets margin;
    protected int xOrg;
    protected int yOrg;
    protected boolean snapToGrid;
    protected int grid = 16;
    protected JLAxis xAxis;
    protected int xAxisHeight;
    protected int xAxisUpMargin;
    protected JLAxis yAxis;
    protected int yAxisWidth;
    protected int yAxisRightMargin;
    protected boolean crossCursor = false;
    protected Color cursorColor = Color.WHITE;
    protected int xCursor = -1;
    protected int yCursor = -1;
    protected Color roiColor = Color.RED;
    protected Color roiSelectionColor = Color.BLACK;
    protected Color roiInsideColor = Color.MAGENTA;
    protected Color roiInsideSelectionColor = new Color(255, 100, 255);
    protected Color roiOutsideColor = new Color(0, 200, 0);
    protected Color roiOutsideSelectionColor = Color.GREEN;
    protected AdvancedImagePlus imp;
    protected RenderedImageCanvas canvas;
    protected ImageJ hiddenIJ;
    protected CanvasRenderer canvasRenderer;
    protected JScrollPane imagePane;
    protected JPanel toolbarPanel;
    protected ButtonGroup buttonGroup;
    protected JToggleButton rectangleButton;
    protected JToggleButton ellipseButton;
    protected JToggleButton freeHandButton;
    protected JToggleButton polygonButton;
    protected JToggleButton lineButton;
    protected JToggleButton angleButton;
    protected JToggleButton wandButton;
    protected JToggleButton zoomButton;
    protected JToggleButton handButton;
    protected JToggleButton arrowButton;
    protected JButton clearButton;
    protected JButton deleteButton;
    protected JToggleButton selectedButton;
    protected JButton innerButton;
    protected JButton outerButton;
    protected JButton maskButton;
    protected JButton invalidateButton;
    protected JButton resetButton;
    protected JButton intersectionButton;
    protected JButton unionButton;
    protected JButton substractButton;
    protected JButton xorButton;
    protected JButton undoButton;
    protected JButton redoButton;
    protected String rectangleTitle = "Rectangle ROI";
    protected String ellipseTitle = "Ellipse ROI";
    protected String freeHandTitle = "Free Draw ROI";
    protected String polygonTitle = "Polygon ROI";
    protected String lineTitle = "Line";
    protected String angleTitle = "Angle";
    protected String wandTitle = "Color Zone ROI";
    protected String zoomTitle = "Zoom";
    protected String handTitle = "Scroll Image";
    protected String selectionTitle = "Selection Mode";
    protected String deleteTitle = "Delete Selected ROI";
    protected String deleteUndoRedoTitle = "ROI deletion";
    protected String clearTitle = "Delete All ROIs";
    protected String clearUndoRedoTitle = "ROI deletion";
    protected String innerTitle = "Interior ROI";
    protected String outerTitle = "Exterior ROI";
    protected String maskTitle = "Apply Mask";
    protected String maskUndoRedoTitle = "mask";
    protected String invalidateTitle = "Invalidate ROI";
    protected String resetTitle = "Reset Image";
    protected String resetUndoRedoTitle = "Reset Image";
    protected String intersectionTitle = "ROI intersection";
    protected String intersectionUndoRedoTitle = "intersection";
    protected String unionTitle = "ROI union";
    protected String unionUndoRedoTitle = "union";
    protected String substractTitle = "ROI substraction";
    protected String substractUndoRedoTitle = "substraction";
    protected String xorTitle = "ROI xor";
    protected String xorUndoRedoTitle = "xor";
    protected String undoTitle = "Undo";
    protected String redoTitle = "Redo";
    protected UndoManager undoManager = new UndoManager();
    protected static final int undoLimit = 1;
    protected String ignoreROITitle;
    protected String ignoreROIMessage;
    protected String ignoreROIContinueMessage;
    protected String deleteAllROIsTitle;
    protected String deleteAllROIsMessage;
    protected static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public JImageJ() {
        this.undoManager.setLimit(1);
        this.initMessages();
        this.hiddenIJ = new ImageJ(){

            @Override
            public void show() {
            }

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    super.setVisible(b);
                }
            }
        };
        this.imp = new AdvancedImagePlus();
        this.initCanvasRenderer();
        this.canvas = new RenderedImageCanvas(this.imp);
        this.canvas.removeMouseListener(this.canvas);
        this.canvas.removeMouseMotionListener(this.canvas);
        this.imagePane = new JScrollPane(this.canvasRenderer);
        new HiddenWindow(this.imp, this.canvas);
        this.setLayout(new GridBagLayout());
        this.initToolbar();
        GridBagConstraints toolbarConstraints = new GridBagConstraints();
        toolbarConstraints.fill = 2;
        toolbarConstraints.gridx = 0;
        toolbarConstraints.gridy = 0;
        toolbarConstraints.weightx = 1.0;
        toolbarConstraints.weighty = 0.0;
        this.add((Component)this.toolbarPanel, toolbarConstraints);
        GridBagConstraints canvasConstraints = new GridBagConstraints();
        canvasConstraints.fill = 1;
        canvasConstraints.gridx = 0;
        canvasConstraints.gridy = 1;
        canvasConstraints.weightx = 1.0;
        canvasConstraints.weighty = 1.0;
        this.add((Component)this.imagePane, canvasConstraints);
        Toolbar.getInstance().setEnabled(true);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.xOrg = 5;
        this.yOrg = 5;
        this.snapToGrid = false;
        this.yAxis = new JLAxis(this.canvasRenderer, 6);
        this.yAxis.setAxisColor(Color.BLACK);
        this.yAxis.setFont(ATKConstant.labelFont);
        this.yAxis.setAutoScale(false);
        this.yAxis.setMinimum(0.0);
        this.yAxis.setMaximum(100.0);
        this.yAxis.setVisible(false);
        this.yAxis.setInverted(false);
        this.xAxis = new JLAxis(this.canvasRenderer, 2);
        this.xAxis.setAxisColor(Color.BLACK);
        this.xAxis.setFont(ATKConstant.labelFont);
        this.xAxis.setAutoScale(false);
        this.xAxis.setMinimum(0.0);
        this.xAxis.setMaximum(100.0);
        this.xAxis.setVisible(false);
        Roi.setColor(this.roiColor);
    }

    protected void initCanvasRenderer() {
        this.canvasRenderer = new CanvasRenderer();
    }

    protected void initToolbar() {
        this.toolbarPanel = new JPanel();
        this.toolbarPanel.setBackground(this.getBackground());
        Dimension preferredSize = new Dimension(414, 18);
        this.toolbarPanel.setPreferredSize(preferredSize);
        this.toolbarPanel.setMinimumSize(preferredSize);
        preferredSize = null;
        this.toolbarPanel.setLayout(null);
        this.rectangleButton = new JToggleButton();
        this.rectangleButton.setMargin(NO_MARGIN);
        this.rectangleButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.rectangleButton.setToolTipText(this.rectangleTitle);
        this.rectangleButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/rectangle.gif")));
        this.rectangleButton.addActionListener(this);
        this.rectangleButton.setBounds(0, 0, 18, 18);
        this.rectangleButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.rectangleButton);
        this.ellipseButton = new JToggleButton();
        this.ellipseButton.setMargin(NO_MARGIN);
        this.ellipseButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.ellipseButton.setToolTipText(this.ellipseTitle);
        this.ellipseButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/ellipse.gif")));
        this.ellipseButton.addActionListener(this);
        this.ellipseButton.setBounds(18, 0, 18, 18);
        this.ellipseButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.ellipseButton);
        this.polygonButton = new JToggleButton();
        this.polygonButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.polygonButton.setMargin(NO_MARGIN);
        this.polygonButton.setToolTipText(this.polygonTitle);
        this.polygonButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/polygon.gif")));
        this.polygonButton.addActionListener(this);
        this.polygonButton.setBounds(36, 0, 18, 18);
        this.polygonButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.polygonButton);
        this.freeHandButton = new JToggleButton();
        this.freeHandButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.freeHandButton.setMargin(NO_MARGIN);
        this.freeHandButton.setToolTipText(this.freeHandTitle);
        this.freeHandButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/freeHand.gif")));
        this.freeHandButton.addActionListener(this);
        this.freeHandButton.setBounds(54, 0, 18, 18);
        this.freeHandButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.freeHandButton);
        this.lineButton = new JToggleButton();
        this.lineButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.lineButton.setMargin(NO_MARGIN);
        this.lineButton.setToolTipText(this.lineTitle);
        this.lineButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/line.gif")));
        this.lineButton.addActionListener(this);
        this.lineButton.setBounds(72, 0, 18, 18);
        this.lineButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.lineButton);
        this.angleButton = new JToggleButton();
        this.angleButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.angleButton.setMargin(NO_MARGIN);
        this.angleButton.setToolTipText(this.angleTitle);
        this.angleButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/angle.gif")));
        this.angleButton.addActionListener(this);
        this.angleButton.setBounds(90, 0, 18, 18);
        this.angleButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.angleButton);
        this.wandButton = new JToggleButton();
        this.wandButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.wandButton.setMargin(NO_MARGIN);
        this.wandButton.setToolTipText(this.wandTitle);
        this.wandButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/wand.gif")));
        this.wandButton.addActionListener(this);
        this.wandButton.setBounds(108, 0, 18, 18);
        this.wandButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.wandButton);
        this.zoomButton = new JToggleButton();
        this.zoomButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.zoomButton.setMargin(NO_MARGIN);
        this.zoomButton.setToolTipText(this.zoomTitle);
        this.zoomButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/zoom.gif")));
        this.zoomButton.addActionListener(this);
        this.zoomButton.setBounds(126, 0, 18, 18);
        this.zoomButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.zoomButton);
        this.handButton = new JToggleButton();
        this.handButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.handButton.setMargin(NO_MARGIN);
        this.handButton.setToolTipText(this.handTitle);
        this.handButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/hand.gif")));
        this.handButton.addActionListener(this);
        this.handButton.setBounds(144, 0, 18, 18);
        this.handButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.handButton);
        this.arrowButton = new JToggleButton();
        this.arrowButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.arrowButton.setMargin(NO_MARGIN);
        this.arrowButton.setToolTipText(this.selectionTitle);
        this.arrowButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/arrow.gif")));
        this.arrowButton.addActionListener(this);
        this.arrowButton.setBounds(162, 0, 18, 18);
        this.arrowButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.arrowButton);
        this.deleteButton = new JButton();
        this.deleteButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.deleteButton.setMargin(NO_MARGIN);
        this.deleteButton.setToolTipText(this.deleteTitle);
        this.deleteButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/delete.gif")));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setBounds(180, 0, 18, 18);
        this.deleteButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.deleteButton);
        this.clearButton = new JButton();
        this.clearButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.clearButton.setMargin(NO_MARGIN);
        this.clearButton.setToolTipText(this.clearTitle);
        this.clearButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/clear.gif")));
        this.clearButton.addActionListener(this);
        this.clearButton.setBounds(198, 0, 18, 18);
        this.clearButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.clearButton);
        this.innerButton = new JButton();
        this.innerButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.innerButton.setMargin(NO_MARGIN);
        this.innerButton.setToolTipText(this.innerTitle);
        this.innerButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/interiorRoi.png")));
        this.innerButton.addActionListener(this);
        this.innerButton.setBounds(216, 0, 18, 18);
        this.innerButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.innerButton);
        this.outerButton = new JButton();
        this.outerButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.outerButton.setMargin(NO_MARGIN);
        this.outerButton.setToolTipText(this.outerTitle);
        this.outerButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/exteriorRoi.png")));
        this.outerButton.addActionListener(this);
        this.outerButton.setBounds(234, 0, 18, 18);
        this.outerButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.outerButton);
        this.maskButton = new JButton();
        this.maskButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.maskButton.setMargin(NO_MARGIN);
        this.maskButton.setToolTipText(this.maskTitle);
        this.maskButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/mask.gif")));
        this.maskButton.addActionListener(this);
        this.maskButton.setBounds(252, 0, 18, 18);
        this.maskButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.maskButton);
        this.invalidateButton = new JButton();
        this.invalidateButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.invalidateButton.setMargin(NO_MARGIN);
        this.invalidateButton.setToolTipText(this.invalidateTitle);
        this.invalidateButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/invalidate.gif")));
        this.invalidateButton.addActionListener(this);
        this.invalidateButton.setBounds(270, 0, 18, 18);
        this.invalidateButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.invalidateButton);
        this.resetButton = new JButton();
        this.resetButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.resetButton.setMargin(NO_MARGIN);
        this.resetButton.setToolTipText(this.resetTitle);
        this.resetButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/reset.gif")));
        this.resetButton.addActionListener(this);
        this.resetButton.setBounds(288, 0, 18, 18);
        this.resetButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.resetButton);
        this.intersectionButton = new JButton();
        this.intersectionButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.intersectionButton.setMargin(NO_MARGIN);
        this.intersectionButton.setToolTipText(this.intersectionTitle);
        this.intersectionButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/intersection.gif")));
        this.intersectionButton.addActionListener(this);
        this.intersectionButton.setBounds(306, 0, 18, 18);
        this.intersectionButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.intersectionButton);
        this.unionButton = new JButton();
        this.unionButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.unionButton.setMargin(NO_MARGIN);
        this.unionButton.setToolTipText(this.unionTitle);
        this.unionButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/union.gif")));
        this.unionButton.addActionListener(this);
        this.unionButton.setBounds(324, 0, 18, 18);
        this.unionButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.unionButton);
        this.substractButton = new JButton();
        this.substractButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.substractButton.setMargin(NO_MARGIN);
        this.substractButton.setToolTipText(this.substractTitle);
        this.substractButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/substract.gif")));
        this.substractButton.addActionListener(this);
        this.substractButton.setBounds(342, 0, 18, 18);
        this.substractButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.substractButton);
        this.xorButton = new JButton();
        this.xorButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.xorButton.setMargin(NO_MARGIN);
        this.xorButton.setToolTipText(this.xorTitle);
        this.xorButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/xor.gif")));
        this.xorButton.addActionListener(this);
        this.xorButton.setBounds(360, 0, 18, 18);
        this.xorButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.xorButton);
        this.undoButton = new JButton();
        this.undoButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.undoButton.setMargin(NO_MARGIN);
        this.undoButton.setToolTipText(this.undoTitle);
        this.undoButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/undo.gif")));
        this.undoButton.addActionListener(this);
        this.undoButton.setBounds(378, 0, 18, 18);
        this.undoButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.undoButton);
        this.redoButton = new JButton();
        this.redoButton.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.redoButton.setMargin(NO_MARGIN);
        this.redoButton.setToolTipText(this.redoTitle);
        this.redoButton.setIcon(new ImageIcon(JImage.class.getResource("/fr/esrf/tangoatk/widget/util/redo.gif")));
        this.redoButton.addActionListener(this);
        this.redoButton.setBounds(396, 0, 18, 18);
        this.redoButton.setBackground(Color.WHITE);
        this.toolbarPanel.add(this.redoButton);
        this.updateUndoRedoButtons();
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rectangleButton);
        this.buttonGroup.add(this.ellipseButton);
        this.buttonGroup.add(this.polygonButton);
        this.buttonGroup.add(this.freeHandButton);
        this.buttonGroup.add(this.lineButton);
        this.buttonGroup.add(this.angleButton);
        this.buttonGroup.add(this.wandButton);
        this.buttonGroup.add(this.zoomButton);
        this.buttonGroup.add(this.handButton);
        this.buttonGroup.add(this.arrowButton);
        this.rectangleButton.doClick();
    }

    protected void updateUndoRedoButtons() {
        String presentation = this.undoManager.getUndoPresentationName();
        if (presentation != null && !"".equals(presentation.trim())) {
            this.undoButton.setToolTipText(presentation);
        }
        this.undoButton.setEnabled(this.undoManager.canUndo());
        presentation = this.undoManager.getRedoPresentationName();
        if (presentation != null && !"".equals(presentation.trim())) {
            this.redoButton.setToolTipText(presentation);
        }
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    protected void initMessages() {
        this.ignoreROITitle = "Warning! ROI ignored";
        this.ignoreROIMessage = "The following ROI will be ignored:\n";
        this.ignoreROIContinueMessage = "Do you wish to continue ?";
        this.deleteAllROIsTitle = "Please confirm action";
        this.deleteAllROIsMessage = "Delete all ROIs ?";
    }

    public void setMargin(Insets i) {
        this.margin = i;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public AdvancedImagePlus getImagePlus() {
        return this.imp;
    }

    protected void measureAxis() {
        this.xAxisHeight = 0;
        this.yAxisWidth = 0;
        this.xAxisUpMargin = this.xAxis.getThickness();
        this.yAxisRightMargin = this.xAxis.getFontOverWidth() - 1;
        Dimension imageSize = this.canvas.getPreferredSize();
        int imageWidth = imageSize.width;
        int imageHeight = imageSize.height;
        imageSize = null;
        if (this.xAxis.isVisible()) {
            this.xAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), imageWidth, 0);
            this.xAxisHeight = this.xAxis.getThickness();
        }
        if (this.yAxis.isVisible()) {
            this.yAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, imageHeight);
            this.yAxisWidth = this.yAxis.getThickness();
        }
    }

    protected void paintAxis(Graphics g) {
        Dimension imageSize = this.canvas.getPreferredSize();
        int imageWidth = imageSize.width;
        int imageHeight = imageSize.height;
        imageSize = null;
        if (this.yAxis.isVisible()) {
            if (this.yAxis.getOrientation() == 5) {
                this.yAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), imageWidth - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            } else {
                this.yAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), imageWidth - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            }
        }
        if (this.xAxis.isVisible()) {
            if (this.xAxis.getOrientation() == 2) {
                this.xAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, imageHeight, Color.BLACK, 0, 0);
                }
            } else {
                this.xAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, imageHeight, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                }
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension toolbarSize = this.toolbarPanel.getPreferredSize();
        int toolbarWidth = toolbarSize.width;
        return new Dimension(toolbarWidth, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JToggleButton) {
            this.selectedButton = (JToggleButton)e.getSource();
            this.canvas.setSelectionMode(e.getSource() == this.arrowButton);
        }
        if (e.getSource() == this.rectangleButton) {
            Toolbar.getInstance().setTool(0);
            this.imp.setHandledRoi(null);
        } else if (e.getSource() == this.ellipseButton) {
            Toolbar.getInstance().setTool(1);
        } else if (e.getSource() == this.polygonButton) {
            Toolbar.getInstance().setTool(2);
        } else if (e.getSource() == this.freeHandButton) {
            Toolbar.getInstance().setTool(3);
        } else if (e.getSource() == this.lineButton) {
            Toolbar.getInstance().setTool(4);
        } else if (e.getSource() == this.angleButton) {
            Toolbar.getInstance().setTool(14);
        } else if (e.getSource() == this.wandButton) {
            Toolbar.getInstance().setTool(8);
        } else if (e.getSource() == this.zoomButton) {
            Toolbar.getInstance().setTool(11);
        } else if (e.getSource() == this.handButton) {
            Toolbar.getInstance().setTool(12);
        } else if (e.getSource() == this.arrowButton) {
            Toolbar.getInstance().setTool(0);
        } else if (e.getSource() == this.deleteButton) {
            this.deleteSelectedRois();
        } else if (e.getSource() == this.clearButton) {
            this.deleteAllROIs();
        } else if (e.getSource() == this.innerButton) {
            this.setSelectedRoisAsInner();
        } else if (e.getSource() == this.outerButton) {
            this.setSelectedRoisAsOuter();
        } else if (e.getSource() == this.maskButton) {
            this.applyMask();
        } else if (e.getSource() == this.invalidateButton) {
            this.invalidateROI();
        } else if (e.getSource() == this.resetButton) {
            this.resetMask();
        } else if (e.getSource() == this.intersectionButton) {
            this.intersectROIs();
        } else if (e.getSource() == this.unionButton) {
            this.unifyROIs();
        } else if (e.getSource() == this.substractButton) {
            this.substractROIs();
        } else if (e.getSource() == this.xorButton) {
            this.xorROIs();
        } else if (e.getSource() == this.undoButton) {
            this.undo();
        } else if (e.getSource() == this.redoButton) {
            this.redo();
        }
        this.canvasRenderer.grabFocus();
        this.repaint();
    }

    public Toolbar getToolbar() {
        return Toolbar.getInstance();
    }

    public void setImage(BufferedImage i) {
        if (this.theImage != i) {
            BufferedImage formerImage = this.theImage;
            this.theImage = i;
            this.imp.killRoi();
            this.imp.setWindow(null);
            if (this.theImage != null) {
                this.imp.setImage(this.theImage);
            }
            if (formerImage != null) {
                formerImage.flush();
                formerImage = null;
            }
            boolean selectionMode = false;
            if (this.canvas != null) {
                selectionMode = this.canvas.isSelectionMode();
            }
            this.canvas = new RenderedImageCanvas(this.imp);
            this.canvas.removeMouseListener(this.canvas);
            this.canvas.removeMouseMotionListener(this.canvas);
            this.canvas.setSelectionMode(selectionMode);
            new HiddenWindow(this.imp, this.canvas);
            this.revalidate();
            this.repaint();
        }
    }

    public void refreshImage() {
        if (this.imp != null && this.theImage != null) {
            Image formerImage = this.imp.getImage();
            Roi formerRoi = this.imp.getRoi();
            this.imp.setImage(this.theImage);
            this.imp.setRoi(formerRoi);
            if (formerImage != null) {
                formerImage.flush();
                Object var1_1 = null;
            }
        }
        this.repaint();
    }

    public void setZoom(double zoom) {
        if (this.canvas != null) {
            this.canvas.computeZoom(zoom);
            this.canvasRenderer.revalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public void setZoomRoi(Roi zoomRoi) {
        if (this.canvas != null) {
            this.canvas.computeZoom(zoomRoi);
            this.imp.removeRoi(zoomRoi);
        }
    }

    public void setSelectionRoi(Roi selectionRoi) {
        this.imp.getSelectedRois().clear();
        this.imp.setValidatedRoi(null);
        if (selectionRoi != null) {
            this.imp.removeRoi(selectionRoi);
            Rectangle selectionBounds = selectionRoi.getBounds();
            for (int i = 0; i < this.imp.getAllRois().size(); ++i) {
                Roi roi = this.imp.getAllRois().get(i);
                Rectangle roiBounds = roi.getBounds();
                if (!selectionBounds.contains(roiBounds)) continue;
                this.imp.getSelectedRois().add(roi);
                if (!this.imp.getInnerRois().contains(roi) && !this.imp.getOuterRois().contains(roi)) continue;
                if (this.imp.getValidatedRoi() != null) {
                    this.imp.getSelectedRois().remove(this.imp.getValidatedRoi());
                }
                this.imp.setValidatedRoi(roi);
            }
        }
    }

    public double getZoom() {
        if (this.canvas == null) {
            return 1.0;
        }
        return this.canvas.getMagnification();
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getYAxis() {
        return this.yAxis;
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public Dimension getImageSize() {
        if (this.theImage != null) {
            return new Dimension(this.theImage.getWidth(), this.theImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public int getXOrigin() {
        return this.xOrg + this.yAxis.getThickness();
    }

    public int getYOrigin() {
        return this.yOrg + this.xAxisUpMargin;
    }

    public Point[] getSelectionPoint() {
        if (this.imp != null && this.imp.getSelectedRois() != null) {
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (!(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                Line line = (Line)this.imp.getSelectedRois().get(i);
                Point[] ret = new Point[]{new Point(line.x1, line.y1), new Point(line.x2, line.y2)};
                line = null;
                return ret;
            }
        }
        return null;
    }

    public Rectangle getCurrentRoiBounds() {
        Roi roi;
        if (this.imp != null && this.imp.getRoi() != null && (roi = this.imp.getRoi()) != null) {
            return roi.getBounds();
        }
        return null;
    }

    public void deleteAllROIs() {
        int ok;
        if (this.imp != null && (ok = JOptionPane.showConfirmDialog(this, this.deleteAllROIsMessage, this.deleteAllROIsTitle, 0)) == 0) {
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            this.imp.killRoi();
            this.imp.getAllRois().clear();
            this.imp.getInnerRois().clear();
            this.imp.getOuterRois().clear();
            this.imp.setValidatedRoi(null);
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.clearTitle));
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.revalidate();
            this.repaint();
        }
    }

    public void deleteSelectedRois() {
        if (this.imp != null) {
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            this.imp.deleteSelectedRois();
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.deleteUndoRedoTitle));
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.revalidate();
            this.repaint();
        }
    }

    public void setSelectedRoisAsInner() {
        Vector<Roi> selectedRois = this.imp.getSelectedRois();
        Vector<Roi> innerRois = this.imp.getInnerRois();
        if (selectedRois != null && innerRois != null) {
            for (int i = 0; i < selectedRois.size(); ++i) {
                if (innerRois.contains(selectedRois.get(i))) continue;
                innerRois.add(selectedRois.get(i));
                if (selectedRois.get(i) == this.imp.getRoi()) {
                    this.imp.setHandledRoi(null);
                }
                if (this.imp.getOuterRois() != null) {
                    this.imp.getOuterRois().remove(selectedRois.get(i));
                }
                if (i != selectedRois.size() - 1) continue;
                this.imp.setValidatedRoi(selectedRois.get(i));
            }
            selectedRois.clear();
            this.imp.getSelectedRois().add(this.imp.getValidatedRoi());
        }
        this.repaint();
    }

    public void setSelectedRoisAsOuter() {
        Vector<Roi> selectedRois = this.imp.getSelectedRois();
        Vector<Roi> outerRois = this.imp.getOuterRois();
        if (selectedRois != null && outerRois != null) {
            for (int i = 0; i < selectedRois.size(); ++i) {
                if (outerRois.contains(selectedRois.get(i))) continue;
                outerRois.add(selectedRois.get(i));
                if (selectedRois.get(i) == this.imp.getRoi()) {
                    this.imp.setHandledRoi(null);
                }
                if (this.imp.getInnerRois() != null) {
                    this.imp.getInnerRois().remove(selectedRois.get(i));
                }
                if (i != selectedRois.size() - 1) continue;
                this.imp.setValidatedRoi(selectedRois.get(i));
            }
            selectedRois.clear();
            this.imp.getSelectedRois().add(this.imp.getValidatedRoi());
        }
        this.repaint();
    }

    public void applyMask() {
        if (this.imp.getValidatedRoi() != null && this.getImage() != null) {
            ImageProcessor undoProcessor = this.imp.getProcessor();
            Roi roi = this.imp.getValidatedRoi();
            ColorProcessor ip = new ColorProcessor(this.getImage());
            this.imp.setHandledRoi(roi);
            ip.setRoi(roi);
            ((ImageProcessor)ip).setColor(Toolbar.getBackgroundColor());
            Rectangle bounds = roi.getBounds();
            Dimension size = this.getImageSize();
            int roiX = Math.max(bounds.x, 0);
            if (size.width > 0 && roiX > size.width - 1) {
                roiX = size.width - 1;
            }
            int roiY = Math.max(bounds.y, 0);
            if (size.height > 0 && roiY > size.height - 1) {
                roiY = size.height - 1;
            }
            int roiWidth = Math.min(size.width - roiX, bounds.x + bounds.width - roiX);
            int roiHeight = Math.min(size.height - roiY, bounds.y + bounds.height - roiY);
            bounds.x = roiX;
            bounds.y = roiY;
            bounds.width = roiWidth;
            bounds.height = roiHeight;
            if (this.imp.getOuterRois().contains(roi)) {
                ((ImageProcessor)ip).fill(roi.getMask());
            } else {
                ip.setRoi(0, 0, bounds.x, this.imp.getHeight());
                ((ImageProcessor)ip).fill();
                ip.setRoi(bounds.x, 0, bounds.width, bounds.y);
                ((ImageProcessor)ip).fill();
                ip.setRoi(bounds.x + bounds.width, 0, this.imp.getWidth() - bounds.x - bounds.width, this.imp.getHeight());
                ((ImageProcessor)ip).fill();
                ip.setRoi(bounds.x, bounds.y + bounds.height, bounds.width, this.imp.getHeight() - bounds.y - bounds.height);
                ((ImageProcessor)ip).fill();
                for (int x = 0; x < bounds.width; ++x) {
                    for (int y = 0; y < bounds.height; ++y) {
                        if (roi.contains(x + bounds.x, y + bounds.y)) continue;
                        ((ImageProcessor)ip).drawPixel(x + bounds.x, y + bounds.y);
                    }
                }
            }
            size = null;
            ((ImageProcessor)ip).setColor(Toolbar.getForegroundColor());
            this.imp.setProcessor(null, ip);
            this.undoManager.addEdit(new MaskUndoableEdit(this.imp, undoProcessor, this.maskUndoRedoTitle));
            undoProcessor = null;
            this.updateUndoRedoButtons();
            this.repaint();
            if (this.imp.getRoi() == roi) {
                this.imp.setHandledRoi(null);
            }
        }
    }

    public void resetMask() {
        if (this.imp != null && this.theImage != null) {
            ImageProcessor undoProcessor = this.imp.getProcessor();
            this.refreshImage();
            this.undoManager.addEdit(new MaskUndoableEdit(this.imp, undoProcessor, this.resetUndoRedoTitle));
            undoProcessor = null;
            this.updateUndoRedoButtons();
        }
    }

    public void invalidateROI() {
        Roi roi = this.imp.getValidatedRoi();
        if (roi != null) {
            this.imp.getInnerRois().remove(roi);
            this.imp.getOuterRois().remove(roi);
            this.imp.setValidatedRoi(null);
        }
        this.repaint();
    }

    public void setSelection(int _x1, int _y1, int _x2, int _y2) {
        if (this.imp != null) {
            this.imp.getAllRois().clear();
            Roi roi = new Roi(_x1, _y1, _x2 - _x1, _y2 - _y1);
            this.imp.setRoi(roi);
        }
    }

    public int transformX(int x) {
        if (this.canvas == null) {
            return x;
        }
        return this.canvas.offScreenX(x);
    }

    public int transformY(int y) {
        if (this.canvas == null) {
            return y;
        }
        return this.canvas.offScreenY(y);
    }

    protected boolean canCombineROIs() {
        int ok = 1;
        int selectionCount = this.imp.getSelectedRois().size();
        Roi validatedRoi = this.imp.getValidatedRoi();
        Vector<Integer> indexVector = new Vector<Integer>();
        if (selectionCount > 1) {
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != validatedRoi && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                indexVector.add(new Integer(i + 1));
                --selectionCount;
            }
            if (indexVector.size() == 0) {
                ok = 0;
            } else if (selectionCount > 1) {
                StringBuffer messageBuffer = new StringBuffer(this.ignoreROIMessage);
                messageBuffer.append(indexVector.get(0));
                for (int i = 1; i < indexVector.size(); ++i) {
                    messageBuffer.append(", ");
                    messageBuffer.append(indexVector.get(i));
                }
                messageBuffer.append("\n");
                messageBuffer.append(this.ignoreROIContinueMessage);
                ok = JOptionPane.showConfirmDialog(this, messageBuffer.toString(), this.ignoreROITitle, 0);
                messageBuffer = null;
            }
        }
        validatedRoi = null;
        return ok == 0;
    }

    public void intersectROIs() {
        if (this.canCombineROIs()) {
            Roi firstRoi;
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            Vector<Roi> ignoredRoi = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                ignoredRoi.add(this.imp.getSelectedRois().get(i));
            }
            if (ignoredRoi.size() > 0) {
                this.imp.getSelectedRois().removeAll(ignoredRoi);
            }
            ShapeRoi mainShape = (firstRoi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)firstRoi : new ShapeRoi(firstRoi);
            firstRoi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roiToCombine = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeToCombine = roiToCombine instanceof ShapeRoi ? (ShapeRoi)roiToCombine : new ShapeRoi(roiToCombine);
                roiToCombine = null;
                mainShape = mainShape.and(shapeToCombine);
                shapeToCombine = null;
                if (mainShape == null) break;
                Rectangle mainShapeBounds = mainShape.getBounds();
                if (mainShapeBounds.width == 0 || mainShapeBounds.height == 0) {
                    mainShape = null;
                    mainShapeBounds = null;
                    break;
                }
                mainShapeBounds = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi((Roi)null);
            this.imp.getSelectedRois().addAll(ignoredRoi);
            if (mainShape != null) {
                this.imp.getSelectedRois().add(mainShape);
                this.imp.getAllRois().add(mainShape);
                this.imp.setRoi(mainShape);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.intersectionUndoRedoTitle));
            ignoredRoi.clear();
            ignoredRoi = null;
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void unifyROIs() {
        if (this.canCombineROIs()) {
            Roi firstRoi;
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            Vector<Roi> ignoredRoi = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                ignoredRoi.add(this.imp.getSelectedRois().get(i));
            }
            if (ignoredRoi.size() > 0) {
                this.imp.getSelectedRois().removeAll(ignoredRoi);
            }
            ShapeRoi mainShape = (firstRoi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)firstRoi : new ShapeRoi(firstRoi);
            firstRoi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roiToCombine = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeToCombine = roiToCombine instanceof ShapeRoi ? (ShapeRoi)roiToCombine : new ShapeRoi(roiToCombine);
                roiToCombine = null;
                mainShape = mainShape.or(shapeToCombine);
                shapeToCombine = null;
                if (mainShape == null) break;
                Rectangle mainShapeBounds = mainShape.getBounds();
                if (mainShapeBounds.width == 0 || mainShapeBounds.height == 0) {
                    mainShape = null;
                    mainShapeBounds = null;
                    break;
                }
                mainShapeBounds = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi((Roi)null);
            this.imp.getSelectedRois().addAll(ignoredRoi);
            if (mainShape != null) {
                this.imp.getSelectedRois().add(mainShape);
                this.imp.getAllRois().add(mainShape);
                this.imp.setRoi(mainShape);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.unionUndoRedoTitle));
            ignoredRoi.clear();
            ignoredRoi = null;
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void substractROIs() {
        if (this.canCombineROIs()) {
            Roi firstRoi;
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            Vector<Roi> ignoredRoi = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                ignoredRoi.add(this.imp.getSelectedRois().get(i));
            }
            if (ignoredRoi.size() > 0) {
                this.imp.getSelectedRois().removeAll(ignoredRoi);
            }
            ShapeRoi mainShape = (firstRoi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)firstRoi : new ShapeRoi(firstRoi);
            firstRoi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roiToCombine = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeToCombine = roiToCombine instanceof ShapeRoi ? (ShapeRoi)roiToCombine : new ShapeRoi(roiToCombine);
                roiToCombine = null;
                mainShape = mainShape.not(shapeToCombine);
                shapeToCombine = null;
                if (mainShape == null) break;
                Rectangle mainShapeBounds = mainShape.getBounds();
                if (mainShapeBounds.width == 0 || mainShapeBounds.height == 0) {
                    mainShape = null;
                    mainShapeBounds = null;
                    break;
                }
                mainShapeBounds = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi((Roi)null);
            this.imp.getSelectedRois().addAll(ignoredRoi);
            if (mainShape != null) {
                this.imp.getSelectedRois().add(mainShape);
                this.imp.getAllRois().add(mainShape);
                this.imp.setRoi(mainShape);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.substractUndoRedoTitle));
            ignoredRoi.clear();
            ignoredRoi = null;
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void xorROIs() {
        if (this.canCombineROIs()) {
            Roi firstRoi;
            Vector<Roi> undoRoiVector = new Vector<Roi>();
            undoRoiVector.addAll(this.imp.getAllRois());
            Vector<Roi> undoSelectedRois = new Vector<Roi>();
            undoSelectedRois.addAll(this.imp.getSelectedRois());
            Vector<Roi> undoInnerRois = new Vector<Roi>();
            undoInnerRois.addAll(this.imp.getInnerRois());
            Vector<Roi> undoOuterRois = new Vector<Roi>();
            undoOuterRois.addAll(this.imp.getOuterRois());
            Roi undoValidatedRoi = this.imp.getValidatedRoi();
            Roi undoHandledRoi = this.imp.getRoi();
            Vector<Roi> ignoredRoi = new Vector<Roi>();
            for (int i = 0; i < this.imp.getSelectedRois().size(); ++i) {
                if (this.imp.getSelectedRois().get(i) != this.imp.getValidatedRoi() && !(this.imp.getSelectedRois().get(i) instanceof Line)) continue;
                ignoredRoi.add(this.imp.getSelectedRois().get(i));
            }
            if (ignoredRoi.size() > 0) {
                this.imp.getSelectedRois().removeAll(ignoredRoi);
            }
            ShapeRoi mainShape = (firstRoi = this.imp.getSelectedRois().get(0)) instanceof ShapeRoi ? (ShapeRoi)firstRoi : new ShapeRoi(firstRoi);
            firstRoi = null;
            for (int i = 1; i < this.imp.getSelectedRois().size(); ++i) {
                Roi roiToCombine = this.imp.getSelectedRois().get(i);
                ShapeRoi shapeToCombine = roiToCombine instanceof ShapeRoi ? (ShapeRoi)roiToCombine : new ShapeRoi(roiToCombine);
                roiToCombine = null;
                mainShape = mainShape.xor(shapeToCombine);
                shapeToCombine = null;
                if (mainShape == null) break;
                Rectangle mainShapeBounds = mainShape.getBounds();
                if (mainShapeBounds.width == 0 || mainShapeBounds.height == 0) {
                    mainShape = null;
                    mainShapeBounds = null;
                    break;
                }
                mainShapeBounds = null;
            }
            this.imp.getAllRois().removeAll(this.imp.getSelectedRois());
            this.imp.getSelectedRois().clear();
            this.imp.setRoi((Roi)null);
            this.imp.getSelectedRois().addAll(ignoredRoi);
            if (mainShape != null) {
                this.imp.getSelectedRois().add(mainShape);
                this.imp.getAllRois().add(mainShape);
                this.imp.setRoi(mainShape);
            }
            this.undoManager.addEdit(new RoiDefaultUndoableEdit(this.imp, undoRoiVector, undoSelectedRois, undoInnerRois, undoOuterRois, undoValidatedRoi, undoHandledRoi, this.xorUndoRedoTitle));
            ignoredRoi.clear();
            ignoredRoi = null;
            undoRoiVector = null;
            undoSelectedRois = null;
            undoInnerRois = null;
            undoOuterRois = null;
            undoValidatedRoi = null;
            undoHandledRoi = null;
            this.updateUndoRedoButtons();
            this.canvasRenderer.repaint();
        }
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
        this.updateUndoRedoButtons();
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            try {
                this.undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
        this.updateUndoRedoButtons();
    }

    public Color getRoiColor() {
        return this.roiColor;
    }

    public void setRoiColor(Color selectionColor) {
        this.roiColor = selectionColor;
        Roi.setColor(selectionColor);
    }

    public Color getRoiSelectionColor() {
        return this.roiSelectionColor;
    }

    public void setRoiSelectionColor(Color roiSelectionColor) {
        this.roiSelectionColor = roiSelectionColor;
    }

    public Color getRoiInsideColor() {
        return this.roiInsideColor;
    }

    public void setRoiInsideColor(Color roiInsideColor) {
        this.roiInsideColor = roiInsideColor;
    }

    public Color getRoiInsideSelectionColor() {
        return this.roiInsideSelectionColor;
    }

    public void setRoiInsideSelectionColor(Color roiInsideSelectionColor) {
        this.roiInsideSelectionColor = roiInsideSelectionColor;
    }

    public Color getRoiOutsideColor() {
        return this.roiOutsideColor;
    }

    public void setRoiOutsideColor(Color roiOutsideColor) {
        this.roiOutsideColor = roiOutsideColor;
    }

    public Color getRoiOutsideSelectionColor() {
        return this.roiOutsideSelectionColor;
    }

    public void setRoiOutsideSelectionColor(Color roiOutsideSelectionColor) {
        this.roiOutsideSelectionColor = roiOutsideSelectionColor;
    }

    public JComponent getImageRenderer() {
        return this.canvasRenderer;
    }

    public JScrollPane getImagePane() {
        return this.imagePane;
    }

    public String getIgnoreROITitle() {
        return this.ignoreROITitle;
    }

    public void setIgnoreROITitle(String ignoreROITitle) {
        this.ignoreROITitle = ignoreROITitle;
    }

    public void setIgnoreValidatedROITitle(String ignoreValidatedROITitle) {
        this.ignoreROITitle = ignoreValidatedROITitle;
    }

    public String getIgnoreROIMessage() {
        return this.ignoreROIMessage;
    }

    public void setIgnoreValidatedROIMessage(String ignoreValidatedROIMessage) {
        this.ignoreROIMessage = ignoreValidatedROIMessage;
    }

    public String getIgnoreROIContinueMessage() {
        return this.ignoreROIContinueMessage;
    }

    public void setIgnoreValidatedROIContinueMessage(String ignoreValidatedROIContinueMessage) {
        this.ignoreROIContinueMessage = ignoreValidatedROIContinueMessage;
    }

    public String getDeleteAllROIsTitle() {
        return this.deleteAllROIsTitle;
    }

    public void setDeleteAllROIsTitle(String deleteAllROIsTitle) {
        this.deleteAllROIsTitle = deleteAllROIsTitle;
    }

    public String getDeleteAllROIsMessage() {
        return this.deleteAllROIsMessage;
    }

    public void setDeleteAllROIsMessage(String deleteAllROIsMessage) {
        this.deleteAllROIsMessage = deleteAllROIsMessage;
    }

    public JPanel getToolbarPanel() {
        return this.toolbarPanel;
    }

    public JToggleButton getRectangleButton() {
        return this.rectangleButton;
    }

    public JToggleButton getEllipseButton() {
        return this.ellipseButton;
    }

    public JToggleButton getFreeHandButton() {
        return this.freeHandButton;
    }

    public JToggleButton getPolygonButton() {
        return this.polygonButton;
    }

    public JToggleButton getLineButton() {
        return this.lineButton;
    }

    public JToggleButton getAngleButton() {
        return this.angleButton;
    }

    public JToggleButton getWandButton() {
        return this.wandButton;
    }

    public JToggleButton getZoomButton() {
        return this.zoomButton;
    }

    public JToggleButton getArrowButton() {
        return this.arrowButton;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JToggleButton getSelectedButton() {
        return this.selectedButton;
    }

    public JButton getInnerButton() {
        return this.innerButton;
    }

    public JButton getOuterButton() {
        return this.outerButton;
    }

    public JButton getMaskButton() {
        return this.maskButton;
    }

    public JButton getInvalidateButton() {
        return this.invalidateButton;
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public JButton getIntersectionButton() {
        return this.intersectionButton;
    }

    public JButton getUnionButton() {
        return this.unionButton;
    }

    public JButton getSubstractButton() {
        return this.substractButton;
    }

    public JButton getXorButton() {
        return this.xorButton;
    }

    public String getRectangleTitle() {
        return this.rectangleTitle;
    }

    public void setRectangleTitle(String rectangleTitle) {
        this.rectangleTitle = rectangleTitle;
        this.rectangleButton.setToolTipText(rectangleTitle);
    }

    public String getEllipseTitle() {
        return this.ellipseTitle;
    }

    public void setEllipseTitle(String ellipseTitle) {
        this.ellipseTitle = ellipseTitle;
        this.ellipseButton.setToolTipText(ellipseTitle);
    }

    public String getFreeHandTitle() {
        return this.freeHandTitle;
    }

    public void setFreeHandTitle(String freeHandTitle) {
        this.freeHandTitle = freeHandTitle;
        this.freeHandButton.setToolTipText(freeHandTitle);
    }

    public String getPolygonTitle() {
        return this.polygonTitle;
    }

    public void setPolygonTitle(String polygonTitle) {
        this.polygonTitle = polygonTitle;
        this.polygonButton.setToolTipText(polygonTitle);
    }

    public String getLineTitle() {
        return this.lineTitle;
    }

    public void setLineTitle(String lineTitle) {
        this.lineTitle = lineTitle;
        this.lineButton.setToolTipText(lineTitle);
    }

    public String getAngleTitle() {
        return this.angleTitle;
    }

    public void setAngleTitle(String angleTitle) {
        this.angleTitle = angleTitle;
        this.angleButton.setToolTipText(angleTitle);
    }

    public String getWandTitle() {
        return this.wandTitle;
    }

    public void setWandTitle(String wandTitle) {
        this.wandTitle = wandTitle;
        this.wandButton.setToolTipText(wandTitle);
    }

    public String getZoomTitle() {
        return this.zoomTitle;
    }

    public void setZoomTitle(String zoomTitle) {
        this.zoomTitle = zoomTitle;
        this.zoomButton.setToolTipText(zoomTitle);
    }

    public String getSelectionTitle() {
        return this.selectionTitle;
    }

    public void setSelectionTitle(String selectionTitle) {
        this.selectionTitle = selectionTitle;
        this.selectedButton.setToolTipText(selectionTitle);
    }

    public String getDeleteTitle() {
        return this.deleteTitle;
    }

    public void setDeleteTitle(String deleteTitle) {
        this.deleteTitle = deleteTitle;
        this.deleteButton.setToolTipText(deleteTitle);
    }

    public String getDeleteUndoRedoTitle() {
        return this.deleteUndoRedoTitle;
    }

    public void setDeleteUndoRedoTitle(String deleteUndoRedoTitle) {
        this.deleteUndoRedoTitle = deleteUndoRedoTitle;
    }

    public String getClearTitle() {
        return this.clearTitle;
    }

    public void setClearTitle(String clearTitle) {
        this.clearTitle = clearTitle;
        this.clearButton.setToolTipText(clearTitle);
    }

    public String getClearUndoRedoTitle() {
        return this.clearUndoRedoTitle;
    }

    public void setClearUndoRedoTitle(String clearUndoRedoTitle) {
        this.clearUndoRedoTitle = clearUndoRedoTitle;
    }

    public String getInnerTitle() {
        return this.innerTitle;
    }

    public void setInnerTitle(String innerTitle) {
        this.innerTitle = innerTitle;
        this.innerButton.setToolTipText(innerTitle);
    }

    public String getOuterTitle() {
        return this.outerTitle;
    }

    public void setOuterTitle(String outerTitle) {
        this.outerTitle = outerTitle;
        this.outerButton.setToolTipText(outerTitle);
    }

    public String getMaskTitle() {
        return this.maskTitle;
    }

    public void setMaskTitle(String maskTitle) {
        this.maskTitle = maskTitle;
        this.maskButton.setToolTipText(maskTitle);
    }

    public String getMaskUndoRedoTitle() {
        return this.maskUndoRedoTitle;
    }

    public void setMaskUndoRedoTitle(String maskUndoRedoTitle) {
        this.maskUndoRedoTitle = maskUndoRedoTitle;
    }

    public String getInvalidateTitle() {
        return this.invalidateTitle;
    }

    public void setInvalidateTitle(String invalidateTitle) {
        this.invalidateTitle = invalidateTitle;
        this.invalidateButton.setToolTipText(invalidateTitle);
    }

    public String getResetTitle() {
        return this.resetTitle;
    }

    public void setResetTitle(String resetTitle) {
        this.resetTitle = resetTitle;
        this.resetButton.setToolTipText(resetTitle);
    }

    public String getResetUndoRedoTitle() {
        return this.resetUndoRedoTitle;
    }

    public void setResetUndoRedoTitle(String resetUndoRedoTitle) {
        this.resetUndoRedoTitle = resetUndoRedoTitle;
    }

    public String getIntersectionTitle() {
        return this.intersectionTitle;
    }

    public void setIntersectionTitle(String intersectionTitle) {
        this.intersectionTitle = intersectionTitle;
        this.intersectionButton.setToolTipText(intersectionTitle);
    }

    public String getIntersectionUndoRedoTitle() {
        return this.intersectionUndoRedoTitle;
    }

    public void setIntersectionUndoRedoTitle(String intersectionUndoRedoTitle) {
        this.intersectionUndoRedoTitle = intersectionUndoRedoTitle;
    }

    public String getUnionTitle() {
        return this.unionTitle;
    }

    public void setUnionTitle(String unionTitle) {
        this.unionTitle = unionTitle;
        this.unionButton.setToolTipText(unionTitle);
    }

    public String getUnionUndoRedoTitle() {
        return this.unionUndoRedoTitle;
    }

    public void setUnionUndoRedoTitle(String unionUndoRedoTitle) {
        this.unionUndoRedoTitle = unionUndoRedoTitle;
    }

    public String getSubstractTitle() {
        return this.substractTitle;
    }

    public void setSubstractTitle(String substractTitle) {
        this.substractTitle = substractTitle;
        this.substractButton.setToolTipText(substractTitle);
    }

    public String getSubstractUndoRedoTitle() {
        return this.substractUndoRedoTitle;
    }

    public void setSubstractUndoRedoTitle(String substractUndoRedoTitle) {
        this.substractUndoRedoTitle = substractUndoRedoTitle;
    }

    public String getXorTitle() {
        return this.xorTitle;
    }

    public void setXorTitle(String xorTitle) {
        this.xorTitle = xorTitle;
        this.xorButton.setToolTipText(xorTitle);
    }

    public String getXorUndoRedoTitle() {
        return this.xorUndoRedoTitle;
    }

    public void setXorUndoRedoTitle(String xorUndoRedoTitle) {
        this.xorUndoRedoTitle = xorUndoRedoTitle;
    }

    public String getUndoTitle() {
        return this.undoTitle;
    }

    public void setUndoTitle(String undoTitle) {
        this.undoTitle = undoTitle;
        this.undoButton.setToolTipText(undoTitle);
    }

    public String getRedoTitle() {
        return this.redoTitle;
    }

    public void setRedoTitle(String redoTitle) {
        this.redoTitle = redoTitle;
        this.redoButton.setToolTipText(redoTitle);
    }

    protected void scrollTo(int x, int y) {
        this.imagePane.setIgnoreRepaint(true);
        this.imagePane.getViewport().setIgnoreRepaint(true);
        JScrollBar hbar = this.imagePane.getHorizontalScrollBar();
        JScrollBar vbar = this.imagePane.getVerticalScrollBar();
        if (hbar != null) {
            if (x < hbar.getMaximum() && x > hbar.getMinimum()) {
                hbar.setValue(x);
            } else if (x >= hbar.getMaximum()) {
                hbar.setValue(hbar.getMaximum());
            } else {
                hbar.setValue(hbar.getMinimum());
            }
        }
        if (vbar != null) {
            if (y < vbar.getMaximum() && y > vbar.getMinimum()) {
                vbar.setValue(y);
            } else if (y >= vbar.getMaximum()) {
                vbar.setValue(vbar.getMaximum());
            } else {
                vbar.setValue(vbar.getMinimum());
            }
        }
        this.imagePane.setIgnoreRepaint(false);
        this.imagePane.getViewport().setIgnoreRepaint(false);
        this.imagePane.repaint();
    }

    public void zoomIn() {
        this.canvas.zoomInNoTranslation(0, 0);
        this.canvasRenderer.revalidate();
        this.imagePane.revalidate();
        this.repaint();
    }

    public void zoomOut() {
        this.canvas.zoomOutNoTranslation(0, 0);
        this.canvasRenderer.revalidate();
        this.imagePane.revalidate();
        this.repaint();
    }

    protected class CanvasRenderer
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener {
        protected int xMouse;
        protected int yMouse;
        protected Stroke selectionStroke = new BasicStroke(2.0f);

        public CanvasRenderer() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addKeyListener(this);
        }

        public double antiTranslateX(double x) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            int imageWidth = JImageJ.this.canvas.getPreferredSize().width;
            JImageJ.this.xOrg = (d.width - (imageWidth + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            return x - (double)JImageJ.this.xOrg - (double)JImageJ.this.yAxisWidth;
        }

        public int antiTranslateX(int x) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            int imageWidth = JImageJ.this.canvas.getPreferredSize().width;
            JImageJ.this.xOrg = (d.width - (imageWidth + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            return x - JImageJ.this.xOrg - JImageJ.this.yAxisWidth;
        }

        public double antiTranslateY(double y) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            int imageHeight = JImageJ.this.canvas.getPreferredSize().height;
            JImageJ.this.yOrg = (d.height - (imageHeight + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return y - (double)JImageJ.this.yOrg - (double)JImageJ.this.xAxisUpMargin;
        }

        public int antiTranslateY(int y) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            int imageHeight = JImageJ.this.canvas.getPreferredSize().height;
            JImageJ.this.yOrg = (d.height - (imageHeight + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return y - JImageJ.this.yOrg - JImageJ.this.xAxisUpMargin;
        }

        public void translateGraphics(Graphics g) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            Dimension imageSize = JImageJ.this.canvas.getPreferredSize();
            int imageWidth = imageSize.width;
            int imageHeight = imageSize.height;
            JImageJ.this.xOrg = (d.width - (imageWidth + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (d.height - (imageHeight + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            g.translate(JImageJ.this.xOrg + JImageJ.this.yAxisWidth, JImageJ.this.yOrg + JImageJ.this.xAxisUpMargin);
        }

        public MouseEvent antiTranslateMouseEvent(MouseEvent e) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            Dimension imageSize = JImageJ.this.canvas.getPreferredSize();
            int imageWidth = imageSize.width;
            int imageHeight = imageSize.height;
            JImageJ.this.xOrg = (d.width - (imageWidth + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (d.height - (imageHeight + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() - JImageJ.this.xOrg - JImageJ.this.yAxisWidth, e.getY() - JImageJ.this.yOrg - JImageJ.this.xAxisUpMargin, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        public MouseEvent translateMouseEvent(MouseEvent e) {
            JImageJ.this.measureAxis();
            Dimension d = this.getSize();
            Dimension imageSize = JImageJ.this.canvas.getPreferredSize();
            int imageWidth = imageSize.width;
            int imageHeight = imageSize.height;
            JImageJ.this.xOrg = (d.width - (imageWidth + JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin)) / 2;
            JImageJ.this.yOrg = (d.height - (imageHeight + JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin)) / 2;
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX() + JImageJ.this.xOrg + JImageJ.this.yAxisWidth, e.getY() + JImageJ.this.yOrg + JImageJ.this.xAxisUpMargin, e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseExited(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.grabFocus();
            this.xMouse = e.getX();
            this.yMouse = e.getY();
            if (JImageJ.this.canvas != null && Toolbar.getToolId() != 12) {
                JImageJ.this.canvas.mousePressed(e);
                this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseReleased(e);
                this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (Toolbar.getToolId() == 12) {
                int xDelta = this.xMouse - e.getX();
                int yDelta = this.yMouse - e.getY();
                xDelta = xDelta > 0 ? Math.min(xDelta, 8) : Math.max(xDelta, -8);
                yDelta = yDelta > 0 ? Math.min(yDelta, 8) : Math.max(yDelta, -8);
                JScrollBar hbar = JImageJ.this.imagePane.getHorizontalScrollBar();
                JScrollBar vbar = JImageJ.this.imagePane.getVerticalScrollBar();
                int x = 0;
                int y = 0;
                if (hbar != null) {
                    x = hbar.getValue();
                }
                if (vbar != null) {
                    y = vbar.getValue();
                }
                hbar = null;
                vbar = null;
                JImageJ.this.scrollTo(x += xDelta, y += yDelta);
            }
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseDragged(e);
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (JImageJ.this.canvas != null) {
                JImageJ.this.canvas.mouseMoved(e);
                this.repaint();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (Toolbar.getToolId() == 11) {
                double currentMag = JImageJ.this.getZoom();
                double x = (double)e.getX() / currentMag;
                double y = (double)e.getY() / currentMag;
                if (e.getWheelRotation() < 0) {
                    JImageJ.this.zoomIn();
                } else {
                    JImageJ.this.zoomOut();
                }
                x *= JImageJ.this.getZoom();
                y *= JImageJ.this.getZoom();
                this.revalidate();
                this.repaint();
                Rectangle rect = JImageJ.this.imagePane.getVisibleRect();
                JImageJ.this.scrollTo((int)Math.rint(x -= rect.getCenterX()), (int)Math.rint(y -= rect.getCenterY()));
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            if (JImageJ.this.canvas != null && JImageJ.this.theImage != null) {
                this.adaptAxes();
                Dimension d = this.getSize();
                if (this.isOpaque()) {
                    g2d.setColor(this.getBackground());
                    g2d.fillRect(0, 0, d.width, d.height);
                }
                this.translateGraphics(g2d);
                JImageJ.this.canvas.paint(g2d);
                JImageJ.this.paintAxis(g2d);
                Vector<Roi> innerRois = JImageJ.this.imp.getInnerRois();
                Vector<Roi> outerRois = JImageJ.this.imp.getOuterRois();
                Vector<Roi> selectedRois = JImageJ.this.imp.getSelectedRois();
                boolean manySelected = selectedRois.size() > 1;
                for (Roi roi : JImageJ.this.imp.getAllRois()) {
                    if (roi == null) continue;
                    int selectedIndex = selectedRois.indexOf(roi);
                    if (selectedIndex > -1) {
                        if (manySelected) {
                            g2d.setColor(Color.WHITE);
                            Rectangle bounds = roi.getBounds();
                            int x = bounds.x + bounds.width / 2;
                            int y = bounds.y + bounds.height / 2;
                            g2d.drawString(Integer.toString(selectedIndex + 1), (int)((double)x * JImageJ.this.canvas.getMagnification()), (int)((double)y * JImageJ.this.canvas.getMagnification()));
                        }
                        g2d.setStroke(this.selectionStroke);
                        if (innerRois.contains(roi)) {
                            Roi.setColor(JImageJ.this.roiInsideSelectionColor);
                        } else if (outerRois.contains(roi)) {
                            Roi.setColor(JImageJ.this.roiOutsideSelectionColor);
                        } else {
                            Roi.setColor(JImageJ.this.roiSelectionColor);
                        }
                    } else {
                        g2d.setStroke(oldStroke);
                        if (innerRois.contains(roi)) {
                            Roi.setColor(JImageJ.this.roiInsideColor);
                        } else if (outerRois.contains(roi)) {
                            Roi.setColor(JImageJ.this.roiOutsideColor);
                        } else {
                            Roi.setColor(JImageJ.this.roiColor);
                        }
                    }
                    roi.draw(g2d);
                }
            }
        }

        protected void adaptAxes() {
            if (JImageJ.this.xAxis.isAutoScale()) {
                JImageJ.this.xAxis.setAutoScale(false);
                JImageJ.this.xAxis.setMinimum(0.0);
                JImageJ.this.xAxis.setMaximum(JImageJ.this.theImage.getWidth());
                JImageJ.this.xAxis.setAutoScale(true);
            }
            if (JImageJ.this.yAxis.isAutoScale()) {
                JImageJ.this.yAxis.setAutoScale(false);
                JImageJ.this.yAxis.setMinimum(0.0);
                JImageJ.this.yAxis.setMaximum(JImageJ.this.theImage.getHeight());
                JImageJ.this.yAxis.setAutoScale(true);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (JImageJ.this.canvas != null) {
                Dimension size = JImageJ.this.canvas.getPreferredSize();
                JImageJ.this.measureAxis();
                size.width += JImageJ.this.yAxisWidth + JImageJ.this.yAxisRightMargin;
                size.height += JImageJ.this.xAxisHeight + JImageJ.this.xAxisUpMargin;
                return size;
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            Rectangle bounds = null;
            Roi roi = JImageJ.this.imp.getRoi();
            if (roi != null && roi.getState() != 0) {
                bounds = roi.getBounds();
            }
            switch (e.getKeyCode()) {
                case 8: 
                case 127: {
                    JImageJ.this.deleteSelectedRois();
                    break;
                }
                case 27: {
                    JImageJ.this.getArrowButton().doClick();
                    JImageJ.this.canvas.setCursor(JImageJ.this.canvas.getDefaultCursor());
                    break;
                }
                case 17: {
                    break;
                }
                case 107: 
                case 521: {
                    if (Toolbar.getToolId() != 11) break;
                    JImageJ.this.zoomIn();
                    break;
                }
                case 45: 
                case 109: {
                    if (Toolbar.getToolId() != 11) break;
                    JImageJ.this.zoomOut();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    if (bounds == null) break;
                    int onMask = 512;
                    if ((e.getModifiersEx() & onMask) == onMask) {
                        roi.nudgeCorner(e.getKeyCode());
                        break;
                    }
                    roi.nudge(e.getKeyCode());
                    break;
                }
                default: {
                    JImageJ.this.hiddenIJ.keyPressed(e);
                }
            }
            roi = null;
            bounds = null;
            this.repaint();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            JImageJ.this.hiddenIJ.keyReleased(e);
            this.repaint();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JImageJ.this.hiddenIJ.keyTyped(e);
            this.repaint();
        }
    }

    protected class RenderedImageCanvas
    extends ImageCanvas {
        protected boolean selectionMode;

        public RenderedImageCanvas(ImagePlus imp) {
            super(imp);
            this.selectionMode = false;
        }

        @Override
        public void setCursor(Cursor cursor) {
            if (this.imp instanceof AdvancedImagePlus && !((AdvancedImagePlus)this.imp).isAllowRoiCreation()) {
                cursor = ImageCanvas.defaultCursor;
            }
            super.setCursor(cursor);
            if (JImageJ.this.canvasRenderer != null) {
                JImageJ.this.canvasRenderer.setCursor(cursor);
            }
        }

        @Override
        public void setCursor(int sx, int sy, int ox, int oy) {
            super.setCursor(ox, oy, ox, oy);
        }

        public Cursor getDefaultCursor() {
            return ImageCanvas.defaultCursor;
        }

        @Override
        public Graphics getGraphics() {
            if (JImageJ.this.canvasRenderer == null) {
                return super.getGraphics();
            }
            Graphics g = JImageJ.this.canvasRenderer.getGraphics();
            return g;
        }

        @Override
        public boolean isShowing() {
            if (JImageJ.this.canvasRenderer != null) {
                return JImageJ.this.canvasRenderer.isShowing();
            }
            return super.isShowing();
        }

        @Override
        public synchronized void add(PopupMenu popup) {
        }

        @Override
        protected void handlePopupMenu(MouseEvent e) {
        }

        @Override
        public int offScreenX(int sx) {
            int result = super.offScreenX(sx);
            if (JImageJ.this.canvasRenderer != null) {
                result = (int)((double)JImageJ.this.canvasRenderer.antiTranslateX(sx) / this.magnification);
            }
            return result += this.srcRect.x;
        }

        @Override
        public double offScreenXD(int sx) {
            double result = super.offScreenXD(sx);
            if (JImageJ.this.canvasRenderer != null) {
                result = (double)JImageJ.this.canvasRenderer.antiTranslateX(sx) / this.magnification;
            }
            return result += (double)this.srcRect.x;
        }

        @Override
        public int offScreenY(int sy) {
            int result = super.offScreenY(sy);
            if (JImageJ.this.canvasRenderer != null) {
                result = (int)((double)JImageJ.this.canvasRenderer.antiTranslateY(sy) / this.magnification);
            }
            return result += this.srcRect.y;
        }

        @Override
        public double offScreenYD(int sy) {
            double result = super.offScreenYD(sy);
            if (JImageJ.this.canvasRenderer != null) {
                result = (double)JImageJ.this.canvasRenderer.antiTranslateY(sy) / this.magnification;
            }
            return result += (double)this.srcRect.y;
        }

        public void findSelectedRoi(int x, int y, boolean keepSelection) {
            this.findRoiSelected(x, y, keepSelection);
        }

        @Deprecated
        public void findRoiSelected(int x, int y, boolean keepSelection) {
            if (this.imp instanceof AdvancedImagePlus) {
                Roi closestRoi = this.findRoiAtPoint(x, y);
                Roi validatedRoi = ((AdvancedImagePlus)this.imp).getValidatedRoi();
                Vector<Roi> selectedRois = ((AdvancedImagePlus)this.imp).getSelectedRois();
                Vector<Roi> innerRois = ((AdvancedImagePlus)this.imp).getInnerRois();
                Vector<Roi> outerRois = ((AdvancedImagePlus)this.imp).getOuterRois();
                boolean roiSelected = false;
                boolean alreadySelected = false;
                if (closestRoi != null) {
                    roiSelected = true;
                    alreadySelected = selectedRois.contains(closestRoi);
                }
                if (keepSelection) {
                    if (roiSelected) {
                        boolean isValidatedRoi;
                        boolean bl = isValidatedRoi = innerRois.contains(closestRoi) || outerRois.contains(closestRoi);
                        if (alreadySelected) {
                            selectedRois.remove(closestRoi);
                            if (!isValidatedRoi) {
                                ((AdvancedImagePlus)this.imp).setHandledRoi(closestRoi);
                            }
                            if (closestRoi == validatedRoi) {
                                ((AdvancedImagePlus)this.imp).setValidatedRoi(null);
                            }
                        } else {
                            selectedRois.add(closestRoi);
                            if (isValidatedRoi) {
                                if (validatedRoi != null && closestRoi != validatedRoi) {
                                    selectedRois.remove(validatedRoi);
                                }
                                ((AdvancedImagePlus)this.imp).setValidatedRoi(closestRoi);
                            } else {
                                ((AdvancedImagePlus)this.imp).setHandledRoi(closestRoi);
                            }
                        }
                    }
                } else {
                    selectedRois.clear();
                    ((AdvancedImagePlus)this.imp).setValidatedRoi(null);
                    ((AdvancedImagePlus)this.imp).setHandledRoi(null);
                    if (roiSelected) {
                        selectedRois.add(closestRoi);
                        if (innerRois.contains(closestRoi) || outerRois.contains(closestRoi)) {
                            ((AdvancedImagePlus)this.imp).setValidatedRoi(closestRoi);
                        } else {
                            ((AdvancedImagePlus)this.imp).setHandledRoi(closestRoi);
                        }
                    }
                }
            }
        }

        private Roi findRoiAtPoint(int x, int y) {
            Roi closestRoi = null;
            int minDistance = Integer.MAX_VALUE;
            for (Roi currentRoi : ((AdvancedImagePlus)this.imp).getAllRois()) {
                int distanceY;
                if (currentRoi == null || currentRoi.getState() == 0) continue;
                if (currentRoi.isHandle((int)((double)x * this.magnification), (int)((double)y * this.magnification)) >= 0) {
                    closestRoi = currentRoi;
                    break;
                }
                if (!currentRoi.contains(x, y)) continue;
                Rectangle r = currentRoi.getBounds();
                int distanceX = Math.min(Math.abs(r.x - x), Math.abs(r.x + r.width - (x + 1)));
                int distance = Math.min(distanceX, distanceY = Math.min(Math.abs(r.y - y), Math.abs(r.y + r.width - (y + 1))));
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestRoi = currentRoi;
            }
            return closestRoi;
        }

        public void findHandledRoi(int x, int y) {
            if (this.imp instanceof AdvancedImagePlus) {
                boolean isValidatedRoi;
                Roi closestRoi = this.findRoiAtPoint(x, y);
                Vector<Roi> innerRois = ((AdvancedImagePlus)this.imp).getInnerRois();
                Vector<Roi> outerRois = ((AdvancedImagePlus)this.imp).getOuterRois();
                boolean bl = isValidatedRoi = innerRois.contains(closestRoi) || outerRois.contains(closestRoi);
                if (!isValidatedRoi && closestRoi != null) {
                    ((AdvancedImagePlus)this.imp).setHandledRoi(closestRoi);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && (ImageCanvas.handCursor.equals(this.getCursor()) || ImageCanvas.defaultCursor.equals(this.getCursor()))) {
                this.imp.killRoi();
                int sx = e.getX();
                int sy = e.getY();
                int x = this.offScreenX(sx);
                int y = this.offScreenY(sy);
                boolean keepSelection = e.isShiftDown() || e.isControlDown();
                this.findSelectedRoi(x, y, keepSelection);
            } else {
                super.mouseClicked(e);
            }
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int tool = Toolbar.getToolId();
            if ((tool == 2 || tool == 5 || tool == 14) && this.imp.getRoi() != null && this.imp.getRoi().getState() != 0) {
                this.imp.killRoi();
            }
            int sx = e.getX();
            int sy = e.getY();
            int x = this.offScreenX(sx);
            int y = this.offScreenY(sy);
            if (this.isSelectionMode() || this.imp instanceof AdvancedImagePlus && !((AdvancedImagePlus)this.imp).isAllowRoiCreation()) {
                if (e.isAltDown()) {
                    ((AdvancedImagePlus)this.imp).setAllowRoiCreation(true);
                } else {
                    ((AdvancedImagePlus)this.imp).setAllowRoiCreation(false);
                    this.findHandledRoi(x, y);
                }
            }
            if (Toolbar.getToolId() == 11) {
                Toolbar.getInstance().setTool(0);
            }
            x = (int)((double)x * this.magnification);
            y = (int)((double)y * this.magnification);
            if (this.imp.getRoi() != null && this.imp.getRoi().isHandle(x, y) >= 0 && (this.imp.getRoi().getState() == 0 || this.isSelectionMode() || this.imp instanceof AdvancedImagePlus && !((AdvancedImagePlus)this.imp).isAllowRoiCreation())) {
                super.mousePressed(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            } else {
                super.mousePressed(e);
            }
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int sx = e.getX();
            int sy = e.getY();
            int x = (int)((double)this.offScreenX(sx) * JImageJ.this.canvas.getMagnification());
            int y = (int)((double)this.offScreenY(sy) * JImageJ.this.canvas.getMagnification());
            if (JImageJ.this.selectedButton == JImageJ.this.zoomButton) {
                if (this.imp.getRoi() != null) {
                    JImageJ.this.setZoomRoi(this.imp.getRoi());
                }
                Toolbar.getInstance().setTool(11);
            } else if (this.isSelectionMode() && this.imp instanceof AdvancedImagePlus && ((AdvancedImagePlus)this.imp).isAllowRoiCreation()) {
                JImageJ.this.setSelectionRoi(this.imp.getRoi());
                ((AdvancedImagePlus)this.imp).setAllowRoiCreation(false);
            } else if (this.imp.getRoi() != null && this.imp.getRoi().isHandle(x, y) >= 0) {
                super.mouseReleased(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
            } else {
                super.mouseReleased(e);
            }
            if (this.imp.getRoi() != null && this.imp.getRoi().getState() != 0) {
                Roi.previousRoi = null;
                this.imp.setRoi((Roi)null);
                Roi.previousRoi = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isSelectionMode()) {
                int difference;
                int sx = e.getX();
                int sy = e.getY();
                int x = this.offScreenX(sx);
                int y = this.offScreenY(sy);
                Dimension size = JImageJ.this.getImageSize();
                if (x >= size.width) {
                    difference = 1 + x - size.width;
                    x -= difference;
                    sx = (int)((double)sx - (double)difference * this.magnification);
                }
                if (y >= size.height) {
                    difference = 1 + y - size.height;
                    y -= difference;
                    sy = (int)((double)sy - (double)difference * this.magnification);
                }
                if (sx < JImageJ.this.getXOrigin()) {
                    sx = JImageJ.this.getXOrigin();
                    x = this.offScreenX(sx);
                }
                if (sy < JImageJ.this.getYOrigin()) {
                    sy = JImageJ.this.getYOrigin();
                    y = this.offScreenY(sy);
                }
                if (this.imp.getRoi() != null && this.imp.getRoi().getState() != 0 && this.imp.getRoi().isHandle(x, y) >= 0) {
                    super.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                } else {
                    super.mouseMoved(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), sx, sy, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
        }

        public boolean isSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(boolean selectionMode) {
            this.selectionMode = selectionMode;
            if (this.imp instanceof AdvancedImagePlus) {
                ((AdvancedImagePlus)this.imp).setAllowRoiCreation(!selectionMode);
            }
        }

        public void zoomInNoTranslation(int x, int y) {
            super.zoomIn(x, y);
            JImageJ.this.revalidate();
        }

        public void zoomOutNoTranslation(int x, int y) {
            super.zoomOut(x, y);
            JImageJ.this.revalidate();
        }

        @Override
        public void zoomIn(int x, int y) {
            int ox = this.offScreenX(x);
            int oy = this.offScreenY(y);
            super.zoomIn(ox, oy);
            this.revalidate();
        }

        @Override
        public void zoomOut(int x, int y) {
            int ox = this.offScreenX(x);
            int oy = this.offScreenY(y);
            super.zoomOut(ox, oy);
            this.revalidate();
        }

        @Override
        public void unzoom() {
            super.unzoom();
            this.revalidate();
        }

        public void computeZoom(double zoom) {
            this.setMagnification(zoom);
            int newWidth = (int)((double)this.imageWidth * zoom);
            int newHeight = (int)((double)this.imageHeight * zoom);
            Dimension newSize = this.canEnlarge(newWidth, newHeight);
            if (newSize != null) {
                this.setDrawingSize(newSize.width, newSize.height);
                if (newSize.width != newWidth || newSize.height != newHeight) {
                    this.reAdjustSourceRect(zoom);
                } else {
                    this.setMagnification(zoom);
                }
            } else {
                this.reAdjustSourceRect(zoom);
            }
            this.repaint();
        }

        public void computeZoom(Roi roi) {
            if (roi != null) {
                Rectangle roiBounds = roi.getBounds();
                double roiWidth = roiBounds.width;
                double roiHeight = roiBounds.height;
                Rectangle paneBounds = JImageJ.this.imagePane.getVisibleRect();
                Dimension currentSize = JImageJ.this.getImageSize();
                double paneWidth = paneBounds.width;
                double paneHeight = paneBounds.height;
                paneBounds = null;
                double newMag = Math.min(paneWidth / roiWidth, paneHeight / roiHeight);
                newMag = ImageCanvas.getLowerZoomLevel(newMag + 1.0E-16);
                int newWidth = (int)((double)currentSize.width * newMag);
                int newHeight = (int)((double)currentSize.height * newMag);
                Dimension newSize = new Dimension(newWidth, newHeight);
                this.setDrawingSize(newSize.width, newSize.height);
                this.setMagnification(newMag);
                this.revalidate();
                this.repaint();
                JImageJ.this.canvasRenderer.revalidate();
                Rectangle rect = roi.getBounds();
                Rectangle visible = new Rectangle((int)((double)rect.x * newMag), (int)((double)rect.y * newMag), (int)((double)rect.width * newMag), (int)((double)rect.height * newMag));
                JImageJ.this.imagePane.revalidate();
                JImageJ.this.scrollTo(visible.x, visible.y);
                rect = null;
                visible = null;
            }
        }

        protected void reAdjustSourceRect(double newMag) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            this.srcRect = new Rectangle(0, 0, w, h);
            this.setMagnification(newMag);
        }

        @Override
        protected Dimension canEnlarge(int newWidth, int newHeight) {
            return new Dimension(newWidth, newHeight);
        }
    }

    protected class HiddenWindow
    extends ImageWindow {
        public HiddenWindow(ImagePlus imp, ImageCanvas ic) {
            super(imp, ic);
            this.remove(ic);
        }

        public HiddenWindow(String title) {
            super(title);
        }

        public HiddenWindow(ImagePlus imp) {
            super(imp);
        }

        @Override
        public void show() {
        }

        @Override
        public void setVisible(boolean b) {
            if (!b) {
                super.setVisible(b);
            }
        }
    }
}

