/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Marker;
import fr.esrf.tangoatk.widget.util.MarkerListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JImage
extends JComponent
implements MouseMotionListener,
MouseListener,
KeyListener {
    public static final int MODE_LINE = 0;
    public static final int MODE_RECT = 1;
    public static final int MODE_CROSS = 2;
    public static final int VERTICAL_LEFT = 0;
    public static final int VERTICAL_CENTER = 1;
    public static final int VERTICAL_RIGHT = 2;
    public static final int HORIZONTAL_TOP = 0;
    public static final int HORIZONTAL_CENTER = 1;
    public static final int HORIZONTAL_BOTTOM = 2;
    protected static final int MARKER_CROSS = 1;
    protected static final int MARKER_RECT = 2;
    protected static final int MARKER_VLINE = 3;
    protected static final int MARKER_HLINE = 4;
    protected static final int MARKER_MOVABLE = 5;
    protected BufferedImage theImage = null;
    protected Insets margin;
    protected int xOrg;
    protected int yOrg;
    protected boolean selectionEnabled;
    protected int mode;
    protected boolean isDragging;
    protected boolean isDraggingMovable;
    protected int dragCorner;
    protected int cornerWidth = 10;
    protected int dragMovableMarkerCorner;
    protected int movableMarkerId;
    protected int x1 = -1;
    protected int y1 = -1;
    protected int x2 = -1;
    protected int y2 = -1;
    protected boolean snapToGrid;
    protected int grid = 16;
    protected Vector<Marker> markers = null;
    protected double markerScaleFactor = 1.0;
    protected JLAxis xAxis;
    protected int xAxisHeight;
    protected int xAxisUpMargin;
    protected JLAxis yAxis;
    protected int yAxisWidth;
    protected int yAxisRightMargin;
    protected boolean crossCursor = false;
    protected Color cursorColor = Color.WHITE;
    protected int xCursor = -1;
    protected int yCursor = -1;
    protected Color selectionColor = Color.RED;
    protected int horizontalPosition;
    protected int verticalPosition;

    public JImage() {
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.xOrg = 5;
        this.yOrg = 5;
        this.mode = 1;
        this.dragMovableMarkerCorner = 0;
        this.dragCorner = 0;
        this.verticalPosition = 1;
        this.horizontalPosition = 1;
        this.isDragging = false;
        this.isDraggingMovable = false;
        this.selectionEnabled = true;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.snapToGrid = false;
        this.yAxis = new JLAxis(this, 6);
        this.yAxis.setAxisColor(Color.BLACK);
        this.yAxis.setFont(ATKConstant.labelFont);
        this.yAxis.setAutoScale(false);
        this.yAxis.setMinimum(0.0);
        this.yAxis.setMaximum(100.0);
        this.yAxis.setVisible(false);
        this.yAxis.setInverted(false);
        this.xAxis = new JLAxis(this, 2);
        this.xAxis.setAxisColor(Color.BLACK);
        this.xAxis.setFont(ATKConstant.labelFont);
        this.xAxis.setAutoScale(false);
        this.xAxis.setMinimum(0.0);
        this.xAxis.setMaximum(100.0);
        this.xAxis.setVisible(false);
    }

    public void setCrossCursor(boolean enable) {
        this.crossCursor = enable;
        if (enable) {
            this.setCursor(null);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setCursorColor(Color c) {
        this.cursorColor = c;
    }

    public boolean isCrossCursor() {
        return this.crossCursor;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public Rectangle getSelectionRect() {
        if (this.hasSelection()) {
            return this.buildSelectionRect();
        }
        return null;
    }

    public Point[] getSelectionPoint() {
        if (this.hasSelection()) {
            Point[] ret = new Point[]{new Point(this.x1, this.y1), new Point(this.x2, this.y2)};
            return ret;
        }
        return null;
    }

    public Point[] getSelectionCrossPoint() {
        if (this.hasSelection() && this.mode == 2) {
            Point[] pts = new Point[4];
            Point p1 = new Point();
            Point p2 = new Point();
            Point p3 = new Point();
            Point p4 = new Point();
            pts[0] = p1;
            pts[1] = p2;
            pts[2] = p3;
            pts[3] = p4;
            switch (this.getHorizontalPosition()) {
                case 0: {
                    p1.x = this.x1;
                    p2.x = this.x2;
                    p1.y = this.y1;
                    p2.y = this.y1;
                    break;
                }
                case 1: {
                    p1.x = this.x1;
                    p2.x = this.x2;
                    p1.y = (this.y1 + this.y2) / 2;
                    p2.y = (this.y1 + this.y2) / 2;
                    break;
                }
                case 2: {
                    p1.x = this.x1;
                    p2.x = this.x2;
                    p1.y = this.y2;
                    p2.y = this.y2;
                }
            }
            switch (this.getVerticalPosition()) {
                case 0: {
                    p3.x = this.x1;
                    p4.x = this.x1;
                    p3.y = this.y1;
                    p4.y = this.y2;
                    break;
                }
                case 1: {
                    p3.x = (this.x1 + this.x2) / 2;
                    p4.x = (this.x1 + this.x2) / 2;
                    p3.y = this.y1;
                    p4.y = this.y2;
                    break;
                }
                case 2: {
                    p3.x = this.x2;
                    p4.x = this.x2;
                    p3.y = this.y1;
                    p4.y = this.y2;
                }
            }
            return pts;
        }
        return null;
    }

    public void setSelectionMode(int m) {
        this.mode = m;
        this.clipSelection();
        this.repaint();
    }

    public int getSelectionMode() {
        return this.mode;
    }

    public boolean hasSelection() {
        return this.selectionEnabled && this.x1 >= 0 && this.x2 >= 0 && this.y1 >= 0 && this.y2 >= 0;
    }

    public void setSelection(int _x1, int _y1, int _x2, int _y2) {
        if (this.selectionEnabled) {
            this.x1 = _x1;
            this.y1 = _y1;
            this.x2 = _x2;
            this.y2 = _y2;
            this.clipSelection();
            this.isDragging = false;
            this.repaint();
        }
    }

    public void clearSelection() {
        this.x1 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.y2 = -1;
        this.isDragging = false;
        this.repaint();
    }

    public void setMargin(Insets i) {
        this.margin = i;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public int getXOrigin() {
        return this.xOrg + this.yAxis.getThickness();
    }

    public int getYOrigin() {
        return this.yOrg + this.xAxisUpMargin;
    }

    public void setImage(BufferedImage i) {
        BufferedImage formerImage = this.theImage;
        this.theImage = i;
        this.clearSelection();
        this.repaint();
        if (formerImage != null) {
            formerImage.flush();
        }
        formerImage = null;
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getYAxis() {
        return this.yAxis;
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public Dimension getImageSize() {
        if (this.theImage != null) {
            return new Dimension(this.theImage.getWidth(), this.theImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean b) {
        this.snapToGrid = b;
    }

    public int getSnapGrid() {
        return this.grid;
    }

    public void setSnapGrid(int b) {
        this.grid = b;
    }

    public int addCrossMarker(int x, int y, Color c) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(1, x, y, c));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addMovableMarker(int x, int y, int width, int height, Color c, int lineWidth) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(5, new Rectangle(x, y, width, height), c, lineWidth));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addRectangleMarker(int x, int y, int width, int height, Color c, int lineWidth) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(2, new Rectangle(x, y, width, height), c, lineWidth));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addRectangleMarker(int x, int y, int width, int height, Color c) {
        return this.addRectangleMarker(x, y, width, height, c, 1);
    }

    public int addVerticalLineMarker(int x, Color c) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(3, x, 0, c));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addHorizontalLineMarker(int y, Color c) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(4, 0, y, c));
        this.repaint();
        return this.markers.size() - 1;
    }

    public void setMarkerPos(int id, int x, int y, int nWidth, int nHeight) {
        if (this.markers != null && !this.isDraggingMovable) {
            if (id >= 0 && id < this.markers.size()) {
                Marker m = this.markers.get(id);
                m.markerRect.setBounds(x, y, nWidth, nHeight);
            }
            this.repaint();
        }
    }

    public Point getMarkerPos(int id) {
        if (id >= 0 && id < this.markers.size()) {
            Marker m = this.markers.get(id);
            return new Point(m.markerRect.x, m.markerRect.y);
        }
        return null;
    }

    public void clearMarkers() {
        if (this.markers != null) {
            this.markers.clear();
            this.markers = null;
            this.repaint();
        }
    }

    public int getMarkerNumber() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    public void setMarkerScale(double s) {
        this.markerScaleFactor = s;
    }

    public int getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public void setHorizontalPosition(int horizontalPosition) {
        this.horizontalPosition = horizontalPosition;
        this.repaint();
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    public void setVerticalPosition(int verticalPosition) {
        this.verticalPosition = verticalPosition;
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.repaint();
    }

    public void addMarkerListener(MarkerListener l) {
        this.listenerList.add(MarkerListener.class, l);
    }

    public void removeMarkerListener(MarkerListener l) {
        this.listenerList.remove(MarkerListener.class, l);
    }

    protected void paintCursor(Graphics g) {
        Dimension d = this.getImageSize();
        if (this.crossCursor && this.xCursor >= 0 && this.yCursor >= 0 && this.xCursor <= d.width && this.yCursor <= d.height) {
            g.setColor(this.cursorColor);
            g.drawLine(0, this.yCursor, d.width, this.yCursor);
            g.drawLine(this.xCursor, 0, this.xCursor, d.height);
        }
    }

    protected void paintSelection(Graphics g) {
        if (this.hasSelection()) {
            Graphics2D g2 = (Graphics2D)g;
            Color oldColor = g2.getColor();
            if (this.selectionColor != null) {
                g2.setColor(this.selectionColor);
            } else {
                g2.setColor(Color.RED);
            }
            Rectangle r = this.buildSelectionRect();
            Rectangle c = new Rectangle(0, 0, this.cornerWidth, this.cornerWidth);
            switch (this.mode) {
                case 0: {
                    g2.drawLine(this.x1, this.y1, this.x2, this.y2);
                    int xc = (this.x1 + this.x2) / 2;
                    int yc = (this.y1 + this.y2) / 2;
                    double xn = this.y2 - this.y1;
                    double yn = -(this.x2 - this.x1);
                    double n = Math.sqrt(xn * xn + yn * yn);
                    int vxn = (int)(8.0 * (xn / n));
                    int vyn = (int)(8.0 * (yn / n));
                    xn = this.x2 - this.x1;
                    yn = this.y2 - this.y1;
                    n = Math.sqrt(xn * xn + yn * yn);
                    int vx = (int)(10.0 * (xn / n));
                    int vy = (int)(10.0 * (yn / n));
                    g2.drawLine(xc - vxn, yc - vyn, xc + vxn, yc + vyn);
                    g2.drawLine(xc + vxn, yc + vyn, xc + vx, yc + vy);
                    g2.drawLine(xc + vx, yc + vy, xc - vxn, yc - vyn);
                    c.translate(this.x1 - this.cornerWidth / 2, this.y1 - this.cornerWidth / 2);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(this.x2 - this.x1, this.y2 - this.y1);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    break;
                }
                case 1: {
                    g2.drawRect(r.x, r.y, r.width, r.height);
                    c.translate(r.x - this.cornerWidth / 2, r.y - this.cornerWidth / 2);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(r.width, 0);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(0, r.height);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(-r.width, 0);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(r.width / 2, -r.height / 2);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    break;
                }
                case 2: {
                    int xv;
                    int yh;
                    switch (this.horizontalPosition) {
                        case 0: {
                            yh = this.y1 < this.y2 ? this.y1 : this.y2;
                            break;
                        }
                        case 1: {
                            yh = (this.y1 + this.y2) / 2;
                            break;
                        }
                        case 2: {
                            yh = this.y1 < this.y2 ? this.y2 : this.y1;
                            break;
                        }
                        default: {
                            yh = -1;
                        }
                    }
                    switch (this.verticalPosition) {
                        case 0: {
                            xv = this.x1 < this.x2 ? this.x1 : this.x2;
                            break;
                        }
                        case 1: {
                            xv = (this.x1 + this.x2) / 2;
                            break;
                        }
                        case 2: {
                            xv = this.x1 < this.x2 ? this.x2 : this.x1;
                            break;
                        }
                        default: {
                            xv = -1;
                        }
                    }
                    if (xv < 0 || yh < 0) break;
                    g2.drawLine(this.x1, yh, this.x2, yh);
                    g2.drawLine(xv, this.y1, xv, this.y2);
                    if (this.x1 < this.x2) {
                        g2.drawLine(this.x2, yh, this.x2 - 8, yh - 8);
                        g2.drawLine(this.x2 - 8, yh - 8, this.x2 - 8, yh + 8);
                        g2.drawLine(this.x2 - 8, yh + 8, this.x2, yh);
                    } else {
                        g2.drawLine(this.x2, yh, this.x2 + 8, yh - 8);
                        g2.drawLine(this.x2 + 8, yh - 8, this.x2 + 8, yh + 8);
                        g2.drawLine(this.x2 + 8, yh + 8, this.x2, yh);
                    }
                    if (this.y1 < this.y2) {
                        g2.drawLine(xv, this.y2, xv - 8, this.y2 - 8);
                        g2.drawLine(xv - 8, this.y2 - 8, xv + 8, this.y2 - 8);
                        g2.drawLine(xv + 8, this.y2 - 8, xv, this.y2);
                    } else {
                        g2.drawLine(xv, this.y2, xv - 8, this.y2 + 8);
                        g2.drawLine(xv - 8, this.y2 + 8, xv + 8, this.y2 + 8);
                        g2.drawLine(xv + 8, this.y2 + 8, xv, this.y2);
                    }
                    c.translate(r.x - this.cornerWidth / 2, r.y - this.cornerWidth / 2);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(r.width, 0);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(0, r.height);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(-r.width, 0);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                    c.translate(r.width / 2, -r.height / 2);
                    g2.drawRect(c.x, c.y, c.width, c.height);
                }
            }
            g2.setColor(oldColor);
            g2.setPaintMode();
        }
    }

    protected void measureAxis() {
        this.xAxisHeight = 0;
        this.yAxisWidth = 0;
        this.xAxisUpMargin = 0;
        this.yAxisRightMargin = 0;
        if (this.xAxis.isVisible()) {
            this.xAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth(), 0);
            if (this.xAxis.getOrientation() == 2) {
                this.xAxisHeight = 7;
                this.xAxisUpMargin = this.xAxis.getThickness();
            } else {
                this.xAxisHeight = this.xAxis.getThickness();
                this.xAxisUpMargin = 7;
            }
        }
        if (this.yAxis.isVisible()) {
            this.yAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight());
            this.yAxisWidth = this.yAxis.getThickness();
            this.yAxisRightMargin = 15;
        }
    }

    protected void paintAxis(Graphics g) {
        if (this.yAxis.isVisible()) {
            if (this.yAxis.getOrientation() == 5) {
                this.yAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth() - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            } else {
                this.yAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth() - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            }
        }
        if (this.xAxis.isVisible()) {
            if (this.xAxis.getOrientation() == 2) {
                this.xAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight(), Color.BLACK, 0, 0);
                }
            } else {
                this.xAxis.paintAxisDirect(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight(), Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(g, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        if (this.theImage == null) {
            return;
        }
        if (this.xAxis.isAutoScale()) {
            this.xAxis.setAutoScale(false);
            this.xAxis.setMinimum(0.0);
            this.xAxis.setMaximum((double)this.theImage.getWidth() / this.markerScaleFactor);
            this.xAxis.setAutoScale(true);
        }
        if (this.yAxis.isAutoScale()) {
            this.yAxis.setAutoScale(false);
            this.yAxis.setMinimum(0.0);
            this.yAxis.setMaximum((double)this.theImage.getHeight() / this.markerScaleFactor);
            this.yAxis.setAutoScale(true);
        }
        this.measureAxis();
        this.xOrg = (d.width - (this.theImage.getWidth() + this.yAxisWidth + this.yAxisRightMargin)) / 2;
        this.yOrg = (d.height - (this.theImage.getHeight() + this.xAxisHeight + this.xAxisUpMargin)) / 2;
        g.translate(this.xOrg + this.yAxisWidth, this.yOrg + this.xAxisUpMargin);
        g.drawImage(this.theImage, 0, 0, null);
        this.paintAxis(g);
        this.paintSelection(g);
        this.paintCursor(g);
        if (this.markers != null) {
            for (int i = 0; i < this.markers.size(); ++i) {
                Marker m = this.markers.get(i);
                Graphics2D g2 = (Graphics2D)g;
                Stroke old = g2.getStroke();
                BasicStroke bs = new BasicStroke(m.lineWidth);
                g.setColor(m.markerColor);
                g2.setStroke(bs);
                int x = (int)((double)m.markerRect.x * this.markerScaleFactor);
                int y = (int)((double)m.markerRect.y * this.markerScaleFactor);
                int w = (int)((double)m.markerRect.width * this.markerScaleFactor);
                int h = (int)((double)m.markerRect.height * this.markerScaleFactor);
                Rectangle br = new Rectangle(0, 0, this.theImage.getWidth() + 1, this.theImage.getHeight() + 1);
                Rectangle mr = w == 0 ? new Rectangle(x, y, 1, 1) : new Rectangle(x, y, w, h);
                if (br.contains(mr)) {
                    switch (m.type) {
                        case 1: {
                            g.drawLine(x, 0, x, this.theImage.getHeight());
                            g.drawLine(0, y, this.theImage.getWidth(), y);
                            g.drawRect(x - 2, y - 2, 5, 5);
                            break;
                        }
                        case 2: {
                            g.drawRect(x, y, w, h);
                            break;
                        }
                        case 5: {
                            g.drawRect(x, y, w, h);
                            g2.setStroke(old);
                            Rectangle c = new Rectangle(0, 0, this.cornerWidth, this.cornerWidth);
                            c.translate(x - this.cornerWidth / 2, y - this.cornerWidth / 2);
                            int w2l = w / 2;
                            int w2r = w - w2l;
                            int h2u = h / 2;
                            int h2d = h - h2u;
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(w2l, 0);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(w2r, 0);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(0, h2u);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(0, h2d);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(-w2r, 0);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(-w2l, 0);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(0, -h2d);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            c.translate(w / 2, 0);
                            g2.drawRect(c.x, c.y, c.width, c.height);
                            break;
                        }
                        case 3: {
                            g.drawLine(x, 0, x, this.theImage.getHeight());
                            break;
                        }
                        case 4: {
                            g.drawLine(0, y, this.theImage.getWidth(), y);
                        }
                    }
                }
                g2.setStroke(old);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.theImage == null) {
            return new Dimension(320, 200);
        }
        this.measureAxis();
        return new Dimension(this.theImage.getWidth() + this.margin.right + this.margin.left + this.yAxisWidth + this.yAxisRightMargin, this.theImage.getHeight() + this.margin.top + this.margin.bottom + this.xAxisHeight + this.xAxisUpMargin);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected boolean cornerMatch(int x, int y, int xc, int yc) {
        int cw = this.cornerWidth / 2;
        return x >= xc - cw && x <= xc + cw && y >= yc - cw && y <= yc + cw;
    }

    protected int findCorner(int x, int y) {
        if (this.hasSelection()) {
            int xc = (this.x2 + this.x1) / 2;
            int yc = (this.y2 + this.y1) / 2;
            if (this.cornerMatch(x, y, this.x1, this.y1)) {
                return 1;
            }
            if (this.cornerMatch(x, y, this.x2, this.y1) && this.mode != 0) {
                return 2;
            }
            if (this.cornerMatch(x, y, this.x2, this.y2)) {
                return 3;
            }
            if (this.cornerMatch(x, y, this.x1, this.y2) && this.mode != 0) {
                return 4;
            }
            if (this.cornerMatch(x, y, xc, yc)) {
                return 5;
            }
        }
        return 0;
    }

    protected int findMovableCorner(int x, int y) {
        boolean found = false;
        for (int i = 0; !found && i < this.markers.size(); ++i) {
            Marker m = this.markers.get(i);
            if (m.type != 5) continue;
            int x1 = m.markerRect.x;
            int y1 = m.markerRect.y;
            int x2 = m.markerRect.x + m.markerRect.width;
            int y2 = m.markerRect.y + m.markerRect.height;
            int xc = (x2 + x1) / 2;
            int yc = (y2 + y1) / 2;
            if (this.cornerMatch(x, y, x1, y1)) {
                return 1 + i * 10;
            }
            if (this.cornerMatch(x, y, x2, y1)) {
                return 2 + i * 10;
            }
            if (this.cornerMatch(x, y, x2, y2)) {
                return 3 + i * 10;
            }
            if (this.cornerMatch(x, y, x1, y2)) {
                return 4 + i * 10;
            }
            if (this.cornerMatch(x, y, xc, y1)) {
                return 5 + i * 10;
            }
            if (this.cornerMatch(x, y, x2, yc)) {
                return 6 + i * 10;
            }
            if (this.cornerMatch(x, y, xc, y2)) {
                return 7 + i * 10;
            }
            if (this.cornerMatch(x, y, x1, yc)) {
                return 8 + i * 10;
            }
            if (!this.cornerMatch(x, y, xc, yc)) continue;
            return 9 + i * 10;
        }
        return 0;
    }

    protected Rectangle buildSelectionRect() {
        Rectangle r = new Rectangle();
        if (this.x1 < this.x2) {
            if (this.y1 < this.y2) {
                r.setRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
            } else {
                r.setRect(this.x1, this.y2, this.x2 - this.x1, this.y1 - this.y2);
            }
        } else if (this.y1 < this.y2) {
            r.setRect(this.x2, this.y1, this.x1 - this.x2, this.y2 - this.y1);
        } else {
            r.setRect(this.x2, this.y2, this.x1 - this.x2, this.y1 - this.y2);
        }
        return r;
    }

    protected void repaintBoundingRect(Rectangle oldSel) {
        Rectangle newSel = this.buildSelectionRect();
        if (!newSel.equals(oldSel)) {
            int bx1 = oldSel.x;
            int by1 = oldSel.y;
            int bx2 = oldSel.x + oldSel.width;
            int by2 = oldSel.y + oldSel.height;
            if (newSel.x < bx1) {
                bx1 = newSel.x;
            }
            if (newSel.y < by1) {
                by1 = newSel.y;
            }
            if (newSel.width + newSel.x > bx2) {
                bx2 = newSel.width + newSel.x;
            }
            if (newSel.height + newSel.y > by2) {
                by2 = newSel.height + newSel.y;
            }
            int cw = this.cornerWidth / 2;
            if (this.mode == 0 || this.mode == 2) {
                this.repaint(0L, bx1 - cw + this.xOrg + this.yAxisWidth - 4, by1 - cw + this.yOrg + this.xAxisUpMargin - 4, bx2 - bx1 + this.cornerWidth + 8, by2 - by1 + this.cornerWidth + 8);
            } else {
                this.repaint(0L, bx1 - cw + this.xOrg + this.yAxisWidth, by1 - cw + this.yOrg + this.xAxisUpMargin, bx2 - bx1 + this.cornerWidth + 1, by2 - by1 + this.cornerWidth + 1);
            }
        }
    }

    protected void clipSelection() {
        if (this.hasSelection()) {
            Dimension d = this.getImageSize();
            if (this.mode == 0) {
                if (this.x1 >= d.width) {
                    this.x1 = d.width - 1;
                }
                if (this.y1 >= d.height) {
                    this.y1 = d.height - 1;
                }
                if (this.x2 >= d.width) {
                    this.x2 = d.width - 1;
                }
                if (this.y2 >= d.height) {
                    this.y2 = d.height - 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            } else {
                if (this.x1 == this.x2) {
                    this.x2 += this.grid;
                }
                if (this.y1 == this.y2) {
                    this.y2 += this.grid;
                }
                if (d.width > 1) {
                    if (this.x1 >= d.width - 1) {
                        this.x1 = d.width;
                    }
                    if (this.x2 >= d.width - 1) {
                        this.x2 = d.width;
                    }
                } else {
                    this.x1 = 0;
                    this.x2 = 1;
                }
                if (d.height > 1) {
                    if (this.y1 >= d.height - 1) {
                        this.y1 = d.height;
                    }
                    if (this.y2 >= d.height - 1) {
                        this.y2 = d.height;
                    }
                } else {
                    this.y1 = 0;
                    this.y2 = 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            }
        }
    }

    private void moveMarker(Marker m, int x, int y) {
        Dimension d = this.getImageSize();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > d.width - 1) {
            x = d.width - 1;
        }
        if (y > d.height - 1) {
            y = d.height - 1;
        }
        int mx1 = m.markerRect.x;
        int my1 = m.markerRect.y;
        int mx2 = m.markerRect.x + m.markerRect.width - 1;
        int my2 = m.markerRect.y + m.markerRect.height - 1;
        switch (this.dragMovableMarkerCorner) {
            case 1: {
                if (x > mx2) {
                    x = mx2;
                }
                if (y > my2) {
                    y = my2;
                }
                m.markerRect.setBounds(x, y, mx2 - x + 1, my2 - y + 1);
                this.repaint();
                break;
            }
            case 2: {
                if (x < mx1) {
                    x = mx1;
                }
                if (y > my2) {
                    y = my2;
                }
                m.markerRect.setBounds(mx1, y, x - mx1 + 1, my2 - y + 1);
                this.repaint();
                break;
            }
            case 3: {
                if (x < mx1) {
                    x = mx1;
                }
                if (y < my1) {
                    y = my1;
                }
                m.markerRect.setBounds(mx1, my1, x - mx1 + 1, y - my1 + 1);
                this.repaint();
                break;
            }
            case 4: {
                if (x > mx2) {
                    x = mx2;
                }
                if (y < my1) {
                    y = my1;
                }
                m.markerRect.setBounds(x, my1, mx2 - x + 1, y - my1 + 1);
                this.repaint();
                break;
            }
            case 5: {
                if (y > my2) {
                    y = my2;
                }
                m.markerRect.setBounds(mx1, y, mx2 - mx1 + 1, my2 - y + 1);
                this.repaint();
                break;
            }
            case 6: {
                if (x < mx1) {
                    x = mx1;
                }
                m.markerRect.setBounds(mx1, my1, x - mx1 + 1, my2 - my1 + 1);
                this.repaint();
                break;
            }
            case 7: {
                if (y < my1) {
                    y = my1;
                }
                m.markerRect.setBounds(mx1, my1, mx2 - mx1 + 1, y - my1 + 1);
                this.repaint();
                break;
            }
            case 8: {
                if (x > mx2) {
                    x = mx2;
                }
                m.markerRect.setBounds(x, my1, mx2 - x + 1, my2 - my1 + 1);
                this.repaint();
                break;
            }
            case 9: {
                int tx = x - (mx1 + m.markerRect.width / 2);
                int ty = y - (my1 + m.markerRect.height / 2);
                if (mx1 + tx < 0) {
                    tx = -mx1;
                }
                if (my1 + ty < 0) {
                    ty = -my1;
                }
                if (mx2 + tx > d.width - 1) {
                    tx = d.width - 1 - mx2;
                }
                if (my2 + ty > d.height - 1) {
                    ty = d.height - 1 - my2;
                }
                m.markerRect.setBounds(mx1 + tx, my1 + ty, m.markerRect.width, m.markerRect.height);
                this.repaint();
            }
        }
    }

    private boolean hasMovableMarker() {
        boolean found = false;
        if (this.markers == null) {
            return false;
        }
        for (int i = 0; !found && i < this.markers.size(); ++i) {
            found = this.markers.get((int)i).type == 5;
        }
        return found;
    }

    public void fireMarkerSelection(int markerId) {
        MarkerListener[] list = (MarkerListener[])this.listenerList.getListeners(MarkerListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].clickOnMarker(this, markerId);
        }
    }

    public void fireMarkerMoved(int markerId, Marker m) {
        MarkerListener[] list = (MarkerListener[])this.listenerList.getListeners(MarkerListener.class);
        for (int i = 0; i < list.length; ++i) {
            list[i].markerMoved(this, markerId, m.markerRect.x, m.markerRect.y, m.markerRect.x + m.markerRect.width - 1, m.markerRect.y + m.markerRect.height - 1);
        }
    }

    protected void alignSelection() {
        if (this.snapToGrid && this.hasSelection()) {
            if (this.mode == 1) {
                this.x1 = this.x1 / this.grid * this.grid;
                this.x2 = this.x2 / this.grid * this.grid;
                this.y1 = this.y1 / this.grid * this.grid;
                this.y2 = this.y2 / this.grid * this.grid;
            } else {
                Dimension d = this.getImageSize();
                this.x1 = this.x1 >= d.width - 1 ? d.width - 1 : this.x1 / this.grid * this.grid;
                this.x2 = this.x2 >= d.width - 1 ? d.width - 1 : this.x2 / this.grid * this.grid;
                this.y1 = this.y1 >= d.height - 1 ? d.height - 1 : this.y1 / this.grid * this.grid;
                this.y2 = this.y2 >= d.height - 1 ? d.height - 1 : this.y2 / this.grid * this.grid;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int nx = e.getX() - this.xOrg - this.yAxisWidth;
        int ny = e.getY() - this.yOrg - this.xAxisUpMargin;
        if (this.crossCursor) {
            this.xCursor = nx;
            this.yCursor = ny;
            this.repaint();
        }
        if (this.isDragging) {
            Rectangle oldSel = this.buildSelectionRect();
            Dimension d = this.getImageSize();
            if (nx < 0) {
                nx = 0;
            }
            if (ny < 0) {
                ny = 0;
            }
            if (this.mode == 0) {
                if (nx >= d.width) {
                    nx = d.width - 1;
                }
                if (ny >= d.height) {
                    ny = d.height - 1;
                }
            } else {
                if (nx >= d.width) {
                    nx = d.width;
                }
                if (ny >= d.height) {
                    ny = d.height;
                }
            }
            switch (this.dragCorner) {
                case 1: {
                    this.x1 = nx;
                    this.y1 = ny;
                    break;
                }
                case 2: {
                    this.x2 = nx;
                    this.y1 = ny;
                    break;
                }
                case 3: {
                    this.x2 = nx;
                    this.y2 = ny;
                    break;
                }
                case 4: {
                    this.x1 = nx;
                    this.y2 = ny;
                    break;
                }
                case 5: {
                    Rectangle r = this.buildSelectionRect();
                    int xc = r.x + r.width / 2;
                    int yc = r.y + r.height / 2;
                    int tx = nx - xc;
                    int ty = ny - yc;
                    if (this.x1 + tx < 0) {
                        tx = -this.x1;
                    }
                    if (this.x2 + tx < 0) {
                        tx = -this.x2;
                    }
                    if (this.y1 + ty < 0) {
                        ty = -this.y1;
                    }
                    if (this.y2 + ty < 0) {
                        ty = -this.y2;
                    }
                    if (this.mode == 0) {
                        if (this.x1 + tx >= d.width) {
                            tx = d.width - 1 - this.x1;
                        }
                        if (this.x2 + tx >= d.width) {
                            tx = d.width - 1 - this.x2;
                        }
                        if (this.y1 + ty >= d.height) {
                            ty = d.height - 1 - this.y1;
                        }
                        if (this.y2 + ty >= d.height) {
                            ty = d.height - 1 - this.y2;
                        }
                    } else {
                        if (this.x1 + tx >= d.width) {
                            tx = d.width - this.x1;
                        }
                        if (this.x2 + tx >= d.width) {
                            tx = d.width - this.x2;
                        }
                        if (this.y1 + ty >= d.height) {
                            ty = d.height - this.y1;
                        }
                        if (this.y2 + ty >= d.height) {
                            ty = d.height - this.y2;
                        }
                    }
                    this.x1 += tx;
                    this.x2 += tx;
                    this.y1 += ty;
                    this.y2 += ty;
                }
            }
            this.alignSelection();
            this.repaintBoundingRect(oldSel);
        }
        if (this.isDraggingMovable) {
            Marker m = this.markers.get(this.movableMarkerId);
            this.moveMarker(m, nx, ny);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int xImg = e.getX() - this.xOrg - this.yAxisWidth;
        int yImg = e.getY() - this.yOrg - this.xAxisUpMargin;
        if (this.crossCursor) {
            this.xCursor = xImg;
            this.yCursor = yImg;
            this.repaint();
        }
        if (this.hasMovableMarker()) {
            int cType = this.findMovableCorner(xImg, yImg) % 10;
            switch (cType) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(7));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 5: {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 6: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 7: {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 8: {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 9: {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                    break;
                }
                default: {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.crossCursor) {
            this.xCursor = -1;
            this.yCursor = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
        if (this.isDraggingMovable) {
            Marker m = this.markers.get(this.movableMarkerId);
            if (m.hasMoved()) {
                this.fireMarkerMoved(this.movableMarkerId, m);
            }
            this.isDraggingMovable = false;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.grabFocus();
            int x = e.getX() - this.xOrg - this.yAxisWidth;
            int y = e.getY() - this.yOrg - this.xAxisUpMargin;
            if (this.selectionEnabled) {
                this.dragCorner = this.findCorner(x, y);
                if (this.dragCorner == 0 && !this.hasSelection()) {
                    Dimension d = this.getImageSize();
                    if (x > d.width || y > d.height) {
                        return;
                    }
                    if (x < 0) {
                        x = 0;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    this.x1 = this.x2 = x;
                    this.y1 = this.y2 = y;
                    this.dragCorner = 3;
                    this.repaint(0L, this.x1 - this.cornerWidth, this.y1 - this.cornerWidth, this.x1 + this.cornerWidth, this.y1 + this.cornerWidth);
                }
                Rectangle oldSel = this.buildSelectionRect();
                this.alignSelection();
                this.repaintBoundingRect(oldSel);
                this.isDragging = true;
            }
            if (this.hasMovableMarker()) {
                int c = this.findMovableCorner(x, y);
                this.dragMovableMarkerCorner = c % 10;
                this.movableMarkerId = c / 10;
                if (c != 0) {
                    this.fireMarkerSelection(this.movableMarkerId);
                    this.markers.get(this.movableMarkerId).save();
                    this.isDraggingMovable = true;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.hasSelection()) {
            if (e.isShiftDown()) {
                switch (e.getKeyCode()) {
                    case 38: {
                        if (this.horizontalPosition == 2) {
                            this.setHorizontalPosition(1);
                            break;
                        }
                        this.setHorizontalPosition(0);
                        break;
                    }
                    case 40: {
                        if (this.horizontalPosition == 0) {
                            this.setHorizontalPosition(1);
                            break;
                        }
                        this.setHorizontalPosition(2);
                        break;
                    }
                    case 37: {
                        if (this.verticalPosition == 2) {
                            this.setVerticalPosition(1);
                            break;
                        }
                        this.setVerticalPosition(0);
                        break;
                    }
                    case 39: {
                        if (this.verticalPosition == 0) {
                            this.setVerticalPosition(1);
                            break;
                        }
                        this.setVerticalPosition(2);
                    }
                }
            } else {
                Dimension d = this.getImageSize();
                Rectangle oldSel = this.buildSelectionRect();
                int step = this.isSnapToGrid() ? this.grid : 1;
                switch (e.getKeyCode()) {
                    case 38: {
                        if (this.y1 < step || this.y2 < step) break;
                        this.y1 -= step;
                        this.y2 -= step;
                        break;
                    }
                    case 40: {
                        if (!((double)this.y2 < d.getHeight() - (double)step) || !((double)this.y1 < d.getHeight() - (double)step)) break;
                        this.y1 += step;
                        this.y2 += step;
                        break;
                    }
                    case 37: {
                        if (this.x1 < step || this.x2 < step) break;
                        this.x1 -= step;
                        this.x2 -= step;
                        break;
                    }
                    case 39: {
                        if (!((double)this.x2 < d.getWidth() - (double)step) || !((double)this.x1 < d.getWidth() - (double)step)) break;
                        this.x1 += step;
                        this.x2 += step;
                    }
                }
                this.alignSelection();
                this.repaintBoundingRect(oldSel);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JImage image = new JImage();
        BufferedImage img = new BufferedImage(800, 600, 1);
        image.setImage(img);
        image.setSelectionEnabled(false);
        image.addMovableMarker(10, 10, 200, 200, Color.RED, 2);
        image.addMovableMarker(300, 10, 200, 200, Color.GREEN, 2);
        image.mode = 2;
        image.setSelectionColor(Color.GREEN);
        frame.setContentPane(image);
        frame.pack();
        frame.setVisible(true);
    }
}

