/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.EditorPanel;
import fr.esrf.tangoatk.widget.util.Gradient;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class JGradientEditor
extends JComponent
implements ActionListener,
MouseMotionListener,
MouseListener {
    private boolean isEditable;
    private boolean isDragging;
    private Gradient grad;
    private int[] palette;
    private int currentSel = -1;
    private double currentPos;
    private int barHeight = 25;
    private JPopupMenu popMenu;
    private JMenuItem infoMenuItem;
    private JMenuItem addMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem changeColorMenuItem;
    private JMenuItem resetMenuItem;
    private JMenuItem rainbowMenuItem;
    private static final int[] cursorShapeX = new int[]{-5, -2, 2, 5, 5, 2, -2, -5, -5};
    private static final int[] cursorShapeY = new int[]{10, 15, 15, 10, -10, -15, -15, -10, 10};

    public JGradientEditor() {
        this.setBorder(null);
        this.setOpaque(true);
        this.setOpaque(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.isEditable = true;
        this.grad = new Gradient();
        this.palette = this.grad.buildColorMap(256);
        this.popMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Gradient editor");
        this.infoMenuItem.setEnabled(false);
        this.addMenuItem = new JMenuItem("Add color here");
        this.addMenuItem.addActionListener(this);
        this.removeMenuItem = new JMenuItem("Remove");
        this.removeMenuItem.addActionListener(this);
        this.changeColorMenuItem = new JMenuItem("Change color");
        this.changeColorMenuItem.addActionListener(this);
        this.resetMenuItem = new JMenuItem("Reset to default gradient");
        this.resetMenuItem.addActionListener(this);
        this.rainbowMenuItem = new JMenuItem("Reset to rainbow gradient");
        this.rainbowMenuItem.addActionListener(this);
        this.popMenu.add(this.infoMenuItem);
        this.popMenu.add(new JSeparator());
        this.popMenu.add(this.addMenuItem);
        this.popMenu.add(this.removeMenuItem);
        this.popMenu.add(this.changeColorMenuItem);
        this.popMenu.add(this.resetMenuItem);
        this.popMenu.add(this.rainbowMenuItem);
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
    }

    public boolean isEditable() {
        Dimension d = this.getSize();
        return this.isEditable && d.width >= 256;
    }

    public void setGradient(Gradient g) {
        if (g != null) {
            this.grad = g;
            this.palette = g.buildColorMap(256);
        }
    }

    public Gradient getGradient() {
        return this.grad;
    }

    public void setRainbowGradient() {
        this.grad = new Gradient();
        this.grad.buildRainbowGradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    public void setDefaultGradient() {
        this.grad = new Gradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    public void invertGradient() {
        this.grad.invertGradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        block8: {
            int i;
            Dimension d;
            block7: {
                d = this.getSize();
                if (d.width <= 0) {
                    return;
                }
                if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, d.width, d.height);
                }
                if (d.width >= 256) break block7;
                int startY = (d.height - this.barHeight) / 2;
                double r = 256.0 / (double)d.width;
                for (int i2 = 0; i2 < d.width; ++i2) {
                    int id = (int)(r * (double)i2);
                    if (id <= 255) {
                        g.setColor(new Color(this.palette[id]));
                    } else {
                        g.setColor(new Color(this.palette[255]));
                    }
                    g.drawLine(i2, startY, i2, startY + this.barHeight);
                }
                break block8;
            }
            int startX = (d.width - 256) / 2;
            int startY = (d.height - this.barHeight) / 2;
            for (i = 0; i < 256; ++i) {
                g.setColor(new Color(this.palette[i]));
                g.drawLine(startX + i, startY, startX + i, startY + this.barHeight);
            }
            if (!this.isEditable) break block8;
            for (i = 0; i < this.grad.getEntryNumber(); ++i) {
                Color c = this.grad.getColorAt(i);
                double p = this.grad.getPosAt(i);
                int xc = startX + (int)(p * 256.0);
                int yc = startY + this.barHeight / 2;
                g.translate(xc, yc);
                this.paintCursor(g, c);
                g.translate(-xc, -yc);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 50);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isDragging) {
            Dimension d = this.getSize();
            int xe = e.getX();
            int startX = (d.width - 256) / 2;
            this.currentPos = (double)(xe - startX) / 256.0;
            if (this.currentPos < 0.0) {
                this.currentPos = 0.0;
            }
            if (this.currentPos > 1.0) {
                this.currentPos = 1.0;
            }
            this.grad.setPosAt(this.currentSel, this.currentPos);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Color nColor;
        if (!this.isEditable()) {
            return;
        }
        if (!this.isInsideBar(e)) {
            return;
        }
        if (e.getClickCount() == 2 && this.foundEntry(e) && (nColor = JColorChooser.showDialog(this, "Choose gradient color #" + (this.currentSel + 1), this.grad.getColorAt(this.currentSel))) != null) {
            this.grad.setColorAt(this.currentSel, nColor);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEditable()) {
            return;
        }
        if (!this.isInsideBar(e)) {
            return;
        }
        if (this.foundEntry(e)) {
            if (e.getButton() == 3) {
                this.addMenuItem.setVisible(false);
                this.removeMenuItem.setVisible(this.currentSel > 0 && this.currentSel < this.grad.getEntryNumber() - 1);
                this.changeColorMenuItem.setVisible(true);
                this.popMenu.show(this, e.getX(), e.getY());
            }
            if (e.getButton() == 1) {
                this.isDragging = true;
            }
        } else if (e.getButton() == 3) {
            this.addMenuItem.setVisible(true);
            this.removeMenuItem.setVisible(false);
            this.changeColorMenuItem.setVisible(false);
            this.popMenu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.changeColorMenuItem) {
            Color nColor;
            if (this.currentSel >= 0 && this.currentSel < this.grad.getEntryNumber() && (nColor = JColorChooser.showDialog(this, "Choose gradient color #" + (this.currentSel + 1), this.grad.getColorAt(this.currentSel))) != null) {
                this.grad.setColorAt(this.currentSel, nColor);
                this.palette = this.grad.buildColorMap(256);
                this.repaint();
            }
        } else if (evt.getSource() == this.resetMenuItem) {
            this.setDefaultGradient();
        } else if (evt.getSource() == this.rainbowMenuItem) {
            this.setRainbowGradient();
        } else if (evt.getSource() == this.addMenuItem) {
            Color nColor = JColorChooser.showDialog(this, "Choose new color", Color.black);
            if (nColor != null) {
                this.grad.addEntry(nColor, this.currentPos);
                this.palette = this.grad.buildColorMap(256);
                this.repaint();
            }
        } else if (evt.getSource() == this.removeMenuItem) {
            this.grad.removeEntry(this.currentSel);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    public static Gradient showDialog(JDialog parent, Gradient g) {
        JDialog gDialog = new JDialog((Dialog)parent, true);
        return JGradientEditor.showDefDialog(gDialog, g);
    }

    public static Gradient showDialog(JFrame parent, Gradient g) {
        JDialog gDialog = new JDialog((Frame)parent, true);
        return JGradientEditor.showDefDialog(gDialog, g);
    }

    public static Gradient showDialog(JComponent parent, Gradient g) {
        Container p = parent.getRootPane().getParent();
        JDialog gDialog = p instanceof JDialog ? new JDialog((Dialog)((JDialog)p), true) : (p instanceof JFrame ? new JDialog((Frame)((JFrame)p), true) : new JDialog((Frame)null, true));
        return JGradientEditor.showDefDialog(gDialog, g);
    }

    private Color transformColor(Color c, int offset) {
        int nr = c.getRed() + offset;
        int ng = c.getBlue() + offset;
        int nb = c.getGreen() + offset;
        if (nr > 255) {
            nr = 255;
        }
        if (ng > 255) {
            ng = 255;
        }
        if (nb > 255) {
            nb = 255;
        }
        if (nr < 0) {
            nr = 0;
        }
        if (ng < 0) {
            ng = 0;
        }
        if (nb < 0) {
            nb = 0;
        }
        return new Color(nr, ng, nb);
    }

    private boolean isLightColor(Color c) {
        int b;
        int g;
        int r = c.getRed();
        return Math.sqrt(r * r + (g = c.getGreen()) * g + (b = c.getBlue()) * b) > 180.0;
    }

    private void paintCursor(Graphics g, Color c) {
        g.setColor(c);
        g.fillPolygon(cursorShapeX, cursorShapeY, 9);
        if (this.isLightColor(c)) {
            g.setColor(this.transformColor(c, -128));
        } else {
            g.setColor(this.transformColor(c, 128));
        }
        g.drawPolygon(cursorShapeX, cursorShapeY, 9);
    }

    private boolean isInsideBar(MouseEvent e) {
        Dimension d = this.getSize();
        int xe = e.getX();
        int ye = e.getY();
        int startX = (d.width - 256) / 2;
        int startY = (d.height - this.barHeight) / 2;
        return xe >= startX - 5 && xe <= startX + 261 && ye >= startY && ye <= startY + this.barHeight;
    }

    private boolean foundEntry(MouseEvent e) {
        int yc;
        int xc;
        double p;
        boolean found = false;
        Dimension d = this.getSize();
        int xe = e.getX();
        int ye = e.getY();
        int startX = (d.width - 256) / 2;
        int startY = (d.height - this.barHeight) / 2;
        int i = this.grad.getEntryNumber() - 2;
        while (i > 0 && !found) {
            p = this.grad.getPosAt(i);
            xc = startX + (int)(p * 256.0);
            yc = startY + this.barHeight / 2;
            found = xe > xc - 8 && xe < xc + 8 && ye > yc - 15 && ye < yc + 15;
            if (found) continue;
            --i;
        }
        if (found) {
            this.currentSel = i;
        } else {
            p = this.grad.getPosAt(0);
            xc = startX + (int)(p * 256.0);
            yc = startY + this.barHeight / 2;
            boolean bl = found = xe > xc - 8 && xe < xc + 8 && ye > yc - 15 && ye < yc + 15;
            if (!found) {
                p = this.grad.getPosAt(this.grad.getEntryNumber() - 1);
                xc = startX + (int)(p * 256.0);
                yc = startY + this.barHeight / 2;
                boolean bl2 = found = xe > xc - 8 && xe < xc + 8 && ye > yc - 15 && ye < yc + 15;
                this.currentSel = !found ? -1 : this.grad.getEntryNumber() - 1;
            } else {
                this.currentSel = 0;
            }
        }
        this.currentPos = (double)(xe - startX) / 256.0;
        if (this.currentPos < 0.0) {
            this.currentPos = 0.0;
        }
        if (this.currentPos > 1.0) {
            this.currentPos = 1.0;
        }
        return found;
    }

    private static Gradient showDefDialog(JDialog gDialog, Gradient gOrg) {
        EditorPanel gradEditor = new EditorPanel();
        if (gOrg != null) {
            Gradient g = gOrg.cloneMe();
            gradEditor.setGradient(g);
        }
        gDialog.setResizable(false);
        gDialog.setContentPane(gradEditor);
        gDialog.setTitle("Colormap gradient editor");
        ATKGraphicsUtils.centerDialog(gDialog);
        gDialog.setVisible(true);
        gDialog.dispose();
        if (gradEditor.dlgRetValue == 0) {
            return null;
        }
        return gradEditor.getGradient();
    }

    public static void main(String[] args) {
        Gradient d = new Gradient();
        d.buildRainbowGradient();
        JGradientEditor.showDialog((JFrame)null, d);
    }
}

