/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class JArrowButton
extends JComponent
implements MouseListener,
ActionListener {
    public static int UP = 1;
    public static int DOWN = 2;
    private int state;
    private int orientation;
    private Color lightColor;
    private Color darkColor;
    private Color lightDisaColor;
    private Color darkDisaColor;
    private Timer autoRepeat;
    private int timerDelay;

    public JArrowButton() {
        this.setLayout(null);
        this.setBackground(new Color(200, 200, 200));
        this.setPreferredSize(new Dimension(20, 20));
        this.setOpaque(false);
        this.state = 0;
        this.orientation = UP;
        this.timerDelay = 300;
        this.autoRepeat = new Timer(1000, this);
        this.addMouseListener(this);
    }

    public void setOrientation(int o) {
        this.orientation = o;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setState(int s) {
        this.state = s;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void setBackground(Color c) {
        if (this.getBackground() != null && c.getRGB() == this.getBackground().getRGB()) {
            return;
        }
        this.lightColor = this.computeShadowColor(c, 90.0);
        this.darkColor = this.computeShadowColor(c, -90.0);
        this.lightDisaColor = this.computeShadowColor(c, 20.0);
        this.darkDisaColor = this.computeShadowColor(c, -20.0);
        super.setBackground(c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getSource() == this.autoRepeat) {
            if (this.autoRepeat.getDelay() != this.timerDelay) {
                this.autoRepeat.setDelay(this.timerDelay);
            }
            MouseListener[] listenerList = (MouseListener[])this.getListeners(MouseListener.class);
            MouseEvent m = new MouseEvent(this, 500, e.getWhen(), e.getModifiers(), 3, 3, 1, false);
            for (int i = 0; i < listenerList.length; ++i) {
                listenerList[i].mouseClicked(m);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 0;
        this.autoRepeat.stop();
        this.autoRepeat.setDelay(1000);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 1;
        this.autoRepeat.start();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.state = 0;
        this.autoRepeat.stop();
        this.autoRepeat.setDelay(1000);
        this.repaint();
    }

    private void setLightColor(Graphics g) {
        if (this.isEnabled()) {
            g.setColor(this.lightColor);
        } else {
            g.setColor(this.lightDisaColor);
        }
    }

    private void setDarkColor(Graphics g) {
        if (this.isEnabled()) {
            g.setColor(this.darkColor);
        } else {
            g.setColor(this.darkDisaColor);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth() - 1;
        int h = this.getHeight() - 1;
        int m = w / 2;
        int[] pointx = new int[3];
        int[] pointy = new int[3];
        if (this.orientation == UP) {
            pointx[0] = 0;
            pointy[0] = h;
            pointx[1] = m;
            pointy[1] = 0;
            pointx[2] = w;
            pointy[2] = h;
            g.setColor(this.getBackground());
            g.fillPolygon(pointx, pointy, 3);
            if (this.state == 0) {
                this.setLightColor(g);
                g.drawLine(0, h, m, 0);
                this.setDarkColor(g);
                g.drawLine(m, 0, w, h);
                g.drawLine(w, h, 0, h);
            } else {
                this.setDarkColor(g);
                g.drawLine(0, h, m, 0);
                this.setLightColor(g);
                g.drawLine(m, 0, w, h);
                g.drawLine(w, h, 0, h);
            }
        } else {
            pointx[0] = 0;
            pointy[0] = 0;
            pointx[1] = m;
            pointy[1] = h;
            pointx[2] = w;
            pointy[2] = 0;
            g.setColor(this.getBackground());
            g.fillPolygon(pointx, pointy, 3);
            if (this.state == 0) {
                this.setLightColor(g);
                g.drawLine(0, 0, m, h);
                this.setDarkColor(g);
                g.drawLine(m, h, w, 0);
                g.drawLine(w, 0, 0, 0);
            } else {
                this.setDarkColor(g);
                g.drawLine(0, 0, m, h);
                this.setLightColor(g);
                g.drawLine(m, h, w, 0);
                g.drawLine(w, 0, 0, 0);
            }
        }
    }

    private void RGBtoYUV(Color c, double[] yuv) {
        double R = c.getRed();
        double G = c.getGreen();
        double B = c.getBlue();
        yuv[0] = 0.299 * R + 0.587 * G + 0.114 * B;
        yuv[1] = -0.169 * R - 0.331 * G + 0.5 * B + 128.0;
        yuv[2] = 0.5 * R - 0.419 * G - 0.081 * B + 128.0;
    }

    private Color createColorFromYUV(double[] yuv) {
        int r = (int)(yuv[0] + 1.4075 * (yuv[2] - 128.0));
        int g = (int)(yuv[0] - 0.7169 * (yuv[2] - 128.0) - 0.3455 * (yuv[1] - 128.0));
        int b = (int)(yuv[0] + 1.779 * (yuv[1] - 128.0));
        if (r > 255) {
            r = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (b > 255) {
            b = 255;
        }
        if (b < 0) {
            b = 0;
        }
        return new Color(r, g, b);
    }

    private Color computeShadowColor(Color c, double ratio) {
        double[] yuv = new double[3];
        this.RGBtoYUV(c, yuv);
        yuv[0] = yuv[0] + ratio;
        return this.createColorFromYUV(yuv);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JArrowButton b = new JArrowButton();
        f.getContentPane().setLayout(null);
        f.getContentPane().add(b);
        b.setBounds(10, 10, 10, 10);
        f.setSize(200, 100);
        f.setVisible(true);
    }
}

