/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;

public class ErrorPopup
implements IErrorListener,
ISetErrorListener {
    private static ErrorPopup instance;

    private ErrorPopup() {
    }

    public static ErrorPopup getInstance() {
        if (instance == null) {
            instance = new ErrorPopup();
        }
        return instance;
    }

    private String getSourceName(ErrorEvent evt) {
        Object src = evt.getSource();
        String ret = "";
        if (src != null) {
            if (src instanceof IEntity) {
                ret = ((IEntity)src).getName();
            } else if (src instanceof Device) {
                ret = ((Device)src).getName();
            } else if (src instanceof String) {
                ret = (String)src;
            } else {
                System.out.println("ErrorPopup.getSourceName() : Warning getting unknown source object.");
            }
        }
        return ret;
    }

    @Override
    public void errorChange(ErrorEvent evt) {
        Throwable error = evt.getError();
        if (error instanceof AttributeSetException || error instanceof CommandExecuteException) {
            ATKException atkex = (ATKException)error;
            ErrorPane.showErrorMessage(null, this.getSourceName(evt), atkex);
        }
    }

    @Override
    public void setErrorOccured(ErrorEvent evt) {
        Throwable error = evt.getError();
        if (error instanceof AttributeSetException) {
            ATKException atkex = (ATKException)error;
            ErrorPane.showErrorMessage(null, "Set Attribute Error", this.getSourceName(evt), atkex);
        } else {
            System.out.println("ErrorPopup.setErrorOccured() : not an AttributeSetException.");
        }
    }

    public static void main(String[] args) throws Exception {
        AttributeList list = new AttributeList();
        ErrorHistory eh = new ErrorHistory();
        list.addErrorListener(eh);
        eh.setVisible(true);
        list.addErrorListener(ErrorPopup.getInstance());
        list.addSetErrorListener(ErrorPopup.getInstance());
        list.add("jlp/test/1/att_trois");
        list.startRefresher();
    }
}

