/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevError;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.widget.util.ErrorList;
import fr.esrf.tangoatk.widget.util.ErrorObject;
import fr.esrf.tangoatk.widget.util.ErrorPanel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class ErrorAdapter
extends AbstractTableModel {
    public static final int TIME = 0;
    public static final int SEVERITY = 1;
    public static final int SOURCE = 2;
    public static final int DESCRIPTION = 3;
    public static final int ORIGIN = 4;
    public static final int REASON = 5;
    private static final int MIN_ERROR_BUFFER_SIZE = 100;
    String[] columnNames = new String[]{"Time", "Severity", "Source", "Description"};
    SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    int errorBufferSize = 100;
    int nbError = 0;
    Vector errors = new Vector();
    Vector filteredErrors = new Vector();
    int sortColumn = -1;
    String visibleSource = null;
    boolean showPanic = true;
    boolean showError = true;
    boolean showWarning = true;
    ErrorPanel peerPanel = null;

    ErrorAdapter() {
    }

    public void setErrorPanel(ErrorPanel p) {
        this.peerPanel = p;
    }

    synchronized void clearError() {
        this.errors = new Vector();
        this.filteredErrors = new Vector();
        this.nbError = 0;
        this.fireSourceChange();
        this.updateFilters();
    }

    public synchronized void addError(ErrorEvent errorevent) {
        boolean added;
        String src = errorevent.getSource().toString();
        if (src == null) {
            System.out.println("ErrorAdapter.addError() : Warning cannot handle error with null source !");
            System.out.println("ErrorAdapter.addError() : " + errorevent.getError());
            return;
        }
        int i = this.getSourceIndex(src);
        if (i >= 0) {
            added = ((ErrorList)this.errors.get(i)).addError(errorevent.getError(), errorevent.getTimeStamp());
        } else {
            ErrorList nList = new ErrorList(src);
            added = nList.addError(errorevent.getError(), errorevent.getTimeStamp());
            this.errors.add(nList);
            this.fireSourceChange();
        }
        if (added) {
            if (this.nbError >= this.errorBufferSize) {
                ErrorList el;
                int imin = -1;
                long tmin = Long.MAX_VALUE;
                i = 0;
                for (i = 0; i < this.errors.size(); ++i) {
                    el = (ErrorList)this.errors.get(0);
                    if (el.get(0).getTime() >= tmin) continue;
                    tmin = el.get(0).getTime();
                    imin = i;
                }
                if (imin >= 0) {
                    el = (ErrorList)this.errors.get(imin);
                    el.removeFirst();
                    if (el.size() == 0) {
                        this.errors.remove(el);
                        this.fireSourceChange();
                    }
                }
            } else {
                ++this.nbError;
            }
        }
        this.updateFilters();
    }

    public int getErrorBufferSize() {
        return this.errorBufferSize;
    }

    public void setErrorBufferSize(int bs) {
        if (bs > 100) {
            this.errorBufferSize = bs;
        }
    }

    public void setTimeFormat(SimpleDateFormat simpledateformat) {
        this.format = simpledateformat;
    }

    public SimpleDateFormat getTimeFormat() {
        return this.format;
    }

    public void setSourceFilter(String s) {
        this.visibleSource = s;
        this.updateFilters();
    }

    public void setSortedColumn(int column) {
        this.sortColumn = column;
        this.updateFilters();
    }

    public void showPanic(boolean b) {
        this.showPanic = b;
        this.updateFilters();
    }

    public void showError(boolean b) {
        this.showError = b;
        this.updateFilters();
    }

    public void showWarning(boolean b) {
        this.showWarning = b;
        this.updateFilters();
    }

    public DevError[] getErrorNumber(int i) {
        Throwable throwable = ((ErrorObject)this.filteredErrors.get(i)).getError();
        if (!(throwable instanceof ATKException)) {
            return null;
        }
        return ((ATKException)throwable).getErrors();
    }

    public Throwable getErrorAt(int i) {
        return ((ErrorObject)this.filteredErrors.get(i)).getError();
    }

    public Vector getAllSource() {
        Vector<String> ret = new Vector<String>();
        for (int i = 0; i < this.errors.size(); ++i) {
            ret.add(((ErrorList)this.errors.get((int)i)).source);
        }
        return ret;
    }

    @Override
    public Object getValueAt(int i, int j) {
        ErrorObject err = (ErrorObject)this.filteredErrors.get(i);
        switch (j) {
            case 0: {
                Date date = new Date(err.getTime());
                return this.format.format(date);
            }
            case 1: {
                return err.getSeverity();
            }
            case 3: {
                return err.getMessage();
            }
            case 2: {
                return err.getSource();
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.filteredErrors.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    private int getSourceIndex(String src) {
        int i = 0;
        boolean found = false;
        if (src == null) {
            return -1;
        }
        while (!found && i < this.errors.size()) {
            found = src.equalsIgnoreCase(((ErrorList)this.errors.get((int)i)).source);
            if (found) continue;
            ++i;
        }
        if (!found) {
            return -1;
        }
        return i;
    }

    private void updateFilters() {
        Vector nErrors = new Vector();
        int src = this.getSourceIndex(this.visibleSource);
        if (src >= 0) {
            ErrorList el = (ErrorList)this.errors.get(src);
            for (int i = 0; i < el.size(); ++i) {
                this.insertError(nErrors, el.get(i));
            }
        } else {
            for (int j = 0; j < this.errors.size(); ++j) {
                ErrorList el = (ErrorList)this.errors.get(j);
                for (int i = 0; i < el.size(); ++i) {
                    this.insertError(nErrors, el.get(i));
                }
            }
        }
        this.filteredErrors = nErrors;
        this.fireTableDataChanged();
    }

    private void insertError(Vector errs, ErrorObject e) {
        if (!this.wanted(e)) {
            return;
        }
        int sz = errs.size();
        int i = 0;
        boolean found = false;
        switch (this.sortColumn) {
            case 0: {
                while (!found && i < sz) {
                    ErrorObject c = (ErrorObject)errs.get(i);
                    found = e.getTime() <= c.getTime();
                    if (found) continue;
                    ++i;
                }
                break;
            }
            case 1: {
                while (!found && i < sz) {
                    ErrorObject c = (ErrorObject)errs.get(i);
                    int cp = e.getSeverity().compareToIgnoreCase(c.getSeverity());
                    found = cp < 0 || cp == 0 && e.getTime() <= c.getTime();
                    if (found) continue;
                    ++i;
                }
                break;
            }
            case 2: {
                while (!found && i < sz) {
                    ErrorObject c = (ErrorObject)errs.get(i);
                    int cp = e.getSource().compareToIgnoreCase(c.getSource());
                    found = cp < 0 || cp == 0 && e.getTime() <= c.getTime();
                    if (found) continue;
                    ++i;
                }
                break;
            }
            case 3: {
                while (!found && i < sz) {
                    ErrorObject c = (ErrorObject)errs.get(i);
                    int cp = e.getMessage().compareToIgnoreCase(c.getMessage());
                    found = cp < 0 || cp == 0 && e.getTime() <= c.getTime();
                    if (found) continue;
                    ++i;
                }
                break;
            }
            default: {
                errs.add(e);
                return;
            }
        }
        errs.add(i, e);
    }

    private boolean wanted(ErrorObject evt) {
        if (!this.showPanic && evt.getSeverity().equals(ATKException.severity[2])) {
            return false;
        }
        if (!this.showError && evt.getSeverity().equals(ATKException.severity[1])) {
            return false;
        }
        return this.showWarning || !evt.getSeverity().equals(ATKException.severity[0]);
    }

    private void fireSourceChange() {
        if (this.peerPanel != null) {
            this.peerPanel.sourceChange();
        }
    }
}

