/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.NumberProperty;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringProperty;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class EntityJTableAdapter
extends AbstractTableModel {
    JTable table;
    boolean initialized = false;
    List entities = new Vector();
    int columns = 0;
    List columnNames = new Vector();

    public void addTableModelListener(JTable jtable) {
        super.addTableModelListener(jtable);
        System.out.println("Added listener " + jtable);
    }

    public void addEntity(IEntity ientity) {
        this.entities.add(ientity);
        Map map = ientity.getPropertyMap();
        if (!this.initialized) {
            this.columnNames.addAll(map.values());
            this.columns = this.columnNames.size();
        } else {
            this.normalizeProperties(ientity);
        }
        this.fireTableChanged(new TableModelEvent(this));
        this.fireTableRowsInserted(0, 1);
    }

    protected void normalizeProperties(IEntity ientity) {
        Map map = ientity.getPropertyMap();
        try {
            if (map.size() < this.columns) {
                for (int i = 0; i < this.columns; ++i) {
                    String s = ((Property)this.columnNames.get(i)).toString();
                    if (map.containsKey(s)) continue;
                    map.put(s, null);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void addEntities(AttributeList attributelist) {
        int i = this.entities.size();
        for (int j = 0; j < attributelist.size(); ++j) {
            IEntity ientity = (IEntity)attributelist.get(j);
            this.normalizeProperties(ientity);
            this.entities.add(attributelist.get(j));
        }
        this.fireTableRowsInserted(i, this.entities.size() - 1);
    }

    public void setTable(JTable jtable) {
        this.table = jtable;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames.get(i).toString();
    }

    @Override
    public int getRowCount() {
        return this.entities.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    public Property internalGetValueAt(int i, int j) {
        Vector vector = new Vector();
        IEntity ientity = (IEntity)this.entities.get(i);
        if (ientity.getPropertyMap() == null) {
            return null;
        }
        vector.addAll(ientity.getPropertyMap().values());
        return (Property)vector.get(j);
    }

    @Override
    public Object getValueAt(int i, int j) {
        Property aentityproperty = this.internalGetValueAt(i, j);
        if (aentityproperty == null) {
            aentityproperty = (Property)this.columnNames.get(j);
            if (aentityproperty instanceof NumberProperty) {
                return new Double("NaN");
            }
            return "NULL";
        }
        if (aentityproperty instanceof StringProperty || aentityproperty instanceof NumberProperty) {
            System.out.println("Returning " + aentityproperty.getValue());
            return aentityproperty.getValue();
        }
        return aentityproperty.getPresentation();
    }

    @Override
    public void setValueAt(Object obj, int i, int j) {
        Property aentityproperty = this.internalGetValueAt(i, j);
        aentityproperty.setValue(obj);
        aentityproperty.store();
        this.fireTableCellUpdated(i, j);
    }

    @Override
    public boolean isCellEditable(int i, int j) {
        Property aentityproperty = this.internalGetValueAt(i, j);
        if (aentityproperty == null) {
            return false;
        }
        return aentityproperty.isEditable();
    }

    public Class getColumnClass(int i) {
        Property aentityproperty = (Property)this.columnNames.get(i);
        if (aentityproperty instanceof StringProperty) {
            return String.class;
        }
        if (aentityproperty instanceof NumberProperty) {
            return Double.class;
        }
        return String.class;
    }

    public static void main(String[] args) throws Exception {
        JFrame jframe = new JFrame();
        AttributeList attributelist = new AttributeList();
        EntityJTableAdapter entityjtableadapter = new EntityJTableAdapter();
        entityjtableadapter.addEntity(attributelist.add("eas/test-api/1/Att_sinus"));
        JTable jtable = new JTable(entityjtableadapter);
        jtable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        attributelist.add("eas/test-api/1/*");
        JScrollPane jscrollpane = new JScrollPane(jtable);
        jframe.getContentPane().add(jscrollpane);
        jframe.pack();
        jframe.setVisible(true);
    }
}

