/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class EditorPanel
extends JPanel
implements ActionListener {
    private JButton bwButton;
    private JButton colorButton;
    private JButton invertButton;
    private JButton helpButton;
    private JButton okButton;
    private JButton cancelButton;
    private JGradientEditor gradEditor;
    private static String helpString = "Cursor color can be changed by double clicking on it.\nCursors can be moved by dragging them.\nColor entry can be added or removed by right clicking on the gradient.";
    int dlgRetValue = 0;

    public EditorPanel() {
        this.setLayout(new BorderLayout());
        JPanel gPanel = new JPanel();
        gPanel.setLayout(new BorderLayout());
        gPanel.setBorder(BorderFactory.createEtchedBorder());
        this.gradEditor = new JGradientEditor();
        gPanel.add((Component)this.gradEditor, "Center");
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new FlowLayout());
        this.bwButton = new JButton("Monochrome");
        this.bwButton.setFont(ATKConstant.labelFont);
        this.bwButton.addActionListener(this);
        cPanel.add(this.bwButton);
        this.colorButton = new JButton("Color");
        this.colorButton.setFont(ATKConstant.labelFont);
        this.colorButton.addActionListener(this);
        cPanel.add(this.colorButton);
        this.invertButton = new JButton("Invert");
        this.invertButton.setFont(ATKConstant.labelFont);
        this.invertButton.addActionListener(this);
        cPanel.add(this.invertButton);
        gPanel.add((Component)cPanel, "South");
        this.add((Component)gPanel, "Center");
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(2);
        JPanel panelButton = new JPanel(fl);
        this.helpButton = new JButton("Help");
        this.helpButton.setFont(ATKConstant.labelFont);
        this.helpButton.addActionListener(this);
        this.okButton = new JButton("Apply");
        this.okButton.setFont(ATKConstant.labelFont);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Dismiss");
        this.cancelButton.setFont(ATKConstant.labelFont);
        this.cancelButton.addActionListener(this);
        panelButton.add(this.helpButton);
        panelButton.add(this.okButton);
        panelButton.add(this.cancelButton);
        this.add((Component)panelButton, "South");
    }

    public void setEditable(boolean b) {
        this.gradEditor.setEditable(b);
    }

    public boolean isEditable() {
        return this.gradEditor.isEditable();
    }

    public void setGradient(Gradient g) {
        this.gradEditor.setGradient(g);
    }

    public Gradient getGradient() {
        return this.gradEditor.getGradient();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            this.dlgRetValue = 1;
            this.getRootPane().getParent().setVisible(false);
        } else if (src == this.cancelButton) {
            this.dlgRetValue = 0;
            this.getRootPane().getParent().setVisible(false);
        } else if (src == this.bwButton) {
            this.gradEditor.setDefaultGradient();
        } else if (src == this.colorButton) {
            this.gradEditor.setRainbowGradient();
        } else if (src == this.invertButton) {
            this.gradEditor.invertGradient();
        } else if (src == this.helpButton) {
            JOptionPane.showMessageDialog(null, helpString, "Help on Gradient Editor", 1);
        }
    }
}

