/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.EditableTableRowModel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.TableRowModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JTable;

public class EditableJTableRow
extends JTableRow
implements ActionListener {
    protected JMenuItem loadMenuItem;
    protected JMenuItem deleteMenuItem;
    private EditableTableRowModel etrm = null;

    public EditableJTableRow() {
        this.editable = true;
        this.loadMenuItem = new JMenuItem("Load File");
        this.loadMenuItem.addActionListener(this);
        this.deleteMenuItem = new JMenuItem("Delete Rows");
        this.deleteMenuItem.addActionListener(this);
        int saveIndex = this.tableMenu.getComponentIndex(this.saveMenuItem);
        this.tableMenu.remove(saveIndex);
        this.tableMenu.insert(this.loadMenuItem, saveIndex);
        this.tableMenu.insert(this.deleteMenuItem, saveIndex);
        this.etrm = new EditableTableRowModel();
        this.dm = this.etrm;
    }

    @Override
    public void setEditable(boolean b) {
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public void setTableRowModel(TableRowModel trm) {
        if (trm != null) {
            this.dm = trm;
        }
    }

    public EditableTableRowModel getEditorTableRowModel() {
        return this.etrm;
    }

    public JTable getJTable() {
        return this.theTable;
    }

    public void loadDataFile() {
        File f;
        int returnVal;
        JFileChooser jfc = new JFileChooser(".");
        if (this.currentFile != null) {
            jfc.setSelectedFile(this.currentFile);
        }
        if ((returnVal = jfc.showDialog(this, "Load")) == 0 && (f = jfc.getSelectedFile()) != null) {
            this.currentFile = f;
            this.etrm.loadDataFile(f);
            String[] colNames = this.etrm.getColName();
            this.setData(this.etrm.getData(), colNames);
            this.etrm.fireTableDataChanged();
        }
    }

    public void deleteSelectedRows() {
        int[] cols = this.theTable.getSelectedColumns();
        int[] rows = this.theTable.getSelectedRows();
        if (!(cols != null && cols.length != 0 || rows != null && rows.length != 0)) {
            return;
        }
        this.theTable.clearSelection();
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            this.etrm.removeOneRow(rows[i]);
        }
        String[] colNames = this.etrm.getColName();
        this.setData(this.etrm.getData(), colNames);
        this.etrm.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src != this.loadMenuItem && src != this.deleteMenuItem) {
            super.actionPerformed(e);
            return;
        }
        if (src == this.deleteMenuItem) {
            this.deleteSelectedRows();
        }
        if (src == this.loadMenuItem) {
            this.loadDataFile();
        }
    }
}

