/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Node;
import fr.esrf.tangoatk.widget.util.RootNode;
import fr.esrf.tangoatk.widget.util.TreeNodeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DeviceFinder
extends JPanel {
    public static final int MODE_DEVICE = 0;
    public static final int MODE_ATTRIBUTE = 1;
    public static final int MODE_COMMAND = 2;
    public static final int MODE_ATTRIBUTE_SCALAR = 3;
    public static final int MODE_ATTRIBUTE_NUMBER_SCALAR = 4;
    public static final int MODE_ATTRIBUTE_BOOLEAN_SCALAR = 5;
    public static final int MODE_ATTRIBUTE_STRING_SCALAR = 6;
    public static final int MODE_ATTRIBUTE_NUMBER_SPECTRUM = 7;
    public static final int MODE_ATTRIBUTE_NUMBER_BOOLEAN_SCALAR = 8;
    public static final int MODE_ATTRIBUTE_NUMBER_BOOLEAN_SPECTRUM_SCALAR = 9;
    public static final int MODE_ATTRIBUTE_NUMBER_BOOLEAN_STATE_SPECTRUM_SCALAR = 10;
    static Database db;
    JTree tree;
    JScrollPane treeView;
    DefaultTreeModel treeModel;
    int mode;

    public DeviceFinder(int mode) {
        this.mode = mode;
        try {
            db = ApiUtil.get_db_obj();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage(null, "Database", e);
            return;
        }
        this.setLayout(new BorderLayout());
        this.createTree();
        this.add((Component)this.treeView, "Center");
    }

    public void setSelectionModel(int selectionModel) {
        this.tree.getSelectionModel().setSelectionMode(selectionModel);
    }

    public String[] getSelectedNames() {
        TreePath[] p = this.tree.getSelectionPaths();
        Vector<String> completePath = new Vector<String>();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                Object[] pth = p[i].getPath();
                Node lastNode = (Node)pth[pth.length - 1];
                if (!lastNode.isLeaf()) continue;
                StringBuffer str = new StringBuffer();
                for (int j = 1; j < pth.length; ++j) {
                    str.append(pth[j]);
                    if (j == pth.length - 1) continue;
                    str.append('/');
                }
                completePath.add(str.toString());
            }
        }
        String[] ret = new String[completePath.size()];
        for (int i = 0; i < completePath.size(); ++i) {
            ret[i] = (String)completePath.get(i);
        }
        return ret;
    }

    private void createTree() {
        this.treeModel = new DefaultTreeModel(new RootNode(this.mode));
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new TreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeView = new JScrollPane(this.tree);
    }

    public JTree getTree() {
        return this.tree;
    }

    public static void main(String[] args) {
        final DeviceFinder df = new DeviceFinder(0);
        df.setSelectionModel(1);
        JFrame f = new JFrame();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JButton selButton = new JButton("Select");
        selButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] names = df.getSelectedNames();
                System.out.println("-------------------------");
                for (int i = 0; i < names.length; ++i) {
                    System.out.println(names[i]);
                }
            }
        });
        p.add((Component)selButton, "South");
        p.add((Component)df, "Center");
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }
}

