/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.util.Vector;

public class AdvancedImagePlus
extends ImagePlus {
    protected Vector<Roi> roiVector = new Vector();
    protected Vector<Roi> selectedRois = new Vector();
    protected Vector<Roi> innerRois = new Vector();
    protected Vector<Roi> outerRois = new Vector();
    protected Roi validatedRoi = null;
    protected boolean allowRoiCreation = true;

    public AdvancedImagePlus() {
    }

    public AdvancedImagePlus(String title, Image img) {
        super(title, img);
    }

    public AdvancedImagePlus(String title, ImageProcessor ip) {
        super(title, ip);
    }

    public AdvancedImagePlus(String title, ImageStack stack) {
        super(title, stack);
    }

    public AdvancedImagePlus(String pathOrURL) {
        super(pathOrURL);
    }

    @Override
    public void setImage(Image img) {
        super.setImage(img);
    }

    @Override
    public void setRoi(Roi newRoi) {
        if (newRoi != null) {
            this.addRoi(newRoi);
            newRoi.setImage(this);
        }
        this.setHandledRoi(newRoi);
        Roi.previousRoi = null;
    }

    @Override
    public void killRoi() {
        super.killRoi();
        Roi.previousRoi = null;
    }

    public void setSelectedRoi(Roi selectedRoi) {
        if (!this.selectedRois.contains(selectedRoi)) {
            this.selectedRois.add(selectedRoi);
        }
        this.setHandledRoi(selectedRoi);
    }

    public void setHandledRoi(Roi handledRoi) {
        this.roi = handledRoi;
        if (this.getProcessor() != null) {
            this.getProcessor().setRoi(handledRoi);
        }
    }

    @Override
    public void createNewRoi(int sx, int sy) {
        if (this.isAllowRoiCreation()) {
            super.createNewRoi(sx, sy);
            if (this.roi != null) {
                this.addRoi(this.roi);
            }
        }
    }

    public void addRoi(Roi roi) {
        if (!this.roiVector.contains(roi)) {
            this.roiVector.add(roi);
        }
    }

    public void removeRoi(Roi roi) {
        this.roiVector.remove(roi);
        this.selectedRois.remove(roi);
        this.innerRois.remove(roi);
        this.outerRois.remove(roi);
        if (this.validatedRoi != null && this.validatedRoi.equals(roi)) {
            this.validatedRoi = null;
        }
        if (this.getRoi() != null && this.getRoi().equals(roi)) {
            this.setRoi((Roi)null);
        }
    }

    public Vector<Roi> getAllRois() {
        return this.roiVector;
    }

    public Vector<Roi> getSelectedRois() {
        return this.selectedRois;
    }

    public void setSelectedRois(Vector<Roi> selectedRois) {
        this.selectedRois = selectedRois;
    }

    public void deleteSelectedRois() {
        for (int i = 0; i < this.getSelectedRois().size(); ++i) {
            this.getAllRois().remove(this.getSelectedRois().get(i));
            if (this.getRoi() != null && this.getRoi().equals(this.getSelectedRois().get(i))) {
                this.killRoi();
                this.roi = null;
            }
            this.getInnerRois().remove(this.getSelectedRois().get(i));
            this.getOuterRois().remove(this.getSelectedRois().get(i));
            if (this.validatedRoi != this.getSelectedRois().get(i)) continue;
            this.validatedRoi = null;
        }
        this.getSelectedRois().clear();
        if (this.getAllRois().size() > 0) {
            this.roi = this.getAllRois().get(this.getAllRois().size() - 1);
        }
    }

    public boolean isAllowRoiCreation() {
        return this.allowRoiCreation;
    }

    public void setAllowRoiCreation(boolean allowRoiCreation) {
        this.allowRoiCreation = allowRoiCreation;
    }

    public Vector<Roi> getInnerRois() {
        return this.innerRois;
    }

    public Vector<Roi> getOuterRois() {
        return this.outerRois;
    }

    public Roi getValidatedRoi() {
        return this.validatedRoi;
    }

    public void setValidatedRoi(Roi validatedRoi) {
        this.validatedRoi = validatedRoi;
    }
}

