/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class ATKField
extends JTextField {
    protected boolean inserting = false;
    protected boolean editable = false;
    protected boolean modelEditable = false;
    protected boolean receivedEvent = false;
    protected int length = 0;
    protected String format = "";
    protected String error = "-------";
    protected ATKFormat userFormat;

    public ATKField() {
        Keymap parent = this.getKeymap();
        Keymap map = JTextComponent.addKeymap("entermap", parent);
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0, false);
        map.addActionForKeyStroke(enterStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ATKField.this.enter(e);
            }
        });
        this.setKeymap(map);
    }

    public void setUserFormat(ATKFormat format) {
        this.userFormat = format;
    }

    public ATKFormat getUserFormat() {
        return this.userFormat;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.length > 0) {
            Dimension dim = UIManagerHelper.getRequiredSize(this.getFontMetrics(this.getFont()), this.length);
            this.setPreferredSize(dim);
            this.setMinimumSize(dim);
        }
    }

    protected void enter(ActionEvent e) {
    }

    public void setState(Color color) {
        if (this.isEditable()) {
            return;
        }
        this.setBackground(color);
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b && this.modelEditable);
        this.editable = b;
        this.receivedEvent = false;
    }

    @Override
    public boolean isEditable() {
        return this.editable && this.modelEditable;
    }

    public void setError() {
        if (this.isEditable()) {
            return;
        }
        this.setText(this.error);
    }

    public void setFormat(String format) {
        if ("No format".equals(format)) {
            format = "%s";
        }
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setMaximumLength(int characters) {
        this.length = characters;
        this.setPreferredSize(UIManagerHelper.getRequiredSize(this.getFontMetrics(this.getFont()), this.length));
    }

    public int getMaximumLength() {
        return this.length;
    }
}

