/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.AttributeFactory;
import fr.esrf.tangoatk.core.attribute.PolledAttributeFactory;
import fr.esrf.tangoatk.core.command.ACommand;
import fr.esrf.tangoatk.core.command.CommandFactory;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ATKDiagnostic {
    private static final String[] deviceColNames = new String[]{"Device name", "IDL version", "Events support", "Listeners", "", "Polling count"};
    private static final String[] attributeColNames = new String[]{"Attribute name", "Event enabled", "Event src", "Listeners", "", "Polling", "Change", "Periodic", "Config"};
    private static final String[] polledAttributeColNames = new String[]{"Attribute name", "Listeners", "", "Polling count"};
    private static final String[] commandColNames = new String[]{"Command name", "Execution count"};
    private static String[] evtType = new String[]{"Unknown", "notifd", "zmq"};
    private long refreshTime;
    private long lastRefreshTime;
    private long deltaRefresh;

    public ATKDiagnostic(String dummy) {
        this.lastRefreshTime = this.refreshTime = System.currentTimeMillis();
        this.deltaRefresh = 0L;
        DiagPanel f = new DiagPanel();
        ATKGraphicsUtils.centerFrameOnScreen(f);
        f.setVisible(true);
    }

    public static void showDiagnostic() {
        new ATKDiagnostic(null);
    }

    public static void main(String[] args) {
        try {
            AttributeFactory.getInstance().getAttribute("sys/machstat/tango/sig_current");
            AttributeFactory.getInstance().getAttribute("test/d-libera-bpm/srtm-2/SA_Va");
        }
        catch (ConnectionException e) {
            ErrorPane.showErrorMessage(null, "Error", "", e);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage(null, "Error", "", e);
        }
        ATKDiagnostic.showDiagnostic();
    }

    class DiagPanel
    extends JFrame
    implements ActionListener,
    MouseListener {
        private JButton refreshButton;
        private JButton dismissButton;
        private boolean isUpdating = false;
        private JTable deviceTable;
        private DeviceTableModel deviceModel;
        private JButton startRefresherBtn;
        private JButton stopRefresherBtn;
        private JTextField refreshPeriodText;
        private JLabel refreshPeriodLabel;
        private JLabel refreshStateLabel;
        private JTable attributeTable;
        private AttributeTableModel attributeModel;
        private JTextField attributeEvtText;
        private JTable polledAttributeTable;
        private PolledAttributeTableModel polledAttributeModel;
        private CommandTableModel commandModel;

        DiagPanel() {
            JPanel innerPanel = new JPanel(new BorderLayout());
            JTabbedPane pane = new JTabbedPane();
            JPanel devicePanel = new JPanel(new BorderLayout());
            this.deviceModel = new DeviceTableModel();
            this.deviceTable = new JTable(this.deviceModel);
            this.deviceTable.setDefaultRenderer(JButton.class, new MyCellRenderer());
            this.deviceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.deviceTable.getColumnModel().getColumn(4).setMaxWidth(25);
            this.deviceTable.addMouseListener(this);
            JScrollPane deviceView = new JScrollPane(this.deviceTable);
            deviceView.setPreferredSize(new Dimension(700, 400));
            devicePanel.add((Component)deviceView, "Center");
            JPanel dFacPanel = new JPanel();
            dFacPanel.setLayout(null);
            dFacPanel.setPreferredSize(new Dimension(0, 40));
            this.refreshStateLabel = new JLabel();
            this.refreshStateLabel.setFont(ATKConstant.labelFont);
            this.refreshStateLabel.setBounds(10, 10, 180, 25);
            dFacPanel.add(this.refreshStateLabel);
            this.startRefresherBtn = new JButton("Start");
            this.startRefresherBtn.setFont(ATKConstant.labelFont);
            this.startRefresherBtn.addActionListener(this);
            this.startRefresherBtn.setBounds(200, 10, 70, 25);
            dFacPanel.add(this.startRefresherBtn);
            this.stopRefresherBtn = new JButton("Stop");
            this.stopRefresherBtn.setFont(ATKConstant.labelFont);
            this.stopRefresherBtn.addActionListener(this);
            this.stopRefresherBtn.setBounds(280, 10, 70, 25);
            dFacPanel.add(this.stopRefresherBtn);
            this.refreshPeriodLabel = new JLabel();
            this.refreshPeriodLabel.setFont(ATKConstant.labelFont);
            this.refreshPeriodLabel.setBounds(360, 10, 100, 25);
            this.refreshPeriodLabel.setText("Period (ms)");
            dFacPanel.add(this.refreshPeriodLabel);
            this.refreshPeriodText = new JTextField();
            this.refreshPeriodText.setFont(ATKConstant.labelFont);
            this.refreshPeriodText.setMargin(new Insets(0, 0, 0, 0));
            this.refreshPeriodText.setBounds(470, 10, 80, 25);
            this.refreshPeriodText.addActionListener(this);
            dFacPanel.add(this.refreshPeriodText);
            devicePanel.add((Component)dFacPanel, "South");
            pane.add((Component)devicePanel, "Device");
            JPanel attributePanel = new JPanel(new BorderLayout());
            this.attributeModel = new AttributeTableModel();
            this.attributeTable = new JTable(this.attributeModel);
            this.attributeTable.setDefaultRenderer(JButton.class, new MyCellRenderer());
            this.attributeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.attributeTable.getColumnModel().getColumn(4).setMaxWidth(25);
            this.attributeTable.addMouseListener(this);
            JScrollPane attributeView = new JScrollPane(this.attributeTable);
            attributePanel.add((Component)attributeView, "Center");
            this.attributeEvtText = new JTextField();
            this.attributeEvtText.setText(" ");
            attributePanel.add((Component)this.attributeEvtText, "South");
            pane.add((Component)attributePanel, "Attribute");
            this.attributeEvtText = new JTextField();
            this.attributeEvtText.setText(" ");
            attributePanel.add((Component)this.attributeEvtText, "South");
            pane.add((Component)attributePanel, "Attribute");
            JPanel polledAttributePanel = new JPanel(new BorderLayout());
            this.polledAttributeModel = new PolledAttributeTableModel();
            this.polledAttributeTable = new JTable(this.polledAttributeModel);
            this.polledAttributeTable.setDefaultRenderer(JButton.class, new MyCellRenderer());
            this.polledAttributeTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.polledAttributeTable.getColumnModel().getColumn(2).setMaxWidth(25);
            this.polledAttributeTable.addMouseListener(this);
            JScrollPane polledAttributeView = new JScrollPane(this.polledAttributeTable);
            polledAttributePanel.add((Component)polledAttributeView, "Center");
            pane.add((Component)polledAttributePanel, "Polled Attribute");
            JPanel commandPanel = new JPanel(new BorderLayout());
            this.commandModel = new CommandTableModel();
            JTable commandTable = new JTable(this.commandModel);
            commandTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            JScrollPane commandView = new JScrollPane(commandTable);
            commandPanel.add((Component)commandView, "Center");
            pane.add((Component)commandPanel, "Command");
            innerPanel.add((Component)pane, "Center");
            FlowLayout fl = new FlowLayout();
            fl.setAlignment(2);
            JPanel btnPanel = new JPanel(fl);
            this.refreshButton = new JButton("Update fields");
            this.refreshButton.setFont(ATKConstant.labelFont);
            this.refreshButton.addActionListener(this);
            btnPanel.add(this.refreshButton);
            this.dismissButton = new JButton("Dismiss");
            this.dismissButton.setFont(ATKConstant.labelFont);
            this.dismissButton.addActionListener(this);
            btnPanel.add(this.dismissButton);
            innerPanel.add((Component)btnPanel, "South");
            this.setContentPane(innerPanel);
            this.setTitle("ATK Diagnostic");
            this.refreshControls();
        }

        private void refreshControls() {
            this.isUpdating = true;
            if (DeviceFactory.getInstance().isRefreshing()) {
                this.refreshStateLabel.setText("Refresher is Running");
            } else {
                this.refreshStateLabel.setText("Refresher is Stopped");
            }
            this.refreshPeriodText.setText(Long.toString(DeviceFactory.getInstance().getRefreshInterval()));
            this.refreshPeriodText.setCaretPosition(0);
            this.isUpdating = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isUpdating) {
                return;
            }
            Object src = e.getSource();
            if (src == this.dismissButton) {
                this.setVisible(false);
            } else if (src == this.refreshButton) {
                ATKDiagnostic.this.refreshTime = System.currentTimeMillis();
                long delta = ATKDiagnostic.this.refreshTime - ATKDiagnostic.this.lastRefreshTime;
                if (delta > 1000L) {
                    ATKDiagnostic.this.deltaRefresh = delta;
                    ATKDiagnostic.this.lastRefreshTime = ATKDiagnostic.this.refreshTime;
                    this.attributeModel.refreshStat();
                }
                this.deviceModel.refresh();
                this.deviceModel.fireTableDataChanged();
                this.attributeModel.refresh();
                this.attributeModel.fireTableDataChanged();
                this.polledAttributeModel.refresh();
                this.polledAttributeModel.fireTableDataChanged();
            } else if (src == this.refreshPeriodText) {
                String nPeriod = this.refreshPeriodText.getText();
                try {
                    int p = Integer.parseInt(nPeriod);
                    DeviceFactory.getInstance().setRefreshInterval(p);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(null, "Invalid period:\n" + ex.getMessage(), "Error", 0);
                }
            } else if (src == this.startRefresherBtn) {
                DeviceFactory.getInstance().startRefresher();
            } else if (src == this.stopRefresherBtn) {
                DeviceFactory.getInstance().stopRefresher();
            }
            this.refreshControls();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (src == this.attributeTable) {
                int sRow = this.attributeTable.getSelectedRow();
                int sCol = this.attributeTable.getSelectedColumn();
                if (sRow != -1) {
                    String err = this.attributeModel.getAttribute(sRow).getSubscriptionError();
                    this.attributeEvtText.setText(err);
                }
                if (sCol == 4) {
                    AAttribute a = this.attributeModel.getAttribute(sRow);
                    String info = a.getPropChanges().getListenerInfo();
                    JOptionPane.showMessageDialog(this, info, "Listeners registered for " + a.getName(), 1);
                }
            } else if (src == this.polledAttributeTable) {
                int sRow = this.polledAttributeTable.getSelectedRow();
                int sCol = this.polledAttributeTable.getSelectedColumn();
                if (sCol == 2) {
                    AAttribute a = this.polledAttributeModel.getAttribute(sRow);
                    String info = a.getPropChanges().getListenerInfo();
                    JOptionPane.showMessageDialog(this, info, "Listeners registered for " + a.getName(), 1);
                }
            } else if (src == this.deviceTable) {
                int sRow = this.deviceTable.getSelectedRow();
                int sCol = this.deviceTable.getSelectedColumn();
                if (sCol == 4) {
                    Device d = this.deviceModel.getDevice(sRow);
                    String info = d.getPropChanges().getListenerInfo();
                    JOptionPane.showMessageDialog(this, info, "Listeners registered for " + d.getName(), 1);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class CommandTableModel
    extends AbstractTableModel {
        private ACommand[] allCommands = new ACommand[0];

        public CommandTableModel() {
            this.refresh();
        }

        public void refresh() {
            this.allCommands = CommandFactory.getInstance().getCommands();
        }

        @Override
        public int getRowCount() {
            return this.allCommands.length;
        }

        @Override
        public int getColumnCount() {
            return commandColNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return commandColNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.allCommands[rowIndex].getName();
                }
                case 1: {
                    return Integer.toString(this.allCommands[rowIndex].getExecutionCount());
                }
            }
            return "";
        }
    }

    class PolledAttributeTableModel
    extends AbstractTableModel {
        private AAttribute[] allAttributes = new AAttribute[0];

        public PolledAttributeTableModel() {
            this.refresh();
        }

        public void refresh() {
            this.allAttributes = PolledAttributeFactory.getPolledInstance().getAttributes();
        }

        public AAttribute getAttribute(int idx) {
            return this.allAttributes[idx];
        }

        @Override
        public int getRowCount() {
            return this.allAttributes.length;
        }

        @Override
        public int getColumnCount() {
            return polledAttributeColNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return polledAttributeColNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.allAttributes[rowIndex].getName();
                }
                case 1: {
                    return Integer.toString(this.allAttributes[rowIndex].getPropChanges().getListenerCount());
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return Long.toString(this.allAttributes[rowIndex].getRefreshCount());
                }
            }
            return "";
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        private AAttribute[] allAttributes = new AAttribute[0];

        public AttributeTableModel() {
            this.refresh();
            for (int i = 0; i < this.allAttributes.length; ++i) {
                this.allAttributes[i].lastRefreshCount = this.allAttributes[i].getRefreshCount();
                this.allAttributes[i].lastChangeCount = this.allAttributes[i].getChangeCount();
                this.allAttributes[i].lastPeriodicCount = this.allAttributes[i].getPeriodicCount();
                this.allAttributes[i].statRefresh = "";
                this.allAttributes[i].statChange = "";
                this.allAttributes[i].statPeriodic = "";
            }
        }

        public void refresh() {
            this.allAttributes = AttributeFactory.getInstance().getAttributes();
        }

        public void refreshStat() {
            for (int i = 0; i < this.allAttributes.length; ++i) {
                double diffT = (double)ATKDiagnostic.this.deltaRefresh / 1000.0;
                double diffR = this.allAttributes[i].getRefreshCount() - this.allAttributes[i].lastRefreshCount;
                double diffC = this.allAttributes[i].getChangeCount() - this.allAttributes[i].lastChangeCount;
                double diffP = this.allAttributes[i].getPeriodicCount() - this.allAttributes[i].lastPeriodicCount;
                this.allAttributes[i].statRefresh = " (" + String.format("%.1f", diffR / diffT) + " Hz)";
                this.allAttributes[i].statChange = " (" + String.format("%.1f", diffC / diffT) + " Hz)";
                this.allAttributes[i].statPeriodic = " (" + String.format("%.1f", diffP / diffT) + " Hz)";
                this.allAttributes[i].lastRefreshCount = this.allAttributes[i].getRefreshCount();
                this.allAttributes[i].lastChangeCount = this.allAttributes[i].getChangeCount();
                this.allAttributes[i].lastPeriodicCount = this.allAttributes[i].getPeriodicCount();
            }
        }

        public AAttribute getAttribute(int idx) {
            return this.allAttributes[idx];
        }

        @Override
        public int getRowCount() {
            return this.allAttributes.length;
        }

        @Override
        public int getColumnCount() {
            return attributeColNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return attributeColNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.allAttributes[rowIndex].getName();
                }
                case 1: {
                    return Boolean.toString(this.allAttributes[rowIndex].hasEvents());
                }
                case 2: {
                    return evtType[this.allAttributes[rowIndex].getEventType()];
                }
                case 3: {
                    return Integer.toString(this.allAttributes[rowIndex].getPropChanges().getListenerCount());
                }
                case 4: {
                    return "";
                }
                case 5: {
                    return Long.toString(this.allAttributes[rowIndex].getRefreshCount()) + this.allAttributes[rowIndex].statRefresh;
                }
                case 6: {
                    return Long.toString(this.allAttributes[rowIndex].getChangeCount()) + this.allAttributes[rowIndex].statChange;
                }
                case 7: {
                    return Long.toString(this.allAttributes[rowIndex].getPeriodicCount()) + this.allAttributes[rowIndex].statPeriodic;
                }
                case 8: {
                    return Long.toString(this.allAttributes[rowIndex].getConfigCount());
                }
            }
            return "";
        }
    }

    class DeviceTableModel
    extends AbstractTableModel {
        private Device[] allDevices = new Device[0];

        public DeviceTableModel() {
            this.refresh();
        }

        public void refresh() {
            this.allDevices = DeviceFactory.getInstance().getDevices();
        }

        public Device getDevice(int idx) {
            return this.allDevices[idx];
        }

        @Override
        public int getRowCount() {
            return this.allDevices.length;
        }

        @Override
        public int getColumnCount() {
            return deviceColNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return deviceColNames[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.allDevices[rowIndex].getName();
                }
                case 1: {
                    return Integer.toString(this.allDevices[rowIndex].getIdlVersion());
                }
                case 2: {
                    return Boolean.toString(this.allDevices[rowIndex].doesEvent());
                }
                case 3: {
                    return Integer.toString(this.allDevices[rowIndex].getPropChanges().getListenerCount());
                }
                case 4: {
                    return "";
                }
                case 5: {
                    return Long.toString(this.allDevices[rowIndex].getRefreshCount());
                }
            }
            return "";
        }
    }

    class MyCellRenderer
    implements TableCellRenderer {
        JButton listenerBtn = new JButton();

        public MyCellRenderer() {
            this.listenerBtn.setMargin(new Insets(2, 4, 2, 4));
            this.listenerBtn.setFont(ATKConstant.labelFont);
            this.listenerBtn.setText("...");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.listenerBtn;
        }
    }
}

