/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class PropertyViewer
extends JPanel
implements PropertyChangeListener {
    protected Property model;
    protected Color inputForeground;
    protected Color inputBackground;
    int inputLength = 0;
    int typeLength = 0;
    boolean borderVisible = false;
    Border border = null;
    private boolean editable = false;
    private String value;
    private JLabel type;
    private JTextField input;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("presentation".equals(evt.getPropertyName()) && evt.getSource() instanceof Property) {
            this.setValue((String)evt.getNewValue());
        }
    }

    public PropertyViewer() {
        this.initComponents();
        this.border = this.type.getBorder();
        this.input.setBackground(this.getBackground());
        this.type.setBackground(this.getBackground());
        this.input.setForeground(this.getForeground());
        this.type.setForeground(this.getForeground());
    }

    public void setValueMaximumLength(int characters) {
        this.inputLength = characters;
        this.input.setPreferredSize(UIManagerHelper.getRequiredSize(this.input.getFontMetrics(this.input.getFont()), characters));
    }

    public int getValueMaximumLength() {
        return this.inputLength;
    }

    public void setTypeGMaximumLength(int characters) {
        this.typeLength = characters;
        this.type.setPreferredSize(UIManagerHelper.getRequiredSize(this.type.getFontMetrics(this.type.getFont()), characters));
    }

    public int getTypeMaximumLength() {
        return this.typeLength;
    }

    public void setBorderVisible(boolean isVisible) {
        this.borderVisible = isVisible;
        if (this.borderVisible) {
            this.type.setBorder(this.border);
            this.input.setBorder(this.border);
            return;
        }
        this.type.setBorder(BorderFactory.createEmptyBorder());
        this.input.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void setBorder(Border border) {
        if (this.type == null || this.input == null) {
            return;
        }
        this.type.setBorder(border);
        this.input.setBorder(border);
    }

    @Override
    public Border getBorder() {
        return super.getBorder();
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.type == null || this.input == null) {
            return;
        }
        this.type.setFont(f);
        this.input.setFont(f);
        if (this.inputLength > 0) {
            this.input.setPreferredSize(UIManagerHelper.getRequiredSize(this.input.getFontMetrics(this.input.getFont()), this.inputLength));
        }
        if (this.typeLength > 0) {
            this.type.setPreferredSize(UIManagerHelper.getRequiredSize(this.type.getFontMetrics(this.type.getFont()), this.typeLength));
        }
    }

    protected void labelType(String s) {
        this.type.setText(s);
    }

    public void setValue(String s) {
        this.value = s;
        this.input.setText(this.value);
    }

    public String getValue() {
        return this.value;
    }

    public void setLabelVisible(boolean b) {
        this.type.setVisible(b);
    }

    public boolean isLabelVisible() {
        return this.type.isVisible();
    }

    public double getLabelWidth() {
        return this.type.getPreferredSize().getWidth();
    }

    public void setLabelWidth(double width) {
        Dimension d = this.type.getPreferredSize();
        d.setSize(width, d.getHeight());
        this.type.setPreferredSize(d);
        this.type.setMinimumSize(d);
    }

    public double getValueWidth() {
        return this.input.getPreferredSize().getWidth();
    }

    public void setValueWidth(double i) {
        Dimension d = new Dimension((int)i, (int)this.type.getPreferredSize().getHeight());
        this.input.setPreferredSize(d);
        this.input.setMinimumSize(d);
    }

    public void setValueHorizontalAlignment(int alignment) {
        this.input.setHorizontalAlignment(alignment);
    }

    public int getValueHorizontalAlignment() {
        return this.input.getHorizontalAlignment();
    }

    public void setModel(Property p) {
        if (this.model != null) {
            this.model.removePresentationListener(this);
        }
        this.model = p;
        this.model.addPresentationListener(this);
        this.type.setText(this.model.getName());
        this.setValue("***");
        if (this.model.isSpecified()) {
            this.setValue(this.model.getPresentation());
        }
        this.input.setVisible(true);
    }

    public Property getModel() {
        return this.model;
    }

    private void initComponents() {
        this.type = new JLabel();
        this.input = new JTextField();
        this.setLayout(new GridBagLayout());
        this.type.setText("type");
        this.type.setBorder(new EtchedBorder());
        this.type.setMinimumSize(new Dimension(40, 20));
        this.type.setMaximumSize(new Dimension(100, 20));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        this.add((Component)this.type, gridBagConstraints1);
        this.input.setEditable(false);
        this.input.setForeground(new Color(102, 102, 153));
        this.input.setFont(new Font("Dialog", 1, 12));
        this.input.setText("jTextField1");
        this.input.setBorder(new EtchedBorder());
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PropertyViewer.this.inputKeyPressed(evt);
            }
        });
        this.input.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PropertyViewer.this.inputMouseClicked(evt);
            }
        });
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.1;
        this.add((Component)this.input, gridBagConstraints1);
    }

    private void inputMouseClicked(MouseEvent evt) {
        if (this.isEditable()) {
            this.setInputEnabled(true);
        }
    }

    private void inputKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setInputEnabled(false);
            this.value = this.input.getText();
            this.model.setValue(this.value);
            this.model.store();
            return;
        }
        if (evt.getKeyCode() == 27) {
            this.setInputEnabled(false);
            this.input.setText(this.value);
            return;
        }
    }

    private void setInputEnabled(boolean b) {
        if (!b) {
            this.input.setEditable(false);
            this.input.setFont(this.getFont());
            this.input.setForeground(this.inputForeground);
            this.input.setBackground(this.inputBackground);
            this.input.setBorder(this.border);
            return;
        }
        if (!this.isEditable()) {
            return;
        }
        this.input.setEditable(true);
        this.input.setFont(this.getFont().deriveFont(0));
        this.inputForeground = this.input.getForeground();
        this.inputBackground = this.input.getBackground();
        this.input.setForeground(Color.black);
        this.input.setBackground(Color.white);
        this.input.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    @Override
    public void setForeground(Color color) {
        if (this.input == null || this.type == null) {
            return;
        }
        this.input.setForeground(color);
        this.type.setForeground(color);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.input == null || this.type == null) {
            return;
        }
        this.input.setBackground(color);
        this.type.setBackground(color);
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.input == null || this.type == null) {
            return;
        }
        this.input.setOpaque(isOpaque);
        this.type.setOpaque(isOpaque);
    }

    @Override
    public boolean isOpaque() {
        return super.isOpaque();
    }

    public boolean isEditable() {
        if (this.model != null && this.model.isEditable()) {
            return this.editable;
        }
        return false;
    }
}

