/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class PropertyFieldEditor
extends JTextField
implements PropertyChangeListener {
    private boolean askConfirmation = false;
    private String titleAskConfirmation = "Confirmation";
    private String textAskConfirmation = "Do you want to modify the property ?";
    private Property model = null;

    public PropertyFieldEditor() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyFieldEditor.this.setProperty();
            }
        });
        this.setEditable(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("presentation".equals(evt.getPropertyName()) && evt.getSource() instanceof Property) {
            this.setText(((Property)evt.getSource()).getPresentation());
            this.setEditable(((Property)evt.getSource()).isEditable());
        }
    }

    protected void setProperty() {
        int ok;
        if (this.askConfirmation && (ok = JOptionPane.showConfirmDialog(this, this.textAskConfirmation, this.titleAskConfirmation, 0)) != 0) {
            if (this.model != null) {
                this.setText(this.model.getPresentation());
            } else {
                this.setText("");
            }
            return;
        }
        if (this.model != null) {
            if (this.model.isEditable()) {
                this.model.setValueFromString(this.getText());
                this.setText(this.model.getPresentation());
                this.model.store();
            } else {
                this.setText(this.model.getPresentation());
            }
        } else {
            this.setText("");
        }
    }

    public Property getModel() {
        return this.model;
    }

    public void setModel(Property model) {
        if (this.model != null) {
            this.model.removePresentationListener(this);
        }
        this.model = model;
        if (model != null) {
            model.addPresentationListener(this);
            this.setText(model.getPresentation());
            this.setEditable(model.isEditable());
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
    }

    public String getTextAskConfirmation() {
        return this.textAskConfirmation;
    }

    public void setTextAskConfirmation(String textAskConfirmation) {
        this.textAskConfirmation = textAskConfirmation;
    }

    public String getTitleAskConfirmation() {
        return this.titleAskConfirmation;
    }

    public void setTitleAskConfirmation(String titleAskConfirmation) {
        this.titleAskConfirmation = titleAskConfirmation;
    }
}

