/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.properties;

import fr.esrf.tangoatk.core.Property;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;

public class PropertyAreaEditor
extends JTextArea
implements MouseListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private boolean askConfirmation = false;
    private String titleAskConfirmation = "Confirmation";
    private String textAskConfirmation = "Do you want to modify the property ?";
    private String sendValueText = "Apply modification";
    private JPopupMenu sendPopupMenu = null;
    private JMenuItem sendMenu = null;
    private Property model = null;

    public PropertyAreaEditor() {
        this.addMouseListener(this);
        this.addKeyListener(this);
        try {
            this.sendPopupMenu = new JPopupMenu();
            this.sendMenu = new JMenuItem();
            this.sendPopupMenu.setDoubleBuffered(true);
            this.sendMenu.setText(this.sendValueText);
            this.sendPopupMenu.add(this.sendMenu);
            this.sendMenu.addActionListener(this);
            this.setEditable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setBackground(Color arg0) {
        if (arg0 == null) {
            arg0 = Color.LIGHT_GRAY;
        }
        super.setBackground(arg0);
    }

    public boolean isAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
    }

    public String getTextAskConfirmation() {
        return this.textAskConfirmation;
    }

    public void setTextAskConfirmation(String textAskConfirmation) {
        if (textAskConfirmation.equals("")) {
            return;
        }
        this.textAskConfirmation = textAskConfirmation;
    }

    public String getTitleAskConfirmation() {
        return this.titleAskConfirmation;
    }

    public void setTitleAskConfirmation(String titleAskConfirmation) {
        if (titleAskConfirmation.equals("")) {
            return;
        }
        this.titleAskConfirmation = titleAskConfirmation;
    }

    protected void setProperty() {
        int ok;
        if (this.askConfirmation && (ok = JOptionPane.showConfirmDialog(this, this.textAskConfirmation, this.titleAskConfirmation, 0)) != 0) {
            if (this.model != null) {
                this.setText(this.model.getPresentation());
            } else {
                this.setText("");
            }
            return;
        }
        if (this.model != null) {
            if (this.model.isEditable()) {
                this.model.setValueFromString(this.getText());
                this.setText(this.model.getPresentation());
                this.model.store();
            } else {
                this.setText(this.model.getPresentation());
            }
        } else {
            this.setText("");
        }
    }

    public Property getModel() {
        return this.model;
    }

    public void setModel(Property model) {
        if (this.model != null) {
            this.model.removePresentationListener(this);
        }
        this.model = model;
        if (model != null) {
            model.addPresentationListener(this);
            this.setText(model.getPresentation());
            this.setEditable(model.isEditable());
        } else {
            this.setText("");
            this.setEditable(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("presentation".equals(evt.getPropertyName()) && evt.getSource() instanceof Property) {
            this.setText(((Property)evt.getSource()).getPresentation());
            this.setEditable(((Property)evt.getSource()).isEditable());
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.getClickCount() == 1 && arg0.getButton() == 3) {
            this.sendPopupMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.setProperty();
    }

    public String getSendValueText() {
        return this.sendValueText;
    }

    public void setSendValueText(String sendValueText) {
        this.sendValueText = sendValueText;
        this.sendMenu.setText(sendValueText);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getModifiersEx() == 128 && e.getKeyCode() == 10) {
            e.consume();
            this.setProperty();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

