/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.widget.jdraw.TangoSynopticHandler;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFrame;

public class SynopticFileViewer
extends TangoSynopticHandler {
    private String jdrawDir = null;
    private String jdrawFileName = null;

    public SynopticFileViewer() {
    }

    public SynopticFileViewer(String jdrawf) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setJdrawFileName(jdrawf);
    }

    public SynopticFileViewer(String jdrawd, String jdrawf) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setJdrawDir(jdrawd);
        this.setJdrawFileName(jdrawf);
    }

    public String getJdrawDir() {
        String fn = null;
        fn = this.getSynopticFileName();
        if (fn != null) {
            int indSlash = fn.lastIndexOf(47);
            try {
                this.jdrawDir = fn.substring(0, indSlash - 1);
            }
            catch (Exception ex) {
                this.jdrawDir = null;
            }
        }
        return this.jdrawDir;
    }

    public void setJdrawDir(String newDir) {
        String fn = null;
        fn = this.getSynopticFileName();
        if (fn != null) {
            return;
        }
        if (newDir == null) {
            return;
        }
        if (newDir.length() <= 0) {
            return;
        }
        this.jdrawDir = new String(newDir);
    }

    public String getJdrawFileName() {
        String fn = null;
        fn = this.getSynopticFileName();
        if (fn == null) {
            this.jdrawFileName = null;
        } else {
            int indSlash = fn.lastIndexOf(47);
            int fnSize = fn.length();
            try {
                this.jdrawFileName = fn.substring(indSlash + 1, fnSize - 1);
            }
            catch (Exception ex) {
                this.jdrawFileName = null;
            }
        }
        return this.jdrawFileName;
    }

    public void setJdrawFileName(String jdrawf) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        if (jdrawf == null) {
            this.clearDirAndFileNames();
            return;
        }
        this.jdrawFileName = jdrawf;
        String fullFileName = this.jdrawFileName.startsWith("/") ? this.jdrawFileName : (this.getJdrawDir() == null ? this.jdrawFileName : this.getJdrawDir() + "/" + this.jdrawFileName);
        this.setSynopticFileName(fullFileName);
    }

    public void clearDirAndFileNames() {
        this.jdrawDir = null;
        this.jdrawFileName = null;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        ErrorHistory errorHistory = new ErrorHistory();
        SynopticFileViewer sfv = new SynopticFileViewer();
        try {
            sfv.setErrorHistoryWindow(errorHistory);
            sfv.setToolTipMode(3);
            sfv.setAutoZoom(true);
            sfv.setJdrawFileName("/tmp_14_days/poncet/test_synoptic.jdw");
            jf.setContentPane(sfv);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
        jf.pack();
        jf.setVisible(true);
    }
}

