/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.jdraw;

import fr.esrf.tangoatk.widget.jdraw.DeviceSynopticViewer;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;
import javax.swing.JFrame;

public class DeviceSynopticFrame
extends JFrame {
    private static final String defaultJdrawDir = "/users/poncet/ATK_OLD/jloox_files";
    private String jdrawDir = null;
    private String devName = null;
    private DeviceSynopticViewer dsv = null;

    public DeviceSynopticFrame() {
        this.initComponents();
    }

    public DeviceSynopticFrame(String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.jdrawDir = defaultJdrawDir;
        this.setDevName(dev);
        this.setContentPane(this.dsv);
        this.pack();
        this.setVisible(true);
    }

    public DeviceSynopticFrame(String jdrd, String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this();
        this.setJdrawDir(jdrd);
        this.setDevName(dev);
        this.setContentPane(this.dsv);
        this.pack();
        this.setVisible(true);
    }

    public String getJdrawDir() {
        return this.jdrawDir;
    }

    public void setJdrawDir(String newDir) {
        if (newDir == null) {
            return;
        }
        if (newDir.length() <= 0) {
            return;
        }
        this.jdrawDir = new String(newDir);
    }

    public String getDevName() {
        return this.devName;
    }

    public void setDevName(String dev) throws MissingResourceException, FileNotFoundException, IllegalArgumentException {
        this.devName = dev;
        this.dsv = new DeviceSynopticViewer(this.jdrawDir, dev);
    }

    public String getFileNameFromDev(String dev) {
        if (dev == null) {
            return dev;
        }
        String devFile = dev.replace('/', '_');
        return devFile;
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DeviceSynopticFrame.this.exitForm(evt);
            }
        });
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        String deviceName = args.length <= 0 ? "id14/eh3_mono/diamond" : args[0];
        try {
            DeviceSynopticFrame dsf = new DeviceSynopticFrame(deviceName);
            WindowListener[] wl = dsf.getWindowListeners();
            for (int i = 0; i < wl.length; ++i) {
                dsf.removeWindowListener(wl[i]);
                System.out.println("windowListener[" + i + "]");
            }
            dsf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Prog Aborted.");
            System.exit(-1);
        }
    }
}

