/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageManipulator;
import fr.esrf.tangoatk.widget.image.IImagePanel;
import fr.esrf.tangoatk.widget.image.IImageViewer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class RoiControlPanel
extends JPanel
implements IImageManipulator,
IImagePanel {
    int sx = 0;
    int sy = 0;
    int ex = 0;
    int ey = 0;
    int i = 0;
    IImageViewer model;
    JPanel top;
    Graphics graphics;

    @Override
    public void setModel(IImageViewer viewer) {
        this.setImageViewer(viewer);
    }

    @Override
    public void setImageViewer(IImageViewer viewer) {
        viewer.addImageManipulator(this);
        this.model = viewer;
        this.top = this.model.getTopLayer();
    }

    @Override
    public String getName() {
        return "Roi Control";
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public BufferedImage filter(BufferedImage i) {
        this.graphics = i.getGraphics();
        this.graphics.setColor(Color.red);
        this.graphics.drawRect(this.sx, this.sy, this.ex - this.sx, this.ey - this.sy);
        return i;
    }

    @Override
    public void ok() {
        this.getRootPane().getParent().setVisible(false);
    }

    @Override
    public void roiChanged(int startx, int endx, int starty, int endy) {
        this.sx = startx;
        this.ex = endx;
        this.sy = starty;
        this.ey = endy;
        if (++this.i > 20) {
            this.i = 0;
            this.top.repaint();
        }
    }
}

