/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageFormat;
import java.io.IOException;

public class RGB24ImageFormat
extends IImageFormat {
    @Override
    public void setData(byte[] rawData) throws IOException {
        int wh = rawData[0] & 0xFF;
        int wl = rawData[1] & 0xFF;
        int width = (wh <<= 8) | wl;
        int hh = rawData[2] & 0xFF;
        int hl = rawData[3] & 0xFF;
        int height = (hh <<= 8) | hl;
        int idx = 4;
        this.data = new byte[height][width * 3];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                this.data[j][i * 3 + 2] = rawData[idx++];
                this.data[j][i * 3 + 1] = rawData[idx++];
                this.data[j][i * 3 + 0] = rawData[idx++];
            }
        }
    }

    @Override
    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.data[0].length / 3;
    }

    @Override
    public String getName() {
        return "RGB24";
    }

    @Override
    public boolean isColorFormat() {
        return true;
    }

    @Override
    public int getHistogramWidth() {
        return 256;
    }

    @Override
    public double getValue(int x, int y) {
        int g = this.data[y][x * 3 + 1] & 0xFF;
        return g;
    }

    @Override
    public String getValueStr(int x, int y) {
        int r = this.data[y][x * 3 + 2] & 0xFF;
        int g = this.data[y][x * 3 + 1] & 0xFF;
        int b = this.data[y][x * 3 + 0] & 0xFF;
        return "(" + r + "," + g + "," + b + ")";
    }

    @Override
    public void computeFitting() {
    }

    @Override
    public int getRGB(boolean negative, int[] colormap16, int x, int y) {
        if (!negative) {
            int r = this.data[y][x * 3 + 2] & 0xFF;
            int g = this.data[y][x * 3 + 1] & 0xFF;
            int b = this.data[y][x * 3 + 0] & 0xFF;
            return (r << 16) + (g << 8) + b;
        }
        int r = ~this.data[y][x * 3 + 2] & 0xFF;
        int g = ~this.data[y][x * 3 + 1] & 0xFF;
        int b = ~this.data[y][x * 3 + 0] & 0xFF;
        return (r << 16) + (g << 8) + b;
    }
}

