/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageFormat;
import java.io.IOException;

public class Mono16ImageFormat
extends IImageFormat {
    @Override
    public void setData(byte[] rawData) throws IOException {
        int wh = rawData[0] & 0xFF;
        int wl = rawData[1] & 0xFF;
        int width = (wh <<= 8) | wl;
        int hh = rawData[2] & 0xFF;
        int hl = rawData[3] & 0xFF;
        int height = (hh <<= 8) | hl;
        int idx = 4;
        this.data = new byte[height][width * 2];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                this.data[j][i * 2 + 0] = rawData[idx++];
                this.data[j][i * 2 + 1] = rawData[idx++];
            }
        }
    }

    @Override
    public int getWidth() {
        if (this.getHeight() == 0) {
            return 0;
        }
        return this.data[0].length / 2;
    }

    @Override
    public String getName() {
        return "MONO16";
    }

    @Override
    public boolean isColorFormat() {
        return false;
    }

    @Override
    public int getHistogramWidth() {
        return 65536;
    }

    @Override
    public double getValue(int x, int y) {
        int uc1 = this.data[y][2 * x] & 0xFF;
        int uc2 = this.data[y][2 * x + 1] & 0xFF;
        return (uc1 << 8) + uc2;
    }

    @Override
    public String getValueStr(int x, int y) {
        return Double.toString(this.getValue(x, y));
    }

    @Override
    public void computeFitting() {
        if (!this.bestFit) {
            this.tool.getAxis().setMinimum(-this.bfA0);
            this.tool.getAxis().setMaximum(-this.bfA0 + 1.0 / this.bfA1 * 65536.0);
        } else {
            double autoBfMin = 65536.0;
            double autoBfMax = 0.0;
            for (int j = 0; j < this.data.length; ++j) {
                for (int i = 0; i < this.data[j].length / 2; ++i) {
                    int uc1 = this.data[j][2 * i] & 0xFF;
                    int uc2 = this.data[j][2 * i + 1] & 0xFF;
                    double v = (uc1 << 8) + uc2;
                    if (v > autoBfMax) {
                        autoBfMax = v;
                    }
                    if (!(v < autoBfMin)) continue;
                    autoBfMin = v;
                }
            }
            this.bfA0 = -autoBfMin;
            if (autoBfMax == autoBfMin) {
                this.bfA1 = 0.0;
                this.tool.getAxis().setMinimum(autoBfMin);
                this.tool.getAxis().setMaximum(autoBfMax + 1.0);
            } else {
                this.bfA1 = 65536.0 / (autoBfMax - autoBfMin);
                this.tool.getAxis().setMinimum(autoBfMin);
                this.tool.getAxis().setMaximum(autoBfMax);
            }
        }
    }

    private int bestFit(int v) {
        int nv = (int)((this.bfA0 + (double)v) * this.bfA1);
        if (nv < 0) {
            return 0;
        }
        if (nv > 65535) {
            return 65535;
        }
        return nv;
    }

    @Override
    public int getRGB(boolean negative, int[] colormap16, int x, int y) {
        int uc1 = this.data[y][2 * x] & 0xFF;
        int uc2 = this.data[y][2 * x + 1] & 0xFF;
        int v = (uc1 << 8) + uc2;
        if (negative) {
            return colormap16[~this.bestFit(v) & 0xFFFF];
        }
        return colormap16[this.bestFit(v)];
    }
}

