/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.image.LineProfilerPanel;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class LineProfilerViewer
extends JFrame {
    public static final int LINE_MODE_SINGLE = 1;
    public static final int LINE_MODE_DOUBLE = 2;
    public static final int HISTOGRAM_MODE = 3;
    private JSplitPane splitPane;
    private LineProfilerPanel profile1;
    private LineProfilerPanel profile2;
    private int mode;
    private NumberImageViewer parent;

    public LineProfilerViewer() {
        this((NumberImageViewer)null);
    }

    public LineProfilerViewer(NumberImageViewer parent) {
        this.parent = parent;
        this.splitPane = new JSplitPane(0);
        this.profile1 = new LineProfilerPanel(parent);
        this.setTitle("[LineProfile] ImageViewer");
        this.profile1.getChart().setHeader("Line profile");
        this.profile1.getChart().getXAxis().setName("Pixel index");
        this.profile1.getChart().getY1Axis().setName("Value");
        this.profile1.getChart().setLabelVisible(false);
        this.profile1.getChart().setName("Pixel value");
        this.profile2 = null;
        this.splitPane.setLeftComponent(this.profile1);
        this.splitPane.setRightComponent(null);
        this.mode = 1;
        this.setContentPane(this.splitPane);
        this.pack();
    }

    public void setXAxisName(String name) {
        this.profile1.getChart().getXAxis().setName(name);
    }

    public void setYAxisName(String name) {
        this.profile1.getChart().getY1Axis().setName(name);
    }

    public void setFormat(String format) {
        this.profile1.setFormat(format);
        if (this.profile2 != null) {
            this.profile2.setFormat(format);
        }
    }

    public void setHeader(String header) {
        this.profile1.getChart().setHeader(header);
    }

    public void setSource(String source, Object value) {
        this.profile1.setSource(source, value);
    }

    public void setHeader2(String header) {
        this.profile2.getChart().setHeader(header);
    }

    public void setSource2(String source, Object value) {
        this.profile2.setSource(source, value);
    }

    public void setMode(int mode) {
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        switch (this.mode) {
            case 1: {
                this.setTitle("[LineProfile] ImageViewer");
                this.profile1.getChart().setHeader("Line profile");
                this.profile1.getChart().getXAxis().setName("Pixel index");
                this.profile1.getChart().getY1Axis().setName("Value");
                this.profile1.getChart().setLabelVisible(false);
                this.profile1.getChart().setName("Pixel value");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                if (this.profile2 == null) break;
                this.splitPane.setRightComponent(null);
                this.profile2.setVisible(false);
                this.pack();
                break;
            }
            case 2: {
                this.setTitle("[LineProfile] ImageViewer");
                if (this.profile2 == null) {
                    this.profile2 = new LineProfilerPanel(this.parent);
                    this.profile2.setId(2);
                }
                this.profile1.getChart().setHeader("Line profile (Horizontal)");
                this.profile1.getChart().getXAxis().setName("Pixel index");
                this.profile1.getChart().getY1Axis().setName("Value");
                this.profile1.getChart().setLabelVisible(false);
                this.profile1.getChart().setName("Pixel value");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                this.profile2.getChart().setHeader("Line profile (Vertical)");
                this.profile2.getChart().getXAxis().setName("Pixel index");
                this.profile2.getChart().getY1Axis().setName("Value");
                this.profile2.getChart().setLabelVisible(false);
                this.profile2.getChart().setName("Pixel value");
                if (this.profile2.getChart().isZoomed()) {
                    this.profile2.getChart().exitZoom();
                }
                this.splitPane.setRightComponent(this.profile2);
                this.profile2.setVisible(true);
                this.pack();
                break;
            }
            case 3: {
                this.setTitle("[Histogram] ImageViewer");
                this.profile1.getChart().setHeader("Histogram");
                this.profile1.getChart().getXAxis().setName("Pixel value");
                this.profile1.getChart().getY1Axis().setName("Number");
                this.profile1.getChart().setName("pixel number");
                if (this.profile1.getChart().isZoomed()) {
                    this.profile1.getChart().exitZoom();
                }
                if (this.profile2 == null) break;
                this.splitPane.setRightComponent(null);
                this.profile2.setVisible(false);
                this.pack();
            }
        }
    }

    public void setLineProfileMode() {
        this.setMode(1);
    }

    public void setHistogramMode() {
        this.setMode(3);
    }

    public void setData(double[] v) {
        this.setData(v, 0);
    }

    public void setData(double[] v, double xgain, double xoffset) {
        this.profile1.setData(v, xgain, xoffset);
    }

    public void setData(double[] v, int startIndexing) {
        this.profile1.setData(v, startIndexing);
    }

    public void setData2(double[] v) {
        this.setData2(v, 0);
    }

    public void setData2(double[] v, int startIndexing) {
        if (this.profile2 != null) {
            this.profile2.setData(v, startIndexing);
        }
    }

    public LineProfilerPanel getProfile1() {
        return this.profile1;
    }

    public LineProfilerPanel getProfile2() {
        return this.profile2;
    }

    public static void main(String[] args) {
        LineProfilerViewer l = new LineProfilerViewer();
        l.setDefaultCloseOperation(3);
        l.setVisible(true);
    }
}

