/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineProfilerPanel
extends JPanel
implements IJLChartListener,
ActionListener,
ChangeListener {
    protected JPanel cfgPanel;
    protected JLChart theGraph;
    protected JLDataView theDataY;
    protected JTableRow theTable = null;
    protected Font panelFont;
    protected JCheckBox tableCheck;
    protected JLabel minLabel;
    protected JTextField minText;
    protected JLabel maxLabel;
    protected JTextField maxText;
    protected JLabel avgLabel;
    protected JTextField avgText;
    protected JLabel stdLabel;
    protected JTextField stdText;
    protected String userFormat = "";
    protected JLabel srcLabel = null;
    protected JTextField srcText = null;
    protected JSpinner srcSpin = null;
    protected static String[] colName = new String[]{"Index", "Value"};
    protected static String[][] emptyStr = new String[][]{{"", ""}};
    private NumberImageViewer parent;
    private int id;
    private boolean isSpinEdit;

    public LineProfilerPanel() {
        this((NumberImageViewer)null);
    }

    public LineProfilerPanel(NumberImageViewer parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        this.panelFont = new Font("Dialog", 0, 11);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(new FlowLayout(0));
        this.add((Component)this.cfgPanel, "South");
        this.tableCheck = new JCheckBox("View table");
        this.tableCheck.setSelected(false);
        this.tableCheck.setFont(this.panelFont);
        this.tableCheck.addActionListener(this);
        this.cfgPanel.add(this.tableCheck);
        this.minLabel = new JLabel("Min");
        this.minLabel.setFont(this.panelFont);
        this.minLabel.setHorizontalAlignment(4);
        this.cfgPanel.add(this.minLabel);
        this.minText = new JTextField("");
        this.minText.setPreferredSize(new Dimension(60, 20));
        this.minText.setMargin(new Insets(0, 0, 0, 0));
        this.minText.setFont(this.panelFont);
        this.cfgPanel.add(this.minText);
        this.maxLabel = new JLabel("Max");
        this.maxLabel.setFont(this.panelFont);
        this.maxLabel.setHorizontalAlignment(4);
        this.cfgPanel.add(this.maxLabel);
        this.maxText = new JTextField("");
        this.maxText.setPreferredSize(new Dimension(60, 20));
        this.maxText.setMargin(new Insets(0, 0, 0, 0));
        this.maxText.setFont(this.panelFont);
        this.cfgPanel.add(this.maxText);
        this.avgLabel = new JLabel("Avg");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setHorizontalAlignment(4);
        this.cfgPanel.add(this.avgLabel);
        this.avgText = new JTextField("");
        this.avgText.setPreferredSize(new Dimension(60, 20));
        this.avgText.setMargin(new Insets(0, 0, 0, 0));
        this.avgText.setFont(this.panelFont);
        this.cfgPanel.add(this.avgText);
        this.stdLabel = new JLabel("Std");
        this.stdLabel.setFont(this.panelFont);
        this.stdLabel.setHorizontalAlignment(4);
        this.cfgPanel.add(this.stdLabel);
        this.stdText = new JTextField("");
        this.stdText.setPreferredSize(new Dimension(60, 20));
        this.stdText.setMargin(new Insets(0, 0, 0, 0));
        this.stdText.setFont(this.panelFont);
        this.cfgPanel.add(this.stdText);
        if (parent != null) {
            this.srcLabel = new JLabel("Source");
            this.srcLabel.setPreferredSize(new Dimension(60, 20));
            this.srcLabel.setFont(this.panelFont);
            this.srcLabel.setHorizontalAlignment(4);
            this.cfgPanel.add(this.srcLabel);
            this.srcText = new JTextField("");
            this.srcText.setEditable(true);
            this.srcText.setPreferredSize(new Dimension(120, 20));
            this.srcText.setMargin(new Insets(0, 0, 0, 0));
            this.srcText.setFont(this.panelFont);
            this.srcText.addActionListener(this);
            this.cfgPanel.add(this.srcText);
            this.srcSpin = new JSpinner(new SpinnerNumberModel(0, 0, 65536, 1));
            this.srcSpin.setVisible(false);
            this.srcSpin.setPreferredSize(new Dimension(120, 20));
            this.srcSpin.addChangeListener(this);
            this.cfgPanel.add(this.srcSpin);
        }
        this.theGraph = new JLChart();
        this.theGraph.setBorder(new EtchedBorder());
        this.theGraph.getXAxis().setAutoScale(true);
        this.theGraph.getXAxis().setAnnotation(2);
        this.theGraph.getXAxis().setGridVisible(true);
        this.theGraph.getXAxis().setLabelFormat(3);
        this.theDataY = new JLDataView();
        this.theGraph.getY1Axis().setAutoScale(true);
        this.theGraph.getY1Axis().addDataView(this.theDataY);
        this.theGraph.getY1Axis().setGridVisible(true);
        this.theGraph.setPreferredSize(new Dimension(600, 400));
        this.theGraph.setMinimumSize(new Dimension(600, 400));
        this.theGraph.setHeaderFont(new Font("Dialog", 1, 18));
        this.theGraph.setJLChartListener(this);
        this.add((Component)this.theGraph, "Center");
        this.theTable = new JTableRow();
        this.theTable.setPreferredSize(new Dimension(170, 0));
        this.theTable.setVisible(false);
        this.add((Component)this.theTable, "East");
        this.id = 1;
        this.isSpinEdit = false;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSource(String label, Object value) {
        if (this.srcLabel != null) {
            this.srcLabel.setText(label);
        }
        if (value instanceof String && this.srcText != null) {
            if (!this.srcText.hasFocus()) {
                this.srcText.setText((String)value);
            }
            this.srcSpin.setVisible(false);
            this.srcText.setVisible(true);
        }
        if (value instanceof Integer) {
            if (this.srcSpin != null && !this.srcSpin.hasFocus()) {
                this.isSpinEdit = true;
                this.srcSpin.setValue(value);
                this.isSpinEdit = false;
            }
            this.srcSpin.setVisible(true);
            this.srcText.setVisible(false);
        }
    }

    public void setFormat(String format) {
        this.userFormat = format;
    }

    private void refreshTable() {
        if (this.theTable.isVisible()) {
            Object[][] dv;
            LineProfilerPanel.colName[0] = this.theGraph.getXAxis().getName();
            LineProfilerPanel.colName[1] = this.theGraph.getY1Axis().getName();
            if (this.theDataY.getDataLength() > 0) {
                dv = new String[this.theDataY.getDataLength()][2];
                DataList dly = this.theDataY.getData();
                for (int i = 0; i < this.theDataY.getDataLength(); ++i) {
                    dv[i][0] = Integer.toString((int)dly.x);
                    dv[i][1] = Double.toString(dly.y);
                    dly = dly.next;
                }
            } else {
                dv = emptyStr;
            }
            this.theTable.setData(dv, colName);
        }
    }

    public void setData(double[] v, int startIndexing) {
        this.theDataY.reset();
        if (v != null) {
            int i;
            double sum = 0.0;
            double sum2 = 0.0;
            double avg = 0.0;
            double std = 0.0;
            double lgth = v.length;
            for (i = 0; i < v.length; ++i) {
                this.theDataY.add(i + startIndexing, v[i]);
                sum += v[i];
            }
            avg = sum / lgth;
            for (i = 0; i < v.length; ++i) {
                sum2 += (v[i] - avg) * (v[i] - avg);
            }
            std = Math.sqrt(sum2 / lgth);
            this.minText.setText(Double.toString(this.theDataY.getMinimum()));
            this.minText.setCaretPosition(0);
            this.maxText.setText(Double.toString(this.theDataY.getMaximum()));
            this.maxText.setCaretPosition(0);
            Double avgD = new Double(avg);
            Double stdD = new Double(std);
            this.avgText.setText(String.format("%.2f", avgD));
            this.avgText.setCaretPosition(0);
            this.stdText.setText(String.format("%.2f", stdD));
            this.stdText.setCaretPosition(0);
        } else {
            this.minText.setText("");
            this.maxText.setText("");
            this.avgText.setText("");
            this.stdText.setText("");
        }
        this.theGraph.repaint();
        this.refreshTable();
    }

    public void setData(double[] v, double xgain, double xoffset) {
        this.theDataY.reset();
        if (v != null) {
            int i;
            double sum = 0.0;
            double sum2 = 0.0;
            double avg = 0.0;
            double std = 0.0;
            double lgth = v.length;
            for (i = 0; i < v.length; ++i) {
                this.theDataY.add((double)i * xgain + xoffset, v[i]);
                sum += v[i];
            }
            avg = sum / lgth;
            for (i = 0; i < v.length; ++i) {
                sum2 += (v[i] - avg) * (v[i] - avg);
            }
            std = Math.sqrt(sum2 / lgth);
            this.minText.setText(Double.toString(this.theDataY.getMinimum()));
            this.minText.setCaretPosition(0);
            this.maxText.setText(Double.toString(this.theDataY.getMaximum()));
            this.maxText.setCaretPosition(0);
            Double avgD = new Double(avg);
            Double stdD = new Double(std);
            this.avgText.setText(String.format("%.2f", avgD));
            this.avgText.setCaretPosition(0);
            this.stdText.setText(String.format("%.2f", stdD));
            this.stdText.setCaretPosition(0);
        } else {
            this.minText.setText("");
            this.maxText.setText("");
            this.avgText.setText("");
            this.stdText.setText("");
        }
        this.theGraph.repaint();
        this.refreshTable();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.tableCheck) {
            this.theTable.setVisible(this.tableCheck.isSelected());
            this.refreshTable();
            this.revalidate();
        } else if (src == this.srcText) {
            this.parent.setSourceFromProfile(this.srcText.getText(), this.id);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.srcSpin && !this.isSpinEdit) {
            this.parent.setSourceFromProfile(this.srcSpin.getValue().toString(), this.id);
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent evt) {
        String[] ret = new String[]{this.theGraph.getXAxis().getName() + " = " + evt.getTransformedXValue(), this.userFormat.length() > 0 ? this.theGraph.getY1Axis().getName() + " = " + ATKFormat.format(this.userFormat, evt.getTransformedYValue()) : this.theGraph.getY1Axis().getName() + " = " + evt.getTransformedYValue()};
        return ret;
    }

    public JLChart getChart() {
        return this.theGraph;
    }
}

